<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Workshop Hero -->
<section class="workshop-hero">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <!-- Breadcrumb -->
                <nav aria-label="breadcrumb" class="mb-4">
                    <ol class="breadcrumb breadcrumb-custom">
                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo base_url('workshops'); ?>">Workshops</a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo htmlspecialchars(character_limiter($workshop->title, 30)); ?></li>
                    </ol>
                </nav>
                
                <!-- Status Badges -->
                <div class="workshop-badges mb-3">
                    <?php
                    $status_classes = [
                        'upcoming' => 'upcoming',
                        'ongoing' => 'ongoing',
                        'completed' => 'completed',
                        'cancelled' => 'cancelled'
                    ];
                    $status_icons = [
                        'upcoming' => 'fa-calendar-alt',
                        'ongoing' => 'fa-play-circle',
                        'completed' => 'fa-check-circle',
                        'cancelled' => 'fa-times-circle'
                    ];
                    ?>
                    <span class="status-badge <?php echo $status_classes[$workshop->status] ?? ''; ?>">
                        <i class="fas <?php echo $status_icons[$workshop->status] ?? ''; ?> me-1"></i>
                        <?php echo ucfirst($workshop->status); ?>
                    </span>
                    <?php if ($workshop->is_featured): ?>
                        <span class="featured-badge">
                            <i class="fas fa-star me-1"></i>Featured Programme
                        </span>
                    <?php endif; ?>
                </div>
                
                <!-- Title -->
                <h1 class="workshop-title"><?php echo htmlspecialchars($workshop->title); ?></h1>
                
                <!-- Quick Stats -->
                <div class="workshop-quick-stats">
                    <?php if (!empty($workshop->duration)): ?>
                        <div class="quick-stat">
                            <i class="far fa-clock"></i>
                            <span><?php echo htmlspecialchars($workshop->duration); ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($workshop->target_audience)): ?>
                        <div class="quick-stat">
                            <i class="fas fa-users"></i>
                            <span><?php echo htmlspecialchars($workshop->target_audience); ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($workshop->location)): ?>
                        <div class="quick-stat">
                            <i class="fas fa-map-marker-alt"></i>
                            <span><?php echo htmlspecialchars($workshop->location); ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($workshop->facilitator)): ?>
                        <div class="quick-stat">
                            <i class="fas fa-user-tie"></i>
                            <span>By <?php echo htmlspecialchars($workshop->facilitator); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Featured Image -->
<?php if (!empty($workshop->featured_image)): ?>
<section class="featured-image-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="featured-image-wrapper">
                    <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                         alt="<?php echo htmlspecialchars($workshop->title); ?>"
                         class="featured-image">
                    <?php if (!empty($workshop->start_date)): ?>
                        <div class="date-overlay">
                            <div class="date-card">
                                <span class="date-label">Starts</span>
                                <span class="date-day"><?php echo date('d', strtotime($workshop->start_date)); ?></span>
                                <span class="date-month"><?php echo date('M Y', strtotime($workshop->start_date)); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Workshop Content -->
<section class="py-5 workshop-content-section">
    <div class="container">
        <div class="row">
            <!-- Main Content -->
            <div class="col-lg-8">
                <div class="workshop-content-card">
                    
                    <!-- Lead Description -->
                    <div class="workshop-lead">
                        <p class="lead"><?php echo htmlspecialchars($workshop->description); ?></p>
                    </div>
                    
                    <!-- Workshop Details Grid -->
                    <div class="workshop-details-grid">
                        <?php if (!empty($workshop->duration)): ?>
                            <div class="detail-card">
                                <div class="detail-icon">
                                    <i class="far fa-clock"></i>
                                </div>
                                <div class="detail-content">
                                    <span class="detail-label">Duration</span>
                                    <span class="detail-value"><?php echo htmlspecialchars($workshop->duration); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($workshop->location)): ?>
                            <div class="detail-card">
                                <div class="detail-icon">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div class="detail-content">
                                    <span class="detail-label">Location</span>
                                    <span class="detail-value"><?php echo htmlspecialchars($workshop->location); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($workshop->capacity)): ?>
                            <div class="detail-card">
                                <div class="detail-icon">
                                    <i class="fas fa-users"></i>
                                </div>
                                <div class="detail-content">
                                    <span class="detail-label">Capacity</span>
                                    <span class="detail-value"><?php echo number_format($workshop->capacity); ?> participants</span>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($workshop->facilitator)): ?>
                            <div class="detail-card">
                                <div class="detail-icon">
                                    <i class="fas fa-user-tie"></i>
                                </div>
                                <div class="detail-content">
                                    <span class="detail-label">Facilitator</span>
                                    <span class="detail-value"><?php echo htmlspecialchars($workshop->facilitator); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($workshop->start_date)): ?>
                            <div class="detail-card">
                                <div class="detail-icon">
                                    <i class="fas fa-calendar-alt"></i>
                                </div>
                                <div class="detail-content">
                                    <span class="detail-label">Start Date</span>
                                    <span class="detail-value"><?php echo date('F d, Y', strtotime($workshop->start_date)); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($workshop->end_date)): ?>
                            <div class="detail-card">
                                <div class="detail-icon">
                                    <i class="fas fa-calendar-check"></i>
                                </div>
                                <div class="detail-content">
                                    <span class="detail-label">End Date</span>
                                    <span class="detail-value"><?php echo date('F d, Y', strtotime($workshop->end_date)); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($workshop->price)): ?>
                            <div class="detail-card highlight">
                                <div class="detail-icon">
                                    <i class="fas fa-tag"></i>
                                </div>
                                <div class="detail-content">
                                    <span class="detail-label">Investment</span>
                                    <span class="detail-value price">
                                        <?php if ($workshop->price > 0): ?>
                                            GH₵ <?php echo number_format($workshop->price, 2); ?>
                                        <?php else: ?>
                                            Free
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Full Description -->
                    <?php if (!empty($workshop->full_description)): ?>
                        <div class="content-section">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-info-circle"></i>
                                </div>
                                <h3 class="section-title">About This Workshop</h3>
                            </div>
                            <div class="section-content">
                                <?php echo nl2br(htmlspecialchars($workshop->full_description)); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Learning Objectives -->
                    <?php if (!empty($workshop->objectives)): ?>
                        <div class="content-section">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-bullseye"></i>
                                </div>
                                <h3 class="section-title">Learning Objectives</h3>
                            </div>
                            <div class="section-content objectives">
                                <?php echo nl2br(htmlspecialchars($workshop->objectives)); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Target Audience -->
                    <?php if (!empty($workshop->target_audience)): ?>
                        <div class="content-section">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-user-friends"></i>
                                </div>
                                <h3 class="section-title">Who Should Attend</h3>
                            </div>
                            <div class="section-content">
                                <div class="audience-card">
                                    <i class="fas fa-check-circle"></i>
                                    <span><?php echo htmlspecialchars($workshop->target_audience); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Requirements -->
                    <?php if (!empty($workshop->requirements)): ?>
                        <div class="content-section">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-clipboard-list"></i>
                                </div>
                                <h3 class="section-title">Requirements</h3>
                            </div>
                            <div class="section-content requirements">
                                <?php echo nl2br(htmlspecialchars($workshop->requirements)); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Schedule -->
                    <?php if (!empty($workshop->schedule)): ?>
                        <div class="content-section">
                            <div class="section-header">
                                <div class="section-icon">
                                    <i class="fas fa-calendar-week"></i>
                                </div>
                                <h3 class="section-title">Schedule</h3>
                            </div>
                            <div class="section-content schedule">
                                <?php echo nl2br(htmlspecialchars($workshop->schedule)); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Share Section -->
                    <div class="share-section">
                        <h6 class="share-title"><i class="fas fa-share-alt me-2"></i>Share this Workshop</h6>
                        <div class="share-buttons">
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo current_url(); ?>" 
                               target="_blank" 
                               class="share-btn facebook"
                               title="Share on Facebook">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="https://twitter.com/intent/tweet?url=<?php echo current_url(); ?>&text=<?php echo urlencode($workshop->title); ?>" 
                               target="_blank" 
                               class="share-btn twitter"
                               title="Share on Twitter">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo current_url(); ?>" 
                               target="_blank" 
                               class="share-btn linkedin"
                               title="Share on LinkedIn">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                            <a href="https://wa.me/?text=<?php echo urlencode($workshop->title . ' - ' . current_url()); ?>" 
                               target="_blank" 
                               class="share-btn whatsapp"
                               title="Share on WhatsApp">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Navigation -->
                <div class="workshop-navigation">
                    <a href="<?php echo base_url('workshops'); ?>" class="nav-btn">
                        <i class="fas fa-arrow-left"></i>
                        <span>Back to All Workshops</span>
                    </a>
                </div>
                
                <!-- Related Workshops -->
                <?php if (!empty($related_workshops)): ?>
                    <div class="related-workshops">
                        <h3 class="related-title">
                            <span class="title-icon"><i class="fas fa-chalkboard-teacher"></i></span>
                            Related Workshops
                        </h3>
                        <div class="row">
                            <?php foreach ($related_workshops as $related): ?>
                                <div class="col-md-4 mb-4">
                                    <div class="related-card">
                                        <a href="<?php echo base_url('workshops/view/' . $related->slug); ?>" class="related-image">
                                            <?php if (!empty($related->featured_image)): ?>
                                                <img src="<?php echo base_url('uploads/workshops/' . $related->featured_image); ?>" 
                                                     alt="<?php echo htmlspecialchars($related->title); ?>">
                                            <?php else: ?>
                                                <div class="placeholder-img">
                                                    <i class="fas fa-chalkboard-teacher fa-2x"></i>
                                                </div>
                                            <?php endif; ?>
                                            <span class="related-status <?php echo $related->status; ?>">
                                                <?php echo ucfirst($related->status); ?>
                                            </span>
                                        </a>
                                        <div class="related-content">
                                            <h6 class="related-card-title">
                                                <a href="<?php echo base_url('workshops/view/' . $related->slug); ?>">
                                                    <?php echo htmlspecialchars(character_limiter($related->title, 40)); ?>
                                                </a>
                                            </h6>
                                            <?php if (!empty($related->duration)): ?>
                                                <span class="related-meta">
                                                    <i class="far fa-clock me-1"></i>
                                                    <?php echo htmlspecialchars($related->duration); ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <aside class="sidebar">
                    <!-- Back Widget -->
                    <div class="sidebar-widget back-widget">
                        <a href="<?php echo base_url('workshops'); ?>" class="back-btn">
                            <i class="fas fa-arrow-left me-2"></i>Back to All Workshops
                        </a>
                    </div>
                    
                    <!-- Registration CTA Widget -->
                    <?php if ($workshop->status === 'upcoming' || $workshop->status === 'ongoing'): ?>
                        <div class="sidebar-widget register-widget">
                            <div class="register-header">
                                <i class="fas fa-user-plus"></i>
                                <h5>Register Now</h5>
                            </div>
                            <?php if (!empty($workshop->price) && $workshop->price > 0): ?>
                                <div class="price-display">
                                    <span class="price-label">Investment</span>
                                    <span class="price-amount">GH₵ <?php echo number_format($workshop->price, 2); ?></span>
                                </div>
                            <?php else: ?>
                                <div class="price-display free">
                                    <span class="price-label">This workshop is</span>
                                    <span class="price-amount">FREE</span>
                                </div>
                            <?php endif; ?>
                            <a href="<?php echo base_url('french-workshop/register'); ?>" class="btn btn-register w-100 mb-2">
                                <i class="fas fa-check-circle me-2"></i>Register Now
                            </a>
                            <a href="https://wa.me/233500557751?text=<?php echo urlencode('Hi! I\'m interested in the workshop: ' . $workshop->title); ?>" 
                               target="_blank" 
                               class="btn btn-whatsapp w-100">
                                <i class="fab fa-whatsapp me-2"></i>Enquire via WhatsApp
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Contact CTA Widget -->
                    <div class="sidebar-widget cta-widget">
                        <div class="cta-icon">
                            <i class="fas fa-question-circle"></i>
                        </div>
                        <h5 class="cta-title">Have Questions?</h5>
                        <p class="cta-text">Get in touch with us for more information about this programme.</p>
                        <a href="<?php echo base_url('contact'); ?>" class="btn btn-light w-100 mb-2">
                            <i class="fas fa-envelope me-2"></i>Contact Us
                        </a>
                        <a href="<?php echo base_url('consultation'); ?>" class="btn btn-outline-light w-100">
                            <i class="fas fa-calendar-check me-2"></i>Book Consultation
                        </a>
                    </div>
                    
                    <!-- Facilitator Widget -->
                    <?php if (!empty($workshop->facilitator)): ?>
                        <div class="sidebar-widget facilitator-widget">
                            <h5 class="widget-title"><i class="fas fa-user-tie me-2"></i>Facilitator</h5>
                            <div class="facilitator-card">
                                <div class="facilitator-avatar">
                                    <?php echo strtoupper(substr($workshop->facilitator, 0, 1)); ?>
                                </div>
                                <div class="facilitator-info">
                                    <h6 class="facilitator-name"><?php echo htmlspecialchars($workshop->facilitator); ?></h6>
                                    <span class="facilitator-role">Workshop Facilitator</span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Explore More Widget -->
                    <div class="sidebar-widget explore-widget">
                        <h5 class="widget-title"><i class="fas fa-compass me-2"></i>Explore More</h5>
                        <ul class="explore-list">
                            <li>
                                <a href="<?php echo base_url('workshops'); ?>">
                                    <i class="fas fa-chalkboard-teacher"></i>
                                    <span>All Workshops</span>
                                    <i class="fas fa-chevron-right arrow"></i>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo base_url('volunteer/apply'); ?>">
                                    <i class="fas fa-hands-helping"></i>
                                    <span>Become a Volunteer</span>
                                    <i class="fas fa-chevron-right arrow"></i>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo base_url('blog'); ?>">
                                    <i class="fas fa-newspaper"></i>
                                    <span>Our Blog</span>
                                    <i class="fas fa-chevron-right arrow"></i>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo base_url('donate'); ?>">
                                    <i class="fas fa-heart"></i>
                                    <span>Support Us</span>
                                    <i class="fas fa-chevron-right arrow"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                    
                    <!-- Social Widget -->
                    <div class="sidebar-widget social-widget">
                        <h5 class="widget-title"><i class="fas fa-share-alt me-2"></i>Follow Us</h5>
                        <div class="social-links">
                            <a href="#" class="social-link facebook" title="Facebook">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="https://instagram.com/theskillsatelier" target="_blank" class="social-link instagram" title="Instagram">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="#" class="social-link twitter" title="Twitter">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="https://wa.me/233500557751" target="_blank" class="social-link whatsapp" title="WhatsApp">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<!-- Newsletter Section -->
<section class="py-5 newsletter-section">
    <div class="container">
        <div class="newsletter-card">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <h3 class="fw-bold text-white mb-2">
                        <i class="fas fa-bell me-2"></i>Stay Informed
                    </h3>
                    <p class="text-white-50 mb-0">Subscribe to get updates on new workshops, events, and learning opportunities.</p>
                </div>
                <div class="col-lg-6">
                    <form action="<?php echo base_url('newsletter/subscribe'); ?>" method="post" class="newsletter-form">
                        <div class="input-group">
                            <input type="email" name="email" class="form-control" placeholder="Enter your email address" required>
                            <button type="submit" class="btn btn-light">
                                Subscribe <i class="fas fa-paper-plane ms-2"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* =========================================
   THE SKILLS ATELIER - WORKSHOP VIEW STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
    --status-upcoming: #ffc107;
    --status-ongoing: #28a745;
    --status-completed: #6c757d;
    --status-cancelled: #dc3545;
}

/* =========================================
   WORKSHOP HERO
   ========================================= */
.workshop-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 60px;
    position: relative;
    overflow: hidden;
}

.workshop-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.breadcrumb-custom {
    background: transparent;
    padding: 0;
    margin: 0;
}

.breadcrumb-custom .breadcrumb-item a {
    color: rgba(255,255,255,0.7);
    text-decoration: none;
    transition: color 0.3s ease;
    font-size: 0.9rem;
}

.breadcrumb-custom .breadcrumb-item a:hover {
    color: white;
}

.breadcrumb-custom .breadcrumb-item.active {
    color: rgba(255,255,255,0.9);
    font-size: 0.9rem;
}

.breadcrumb-custom .breadcrumb-item + .breadcrumb-item::before {
    color: rgba(255,255,255,0.5);
}

/* Workshop Badges */
.workshop-badges {
    display: flex;
    flex-wrap: wrap;
    gap: 0.75rem;
}

.status-badge {
    display: inline-flex;
    align-items: center;
    padding: 0.5rem 1.25rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
}

.status-badge.upcoming {
    background: var(--status-upcoming);
    color: #333;
}

.status-badge.ongoing {
    background: var(--status-ongoing);
    color: white;
}

.status-badge.completed {
    background: var(--status-completed);
    color: white;
}

.status-badge.cancelled {
    background: var(--status-cancelled);
    color: white;
}

.featured-badge {
    display: inline-flex;
    align-items: center;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.5rem 1.25rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
}

.workshop-title {
    color: white;
    font-size: 2.75rem;
    font-weight: 700;
    line-height: 1.2;
    margin-bottom: 1.5rem;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
}

.workshop-quick-stats {
    display: flex;
    flex-wrap: wrap;
    gap: 1.5rem;
}

.quick-stat {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: rgba(255,255,255,0.9);
    font-size: 0.95rem;
}

.quick-stat i {
    opacity: 0.8;
}

/* =========================================
   FEATURED IMAGE
   ========================================= */
.featured-image-section {
    margin-top: -40px;
    position: relative;
    z-index: 10;
}

.featured-image-wrapper {
    position: relative;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 60px rgba(0,0,0,0.2);
}

.featured-image {
    width: 100%;
    max-height: 500px;
    object-fit: cover;
    display: block;
}

.date-overlay {
    position: absolute;
    top: 20px;
    right: 20px;
}

.date-card {
    background: white;
    padding: 1rem 1.5rem;
    border-radius: 15px;
    text-align: center;
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
}

.date-label {
    display: block;
    font-size: 0.75rem;
    color: #888;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.date-day {
    display: block;
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--tsa-primary);
    line-height: 1;
}

.date-month {
    display: block;
    font-size: 0.9rem;
    color: #555;
}

/* =========================================
   WORKSHOP CONTENT SECTION
   ========================================= */
.workshop-content-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

.workshop-content-card {
    background: white;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    overflow: hidden;
}

/* Lead Description */
.workshop-lead {
    padding: 2.5rem;
    border-bottom: 1px solid #f0f0f0;
}

.workshop-lead .lead {
    color: #555;
    font-size: 1.2rem;
    line-height: 1.8;
    margin: 0;
}

/* Details Grid */
.workshop-details-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1px;
    background: #f0f0f0;
    border-bottom: 1px solid #f0f0f0;
}

.detail-card {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.5rem;
    background: white;
}

.detail-card.highlight {
    background: var(--tsa-light);
}

.detail-icon {
    width: 50px;
    height: 50px;
    min-width: 50px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.detail-content {
    display: flex;
    flex-direction: column;
}

.detail-label {
    font-size: 0.8rem;
    color: #888;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.detail-value {
    font-weight: 600;
    color: #333;
}

.detail-value.price {
    color: var(--tsa-primary);
    font-size: 1.1rem;
}

/* Content Sections */
.content-section {
    padding: 2rem 2.5rem;
    border-bottom: 1px solid #f0f0f0;
}

.content-section:last-of-type {
    border-bottom: none;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.25rem;
}

.section-icon {
    width: 45px;
    height: 45px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
}

.section-title {
    font-weight: 700;
    color: #333;
    margin: 0;
    font-size: 1.25rem;
}

.section-content {
    color: #555;
    line-height: 1.9;
    font-size: 1.05rem;
}

.section-content.objectives,
.section-content.requirements,
.section-content.schedule {
    padding-left: 1rem;
    border-left: 3px solid var(--tsa-primary);
}

.audience-card {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.25rem;
    background: var(--tsa-light);
    border-radius: 12px;
}

.audience-card i {
    color: var(--tsa-primary);
    font-size: 1.2rem;
}

/* Share Section */
.share-section {
    padding: 2rem 2.5rem;
    background: #fafafa;
}

.share-title {
    font-weight: 600;
    color: #333;
    margin-bottom: 1rem;
}

.share-buttons {
    display: flex;
    gap: 0.75rem;
}

.share-btn {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1rem;
    text-decoration: none;
    transition: all 0.3s ease;
}

.share-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.share-btn.facebook { background: #1877f2; }
.share-btn.twitter { background: #1da1f2; }
.share-btn.linkedin { background: #0077b5; }
.share-btn.whatsapp { background: #25d366; }

.share-btn.facebook:hover { background: #0d65d9; color: white; }
.share-btn.twitter:hover { background: #0c8de4; color: white; }
.share-btn.linkedin:hover { background: #006097; color: white; }
.share-btn.whatsapp:hover { background: #1da851; color: white; }

/* =========================================
   WORKSHOP NAVIGATION
   ========================================= */
.workshop-navigation {
    margin: 2rem 0;
}

.nav-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.75rem;
    padding: 1rem 1.5rem;
    background: white;
    border-radius: 15px;
    text-decoration: none;
    color: #333;
    font-weight: 500;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
}

.nav-btn:hover {
    background: var(--tsa-primary);
    color: white;
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(242, 97, 36, 0.3);
}

/* =========================================
   RELATED WORKSHOPS
   ========================================= */
.related-workshops {
    margin-top: 3rem;
}

.related-title {
    display: flex;
    align-items: center;
    gap: 1rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
}

.title-icon {
    width: 50px;
    height: 50px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.related-card {
    background: white;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    height: 100%;
}

.related-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.12);
}

.related-image {
    display: block;
    height: 150px;
    position: relative;
    overflow: hidden;
}

.related-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.related-card:hover .related-image img {
    transform: scale(1.1);
}

.related-image .placeholder-img {
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #f5f5f5, #e0e0e0);
    color: #ccc;
}

.related-status {
    position: absolute;
    top: 10px;
    left: 10px;
    padding: 0.3rem 0.75rem;
    border-radius: 50px;
    font-size: 0.7rem;
    font-weight: 600;
    text-transform: uppercase;
}

.related-status.upcoming { background: var(--status-upcoming); color: #333; }
.related-status.ongoing { background: var(--status-ongoing); color: white; }
.related-status.completed { background: var(--status-completed); color: white; }

.related-content {
    padding: 1.25rem;
}

.related-card-title {
    font-weight: 600;
    margin-bottom: 0.5rem;
    line-height: 1.4;
}

.related-card-title a {
    color: #333;
    text-decoration: none;
    transition: color 0.3s ease;
}

.related-card-title a:hover {
    color: var(--tsa-primary);
}

.related-meta {
    font-size: 0.8rem;
    color: #888;
}

/* =========================================
   SIDEBAR
   ========================================= */
.sidebar {
    position: sticky;
    top: 100px;
}

.sidebar-widget {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

/* Back Widget */
.back-widget {
    padding: 1rem;
}

.back-btn {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 100%;
    padding: 1rem;
    background: var(--tsa-light);
    border-radius: 12px;
    color: var(--tsa-primary);
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
}

.back-btn:hover {
    background: var(--tsa-primary);
    color: white;
}

/* Register Widget */
.register-widget {
    border: 2px solid var(--tsa-primary);
    border-radius: 20px;
}

.register-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid #f0f0f0;
    margin-bottom: 1rem;
}

.register-header i {
    width: 50px;
    height: 50px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.3rem;
}

.register-header h5 {
    font-weight: 700;
    margin: 0;
    color: #333;
}

.price-display {
    text-align: center;
    padding: 1.5rem;
    background: var(--tsa-light);
    border-radius: 15px;
    margin-bottom: 1.25rem;
}

.price-display.free {
    background: linear-gradient(135deg, #d4edda, #c3e6cb);
}

.price-label {
    display: block;
    font-size: 0.85rem;
    color: #666;
    margin-bottom: 0.25rem;
}

.price-amount {
    display: block;
    font-size: 2rem;
    font-weight: 700;
    color: var(--tsa-primary);
}

.price-display.free .price-amount {
    color: #28a745;
}

.btn-register {
    background: var(--tsa-gradient);
    border: none;
    color: white;
    font-weight: 600;
    padding: 1rem;
    border-radius: 12px;
    transition: all 0.3s ease;
}

.btn-register:hover {
    background: var(--tsa-gradient-reverse);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(242, 97, 36, 0.4);
    color: white;
}

.btn-whatsapp {
    background: #25d366;
    border: none;
    color: white;
    font-weight: 600;
    padding: 1rem;
    border-radius: 12px;
    transition: all 0.3s ease;
}

.btn-whatsapp:hover {
    background: #1da851;
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(37, 211, 102, 0.4);
    color: white;
}

/* CTA Widget */
.cta-widget {
    background: var(--tsa-gradient);
    text-align: center;
    padding: 2rem;
}

.cta-icon {
    width: 70px;
    height: 70px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.25rem;
    color: white;
    font-size: 1.8rem;
}

.cta-title {
    color: white;
    font-weight: 700;
    margin-bottom: 0.75rem;
}

.cta-text {
    color: rgba(255,255,255,0.85);
    font-size: 0.95rem;
    margin-bottom: 1.5rem;
}

.cta-widget .btn-light {
    font-weight: 600;
}

.cta-widget .btn-light:hover {
    background: var(--tsa-cream);
}

.cta-widget .btn-outline-light {
    border-width: 2px;
    font-weight: 600;
}

/* Facilitator Widget */
.widget-title {
    font-weight: 700;
    color: #333;
    margin-bottom: 1rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #f0f0f0;
}

.facilitator-card {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    background: var(--tsa-light);
    border-radius: 12px;
}

.facilitator-avatar {
    width: 60px;
    height: 60px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 700;
    font-size: 1.5rem;
}

.facilitator-name {
    font-weight: 600;
    color: #333;
    margin: 0 0 0.25rem;
}

.facilitator-role {
    font-size: 0.85rem;
    color: #888;
}

/* Explore Widget */
.explore-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.explore-list li {
    margin-bottom: 0.5rem;
}

.explore-list li:last-child {
    margin-bottom: 0;
}

.explore-list a {
    display: flex;
    align-items: center;
    padding: 0.85rem 1rem;
    background: var(--tsa-light);
    border-radius: 12px;
    color: #555;
    text-decoration: none;
    transition: all 0.3s ease;
}

.explore-list a:hover {
    background: var(--tsa-primary);
    color: white;
    transform: translateX(5px);
}

.explore-list a i:first-child {
    width: 20px;
    margin-right: 0.75rem;
    color: var(--tsa-primary);
}

.explore-list a:hover i:first-child {
    color: white;
}

.explore-list a span {
    flex: 1;
    font-weight: 500;
}

.explore-list a .arrow {
    font-size: 0.75rem;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.explore-list a:hover .arrow {
    opacity: 1;
}

/* Social Widget */
.social-links {
    display: flex;
    gap: 0.75rem;
}

.social-link {
    width: 45px;
    height: 45px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
    text-decoration: none;
    transition: all 0.3s ease;
}

.social-link:hover {
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.social-link.facebook { background: #1877f2; }
.social-link.instagram { background: linear-gradient(45deg, #f09433, #e6683c, #dc2743, #cc2366, #bc1888); }
.social-link.twitter { background: #1da1f2; }
.social-link.whatsapp { background: #25d366; }

/* =========================================
   NEWSLETTER SECTION
   ========================================= */
.newsletter-section {
    background: linear-gradient(135deg, #1a1a2e, #16213e);
}

.newsletter-card {
    background: rgba(255,255,255,0.05);
    backdrop-filter: blur(10px);
    border-radius: 20px;
    padding: 2.5rem;
    border: 1px solid rgba(255,255,255,0.1);
}

.newsletter-form .form-control {
    border: none;
    border-radius: 50px 0 0 50px;
    padding: 1rem 1.5rem;
    font-size: 1rem;
}

.newsletter-form .form-control:focus {
    box-shadow: none;
}

.newsletter-form .btn {
    border-radius: 0 50px 50px 0;
    padding: 1rem 2rem;
    font-weight: 600;
}

.newsletter-form .btn:hover {
    background: var(--tsa-cream);
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .workshop-hero {
        padding: 80px 0 50px;
    }
    
    .workshop-title {
        font-size: 2rem;
    }
    
    .workshop-details-grid {
        grid-template-columns: 1fr;
    }
    
    .sidebar {
        position: relative;
        top: 0;
        margin-top: 2rem;
    }
}

@media (max-width: 768px) {
    .workshop-hero {
        padding: 70px 0 40px;
    }
    
    .workshop-title {
        font-size: 1.75rem;
    }
    
    .workshop-quick-stats {
        flex-direction: column;
        gap: 0.75rem;
    }
    
    .featured-image {
        max-height: 300px;
    }
    
    .workshop-lead {
        padding: 1.5rem;
    }
    
    .content-section {
        padding: 1.5rem;
    }
    
    .share-section {
        padding: 1.5rem;
    }
    
    .newsletter-form .input-group {
        flex-direction: column;
    }
    
    .newsletter-form .form-control {
        border-radius: 50px;
        margin-bottom: 1rem;
    }
    
    .newsletter-form .btn {
        border-radius: 50px;
        width: 100%;
    }
}
</style>