<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Volunteers Hero Banner -->
<section class="volunteers-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <nav aria-label="breadcrumb" class="mb-3">
                    <ol class="breadcrumb breadcrumb-custom">
                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Our Volunteers</li>
                    </ol>
                </nav>
                <span class="section-badge mb-3">
                    <i class="fas fa-heart me-2"></i>Our Team
                </span>
                <h1 class="display-5 fw-bold text-white mb-3">Meet Our Volunteers</h1>
                <p class="lead text-white-50 mb-0">The passionate individuals who dedicate their time and skills to help children discover the joy of learning.</p>
            </div>
            <div class="col-lg-4 text-lg-end mt-4 mt-lg-0">
                <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-light btn-lg hero-btn">
                    <i class="fas fa-hand-holding-heart me-2"></i>Join Our Team
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Volunteer Stats Bar -->
<section class="volunteer-stats-bar">
    <div class="container">
        <div class="stats-wrapper">
            <div class="stat-box">
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-content">
                    <span class="stat-number"><?php echo count($volunteers ?? []); ?></span>
                    <span class="stat-label">Active Volunteers</span>
                </div>
            </div>
            <div class="stat-box">
                <div class="stat-icon">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="stat-content">
                    <span class="stat-number">500+</span>
                    <span class="stat-label">Hours Contributed</span>
                </div>
            </div>
            <div class="stat-box">
                <div class="stat-icon">
                    <i class="fas fa-child"></i>
                </div>
                <div class="stat-content">
                    <span class="stat-number">50+</span>
                    <span class="stat-label">Kids Impacted</span>
                </div>
            </div>
            <div class="stat-box">
                <div class="stat-icon">
                    <i class="fas fa-star"></i>
                </div>
                <div class="stat-content">
                    <span class="stat-number">100%</span>
                    <span class="stat-label">Dedication</span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Volunteers Grid Section -->
<section class="py-5 volunteers-section">
    <div class="container">
        <?php if (!empty($volunteers)): ?>
            
            <!-- Section Header -->
            <div class="section-header text-center mb-5">
                <span class="section-badge-alt">Hearts Behind TSA</span>
                <h2 class="fw-bold mt-3">Our Amazing Volunteers</h2>
                <p class="text-muted">Meet the incredible people making education fun and accessible</p>
            </div>
            
            <!-- Volunteers Grid -->
            <div class="row">
                <?php foreach ($volunteers as $index => $volunteer): ?>
                    <div class="col-xl-3 col-lg-4 col-md-6 mb-4">
                        <div class="volunteer-card h-100">
                            <!-- Card Background Pattern -->
                            <div class="card-pattern"></div>
                            
                            <!-- Profile Image -->
                            <div class="volunteer-image">
                                <?php if (!empty($volunteer->profile_photo)): ?>
                                    <img src="<?php echo base_url('uploads/volunteers/' . $volunteer->profile_photo); ?>" 
                                         alt="<?php echo htmlspecialchars($volunteer->full_name); ?>">
                                <?php else: ?>
                                    <div class="avatar-placeholder">
                                        <span><?php echo strtoupper(substr($volunteer->full_name, 0, 1)); ?></span>
                                    </div>
                                <?php endif; ?>
                                <div class="image-glow"></div>
                            </div>
                            
                            <!-- Volunteer Info -->
                            <div class="volunteer-info">
                                <h5 class="volunteer-name"><?php echo htmlspecialchars($volunteer->full_name); ?></h5>
                                
                                <?php if (!empty($volunteer->occupation)): ?>
                                    <p class="volunteer-role"><?php echo htmlspecialchars($volunteer->occupation); ?></p>
                                <?php endif; ?>
                                
                                <?php if (!empty($volunteer->city)): ?>
                                    <div class="volunteer-location">
                                        <i class="fas fa-map-marker-alt"></i>
                                        <span><?php echo htmlspecialchars($volunteer->city); ?><?php echo !empty($volunteer->country) ? ', ' . htmlspecialchars($volunteer->country) : ''; ?></span>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($volunteer->skills)): ?>
                                    <div class="volunteer-skills">
                                        <?php 
                                        $skills = explode(',', $volunteer->skills);
                                        $skills = array_slice($skills, 0, 3); // Show max 3 skills
                                        foreach ($skills as $skill): 
                                        ?>
                                            <span class="skill-tag"><?php echo trim(htmlspecialchars($skill)); ?></span>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <!-- Social/Action Icons -->
                            <div class="volunteer-actions">
                                <span class="volunteer-badge">
                                    <i class="fas fa-hands-helping"></i> Volunteer
                                </span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
        <?php else: ?>
            <!-- Empty State -->
            <div class="empty-state">
                <div class="empty-icon">
                    <i class="fas fa-users"></i>
                </div>
                <h3 class="fw-bold mb-3">No Volunteers Yet</h3>
                <p class="text-muted mb-4">Be the first to join our volunteer team and make a difference in children's lives!</p>
                <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-primary btn-lg">
                    <i class="fas fa-hand-holding-heart me-2"></i>Become Our First Volunteer
                </a>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- Why Volunteer Section -->
<section class="py-5 why-volunteer-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="why-content">
                    <span class="section-badge-alt">Make an Impact</span>
                    <h2 class="fw-bold mt-3 mb-4">Why Volunteer With Us?</h2>
                    
                    <div class="benefit-list">
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-heart"></i>
                            </div>
                            <div class="benefit-content">
                                <h5>Make a Real Difference</h5>
                                <p>Help children discover the joy of learning French and other skills in a fun, immersive environment.</p>
                            </div>
                        </div>
                        
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <div class="benefit-content">
                                <h5>Join a Community</h5>
                                <p>Connect with passionate educators and like-minded individuals who share your values.</p>
                            </div>
                        </div>
                        
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-graduation-cap"></i>
                            </div>
                            <div class="benefit-content">
                                <h5>Grow Your Skills</h5>
                                <p>Develop leadership, teaching, and organizational skills while gaining valuable experience.</p>
                            </div>
                        </div>
                        
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-certificate"></i>
                            </div>
                            <div class="benefit-content">
                                <h5>Get Recognized</h5>
                                <p>Receive certificates, recommendation letters, and recognition for your contributions.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-6">
                <div class="volunteer-roles-card">
                    <div class="roles-header">
                        <h4><i class="fas fa-tasks me-2"></i>Volunteer Opportunities</h4>
                        <p>Find a role that matches your skills and interests</p>
                    </div>
                    
                    <div class="roles-grid">
                        <div class="role-card">
                            <div class="role-icon">
                                <i class="fas fa-chalkboard-teacher"></i>
                            </div>
                            <h6>Teaching Assistant</h6>
                            <p>Support workshop facilitators and engage with learners</p>
                        </div>
                        
                        <div class="role-card">
                            <div class="role-icon">
                                <i class="fas fa-calendar-check"></i>
                            </div>
                            <h6>Event Coordinator</h6>
                            <p>Help organize workshops and community events</p>
                        </div>
                        
                        <div class="role-card">
                            <div class="role-icon">
                                <i class="fas fa-camera"></i>
                            </div>
                            <h6>Media & Photography</h6>
                            <p>Capture moments and create content for our platforms</p>
                        </div>
                        
                        <div class="role-card">
                            <div class="role-icon">
                                <i class="fas fa-bullhorn"></i>
                            </div>
                            <h6>Outreach & Marketing</h6>
                            <p>Spread the word and grow our community</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-5 cta-section">
    <div class="container">
        <div class="cta-card">
            <div class="cta-content">
                <div class="cta-icon">
                    <i class="fas fa-hands-helping"></i>
                </div>
                <h2 class="fw-bold text-white mb-3">Ready to Make a Difference?</h2>
                <p class="lead text-white-50 mb-4">Join our volunteer team and help us transform how children learn languages and skills in Ghana.</p>
                <div class="cta-buttons">
                    <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-light btn-lg">
                        <i class="fas fa-user-plus me-2"></i>Apply to Volunteer
                    </a>
                    <a href="https://wa.me/233500557751?text=Hi!%20I'm%20interested%20in%20volunteering%20with%20TSA" 
                       target="_blank" 
                       class="btn btn-outline-light btn-lg">
                        <i class="fab fa-whatsapp me-2"></i>Chat With Us
                    </a>
                </div>
            </div>
            
            <!-- Decorative Elements -->
            <div class="cta-decoration">
                <div class="decoration-circle circle-1"></div>
                <div class="decoration-circle circle-2"></div>
                <div class="decoration-circle circle-3"></div>
            </div>
        </div>
    </div>
</section>

<style>
/* =========================================
   THE SKILLS ATELIER - VOLUNTEERS PAGE STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
}

/* =========================================
   VOLUNTEERS HERO
   ========================================= */
.volunteers-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 80px;
    position: relative;
    overflow: hidden;
}

.volunteers-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.breadcrumb-custom {
    background: transparent;
    padding: 0;
    margin: 0;
}

.breadcrumb-custom .breadcrumb-item a {
    color: rgba(255,255,255,0.7);
    text-decoration: none;
    transition: color 0.3s ease;
}

.breadcrumb-custom .breadcrumb-item a:hover {
    color: white;
}

.breadcrumb-custom .breadcrumb-item.active {
    color: white;
}

.breadcrumb-custom .breadcrumb-item + .breadcrumb-item::before {
    color: rgba(255,255,255,0.5);
}

.section-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.section-badge-alt {
    display: inline-block;
    background: var(--tsa-gradient);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.hero-btn {
    background: white;
    color: var(--tsa-primary);
    font-weight: 600;
    padding: 1rem 2rem;
    border-radius: 50px;
    border: none;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    transition: all 0.3s ease;
}

.hero-btn:hover {
    background: var(--tsa-cream);
    color: var(--tsa-primary-dark);
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.3);
}

/* =========================================
   VOLUNTEER STATS BAR
   ========================================= */
.volunteer-stats-bar {
    background: white;
    padding: 1.5rem 0;
    box-shadow: 0 10px 40px rgba(0,0,0,0.1);
    margin-top: -40px;
    position: relative;
    z-index: 10;
    border-radius: 20px;
    margin-left: 2rem;
    margin-right: 2rem;
}

.stats-wrapper {
    display: flex;
    justify-content: space-around;
    flex-wrap: wrap;
    gap: 1.5rem;
}

.stat-box {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.stat-icon {
    width: 55px;
    height: 55px;
    background: var(--tsa-gradient);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.3rem;
}

.stat-content {
    display: flex;
    flex-direction: column;
}

.stat-number {
    font-size: 1.75rem;
    font-weight: 700;
    color: #333;
    line-height: 1;
}

.stat-label {
    font-size: 0.85rem;
    color: #888;
}

/* =========================================
   VOLUNTEERS SECTION
   ========================================= */
.volunteers-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

.section-header {
    margin-bottom: 3rem;
}

/* =========================================
   VOLUNTEER CARDS
   ========================================= */
.volunteer-card {
    background: white;
    border-radius: 20px;
    padding: 2rem 1.5rem;
    text-align: center;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    transition: all 0.4s ease;
    position: relative;
    overflow: hidden;
    border: 2px solid transparent;
}

.volunteer-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 50px rgba(0,0,0,0.15);
    border-color: var(--tsa-primary);
}

/* Card Background Pattern */
.card-pattern {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 80px;
    background: var(--tsa-gradient);
    opacity: 0.1;
    transition: opacity 0.3s ease;
}

.volunteer-card:hover .card-pattern {
    opacity: 0.2;
}

/* Profile Image */
.volunteer-image {
    position: relative;
    display: inline-block;
    margin-bottom: 1.25rem;
}

.volunteer-image img {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    object-fit: cover;
    border: 4px solid white;
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    position: relative;
    z-index: 2;
    transition: transform 0.3s ease;
}

.volunteer-card:hover .volunteer-image img {
    transform: scale(1.05);
}

.avatar-placeholder {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    background: var(--tsa-gradient);
    display: flex;
    align-items: center;
    justify-content: center;
    border: 4px solid white;
    box-shadow: 0 10px 30px rgba(242, 97, 36, 0.3);
    position: relative;
    z-index: 2;
    transition: transform 0.3s ease;
}

.volunteer-card:hover .avatar-placeholder {
    transform: scale(1.05);
}

.avatar-placeholder span {
    color: white;
    font-size: 2.5rem;
    font-weight: 700;
}

.image-glow {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 130px;
    height: 130px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    opacity: 0;
    filter: blur(20px);
    transition: opacity 0.3s ease;
    z-index: 1;
}

.volunteer-card:hover .image-glow {
    opacity: 0.3;
}

/* Volunteer Info */
.volunteer-info {
    position: relative;
    z-index: 2;
}

.volunteer-name {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.25rem;
    font-size: 1.1rem;
}

.volunteer-role {
    color: var(--tsa-primary);
    font-weight: 500;
    font-size: 0.9rem;
    margin-bottom: 0.5rem;
}

.volunteer-location {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.4rem;
    color: #888;
    font-size: 0.85rem;
    margin-bottom: 1rem;
}

.volunteer-location i {
    color: var(--tsa-primary);
    font-size: 0.8rem;
}

/* Skills Tags */
.volunteer-skills {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 0.5rem;
    margin-top: 0.75rem;
}

.skill-tag {
    display: inline-block;
    background: var(--tsa-light);
    color: var(--tsa-primary);
    padding: 0.3rem 0.75rem;
    border-radius: 50px;
    font-size: 0.75rem;
    font-weight: 600;
}

/* Volunteer Actions */
.volunteer-actions {
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid #f0f0f0;
}

.volunteer-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.4rem;
    background: linear-gradient(135deg, rgba(242, 97, 36, 0.1), rgba(129, 5, 191, 0.1));
    color: var(--tsa-primary);
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.8rem;
    font-weight: 600;
}

/* =========================================
   EMPTY STATE
   ========================================= */
.empty-state {
    text-align: center;
    padding: 5rem 2rem;
}

.empty-icon {
    width: 140px;
    height: 140px;
    background: var(--tsa-light);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 2rem;
}

.empty-icon i {
    font-size: 4rem;
    color: var(--tsa-primary);
    opacity: 0.5;
}

/* =========================================
   WHY VOLUNTEER SECTION
   ========================================= */
.why-volunteer-section {
    background: #f8f9fa;
}

.why-content {
    padding-right: 2rem;
}

.benefit-list {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.benefit-item {
    display: flex;
    gap: 1.25rem;
    align-items: flex-start;
}

.benefit-icon {
    width: 55px;
    height: 55px;
    min-width: 55px;
    background: var(--tsa-gradient);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.3rem;
    box-shadow: 0 10px 25px rgba(242, 97, 36, 0.3);
}

.benefit-content h5 {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.25rem;
}

.benefit-content p {
    color: #666;
    font-size: 0.95rem;
    margin: 0;
    line-height: 1.6;
}

/* Volunteer Roles Card */
.volunteer-roles-card {
    background: white;
    border-radius: 25px;
    padding: 2rem;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
}

.roles-header {
    text-align: center;
    margin-bottom: 2rem;
}

.roles-header h4 {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.5rem;
}

.roles-header p {
    color: #888;
    font-size: 0.95rem;
    margin: 0;
}

.roles-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
}

.role-card {
    background: var(--tsa-light);
    border-radius: 15px;
    padding: 1.5rem;
    text-align: center;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.role-card:hover {
    background: white;
    border-color: var(--tsa-primary);
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(242, 97, 36, 0.15);
}

.role-icon {
    width: 50px;
    height: 50px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
    margin: 0 auto 1rem;
}

.role-card h6 {
    font-weight: 700;
    color: #333;
    margin-bottom: 0.5rem;
}

.role-card p {
    font-size: 0.8rem;
    color: #888;
    margin: 0;
    line-height: 1.5;
}

/* =========================================
   CTA SECTION
   ========================================= */
.cta-section {
    background: var(--tsa-gradient);
    position: relative;
    overflow: hidden;
}

.cta-card {
    background: rgba(255,255,255,0.1);
    backdrop-filter: blur(10px);
    border-radius: 25px;
    padding: 4rem;
    text-align: center;
    border: 1px solid rgba(255,255,255,0.2);
    position: relative;
    overflow: hidden;
}

.cta-icon {
    width: 90px;
    height: 90px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    font-size: 2.5rem;
    color: white;
}

.cta-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.cta-section .btn-light {
    background: white;
    color: var(--tsa-primary);
    font-weight: 600;
    padding: 1rem 2rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
}

.cta-section .btn-light:hover {
    background: var(--tsa-cream);
    transform: translateY(-3px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
}

.cta-section .btn-outline-light {
    border: 2px solid white;
    color: white;
    font-weight: 600;
    padding: 1rem 2rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.cta-section .btn-outline-light:hover {
    background: white;
    color: var(--tsa-primary);
    transform: translateY(-3px);
}

/* Decorative Circles */
.cta-decoration {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    pointer-events: none;
}

.decoration-circle {
    position: absolute;
    border-radius: 50%;
    background: rgba(255,255,255,0.1);
}

.circle-1 {
    width: 200px;
    height: 200px;
    top: -50px;
    left: -50px;
}

.circle-2 {
    width: 150px;
    height: 150px;
    bottom: -30px;
    right: 10%;
}

.circle-3 {
    width: 100px;
    height: 100px;
    top: 20%;
    right: -30px;
}

/* =========================================
   BUTTON STYLES
   ========================================= */
.btn-primary {
    background: var(--tsa-gradient);
    border: none;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    background: var(--tsa-gradient-reverse);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(242, 97, 36, 0.4);
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .volunteers-hero {
        padding: 80px 0 60px;
    }
    
    .volunteers-hero h1 {
        font-size: 2rem;
    }
    
    .volunteer-stats-bar {
        margin-left: 1rem;
        margin-right: 1rem;
    }
    
    .stats-wrapper {
        justify-content: center;
    }
    
    .why-content {
        padding-right: 0;
        margin-bottom: 2rem;
    }
    
    .roles-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .cta-card {
        padding: 3rem 2rem;
    }
}

@media (max-width: 768px) {
    .volunteers-hero {
        padding: 70px 0 50px;
        text-align: center;
    }
    
    .volunteers-hero h1 {
        font-size: 1.75rem;
    }
    
    .volunteer-stats-bar {
        margin-top: -30px;
        padding: 1rem;
    }
    
    .stats-wrapper {
        gap: 1rem;
    }
    
    .stat-box {
        flex: 0 0 45%;
    }
    
    .stat-icon {
        width: 45px;
        height: 45px;
        font-size: 1.1rem;
    }
    
    .stat-number {
        font-size: 1.5rem;
    }
    
    .benefit-item {
        flex-direction: column;
        text-align: center;
        align-items: center;
    }
    
    .roles-grid {
        grid-template-columns: 1fr;
    }
    
    .cta-card {
        padding: 2rem 1.5rem;
    }
    
    .cta-buttons {
        flex-direction: column;
    }
    
    .cta-buttons .btn {
        width: 100%;
    }
}

/* =========================================
   ANIMATIONS
   ========================================= */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.volunteer-card {
    animation: fadeInUp 0.5s ease forwards;
    opacity: 0;
}

.volunteer-card:nth-child(1) { animation-delay: 0.1s; }
.volunteer-card:nth-child(2) { animation-delay: 0.2s; }
.volunteer-card:nth-child(3) { animation-delay: 0.3s; }
.volunteer-card:nth-child(4) { animation-delay: 0.4s; }
.volunteer-card:nth-child(5) { animation-delay: 0.5s; }
.volunteer-card:nth-child(6) { animation-delay: 0.6s; }
.volunteer-card:nth-child(7) { animation-delay: 0.7s; }
.volunteer-card:nth-child(8) { animation-delay: 0.8s; }

.benefit-item {
    animation: fadeInUp 0.5s ease forwards;
    opacity: 0;
}

.benefit-item:nth-child(1) { animation-delay: 0.1s; }
.benefit-item:nth-child(2) { animation-delay: 0.2s; }
.benefit-item:nth-child(3) { animation-delay: 0.3s; }
.benefit-item:nth-child(4) { animation-delay: 0.4s; }
</style>