<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="container py-5">
    <div class="text-center">
        <div class="mb-5">
            <h1 style="font-size: 120px; font-weight: 700; color: #f26124;">404</h1>
            <h2 class="fw-bold mb-3">Page Not Found</h2>
            <p class="lead text-muted mb-4">Sorry, the page you're looking for doesn't exist or has been moved.</p>
            <a href="<?php echo base_url(); ?>" class="btn btn-primary btn-lg">
                <i class="fas fa-home"></i> Back to Home
            </a>
        </div>
        
        <?php if (!empty($recent_posts) || !empty($featured_workshops)): ?>
            <div class="mt-5 pt-5 border-top">
                <h4 class="fw-bold mb-4">You Might Be Looking For:</h4>
                
                <div class="row justify-content-center">
                    <?php if (!empty($recent_posts)): ?>
                        <div class="col-md-6 mb-4">
                            <h5 class="fw-bold mb-3">Recent Articles</h5>
                            <ul class="list-unstyled">
                                <?php foreach ($recent_posts as $post): ?>
                                    <li class="mb-2">
                                        <a href="<?php echo base_url('blog/view/' . $post->slug); ?>" class="text-decoration-none">
                                            <i class="fas fa-newspaper text-primary"></i>
                                            <?php echo htmlspecialchars($post->title); ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($featured_workshops)): ?>
                        <div class="col-md-6 mb-4">
                            <h5 class="fw-bold mb-3">Featured Workshops</h5>
                            <ul class="list-unstyled">
                                <?php foreach ($featured_workshops as $workshop): ?>
                                    <li class="mb-2">
                                        <a href="<?php echo base_url('workshops/view/' . $workshop->slug); ?>" class="text-decoration-none">
                                            <i class="fas fa-chalkboard-teacher text-primary"></i>
                                            <?php echo htmlspecialchars($workshop->title); ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        
        <div class="mt-5">
            <h5 class="fw-bold mb-3">Quick Links</h5>
            <div class="d-flex flex-wrap justify-content-center gap-2">
                <a href="<?php echo base_url('about'); ?>" class="btn btn-outline-primary">About Us</a>
                <a href="<?php echo base_url('workshops'); ?>" class="btn btn-outline-primary">Workshops</a>
                <a href="<?php echo base_url('blog'); ?>" class="btn btn-outline-primary">Blog</a>
                <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-outline-primary">Volunteer</a>
                <a href="<?php echo base_url('contact'); ?>" class="btn btn-outline-primary">Contact</a>
            </div>
        </div>
    </div>
</div>