<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Donate Hero Banner -->
<section class="donate-hero">
    <div class="container">
        <div class="row align-items-center justify-content-center">
            <div class="col-lg-8 text-center">
                <div class="hero-heart">
                    <i class="fas fa-heart"></i>
                    <div class="heart-pulse"></div>
                    <div class="heart-pulse pulse-2"></div>
                </div>
                <span class="section-badge mb-3">
                    <i class="fas fa-gift me-2"></i>Support Our Mission
                </span>
                <h1 class="display-5 fw-bold text-white mb-3">Make a Difference Today</h1>
                <p class="lead text-white-50 mb-0">Your generosity helps us transform how children learn languages and vital skills in Ghana.</p>
            </div>
        </div>
    </div>
</section>

<!-- Impact Stats Bar -->
<section class="impact-stats-bar">
    <div class="container">
        <div class="stats-wrapper">
            <div class="stat-box">
                <div class="stat-icon">
                    <i class="fas fa-child"></i>
                </div>
                <div class="stat-content">
                    <span class="stat-number counter" data-target="<?php echo $impact_stats['lives_impacted'] ?? 50; ?>"><?php echo number_format($impact_stats['lives_impacted'] ?? 50); ?>+</span>
                    <span class="stat-label">Lives Impacted</span>
                </div>
            </div>
            <div class="stat-box">
                <div class="stat-icon">
                    <i class="fas fa-chalkboard-teacher"></i>
                </div>
                <div class="stat-content">
                    <span class="stat-number"><?php echo number_format($impact_stats['workshops_held'] ?? 5); ?>+</span>
                    <span class="stat-label">Workshops Held</span>
                </div>
            </div>
            <div class="stat-box">
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-content">
                    <span class="stat-number"><?php echo number_format($impact_stats['active_volunteers'] ?? 10); ?>+</span>
                    <span class="stat-label">Volunteers</span>
                </div>
            </div>
            <div class="stat-box">
                <div class="stat-icon">
                    <i class="fas fa-handshake"></i>
                </div>
                <div class="stat-content">
                    <span class="stat-number"><?php echo number_format($impact_stats['partners'] ?? 2); ?>+</span>
                    <span class="stat-label">Partners</span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Main Donate Section -->
<section class="py-5 donate-section">
    <div class="container">
        <!-- Section Header -->
        <div class="text-center mb-5">
            <span class="section-badge-alt">Every Gift Counts</span>
            <h2 class="fw-bold mt-3">Ways to Give</h2>
            <p class="text-muted">Choose the donation method that works best for you</p>
        </div>
        
        <div class="row">
            <!-- Donation Methods -->
            <div class="col-lg-8 mb-4">
                <!-- Bank Transfer Card -->
                <div class="donation-card mb-4">
                    <div class="card-header-custom bank">
                        <div class="header-icon">
                            <i class="fas fa-university"></i>
                        </div>
                        <div class="header-content">
                            <h3>Bank Transfer</h3>
                            <p>Make a direct transfer to our account</p>
                        </div>
                    </div>
                    
                    <div class="card-body-custom">
                        <div class="bank-details">
                            <div class="detail-row">
                                <div class="detail-icon">
                                    <i class="fas fa-building"></i>
                                </div>
                                <div class="detail-content">
                                    <span class="detail-label">Bank Name</span>
                                    <span class="detail-value"><?php echo htmlspecialchars($donation_details['bank_name'] ?? 'Contact us for details'); ?></span>
                                </div>
                                <button class="btn-copy" onclick="copyToClipboard('<?php echo htmlspecialchars($donation_details['bank_name'] ?? ''); ?>', this)">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                            
                            <div class="detail-row">
                                <div class="detail-icon">
                                    <i class="fas fa-hashtag"></i>
                                </div>
                                <div class="detail-content">
                                    <span class="detail-label">Account Number</span>
                                    <span class="detail-value highlight"><?php echo htmlspecialchars($donation_details['account_number'] ?? 'Contact us for details'); ?></span>
                                </div>
                                <button class="btn-copy" onclick="copyToClipboard('<?php echo htmlspecialchars($donation_details['account_number'] ?? ''); ?>', this)">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                            
                            <div class="detail-row">
                                <div class="detail-icon">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div class="detail-content">
                                    <span class="detail-label">Account Name</span>
                                    <span class="detail-value"><?php echo htmlspecialchars($donation_details['account_name'] ?? 'The Skills Atelier'); ?></span>
                                </div>
                                <button class="btn-copy" onclick="copyToClipboard('<?php echo htmlspecialchars($donation_details['account_name'] ?? ''); ?>', this)">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Mobile Money Card -->
                <div class="donation-card mb-4">
                    <div class="card-header-custom momo">
                        <div class="header-icon">
                            <i class="fas fa-mobile-alt"></i>
                        </div>
                        <div class="header-content">
                            <h3>Mobile Money</h3>
                            <p>Quick and easy mobile payments</p>
                        </div>
                    </div>
                    
                    <div class="card-body-custom">
                        <div class="momo-options">
                            <div class="momo-provider">
                                <div class="provider-logo mtn">
                                    <span>MTN</span>
                                </div>
                                <div class="provider-details">
                                    <span class="provider-name">MTN Mobile Money</span>
                                    <span class="provider-number"><?php echo htmlspecialchars($donation_details['mobile_money'] ?? '+233 50 055 7751'); ?></span>
                                </div>
                                <button class="btn-copy" onclick="copyToClipboard('<?php echo htmlspecialchars($donation_details['mobile_money'] ?? '+233500557751'); ?>', this)">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                            
                            <!-- Add more providers if available -->
                            <!--
                            <div class="momo-provider">
                                <div class="provider-logo vodafone">
                                    <span>VF</span>
                                </div>
                                <div class="provider-details">
                                    <span class="provider-name">Vodafone Cash</span>
                                    <span class="provider-number">+233 XX XXX XXXX</span>
                                </div>
                                <button class="btn-copy">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                            -->
                        </div>
                        
                        <div class="momo-steps">
                            <h6><i class="fas fa-info-circle me-2"></i>How to Send via Mobile Money:</h6>
                            <ol>
                                <li>Dial *170# (MTN) on your phone</li>
                                <li>Select "Transfer Money"</li>
                                <li>Enter the number above</li>
                                <li>Enter your donation amount</li>
                                <li>Confirm with your PIN</li>
                            </ol>
                        </div>
                    </div>
                </div>
                
                <!-- Donation Impact Section -->
                <div class="impact-card">
                    <div class="impact-header">
                        <i class="fas fa-chart-line"></i>
                        <h4>Your Donation Impact</h4>
                    </div>
                    <div class="impact-grid">
                        <div class="impact-item">
                            <div class="impact-amount">GH₵ 50</div>
                            <div class="impact-desc">Provides learning materials for 1 child for a month</div>
                        </div>
                        <div class="impact-item">
                            <div class="impact-amount">GH₵ 100</div>
                            <div class="impact-desc">Sponsors a child's workshop registration</div>
                        </div>
                        <div class="impact-item">
                            <div class="impact-amount">GH₵ 250</div>
                            <div class="impact-desc">Covers a full term of French classes for 1 child</div>
                        </div>
                        <div class="impact-item">
                            <div class="impact-amount">GH₵ 500+</div>
                            <div class="impact-desc">Supports our community outreach programmes</div>
                        </div>
                    </div>
                </div>
                
                <!-- Confirmation Note -->
                <div class="confirmation-note">
                    <div class="note-icon">
                        <i class="fas fa-bell"></i>
                    </div>
                    <div class="note-content">
                        <h5>After Your Donation</h5>
                        <p>Please send us an email or WhatsApp message with your name and donation amount so we can acknowledge your generous contribution and send you a receipt.</p>
                        <div class="note-actions">
                            <a href="mailto:info@theskillsatelier.com?subject=Donation%20Confirmation" class="btn btn-note">
                                <i class="fas fa-envelope me-2"></i>Send Email
                            </a>
                            <a href="https://wa.me/233500557751?text=Hello!%20I%20just%20made%20a%20donation%20to%20TSA." target="_blank" class="btn btn-note whatsapp">
                                <i class="fab fa-whatsapp me-2"></i>WhatsApp
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <aside class="sidebar">
                    <!-- Other Ways Widget -->
                    <div class="sidebar-widget ways-widget">
                        <div class="ways-header">
                            <i class="fas fa-hands-helping"></i>
                            <h5>Other Ways to Help</h5>
                        </div>
                        <p>Your time and skills are valuable too!</p>
                        
                        <div class="ways-options">
                            <a href="<?php echo base_url('volunteer/apply'); ?>" class="way-option">
                                <div class="way-icon">
                                    <i class="fas fa-hand-holding-heart"></i>
                                </div>
                                <div class="way-content">
                                    <h6>Volunteer</h6>
                                    <p>Share your time and skills</p>
                                </div>
                                <i class="fas fa-chevron-right"></i>
                            </a>
                            
                            <a href="<?php echo base_url('contact'); ?>" class="way-option">
                                <div class="way-icon">
                                    <i class="fas fa-handshake"></i>
                                </div>
                                <div class="way-content">
                                    <h6>Partner With Us</h6>
                                    <p>Corporate partnerships</p>
                                </div>
                                <i class="fas fa-chevron-right"></i>
                            </a>
                            
                            <a href="<?php echo base_url('workshops'); ?>" class="way-option">
                                <div class="way-icon">
                                    <i class="fas fa-share-alt"></i>
                                </div>
                                <div class="way-content">
                                    <h6>Spread the Word</h6>
                                    <p>Tell others about us</p>
                                </div>
                                <i class="fas fa-chevron-right"></i>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Why Donate Widget -->
                    <div class="sidebar-widget why-widget">
                        <h5 class="widget-title"><i class="fas fa-heart me-2"></i>Why Support TSA?</h5>
                        <div class="why-list">
                            <div class="why-item">
                                <div class="why-icon">
                                    <i class="fas fa-check"></i>
                                </div>
                                <span>100% goes to programmes</span>
                            </div>
                            <div class="why-item">
                                <div class="why-icon">
                                    <i class="fas fa-check"></i>
                                </div>
                                <span>Transparent reporting</span>
                            </div>
                            <div class="why-item">
                                <div class="why-icon">
                                    <i class="fas fa-check"></i>
                                </div>
                                <span>Local community impact</span>
                            </div>
                            <div class="why-item">
                                <div class="why-icon">
                                    <i class="fas fa-check"></i>
                                </div>
                                <span>Empowering children</span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Contact Widget -->
                    <div class="sidebar-widget contact-widget">
                        <div class="contact-icon">
                            <i class="fas fa-question-circle"></i>
                        </div>
                        <h5>Questions About Donating?</h5>
                        <p>We're happy to answer any questions you have about donations and how your contribution will be used.</p>
                        <a href="<?php echo base_url('contact'); ?>" class="btn btn-contact">
                            <i class="fas fa-envelope me-2"></i>Contact Us
                        </a>
                    </div>
                    
                    <!-- Testimonial Widget -->
                    <div class="sidebar-widget donor-widget">
                        <div class="donor-quote">
                            <i class="fas fa-quote-left"></i>
                        </div>
                        <p class="donor-text">"Supporting TSA has been incredibly rewarding. Seeing the children learn and grow makes every contribution worthwhile."</p>
                        <div class="donor-info">
                            <div class="donor-avatar">
                                <span>KA</span>
                            </div>
                            <div>
                                <h6>Kwame A.</h6>
                                <span>Monthly Donor</span>
                            </div>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<!-- Trust Section -->
<section class="py-5 trust-section">
    <div class="container">
        <div class="trust-card">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <div class="trust-content">
                        <span class="section-badge-alt">Our Promise</span>
                        <h3 class="fw-bold mt-3">Transparency & Accountability</h3>
                        <p>At The Skills Atelier, we believe in complete transparency. Every donation is tracked and reported on, ensuring your contribution makes the maximum impact.</p>
                        <div class="trust-points">
                            <div class="trust-point">
                                <i class="fas fa-file-alt"></i>
                                <span>Regular impact reports</span>
                            </div>
                            <div class="trust-point">
                                <i class="fas fa-receipt"></i>
                                <span>Donation receipts provided</span>
                            </div>
                            <div class="trust-point">
                                <i class="fas fa-eye"></i>
                                <span>Open financial records</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="trust-visual">
                        <div class="visual-circle">
                            <div class="circle-content">
                                <span class="circle-percent">100%</span>
                                <span class="circle-text">Goes to Programmes</span>
                            </div>
                            <svg class="circle-progress" viewBox="0 0 100 100">
                                <circle class="circle-bg" cx="50" cy="50" r="45"/>
                                <circle class="circle-fill" cx="50" cy="50" r="45"/>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Copy Success Toast -->
<div class="copy-toast" id="copyToast">
    <i class="fas fa-check-circle"></i>
    <span>Copied to clipboard!</span>
</div>

<style>
/* =========================================
   THE SKILLS ATELIER - DONATE PAGE STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
    --whatsapp-green: #25D366;
    --mtn-yellow: #ffcc00;
}

/* =========================================
   DONATE HERO
   ========================================= */
.donate-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 80px;
    position: relative;
    overflow: hidden;
}

.donate-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.hero-heart {
    position: relative;
    display: inline-block;
    margin-bottom: 1.5rem;
}

.hero-heart > i {
    font-size: 4rem;
    color: white;
    position: relative;
    z-index: 2;
    animation: heartbeat 1.5s infinite;
}

@keyframes heartbeat {
    0%, 100% { transform: scale(1); }
    25% { transform: scale(1.1); }
    50% { transform: scale(1); }
    75% { transform: scale(1.1); }
}

.heart-pulse {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 100px;
    height: 100px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    animation: pulse-out 2s infinite;
}

.heart-pulse.pulse-2 {
    animation-delay: 0.5s;
}

@keyframes pulse-out {
    0% { transform: translate(-50%, -50%) scale(0.5); opacity: 1; }
    100% { transform: translate(-50%, -50%) scale(1.5); opacity: 0; }
}

.section-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.section-badge-alt {
    display: inline-block;
    background: var(--tsa-gradient);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

/* =========================================
   IMPACT STATS BAR
   ========================================= */
.impact-stats-bar {
    background: white;
    padding: 1.5rem 0;
    box-shadow: 0 10px 40px rgba(0,0,0,0.1);
    margin-top: -40px;
    position: relative;
    z-index: 10;
    border-radius: 20px;
    margin-left: 2rem;
    margin-right: 2rem;
}

.stats-wrapper {
    display: flex;
    justify-content: space-around;
    flex-wrap: wrap;
    gap: 1.5rem;
}

.stat-box {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.stat-icon {
    width: 55px;
    height: 55px;
    background: var(--tsa-gradient);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.3rem;
}

.stat-content {
    display: flex;
    flex-direction: column;
}

.stat-number {
    font-size: 1.75rem;
    font-weight: 700;
    color: #333;
    line-height: 1;
}

.stat-label {
    font-size: 0.85rem;
    color: #888;
}

/* =========================================
   DONATE SECTION
   ========================================= */
.donate-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

/* Donation Cards */
.donation-card {
    background: white;
    border-radius: 25px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
    overflow: hidden;
}

.card-header-custom {
    padding: 1.5rem 2rem;
    display: flex;
    align-items: center;
    gap: 1.25rem;
}

.card-header-custom.bank {
    background: var(--tsa-gradient);
}

.card-header-custom.momo {
    background: linear-gradient(135deg, var(--mtn-yellow), #e6b800);
}

.header-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: white;
}

.card-header-custom.momo .header-icon {
    color: #333;
}

.header-content h3 {
    color: white;
    font-weight: 700;
    margin-bottom: 0.25rem;
}

.card-header-custom.momo .header-content h3 {
    color: #333;
}

.header-content p {
    color: rgba(255,255,255,0.85);
    margin: 0;
    font-size: 0.9rem;
}

.card-header-custom.momo .header-content p {
    color: rgba(0,0,0,0.6);
}

.card-body-custom {
    padding: 2rem;
}

/* Bank Details */
.bank-details {
    display: flex;
    flex-direction: column;
    gap: 1.25rem;
}

.detail-row {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.25rem;
    background: #f8f9fa;
    border-radius: 12px;
    transition: all 0.3s ease;
}

.detail-row:hover {
    background: var(--tsa-light);
}

.detail-icon {
    width: 45px;
    height: 45px;
    background: var(--tsa-gradient);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1rem;
}

.detail-content {
    flex: 1;
    display: flex;
    flex-direction: column;
}

.detail-label {
    font-size: 0.75rem;
    color: #888;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.detail-value {
    font-weight: 600;
    color: #333;
    font-size: 1.1rem;
}

.detail-value.highlight {
    color: var(--tsa-primary);
    font-size: 1.25rem;
}

.btn-copy {
    width: 40px;
    height: 40px;
    border: none;
    background: white;
    border-radius: 10px;
    color: var(--tsa-primary);
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.btn-copy:hover {
    background: var(--tsa-primary);
    color: white;
    transform: scale(1.05);
}

.btn-copy.copied {
    background: #28a745;
    color: white;
}

/* Mobile Money */
.momo-options {
    margin-bottom: 1.5rem;
}

.momo-provider {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.25rem;
    background: #f8f9fa;
    border-radius: 12px;
    margin-bottom: 1rem;
}

.momo-provider:last-child {
    margin-bottom: 0;
}

.provider-logo {
    width: 50px;
    height: 50px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 0.85rem;
}

.provider-logo.mtn {
    background: var(--mtn-yellow);
    color: #333;
}

.provider-logo.vodafone {
    background: #e60000;
    color: white;
}

.provider-details {
    flex: 1;
    display: flex;
    flex-direction: column;
}

.provider-name {
    font-size: 0.85rem;
    color: #888;
}

.provider-number {
    font-weight: 700;
    color: #333;
    font-size: 1.1rem;
}

.momo-steps {
    background: linear-gradient(135deg, rgba(255, 204, 0, 0.1), rgba(255, 204, 0, 0.05));
    padding: 1.25rem;
    border-radius: 12px;
    border-left: 4px solid var(--mtn-yellow);
}

.momo-steps h6 {
    font-weight: 600;
    color: #333;
    margin-bottom: 0.75rem;
}

.momo-steps ol {
    margin: 0;
    padding-left: 1.25rem;
}

.momo-steps li {
    color: #555;
    margin-bottom: 0.5rem;
    font-size: 0.9rem;
}

.momo-steps li:last-child {
    margin-bottom: 0;
}

/* Impact Card */
.impact-card {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
}

.impact-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 1.5rem;
}

.impact-header i {
    font-size: 1.5rem;
    color: var(--tsa-primary);
}

.impact-header h4 {
    font-weight: 700;
    margin: 0;
}

.impact-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
}

.impact-item {
    background: var(--tsa-light);
    padding: 1.25rem;
    border-radius: 15px;
    border: 2px solid transparent;
    transition: all 0.3s ease;
}

.impact-item:hover {
    border-color: var(--tsa-primary);
    transform: translateY(-3px);
}

.impact-amount {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--tsa-primary);
    margin-bottom: 0.5rem;
}

.impact-desc {
    font-size: 0.9rem;
    color: #555;
    line-height: 1.5;
}

/* Confirmation Note */
.confirmation-note {
    background: linear-gradient(135deg, rgba(242, 97, 36, 0.1), rgba(129, 5, 191, 0.1));
    border-radius: 20px;
    padding: 2rem;
    display: flex;
    gap: 1.5rem;
    align-items: flex-start;
    border: 2px dashed var(--tsa-primary);
}

.note-icon {
    width: 60px;
    height: 60px;
    min-width: 60px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: white;
}

.note-content h5 {
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.note-content p {
    color: #555;
    margin-bottom: 1rem;
    line-height: 1.6;
}

.note-actions {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.btn-note {
    background: white;
    color: var(--tsa-primary);
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    border: 2px solid var(--tsa-primary);
    transition: all 0.3s ease;
}

.btn-note:hover {
    background: var(--tsa-primary);
    color: white;
}

.btn-note.whatsapp {
    background: var(--whatsapp-green);
    color: white;
    border-color: var(--whatsapp-green);
}

.btn-note.whatsapp:hover {
    background: #128C7E;
    border-color: #128C7E;
}

/* =========================================
   SIDEBAR
   ========================================= */
.sidebar {
    position: sticky;
    top: 100px;
}

.sidebar-widget {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.widget-title {
    font-weight: 700;
    color: #333;
    margin-bottom: 1rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #f0f0f0;
}

/* Ways Widget */
.ways-widget {
    background: var(--tsa-gradient);
    padding: 2rem;
}

.ways-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 0.5rem;
}

.ways-header i {
    font-size: 1.5rem;
    color: white;
}

.ways-header h5 {
    color: white;
    font-weight: 700;
    margin: 0;
}

.ways-widget > p {
    color: rgba(255,255,255,0.85);
    margin-bottom: 1.25rem;
}

.ways-options {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.way-option {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    background: rgba(255,255,255,0.15);
    border-radius: 12px;
    text-decoration: none;
    transition: all 0.3s ease;
}

.way-option:hover {
    background: white;
}

.way-icon {
    width: 45px;
    height: 45px;
    background: white;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--tsa-primary);
    font-size: 1.1rem;
    transition: all 0.3s ease;
}

.way-option:hover .way-icon {
    background: var(--tsa-gradient);
    color: white;
}

.way-content {
    flex: 1;
}

.way-content h6 {
    color: white;
    font-weight: 600;
    margin: 0;
    font-size: 0.95rem;
    transition: color 0.3s ease;
}

.way-option:hover .way-content h6 {
    color: #333;
}

.way-content p {
    color: rgba(255,255,255,0.7);
    font-size: 0.8rem;
    margin: 0;
    transition: color 0.3s ease;
}

.way-option:hover .way-content p {
    color: #888;
}

.way-option > .fa-chevron-right {
    color: rgba(255,255,255,0.5);
    transition: all 0.3s ease;
}

.way-option:hover > .fa-chevron-right {
    color: var(--tsa-primary);
    transform: translateX(3px);
}

/* Why Widget */
.why-list {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.why-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.why-icon {
    width: 30px;
    height: 30px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.75rem;
}

.why-item span {
    color: #555;
    font-size: 0.95rem;
}

/* Contact Widget */
.contact-widget {
    text-align: center;
    background: #f8f9fa;
}

.contact-widget .contact-icon {
    width: 60px;
    height: 60px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.5rem;
    color: white;
}

.contact-widget h5 {
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.contact-widget p {
    color: #666;
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

.btn-contact {
    background: var(--tsa-gradient);
    color: white;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    border: none;
    width: 100%;
    transition: all 0.3s ease;
}

.btn-contact:hover {
    background: var(--tsa-gradient-reverse);
    color: white;
    transform: translateY(-2px);
}

/* Donor Widget */
.donor-widget {
    background: linear-gradient(135deg, var(--tsa-light), #fff);
    border: 2px solid var(--tsa-primary);
    position: relative;
    padding-top: 2.5rem;
}

.donor-quote {
    position: absolute;
    top: -15px;
    left: 1.5rem;
    width: 40px;
    height: 40px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1rem;
}

.donor-text {
    color: #555;
    font-style: italic;
    line-height: 1.7;
    margin-bottom: 1rem;
}

.donor-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.donor-avatar {
    width: 45px;
    height: 45px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 700;
    font-size: 0.9rem;
}

.donor-info h6 {
    font-weight: 600;
    margin: 0;
    color: #333;
}

.donor-info span {
    font-size: 0.8rem;
    color: #888;
}

/* =========================================
   TRUST SECTION
   ========================================= */
.trust-section {
    background: #f8f9fa;
}

.trust-card {
    background: white;
    border-radius: 25px;
    padding: 3rem;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
}

.trust-content h3 {
    margin-bottom: 1rem;
}

.trust-content p {
    color: #666;
    line-height: 1.7;
    margin-bottom: 1.5rem;
}

.trust-points {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.trust-point {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.trust-point i {
    width: 35px;
    height: 35px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.85rem;
}

.trust-point span {
    font-weight: 500;
    color: #333;
}

/* Trust Visual */
.trust-visual {
    display: flex;
    justify-content: center;
    align-items: center;
}

.visual-circle {
    position: relative;
    width: 220px;
    height: 220px;
}

.circle-content {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    text-align: center;
    z-index: 2;
}

.circle-percent {
    display: block;
    font-size: 3rem;
    font-weight: 700;
    color: var(--tsa-primary);
}

.circle-text {
    display: block;
    font-size: 0.9rem;
    color: #666;
    max-width: 120px;
}

.circle-progress {
    width: 100%;
    height: 100%;
    transform: rotate(-90deg);
}

.circle-bg {
    fill: none;
    stroke: #e9ecef;
    stroke-width: 8;
}

.circle-fill {
    fill: none;
    stroke: url(#gradient);
    stroke-width: 8;
    stroke-linecap: round;
    stroke-dasharray: 283;
    stroke-dashoffset: 0;
    animation: fillCircle 2s ease-out forwards;
}

@keyframes fillCircle {
    from { stroke-dashoffset: 283; }
    to { stroke-dashoffset: 0; }
}

/* =========================================
   COPY TOAST
   ========================================= */
.copy-toast {
    position: fixed;
    bottom: 30px;
    left: 50%;
    transform: translateX(-50%) translateY(100px);
    background: #333;
    color: white;
    padding: 1rem 2rem;
    border-radius: 50px;
    display: flex;
    align-items: center;
    gap: 0.75rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.3);
    z-index: 9999;
    opacity: 0;
    transition: all 0.3s ease;
}

.copy-toast.show {
    transform: translateX(-50%) translateY(0);
    opacity: 1;
}

.copy-toast i {
    color: #28a745;
    font-size: 1.2rem;
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .donate-hero {
        padding: 80px 0 60px;
    }
    
    .donate-hero h1 {
        font-size: 2rem;
    }
    
    .impact-stats-bar {
        margin-left: 1rem;
        margin-right: 1rem;
    }
    
    .stats-wrapper {
        justify-content: center;
    }
    
    .sidebar {
        position: relative;
        top: 0;
        margin-top: 2rem;
    }
    
    .trust-card {
        padding: 2rem;
    }
}

@media (max-width: 768px) {
    .donate-hero {
        padding: 70px 0 50px;
    }
    
    .donate-hero h1 {
        font-size: 1.75rem;
    }
    
    .hero-heart > i {
        font-size: 3rem;
    }
    
    .impact-stats-bar {
        margin-top: -30px;
        padding: 1rem;
    }
    
    .stat-box {
        flex: 0 0 45%;
    }
    
    .card-header-custom {
        flex-direction: column;
        text-align: center;
    }
    
    .card-body-custom {
        padding: 1.5rem;
    }
    
    .detail-row {
        flex-wrap: wrap;
    }
    
    .impact-grid {
        grid-template-columns: 1fr;
    }
    
    .confirmation-note {
        flex-direction: column;
        text-align: center;
    }
    
    .note-actions {
        justify-content: center;
    }
    
    .trust-visual {
        margin-top: 2rem;
    }
    
    .visual-circle {
        width: 180px;
        height: 180px;
    }
    
    .circle-percent {
        font-size: 2.5rem;
    }
}
</style>

<!-- SVG Gradient Definition -->
<svg width="0" height="0">
    <defs>
        <linearGradient id="gradient" x1="0%" y1="0%" x2="100%" y2="0%">
            <stop offset="0%" style="stop-color:#f26124"/>
            <stop offset="100%" style="stop-color:#8105bf"/>
        </linearGradient>
    </defs>
</svg>

<script>
// Copy to clipboard function
function copyToClipboard(text, button) {
    if (!text) return;
    
    if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(text).then(function() {
            showCopySuccess(button);
        }).catch(function() {
            fallbackCopy(text, button);
        });
    } else {
        fallbackCopy(text, button);
    }
}

function fallbackCopy(text, button) {
    var textArea = document.createElement('textarea');
    textArea.value = text;
    textArea.style.position = 'fixed';
    textArea.style.left = '-9999px';
    document.body.appendChild(textArea);
    textArea.select();
    try {
        document.execCommand('copy');
        showCopySuccess(button);
    } catch (err) {
        console.error('Copy failed', err);
    }
    document.body.removeChild(textArea);
}

function showCopySuccess(button) {
    // Update button
    var originalHTML = button.innerHTML;
    button.innerHTML = '<i class="fas fa-check"></i>';
    button.classList.add('copied');
    
    // Show toast
    var toast = document.getElementById('copyToast');
    toast.classList.add('show');
    
    // Reset after 2 seconds
    setTimeout(function() {
        button.innerHTML = originalHTML;
        button.classList.remove('copied');
        toast.classList.remove('show');
    }, 2000);
}
</script>