<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Hero Banner -->
<section class="about-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8 mx-auto text-center">
                <span class="section-badge">About Us</span>
                <h1 class="display-4 fw-bold text-white mb-4">The Skills Atelier | TSA</h1>
                <p class="lead text-white-50">Transforming how language and vital skills are taught, starting with children.</p>
            </div>
        </div>
    </div>
</section>

<!-- Our Story Section -->
<section class="py-5 story-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="story-image-container">
                    <img src="<?php echo base_url('assets/images/founder.jpg'); ?>" 
                         alt="Our Founder's Journey" 
                         class="img-fluid rounded-4 shadow-lg main-story-img">
                    <div class="story-accent">
                        <i class="fas fa-quote-left fa-2x mb-2"></i>
                        <p class="mb-0">"A decade in France taught me what immersive learning truly means."</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <span class="section-badge">Our Story</span>
                <h2 class="fw-bold mb-4">Born From Personal Experience</h2>
                <p class="lead text-muted mb-4"><?php echo $site_settings['about_description'] ?? 'The Skills Atelier was born out of a deeply personal journey.'; ?></p>
                
                <p>Our founder began learning French and Spanish in Ghana, only to face a <strong>rigid, non-immersive system</strong> that made true language acquisition feel out of reach.</p>
                
                <p>Years later, after <strong>over a decade living and working in France</strong>—and travelling through various francophone countries—she returned home with a mission: to transform how language and vital skills are taught, starting with children.</p>
                
                <div class="journey-timeline mt-4">
                    <div class="timeline-item">
                        <div class="timeline-icon">
                            <i class="fas fa-graduation-cap"></i>
                        </div>
                        <div class="timeline-content">
                            <h6 class="mb-1">Learning in Ghana</h6>
                            <p class="small text-muted mb-0">Faced rigid, traditional language education systems</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-icon">
                            <i class="fas fa-plane"></i>
                        </div>
                        <div class="timeline-content">
                            <h6 class="mb-1">Living in France</h6>
                            <p class="small text-muted mb-0">Over a decade of immersive experience</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-icon">
                            <i class="fas fa-lightbulb"></i>
                        </div>
                        <div class="timeline-content">
                            <h6 class="mb-1">The Mission</h6>
                            <p class="small text-muted mb-0">Returned to Ghana to transform education</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-icon">
                            <i class="fas fa-rocket"></i>
                        </div>
                        <div class="timeline-content">
                            <h6 class="mb-1">April 2025</h6>
                            <p class="small text-muted mb-0">Launched The Skills Atelier</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Statistics Section -->
<section class="py-5 statistics-section">
    <div class="container">
        <div class="row text-center text-white">
            <div class="col-md-3 col-6 mb-4 mb-md-0">
                <div class="stat-item">
                    <div class="stat-icon mb-3">
                        <i class="fas fa-hands-helping"></i>
                    </div>
                    <h2 class="display-4 fw-bold mb-0"><?php echo number_format($statistics['volunteers'] ?? 0); ?>+</h2>
                    <p class="lead mb-0">Volunteers</p>
                </div>
            </div>
            <div class="col-md-3 col-6 mb-4 mb-md-0">
                <div class="stat-item">
                    <div class="stat-icon mb-3">
                        <i class="fas fa-chalkboard-teacher"></i>
                    </div>
                    <h2 class="display-4 fw-bold mb-0"><?php echo number_format($statistics['workshops'] ?? 0); ?>+</h2>
                    <p class="lead mb-0">Workshops</p>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-item">
                    <div class="stat-icon mb-3">
                        <i class="fas fa-handshake"></i>
                    </div>
                    <h2 class="display-4 fw-bold mb-0"><?php echo number_format($statistics['partners'] ?? 0); ?>+</h2>
                    <p class="lead mb-0">Partners</p>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-item">
                    <div class="stat-icon mb-3">
                        <i class="fas fa-child"></i>
                    </div>
                    <h2 class="display-4 fw-bold mb-0"><?php echo number_format($statistics['total_learners'] ?? 0); ?>+</h2>
                    <p class="lead mb-0">Learners</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Mission & Vision Section -->
<section class="py-5 mission-vision-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 mb-4">
                <div class="mission-card h-100">
                    <div class="card-icon">
                        <i class="fas fa-bullseye"></i>
                    </div>
                    <h3 class="fw-bold mb-3">Our Mission</h3>
                    <p class="lead mb-4">To transform how language and vital skills are taught through fun, immersive, and interactive learning experiences.</p>
                    <ul class="mission-list">
                        <li><i class="fas fa-check-circle"></i> Nurture curiosity and confidence in children</li>
                        <li><i class="fas fa-check-circle"></i> Connect learners to francophone cultures</li>
                        <li><i class="fas fa-check-circle"></i> Make language acquisition accessible and enjoyable</li>
                        <li><i class="fas fa-check-circle"></i> Empower lifelong learners and global citizens</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-6 mb-4">
                <div class="vision-card h-100">
                    <div class="card-icon">
                        <i class="fas fa-eye"></i>
                    </div>
                    <h3 class="fw-bold mb-3">Our Vision</h3>
                    <p class="lead mb-4">A Ghana where every child has access to quality, immersive language education and vital skills development.</p>
                    <ul class="vision-list">
                        <li><i class="fas fa-star"></i> Expand across multiple regions in Ghana</li>
                        <li><i class="fas fa-star"></i> Offer multiple language programmes</li>
                        <li><i class="fas fa-star"></i> Include tech, arts, and culinary skills</li>
                        <li><i class="fas fa-star"></i> Support Ghana's multilingual future</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Our Programmes Section -->
<section class="py-5 bg-light programmes-section">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-badge">What We Offer</span>
            <h2 class="fw-bold">Our Programmes</h2>
            <p class="lead text-muted">Skills development beyond language</p>
        </div>
        
        <div class="row">
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="programme-card">
                    <div class="programme-icon">
                        <i class="fas fa-language"></i>
                    </div>
                    <h5 class="fw-bold">Languages</h5>
                    <p class="text-muted mb-0">French, Spanish & more immersive language workshops</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="programme-card">
                    <div class="programme-icon">
                        <i class="fas fa-utensils"></i>
                    </div>
                    <h5 class="fw-bold">Culinary</h5>
                    <p class="text-muted mb-0">Cooking classes with cultural immersion experiences</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="programme-card">
                    <div class="programme-icon">
                        <i class="fas fa-laptop-code"></i>
                    </div>
                    <h5 class="fw-bold">Software & Tech</h5>
                    <p class="text-muted mb-0">Digital literacy and coding skills for the future</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="programme-card">
                    <div class="programme-icon">
                        <i class="fas fa-camera"></i>
                    </div>
                    <h5 class="fw-bold">Arts & Photography</h5>
                    <p class="text-muted mb-0">Creative expression and visual arts development</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- French Workshop Highlight -->
<section class="py-5 french-workshop-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 order-lg-2 mb-4 mb-lg-0">
                <div class="workshop-gallery">
                    <img src="<?php echo base_url('assets/images/workshop.jpg'); ?>" 
                         alt="French Workshop" 
                         class="img-fluid rounded-4 shadow-lg">
                    <div class="gallery-badge">
                        <span class="badge-flag">🇫🇷</span>
                        <span>Flagship Programme</span>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 order-lg-1">
                <span class="section-badge">Since April 2025</span>
                <h2 class="fw-bold mb-4">French Workshop for Kids</h2>
                <p class="lead">Helping children aged <strong>6 to 12</strong> fall in love with French through fun, immersive, and interactive learning experiences.</p>
                <p>Held in <strong>East Legon</strong> (hoping to expand to other areas), this weekly programme offers more than grammar and vocabulary—it nurtures curiosity, confidence, and connection to francophone cultures.</p>
                
                <div class="workshop-features mt-4">
                    <div class="row">
                        <div class="col-6 mb-3">
                            <div class="feature-item">
                                <i class="fas fa-comments text-primary"></i>
                                <span>Practice Speaking</span>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <div class="feature-item">
                                <i class="fas fa-gamepad text-primary"></i>
                                <span>Play-based Learning</span>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <div class="feature-item">
                                <i class="fas fa-music text-primary"></i>
                                <span>Music & Movement</span>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <div class="feature-item">
                                <i class="fas fa-mobile-alt text-primary"></i>
                                <span>Educational Apps</span>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <div class="feature-item">
                                <i class="fas fa-book-open text-primary"></i>
                                <span>Reading French Books</span>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <div class="feature-item">
                                <i class="fas fa-globe-africa text-primary"></i>
                                <span>Cultural Events</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <a href="<?php echo base_url('kid_registration'); ?>" class="btn btn-primary btn-lg mt-3">
                    <i class="fas fa-user-plus me-2"></i>Register Your Child
                </a>
            </div>
        </div>
    </div>
</section>

<!-- What Sets Us Apart -->
<section class="py-5 bg-light difference-section">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-badge">Why Choose Us</span>
            <h2 class="fw-bold">What Sets Us Apart</h2>
            <p class="lead text-muted">The difference that makes the difference</p>
        </div>
        
        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="difference-card text-center">
                    <div class="difference-icon">
                        <i class="fas fa-globe"></i>
                    </div>
                    <h5 class="fw-bold">Real Immersion</h5>
                    <p class="text-muted">Our founder's decade of living in France brings authentic, real-world language experience to every lesson.</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="difference-card text-center">
                    <div class="difference-icon">
                        <i class="fas fa-heart"></i>
                    </div>
                    <h5 class="fw-bold">Fun First</h5>
                    <p class="text-muted">Learning through games, songs, role-play, and cultural events—not boring textbooks and rote memorization.</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="difference-card text-center">
                    <div class="difference-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h5 class="fw-bold">Community Focus</h5>
                    <p class="text-muted">We sponsor children to attend cultural events and collaborate with local restaurants and businesses.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Our Team / Volunteers Section -->
<?php if (!empty($featured_volunteers)): ?>
<section class="py-5 volunteers-section">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-badge">Our Team</span>
            <h2 class="fw-bold">Meet Our Volunteers</h2>
            <p class="lead text-muted">Passionate individuals making a difference</p>
        </div>
        
        <div class="row justify-content-center">
            <?php foreach (array_slice($featured_volunteers, 0, 4) as $volunteer): ?>
                <div class="col-lg-3 col-md-4 col-6 mb-4">
                    <div class="volunteer-card text-center">
                        <div class="volunteer-image">
                            <?php if (!empty($volunteer->profile_photo)): ?>
                                <img src="<?php echo base_url('uploads/volunteers/' . $volunteer->profile_photo); ?>" 
                                     alt="<?php echo htmlspecialchars($volunteer->full_name); ?>">
                            <?php else: ?>
                                <div class="volunteer-placeholder">
                                    <span><?php echo strtoupper(substr($volunteer->full_name, 0, 1)); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="volunteer-info">
                            <h6 class="fw-bold mb-0"><?php echo htmlspecialchars($volunteer->full_name); ?></h6>
                            <small class="text-muted"><?php echo htmlspecialchars($volunteer->occupation ?? 'Volunteer'); ?></small>
                            <?php if (!empty($volunteer->skills)): ?>
                                <p class="small text-primary mt-2 mb-0">
                                    <i class="fas fa-star me-1"></i><?php echo htmlspecialchars(character_limiter($volunteer->skills, 30)); ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-4">
            <a href="<?php echo base_url('volunteers'); ?>" class="btn btn-outline-primary btn-lg me-3">
                <i class="fas fa-users me-2"></i>View All Volunteers
            </a>
            <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-primary btn-lg">
                <i class="fas fa-hand-holding-heart me-2"></i>Join Our Team
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Future Plans Section -->
<section class="py-5 future-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-5 mb-4 mb-lg-0">
                <span class="section-badge">Looking Ahead</span>
                <h2 class="fw-bold mb-4">Upcoming Plans</h2>
                <p class="lead">Our current focus is on the youth in Ghana with a few one-on-one opportunities for adults.</p>
                <p>In <strong>2026 and beyond</strong>, we plan to expand the programme to include more adults and professionals seeking to improve their French fluency for work or travel.</p>
                <p class="text-muted">We hope to do this with the collective support, collaborations, donations and help from you and our community in Ghana.</p>
                
                <div class="d-flex gap-3 mt-4">
                    <a href="<?php echo base_url('donate'); ?>" class="btn btn-primary">
                        <i class="fas fa-heart me-2"></i>Support Us
                    </a>
                    <a href="<?php echo base_url('contact'); ?>" class="btn btn-outline-primary">
                        <i class="fas fa-handshake me-2"></i>Partner With Us
                    </a>
                </div>
            </div>
            <div class="col-lg-7">
                <div class="future-grid">
                    <div class="future-card">
                        <div class="future-icon"><i class="fas fa-school"></i></div>
                        <h6>School Collaborations</h6>
                        <p class="small text-muted mb-0">Partnering with local schools</p>
                    </div>
                    <div class="future-card">
                        <div class="future-icon"><i class="fas fa-globe"></i></div>
                        <h6>Cultural Exchanges</h6>
                        <p class="small text-muted mb-0">Organizing cultural events</p>
                    </div>
                    <div class="future-card">
                        <div class="future-icon"><i class="fas fa-language"></i></div>
                        <h6>Spanish Workshops</h6>
                        <p class="small text-muted mb-0">Expanding language offerings</p>
                    </div>
                    <div class="future-card">
                        <div class="future-icon"><i class="fas fa-laptop-code"></i></div>
                        <h6>Tech & Digital Skills</h6>
                        <p class="small text-muted mb-0">Software development training</p>
                    </div>
                    <div class="future-card">
                        <div class="future-icon"><i class="fas fa-camera"></i></div>
                        <h6>Arts & Photography</h6>
                        <p class="small text-muted mb-0">Creative skills development</p>
                    </div>
                    <div class="future-card">
                        <div class="future-icon"><i class="fas fa-user-tie"></i></div>
                        <h6>Adult Programmes</h6>
                        <p class="small text-muted mb-0">Professional French fluency</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="py-5 cta-section">
    <div class="container">
        <div class="cta-card text-center">
            <h2 class="fw-bold text-white mb-3">Join Us in Shaping Ghana's Multilingual Future</h2>
            <p class="lead text-white-50 mb-4">At The Skills Atelier, we're not just teaching language and key skills—we're cultivating lifelong learners and global citizens.</p>
            <div class="d-flex gap-3 justify-content-center flex-wrap">
                <a href="<?php echo base_url('french-workshop/register'); ?>" class="btn btn-light btn-lg">
                    <i class="fas fa-graduation-cap me-2"></i>Enroll Now
                </a>
                <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-outline-light btn-lg">
                    <i class="fas fa-hands-helping me-2"></i>Volunteer
                </a>
                <a href="<?php echo base_url('donate'); ?>" class="btn btn-outline-light btn-lg">
                    <i class="fas fa-heart me-2"></i>Donate
                </a>
            </div>
        </div>
    </div>
</section>

<style>
/* =========================================
   THE SKILLS ATELIER - ABOUT PAGE STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
}

/* Section Badge */
.section-badge {
    display: inline-block;
    background: var(--tsa-gradient);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-bottom: 1rem;
}

/* =========================================
   HERO SECTION
   ========================================= */
.about-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 80px;
    position: relative;
    overflow: hidden;
}

.about-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.about-hero .section-badge {
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
}

/* =========================================
   STORY SECTION
   ========================================= */
.story-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

.story-image-container {
    position: relative;
}

.main-story-img {
    border: 5px solid white;
}

.story-accent {
    position: absolute;
    bottom: -30px;
    right: -20px;
    background: var(--tsa-gradient);
    color: white;
    padding: 1.5rem;
    border-radius: 15px;
    max-width: 280px;
    box-shadow: 0 15px 40px rgba(242, 97, 36, 0.3);
}

.story-accent i {
    opacity: 0.5;
}

.story-accent p {
    font-style: italic;
    font-size: 0.95rem;
}

/* Journey Timeline */
.journey-timeline {
    position: relative;
    padding-left: 30px;
}

.journey-timeline::before {
    content: '';
    position: absolute;
    left: 12px;
    top: 0;
    bottom: 0;
    width: 2px;
    background: linear-gradient(to bottom, var(--tsa-primary), var(--tsa-secondary));
}

.timeline-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    margin-bottom: 1.5rem;
    position: relative;
}

.timeline-icon {
    width: 26px;
    height: 26px;
    min-width: 26px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.7rem;
    margin-left: -30px;
    border: 3px solid white;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.timeline-content h6 {
    font-weight: 600;
    color: #333;
}

/* =========================================
   STATISTICS SECTION
   ========================================= */
.statistics-section {
    background: var(--tsa-gradient);
    position: relative;
}

.stat-item {
    padding: 1.5rem;
}

.stat-icon {
    width: 70px;
    height: 70px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.8rem;
}

/* =========================================
   MISSION & VISION SECTION
   ========================================= */
.mission-vision-section {
    background: white;
}

.mission-card,
.vision-card {
    padding: 2.5rem;
    border-radius: 20px;
    transition: all 0.3s ease;
}

.mission-card {
    background: linear-gradient(135deg, #fff8f5 0%, #ffe8e0 100%);
    border: 2px solid rgba(242, 97, 36, 0.1);
}

.vision-card {
    background: linear-gradient(135deg, #f8f5ff 0%, #ede0ff 100%);
    border: 2px solid rgba(129, 5, 191, 0.1);
}

.mission-card:hover,
.vision-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 20px 50px rgba(0,0,0,0.1);
}

.card-icon {
    width: 70px;
    height: 70px;
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.8rem;
    margin-bottom: 1.5rem;
}

.mission-card .card-icon {
    background: var(--tsa-primary);
    color: white;
}

.vision-card .card-icon {
    background: var(--tsa-secondary);
    color: white;
}

.mission-list,
.vision-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.mission-list li,
.vision-list li {
    padding: 0.5rem 0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.mission-list i {
    color: var(--tsa-primary);
}

.vision-list i {
    color: var(--tsa-secondary);
}

/* =========================================
   PROGRAMMES SECTION
   ========================================= */
.programme-card {
    background: white;
    padding: 2rem;
    border-radius: 20px;
    text-align: center;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    height: 100%;
    border: 2px solid transparent;
}

.programme-card:hover {
    transform: translateY(-10px);
    border-color: var(--tsa-primary);
    box-shadow: 0 20px 50px rgba(242, 97, 36, 0.15);
}

.programme-icon {
    width: 80px;
    height: 80px;
    background: var(--tsa-gradient);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    color: white;
    font-size: 2rem;
}

/* =========================================
   FRENCH WORKSHOP SECTION
   ========================================= */
.french-workshop-section {
    background: white;
}

.workshop-gallery {
    position: relative;
}

.gallery-badge {
    position: absolute;
    top: 20px;
    left: 20px;
    background: white;
    padding: 0.75rem 1.25rem;
    border-radius: 50px;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    font-size: 0.9rem;
    box-shadow: 0 5px 20px rgba(0,0,0,0.15);
}

.badge-flag {
    font-size: 1.3rem;
}

.workshop-features .feature-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem 1rem;
    background: var(--tsa-light);
    border-radius: 10px;
    font-size: 0.9rem;
    font-weight: 500;
}

.workshop-features .feature-item i {
    font-size: 1.1rem;
}

/* =========================================
   DIFFERENCE SECTION
   ========================================= */
.difference-card {
    background: white;
    padding: 2.5rem;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    height: 100%;
}

.difference-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 50px rgba(0,0,0,0.12);
}

.difference-icon {
    width: 80px;
    height: 80px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    color: white;
    font-size: 2rem;
}

/* =========================================
   VOLUNTEERS SECTION
   ========================================= */
.volunteers-section {
    background: var(--tsa-light);
}

.volunteer-card {
    background: white;
    padding: 2rem;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
}

.volunteer-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 50px rgba(0,0,0,0.12);
}

.volunteer-image {
    margin-bottom: 1rem;
}

.volunteer-image img {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    object-fit: cover;
    border: 4px solid var(--tsa-light);
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
}

.volunteer-placeholder {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    background: var(--tsa-gradient);
    display: inline-flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
}

.volunteer-placeholder span {
    color: white;
    font-size: 2.5rem;
    font-weight: 700;
}

/* =========================================
   FUTURE SECTION
   ========================================= */
.future-section {
    background: white;
}

.future-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1.25rem;
}

.future-card {
    background: var(--tsa-light);
    padding: 1.5rem;
    border-radius: 15px;
    text-align: center;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.future-card:hover {
    background: white;
    border-color: var(--tsa-primary);
    box-shadow: 0 10px 30px rgba(242, 97, 36, 0.15);
    transform: translateY(-5px);
}

.future-icon {
    width: 55px;
    height: 55px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    color: white;
    font-size: 1.3rem;
}

.future-card h6 {
    font-weight: 600;
    margin-bottom: 0.5rem;
}

/* =========================================
   CTA SECTION
   ========================================= */
.cta-section {
    background: var(--tsa-gradient);
}

.cta-card {
    background: rgba(255,255,255,0.1);
    backdrop-filter: blur(10px);
    border-radius: 25px;
    padding: 3.5rem;
    border: 1px solid rgba(255,255,255,0.2);
}

.cta-section .btn-light {
    background: white;
    color: var(--tsa-primary);
    font-weight: 600;
    padding: 0.75rem 2rem;
    border-radius: 50px;
}

.cta-section .btn-light:hover {
    background: var(--tsa-cream);
    transform: translateY(-2px);
}

.cta-section .btn-outline-light {
    border: 2px solid white;
    color: white;
    font-weight: 600;
    padding: 0.75rem 2rem;
    border-radius: 50px;
}

.cta-section .btn-outline-light:hover {
    background: white;
    color: var(--tsa-primary);
}

/* =========================================
   BUTTON STYLES
   ========================================= */
.btn-primary {
    background: var(--tsa-gradient);
    border: none;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    background: var(--tsa-gradient-reverse);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(242, 97, 36, 0.4);
}

.btn-outline-primary {
    border: 2px solid var(--tsa-primary);
    color: var(--tsa-primary);
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.btn-outline-primary:hover {
    background: var(--tsa-primary);
    border-color: var(--tsa-primary);
    color: white;
    transform: translateY(-2px);
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .future-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .story-accent {
        position: relative;
        bottom: 0;
        right: 0;
        margin-top: 1.5rem;
        max-width: 100%;
    }
}

@media (max-width: 768px) {
    .about-hero {
        padding: 80px 0 60px;
    }
    
    .about-hero h1 {
        font-size: 2rem;
    }
    
    .future-grid {
        grid-template-columns: 1fr;
    }
    
    .mission-card,
    .vision-card {
        padding: 1.5rem;
    }
    
    .cta-card {
        padding: 2rem;
    }
    
    .stat-item h2 {
        font-size: 2rem;
    }
    
    .stat-icon {
        width: 50px;
        height: 50px;
        font-size: 1.3rem;
    }
}
</style>