<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Hero Carousel -->
<?php if (!empty($carousel_items)): ?>
<div id="heroCarousel" class="carousel slide carousel-fade" data-bs-ride="carousel" data-bs-interval="5000">
    <div class="carousel-indicators">
        <?php foreach ($carousel_items as $index => $item): ?>
            <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="<?php echo $index; ?>" 
                    <?php echo ($index === 0) ? 'class="active" aria-current="true"' : ''; ?>></button>
        <?php endforeach; ?>
    </div>
    
    <div class="carousel-inner">
        <?php foreach ($carousel_items as $index => $item): ?>
            <div class="carousel-item <?php echo ($index === 0) ? 'active' : ''; ?>">
                <?php if ($item->media_type === 'image' && !empty($item->media_path)): ?>
                    <img src="<?php echo base_url('uploads/carousel/' . $item->media_path); ?>" 
                         class="d-block w-100" 
                         alt="<?php echo htmlspecialchars($item->title); ?>"
                         style="height: 600px; object-fit: cover;">
                <?php elseif ($item->media_type === 'video' && !empty($item->media_path)): ?>
                    <video class="d-block w-100" autoplay muted loop playsinline style="height: 600px; object-fit: cover;">
                        <source src="<?php echo base_url('uploads/carousel/' . $item->media_path); ?>" type="video/mp4">
                    </video>
                <?php endif; ?>
                
                <div class="carousel-caption">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-8 mx-auto text-center">
                                <h1 class="display-4 fw-bold mb-3">
                                    <?php echo htmlspecialchars($item->title); ?>
                                </h1>
                                <?php if (!empty($item->subtitle)): ?>
                                    <p class="lead mb-4">
                                        <?php echo htmlspecialchars($item->subtitle); ?>
                                    </p>
                                <?php endif; ?>
                                <?php if (!empty($item->description)): ?>
                                    <p class="mb-4">
                                        <?php echo htmlspecialchars($item->description); ?>
                                    </p>
                                <?php endif; ?>
                                <?php if (!empty($item->link_url)): ?>
                                    <a href="<?php echo $item->link_url; ?>" class="btn btn-primary btn-lg">
                                        <?php echo htmlspecialchars($item->link_text ?: 'Learn More'); ?> 
                                        <i class="fas fa-arrow-right ms-2"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    
    <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
    </button>
</div>
<?php endif; ?>

<!-- About Us Section -->
<section class="py-5 about-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="about-image-container">
                    <img src="<?php echo base_url('assets/images/about.jpg'); ?>" 
                         alt="The Skills Atelier" 
                         class="img-fluid rounded-4 shadow-lg about-main-img">
                    <div class="about-accent-box">
                        <span class="accent-year">Since</span>
                        <span class="accent-number">2025</span>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="about-content">
                    <span class="section-badge">About Us</span>
                    <h2 class="fw-bold mb-4">The Skills Atelier | TSA</h2>
                    <p class="lead text-muted mb-4">Born out of a deeply personal journey to transform how language and vital skills are taught.</p>
                    <p>Our founder began learning French and Spanish in Ghana, only to face a rigid, non-immersive system. Years later, after over a decade living and working in France—and travelling through various francophone countries—she returned home with a mission: <strong>to transform how language and vital skills are taught, starting with children.</strong></p>
                    <p>Our programmes include and are not limited to languages, culinary, software tech skills, and arts skills like photography!</p>
                    
                    <div class="row mt-4">
                        <div class="col-6">
                            <div class="about-feature">
                                <div class="feature-icon">
                                    <i class="fas fa-globe-africa"></i>
                                </div>
                                <h6>Immersive Learning</h6>
                                <p class="small text-muted mb-0">Real-world language experience</p>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="about-feature">
                                <div class="feature-icon">
                                    <i class="fas fa-child"></i>
                                </div>
                                <h6>Child-Centered</h6>
                                <p class="small text-muted mb-0">Ages 6-12 focus</p>
                            </div>
                        </div>
                    </div>
                    
                    <a href="<?php echo base_url('about'); ?>" class="btn btn-primary mt-4">
                        Learn Our Story <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Statistics Section -->
<section class="py-5 statistics-section">
    <div class="container">
        <div class="row text-center text-white">
            <div class="col-md-3 col-6 mb-4 mb-md-0">
                <div class="stat-item">
                    <div class="stat-icon mb-3">
                        <i class="fas fa-hands-helping"></i>
                    </div>
                    <h2 class="display-4 fw-bold mb-0 stat-counter" data-target="<?php echo $statistics['volunteers'] ?? 10; ?>">0</h2>
                    <p class="lead mb-0">Volunteers</p>
                </div>
            </div>
            <div class="col-md-3 col-6 mb-4 mb-md-0">
                <div class="stat-item">
                    <div class="stat-icon mb-3">
                        <i class="fas fa-chalkboard-teacher"></i>
                    </div>
                    <h2 class="display-4 fw-bold mb-0 stat-counter" data-target="<?php echo $statistics['workshops'] ?? 5; ?>">0</h2>
                    <p class="lead mb-0">Workshops</p>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-item">
                    <div class="stat-icon mb-3">
                        <i class="fas fa-handshake"></i>
                    </div>
                    <h2 class="display-4 fw-bold mb-0 stat-counter" data-target="<?php echo $statistics['partners'] ?? 3; ?>">0</h2>
                    <p class="lead mb-0">Partners</p>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-item">
                    <div class="stat-icon mb-3">
                        <i class="fas fa-users"></i>
                    </div>
                    <h2 class="display-4 fw-bold mb-0 stat-counter" data-target="<?php echo $statistics['total_learners'] ?? 50; ?>">0</h2>
                    <p class="lead mb-0">Learners</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Flagship Programme - French Workshop -->
<section class="py-5 flagship-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 order-lg-2 mb-4 mb-lg-0">
                <div class="flagship-image">
                    <img src="<?php echo base_url('assets/images/wkshop.jpg'); ?>" 
                         alt="French Workshop" 
                         class="img-fluid rounded-4 shadow-lg">
                    <div class="flagship-badge">
                        <i class="fas fa-star me-2"></i>Flagship Programme
                    </div>
                </div>
            </div>
            <div class="col-lg-6 order-lg-1">
                <span class="section-badge">Our Flagship Programme</span>
                <h2 class="fw-bold mb-4">French Workshop for Kids</h2>
                <p class="lead">Launched in <strong>April 2025</strong>, helping children aged 6 to 12 fall in love with French through fun, immersive, and interactive learning experiences.</p>
                <p>Held in <strong>East Legon</strong> (hoping to expand to other areas), this weekly programme offers more than grammar and vocabulary—it nurtures curiosity, confidence, and connection to francophone cultures.</p>
                
                <div class="activities-grid mt-4">
                    <div class="activity-item">
                        <div class="activity-icon"><i class="fas fa-comments"></i></div>
                        <div>
                            <h6 class="mb-1">Practice Speaking</h6>
                            <p class="small text-muted mb-0">Conversations with peers and recorded videos</p>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon"><i class="fas fa-gamepad"></i></div>
                        <div>
                            <h6 class="mb-1">Play-based Learning</h6>
                            <p class="small text-muted mb-0">Interactive games and role-playing</p>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon"><i class="fas fa-music"></i></div>
                        <div>
                            <h6 class="mb-1">Music & Movement</h6>
                            <p class="small text-muted mb-0">French songs to boost memory</p>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon"><i class="fas fa-mobile-alt"></i></div>
                        <div>
                            <h6 class="mb-1">Educational Apps</h6>
                            <p class="small text-muted mb-0">Visual and dynamic learning</p>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon"><i class="fas fa-book-open"></i></div>
                        <div>
                            <h6 class="mb-1">Reading French Books</h6>
                            <p class="small text-muted mb-0">Building vocabulary gradually</p>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon"><i class="fas fa-utensils"></i></div>
                        <div>
                            <h6 class="mb-1">Cultural Events</h6>
                            <p class="small text-muted mb-0">Real-life immersion experiences</p>
                        </div>
                    </div>
                </div>
                
                <div class="d-flex gap-3 mt-4">
                    <a href="<?php echo base_url('kid_registration'); ?>" class="btn btn-primary btn-lg">
                        <i class="fas fa-user-plus me-2"></i>Register Now
                    </a>
                    <a href="<?php echo base_url('workshops/view/french-workshop-with-jacquie'); ?>" class="btn btn-outline-primary btn-lg">
                        Learn More
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Recent Event Highlight -->
<section class="py-5 bg-light event-highlight-section">
    <div class="container">
        <div class="event-highlight-card">
            <div class="row align-items-center">
                <div class="col-lg-5 mb-4 mb-lg-0">
                    <img src="<?php echo base_url('assets/images/workshop.jpg'); ?>" 
                         alt="French Crepe Culinary Workshop" 
                         class="img-fluid rounded-4 shadow">
                </div>
                <div class="col-lg-7">
                    <span class="event-tag">Recent Event</span>
                    <h3 class="fw-bold mb-3">French Crêpe Culinary Workshop</h3>
                    <p class="mb-3">In collaboration with East Legon French Restaurant, <strong>La French Crêpe</strong>, we sponsored children to attend a hands-on culinary experience—providing real-life cultural immersion!</p>
                    <p class="text-muted">We've already begun to see children gain confidence, engage actively, and express themselves in French after just a few sessions.</p>
                    <div class="event-stats d-flex gap-4 mt-4">
                        <div class="event-stat">
                            <i class="fas fa-check-circle text-success"></i>
                            <span>Cultural Immersion</span>
                        </div>
                        <div class="event-stat">
                            <i class="fas fa-check-circle text-success"></i>
                            <span>Real-world Experience</span>
                        </div>
                        <div class="event-stat">
                            <i class="fas fa-check-circle text-success"></i>
                            <span>Fun Learning</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Featured Workshops -->
<?php if (!empty($featured_workshops)): ?>
<section class="py-5 workshops-section">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-badge">Our Programmes</span>
            <h2 class="fw-bold">Featured Workshops</h2>
            <p class="lead text-muted">Empowering Communities Through Immersive Education</p>
        </div>
        
        <div class="row">
            <?php foreach ($featured_workshops as $workshop): ?>
                <div class="col-md-4 mb-4">
                    <div class="workshop-card h-100">
                        <?php if (!empty($workshop->featured_image)): ?>
                            <div class="workshop-image">
                                <img src="<?php echo base_url('uploads/workshops/' . $workshop->featured_image); ?>" 
                                     alt="<?php echo htmlspecialchars($workshop->title); ?>">
                                <span class="workshop-status <?php echo strtolower($workshop->status); ?>">
                                    <?php echo ucfirst($workshop->status); ?>
                                </span>
                            </div>
                        <?php else: ?>
                            <div class="workshop-image placeholder-img">
                                <i class="fas fa-chalkboard-teacher fa-3x text-muted"></i>
                                <span class="workshop-status <?php echo strtolower($workshop->status); ?>">
                                    <?php echo ucfirst($workshop->status); ?>
                                </span>
                            </div>
                        <?php endif; ?>
                        
                        <div class="workshop-body">
                            <h5 class="workshop-title"><?php echo htmlspecialchars($workshop->title); ?></h5>
                            <p class="workshop-description">
                                <?php echo htmlspecialchars(character_limiter($workshop->description, 100)); ?>
                            </p>
                            
                            <div class="workshop-meta">
                                <?php if (!empty($workshop->duration)): ?>
                                    <span class="meta-item">
                                        <i class="far fa-clock"></i>
                                        <?php echo htmlspecialchars($workshop->duration); ?>
                                    </span>
                                <?php endif; ?>
                                
                                <?php if (!empty($workshop->target_audience)): ?>
                                    <span class="meta-item">
                                        <i class="fas fa-users"></i>
                                        <?php echo htmlspecialchars($workshop->target_audience); ?>
                                    </span>
                                <?php endif; ?>
                                
                                <?php if (!empty($workshop->location)): ?>
                                    <span class="meta-item">
                                        <i class="fas fa-map-marker-alt"></i>
                                        <?php echo htmlspecialchars($workshop->location); ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                            
                            <a href="<?php echo base_url('workshops/view/' . $workshop->slug); ?>" 
                               class="btn btn-primary w-100 mt-3">
                                Learn More <i class="fas fa-arrow-right ms-2"></i>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-4">
            <a href="<?php echo base_url('workshops'); ?>" class="btn btn-outline-primary btn-lg">
                View All Workshops <i class="fas fa-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Upcoming Plans Section -->
<section class="py-5 plans-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-5 mb-4 mb-lg-0">
                <span class="section-badge">What's Next</span>
                <h2 class="fw-bold mb-4">Upcoming Plans</h2>
                <p class="lead">Our current focus is on the youth in Ghana with a few one-on-one opportunities for adults.</p>
                <p>In 2026 and beyond, we plan to expand the programme to include more adults and professionals seeking to improve their French fluency for work or travel.</p>
                <p class="text-muted">At The Skills Atelier, we're not just teaching language and key skills but cultivating lifelong learners and global citizens.</p>
                
                <a href="<?php echo base_url('donate'); ?>" class="btn btn-secondary btn-lg mt-3">
                    <i class="fas fa-heart me-2"></i>Support Our Mission
                </a>
            </div>
            <div class="col-lg-7">
                <div class="plans-grid">
                    <div class="plan-card">
                        <div class="plan-icon">
                            <i class="fas fa-school"></i>
                        </div>
                        <h5>School Collaborations</h5>
                        <p class="text-muted mb-0">Partnering with local schools to bring French education to more children.</p>
                    </div>
                    <div class="plan-card">
                        <div class="plan-icon">
                            <i class="fas fa-globe"></i>
                        </div>
                        <h5>Cultural Exchanges</h5>
                        <p class="text-muted mb-0">Organizing events that connect learners with francophone cultures.</p>
                    </div>
                    <div class="plan-card">
                        <div class="plan-icon">
                            <i class="fas fa-language"></i>
                        </div>
                        <h5>Spanish Workshops</h5>
                        <p class="text-muted mb-0">Expanding to offer Spanish language learning programmes.</p>
                    </div>
                    <div class="plan-card">
                        <div class="plan-icon">
                            <i class="fas fa-laptop-code"></i>
                        </div>
                        <h5>Tech Skills</h5>
                        <p class="text-muted mb-0">Software development and digital literacy workshops.</p>
                    </div>
                    <div class="plan-card">
                        <div class="plan-icon">
                            <i class="fas fa-camera"></i>
                        </div>
                        <h5>Arts & Photography</h5>
                        <p class="text-muted mb-0">Creative skills development for aspiring artists.</p>
                    </div>
                    <div class="plan-card">
                        <div class="plan-icon">
                            <i class="fas fa-user-tie"></i>
                        </div>
                        <h5>Adult Programmes</h5>
                        <p class="text-muted mb-0">French fluency for professionals and travelers.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="py-5 cta-section">
    <div class="container">
        <div class="cta-card">
            <div class="row align-items-center">
                <div class="col-lg-8 mb-4 mb-lg-0">
                    <h3 class="fw-bold mb-2">Ready to Start Your Learning Journey?</h3>
                    <p class="lead mb-0">Join our French Workshop, volunteer with us, or book a free consultation session.</p>
                </div>
                <div class="col-lg-4 text-lg-end">
                    <div class="d-flex gap-2 flex-wrap justify-content-lg-end">
                        <a href="<?php echo base_url('kid_registration'); ?>" class="btn btn-light btn-lg">
                            <i class="fas fa-graduation-cap me-2"></i>Enroll Now
                        </a>
                        <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-outline-light btn-lg">
                            <i class="fas fa-hands-helping me-2"></i>Volunteer
                        </a>
                        <a href="<?php echo base_url('consultation'); ?>" class="btn btn-outline-light btn-lg">
                            <i class="fas fa-calendar-check me-2"></i>Consult
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Latest Blog Posts -->
<?php if (!empty($latest_posts)): ?>
<section class="py-5 blog-section">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-badge">Our Blog</span>
            <h2 class="fw-bold">Latest News & Stories</h2>
            <p class="lead text-muted">Stay updated with our community activities</p>
        </div>
        
        <div class="row">
            <?php foreach (array_slice($latest_posts, 0, 3) as $index => $post): ?>
                <div class="col-md-4 mb-4">
                    <article class="blog-card h-100 <?php echo ($index === 0) ? 'featured' : ''; ?>">
                        <div class="blog-image">
                            <?php if (!empty($post->featured_image)): ?>
                                <img src="<?php echo base_url('uploads/blog/' . $post->featured_image); ?>" 
                                     alt="<?php echo htmlspecialchars($post->title); ?>">
                            <?php else: ?>
                                <div class="placeholder-img">
                                    <i class="fas fa-newspaper fa-3x text-muted"></i>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($post->category_name)): ?>
                                <span class="blog-category"><?php echo htmlspecialchars($post->category_name); ?></span>
                            <?php endif; ?>
                        </div>
                        
                        <div class="blog-body">
                            <div class="blog-meta">
                                <span><i class="far fa-calendar me-1"></i><?php echo date('M d, Y', strtotime($post->published_at)); ?></span>
                                <?php if (isset($post->views_count) && $post->views_count > 0): ?>
							<span><i class="far fa-eye me-1"></i><?php echo number_format($post->views_count); ?> views</span>
						<?php endif; ?>
                            </div>
                            
                            <h5 class="blog-title">
                                <a href="<?php echo base_url('blog/view/' . $post->slug); ?>">
                                    <?php echo htmlspecialchars($post->title); ?>
                                </a>
                            </h5>
                            
                            <p class="blog-excerpt">
                                <?php echo htmlspecialchars(character_limiter($post->excerpt, 120)); ?>
                            </p>
                            
                            <a href="<?php echo base_url('blog/view/' . $post->slug); ?>" class="read-more">
                                Read More <i class="fas fa-arrow-right ms-2"></i>
                            </a>
                        </div>
                    </article>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-4">
            <a href="<?php echo base_url('blog'); ?>" class="btn btn-primary btn-lg">
                View All Articles <i class="fas fa-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Testimonials Section -->
<section class="py-5 testimonials-section">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-badge">Testimonials</span>
            <h2 class="fw-bold">What Parents Say</h2>
            <p class="lead text-muted">Hear from families in our learning community</p>
        </div>
        
        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="testimonial-card">
                    <div class="testimonial-rating">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimonial-text">"My daughter has gained so much confidence speaking French after just a few sessions. The interactive approach really works!"</p>
                    <div class="testimonial-author">
                        <div class="author-avatar">A</div>
                        <div>
                            <h6 class="mb-0">Ama S.</h6>
                            <small class="text-muted">Parent</small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="testimonial-card">
                    <div class="testimonial-rating">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimonial-text">"The French Crêpe workshop was an amazing experience. My son learned while having fun—exactly what education should be!"</p>
                    <div class="testimonial-author">
                        <div class="author-avatar">K</div>
                        <div>
                            <h6 class="mb-0">Kofi M.</h6>
                            <small class="text-muted">Parent</small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="testimonial-card">
                    <div class="testimonial-rating">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimonial-text">"Finally, an immersive French programme in Ghana! The cultural events and real-world practice make all the difference."</p>
                    <div class="testimonial-author">
                        <div class="author-avatar">E</div>
                        <div>
                            <h6 class="mb-0">Efua A.</h6>
                            <small class="text-muted">Parent</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Partners Section -->
<?php if (!empty($partners)): ?>
<section class="py-5 bg-light partners-section">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-badge">Our Network</span>
            <h2 class="fw-bold">Our Partners</h2>
            <p class="lead text-muted">Trusted organizations supporting our mission</p>
        </div>
        
        <div class="row align-items-center justify-content-center">
            <?php foreach (array_slice($partners, 0, 6) as $partner): ?>
                <div class="col-lg-2 col-md-3 col-4 text-center mb-4">
                    <div class="partner-logo-wrapper">
                        <?php if (!empty($partner->logo)): ?>
                            <a href="<?php echo $partner->website ?: '#'; ?>" target="_blank" rel="noopener">
                                <img src="<?php echo base_url('uploads/partners/' . $partner->logo); ?>" 
                                     alt="<?php echo htmlspecialchars($partner->name); ?>"
                                     class="partner-logo">
                            </a>
                        <?php else: ?>
                            <div class="partner-placeholder">
                                <i class="fas fa-building fa-2x"></i>
                                <p class="small mt-2 mb-0"><?php echo htmlspecialchars($partner->name); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <?php if (count($partners) > 6): ?>
            <div class="text-center mt-4">
                <a href="<?php echo base_url('partners'); ?>" class="btn btn-outline-primary">
                    View All Partners <i class="fas fa-arrow-right ms-2"></i>
                </a>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php endif; ?>

<!-- Contact Quick Section -->
<section class="py-5 contact-quick-section">
    <div class="container">
        <div class="row">
            <div class="col-md-4 mb-4 mb-md-0">
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <h5>Location</h5>
                    <p class="mb-0">East Legon, Accra, Ghana</p>
                </div>
            </div>
            <div class="col-md-4 mb-4 mb-md-0">
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fab fa-whatsapp"></i>
                    </div>
                    <h5>WhatsApp</h5>
                    <p class="mb-0"><a href="https://wa.me/233500557751">+233 50 055 7751</a></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fab fa-instagram"></i>
                    </div>
                    <h5>Follow Us</h5>
                    <p class="mb-0"><a href="https://instagram.com/theskillsatelier" target="_blank">@theskillsatelier</a></p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Newsletter Section -->
<!--<section class="py-5 newsletter-section">
    <div class="container">
        <div class="newsletter-card">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <h3 class="fw-bold mb-2"><i class="fas fa-envelope-open-text me-2"></i>Stay Updated</h3>
                    <p class="mb-0">Subscribe to our newsletter for workshop updates, events, and French learning tips!</p>
                </div>
                <div class="col-lg-6">
                    <form action="<?php echo base_url('newsletter/subscribe'); ?>" method="post" class="newsletter-form">
                        <div class="input-group">
                            <input type="email" name="email" class="form-control form-control-lg" placeholder="Enter your email address" required>
                            <button type="submit" class="btn btn-primary btn-lg">
                                Subscribe <i class="fas fa-paper-plane ms-2"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>-->

<style>
/* =========================================
   THE SKILLS ATELIER - HOMEPAGE STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
}

/* Section Badge */
.section-badge {
    display: inline-block;
    background: var(--tsa-gradient);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-bottom: 1rem;
}

/* =========================================
   HERO CAROUSEL
   ========================================= */
.carousel-item {
    position: relative;
}

.carousel-item::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(to bottom, rgba(0,0,0,0.2), rgba(0,0,0,0.5));
    z-index: 1;
}

.carousel-caption {
    position: absolute;
    bottom: 50%;
    transform: translateY(50%);
    left: 0;
    right: 0;
    z-index: 2;
}

.carousel-caption .container > .row > div {
    background: rgba(0, 0, 0, 0.45);
    backdrop-filter: blur(5px);
    border-radius: 20px;
    padding: 2rem 2.5rem;
    max-width: 800px;
    margin: 0 auto;
    border: 1px solid rgba(255,255,255,0.1);
}

.carousel-caption h1 {
    font-size: 2.2rem;
    font-weight: 700;
    color: white !important;
    text-shadow: 2px 2px 8px rgba(0,0,0,0.9);
    margin-bottom: 0.75rem;
}

.carousel-caption .lead {
    font-size: 1.15rem;
    color: white !important;
    text-shadow: 1px 1px 4px rgba(0,0,0,0.9);
}

.carousel-caption p {
    font-size: 1rem;
    color: rgba(255,255,255,0.9) !important;
    text-shadow: 1px 1px 4px rgba(0,0,0,0.9);
}

.carousel-caption .btn-primary {
    background-color: var(--tsa-primary);
    color: white;
    border: none;
    font-weight: 600;
    padding: 0.75rem 2rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.carousel-caption .btn-primary:hover {
    background-color: var(--tsa-primary-dark);
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(242, 97, 36, 0.4);
}

.carousel-indicators button {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background-color: rgba(255,255,255,0.5);
    border: 2px solid white;
}

.carousel-indicators button.active {
    background-color: var(--tsa-primary);
    border-color: var(--tsa-primary);
}

/* =========================================
   ABOUT SECTION
   ========================================= */
.about-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

.about-image-container {
    position: relative;
}

.about-main-img {
    border: 5px solid white;
    box-shadow: 0 20px 60px rgba(0,0,0,0.15);
}

.about-accent-box {
    position: absolute;
    bottom: -20px;
    right: -20px;
    background: var(--tsa-gradient);
    color: white;
    padding: 1.5rem 2rem;
    border-radius: 15px;
    text-align: center;
    box-shadow: 0 10px 30px rgba(242, 97, 36, 0.3);
}

.about-accent-box .accent-year {
    display: block;
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 2px;
}

.about-accent-box .accent-number {
    display: block;
    font-size: 2.5rem;
    font-weight: 700;
}

.about-feature {
    padding: 1.5rem;
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
}

.about-feature:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.12);
}

.about-feature .feature-icon {
    width: 50px;
    height: 50px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.3rem;
    margin-bottom: 1rem;
}

/* =========================================
   STATISTICS SECTION
   ========================================= */
.statistics-section {
    background: var(--tsa-gradient);
    position: relative;
    overflow: hidden;
}

.statistics-section::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
    animation: float 20s linear infinite;
}

@keyframes float {
    0% { transform: translateX(0) translateY(0); }
    100% { transform: translateX(-50px) translateY(-50px); }
}

.stat-item {
    padding: 1.5rem;
    position: relative;
    z-index: 1;
}

.stat-icon {
    width: 70px;
    height: 70px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.8rem;
}

.stat-item h2 {
    font-size: 3rem;
}

/* =========================================
   FLAGSHIP PROGRAMME SECTION
   ========================================= */
.flagship-section {
    background: white;
}

.flagship-image {
    position: relative;
}

.flagship-image img {
    border: 5px solid var(--tsa-light);
}

.flagship-badge {
    position: absolute;
    top: 20px;
    left: 20px;
    background: var(--tsa-primary);
    color: white;
    padding: 0.6rem 1.2rem;
    border-radius: 50px;
    font-weight: 600;
    font-size: 0.85rem;
    box-shadow: 0 5px 20px rgba(242, 97, 36, 0.4);
}

.activities-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
}

.activity-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    padding: 1rem;
    background: var(--tsa-light);
    border-radius: 12px;
    transition: all 0.3s ease;
}

.activity-item:hover {
    background: white;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    transform: translateY(-2px);
}

.activity-icon {
    width: 45px;
    height: 45px;
    min-width: 45px;
    background: var(--tsa-gradient);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
}

/* =========================================
   EVENT HIGHLIGHT SECTION
   ========================================= */
.event-highlight-card {
    background: white;
    border-radius: 20px;
    padding: 2.5rem;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
    border-left: 5px solid var(--tsa-primary);
}

.event-tag {
    display: inline-block;
    background: var(--tsa-cream);
    color: var(--tsa-primary-dark);
    padding: 0.3rem 1rem;
    border-radius: 50px;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    margin-bottom: 1rem;
}

.event-stats {
    flex-wrap: wrap;
}

.event-stat {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.9rem;
    color: #555;
}

/* =========================================
   WORKSHOPS SECTION
   ========================================= */
.workshops-section {
    background: var(--tsa-light);
}

.workshop-card {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    border: 1px solid rgba(0,0,0,0.05);
}

.workshop-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 50px rgba(0,0,0,0.15);
}

.workshop-image {
    height: 200px;
    position: relative;
    overflow: hidden;
}

.workshop-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.workshop-card:hover .workshop-image img {
    transform: scale(1.1);
}

.workshop-image.placeholder-img {
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #f5f5f5, #e0e0e0);
}

.workshop-status {
    position: absolute;
    top: 15px;
    right: 15px;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.75rem;
    font-weight: 600;
    text-transform: uppercase;
}

.workshop-status.upcoming {
    background: var(--tsa-primary);
    color: white;
}

.workshop-status.ongoing {
    background: #28a745;
    color: white;
}

.workshop-status.completed {
    background: #6c757d;
    color: white;
}

.workshop-body {
    padding: 1.5rem;
}

.workshop-title {
    font-weight: 700;
    margin-bottom: 0.75rem;
    color: #333;
}

.workshop-description {
    color: #666;
    font-size: 0.95rem;
    margin-bottom: 1rem;
}

.workshop-meta {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.meta-item {
    font-size: 0.85rem;
    color: #888;
}

.meta-item i {
    color: var(--tsa-primary);
    width: 20px;
}

/* =========================================
   PLANS SECTION
   ========================================= */
.plans-section {
    background: white;
}

.plans-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1.5rem;
}

.plan-card {
    background: var(--tsa-light);
    padding: 1.5rem;
    border-radius: 15px;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.plan-card:hover {
    border-color: var(--tsa-primary);
    background: white;
    box-shadow: 0 10px 30px rgba(242, 97, 36, 0.15);
}

.plan-icon {
    width: 55px;
    height: 55px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.4rem;
    margin-bottom: 1rem;
}

.plan-card h5 {
    font-weight: 600;
    margin-bottom: 0.5rem;
}

/* =========================================
   CTA SECTION
   ========================================= */
.cta-section {
    background: var(--tsa-gradient);
    position: relative;
}

.cta-card {
    background: rgba(255,255,255,0.1);
    backdrop-filter: blur(10px);
    border-radius: 20px;
    padding: 2.5rem;
    border: 1px solid rgba(255,255,255,0.2);
    color: white;
}

.cta-card h3 {
    color: white;
}

.cta-card .lead {
    color: rgba(255,255,255,0.9);
}

.cta-section .btn-light {
    background: white;
    color: var(--tsa-primary);
    font-weight: 600;
    border-radius: 50px;
}

.cta-section .btn-light:hover {
    background: var(--tsa-cream);
    transform: translateY(-2px);
}

.cta-section .btn-outline-light {
    border: 2px solid white;
    color: white;
    font-weight: 600;
    border-radius: 50px;
}

.cta-section .btn-outline-light:hover {
    background: white;
    color: var(--tsa-primary);
}

/* =========================================
   BLOG SECTION
   ========================================= */
.blog-section {
    background: white;
}

.blog-card {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    border: 1px solid rgba(0,0,0,0.05);
}

.blog-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 50px rgba(0,0,0,0.15);
}

.blog-image {
    height: 200px;
    position: relative;
    overflow: hidden;
}

.blog-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.blog-card:hover .blog-image img {
    transform: scale(1.1);
}

.blog-image .placeholder-img {
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #f5f5f5, #e0e0e0);
}

.blog-category {
    position: absolute;
    top: 15px;
    left: 15px;
    background: var(--tsa-primary);
    color: white;
    padding: 0.3rem 1rem;
    border-radius: 50px;
    font-size: 0.75rem;
    font-weight: 600;
}

.blog-body {
    padding: 1.5rem;
}

.blog-meta {
    display: flex;
    gap: 1rem;
    margin-bottom: 0.75rem;
    font-size: 0.85rem;
    color: #888;
}

.blog-title {
    font-weight: 700;
    margin-bottom: 0.75rem;
}

.blog-title a {
    color: #333;
    text-decoration: none;
    transition: color 0.3s ease;
}

.blog-title a:hover {
    color: var(--tsa-primary);
}

.blog-excerpt {
    color: #666;
    font-size: 0.95rem;
    margin-bottom: 1rem;
}

.read-more {
    color: var(--tsa-primary);
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
}

.read-more:hover {
    color: var(--tsa-primary-dark);
}

.read-more i {
    transition: transform 0.3s ease;
}

.read-more:hover i {
    transform: translateX(5px);
}

/* =========================================
   TESTIMONIALS SECTION
   ========================================= */
.testimonials-section {
    background: var(--tsa-light);
}

.testimonial-card {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    height: 100%;
}

.testimonial-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 50px rgba(0,0,0,0.12);
}

.testimonial-rating {
    margin-bottom: 1rem;
    color: #ffc107;
}

.testimonial-text {
    font-style: italic;
    color: #555;
    margin-bottom: 1.5rem;
    line-height: 1.7;
}

.testimonial-author {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.author-avatar {
    width: 50px;
    height: 50px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 700;
    font-size: 1.2rem;
}

/* =========================================
   PARTNERS SECTION
   ========================================= */
.partners-section {
    background: #f8f9fa;
}

.partner-logo-wrapper {
    padding: 1rem;
    transition: all 0.3s ease;
}

.partner-logo {
    max-height: 80px;
    max-width: 100%;
    opacity: 0.6;
    filter: grayscale(100%);
    transition: all 0.3s ease;
}

.partner-logo-wrapper:hover .partner-logo {
    opacity: 1;
    filter: grayscale(0%);
    transform: scale(1.1);
}

.partner-placeholder {
    padding: 1rem;
    color: #999;
}

/* =========================================
   CONTACT QUICK SECTION
   ========================================= */
.contact-quick-section {
    background: white;
}

.contact-card {
    text-align: center;
    padding: 2rem;
    background: var(--tsa-light);
    border-radius: 20px;
    transition: all 0.3s ease;
}

.contact-card:hover {
    background: white;
    box-shadow: 0 10px 40px rgba(242, 97, 36, 0.15);
    transform: translateY(-5px);
}

.contact-icon {
    width: 70px;
    height: 70px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    color: white;
    font-size: 1.8rem;
}

.contact-card h5 {
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.contact-card a {
    color: var(--tsa-primary);
    text-decoration: none;
    font-weight: 500;
}

.contact-card a:hover {
    text-decoration: underline;
}

/* =========================================
   NEWSLETTER SECTION
   ========================================= */
.newsletter-section {
    background: linear-gradient(135deg, #1a1a2e, #16213e);
}

.newsletter-card {
    background: rgba(255,255,255,0.05);
    backdrop-filter: blur(10px);
    border-radius: 20px;
    padding: 2.5rem;
    border: 1px solid rgba(255,255,255,0.1);
    color: white;
}

.newsletter-card h3 {
    color: white;
}

.newsletter-card p {
    color: rgba(255,255,255,0.8);
}

.newsletter-form .form-control {
    border: none;
    border-radius: 50px 0 0 50px;
    padding: 0.8rem 1.5rem;
}

.newsletter-form .btn {
    border-radius: 0 50px 50px 0;
    padding-left: 2rem;
    padding-right: 2rem;
}

/* =========================================
   GLOBAL BUTTON STYLES
   ========================================= */
.btn-primary {
    background: var(--tsa-gradient);
    border: none;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    background: var(--tsa-gradient-reverse);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(242, 97, 36, 0.4);
}

.btn-outline-primary {
    border: 2px solid var(--tsa-primary);
    color: var(--tsa-primary);
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.btn-outline-primary:hover {
    background: var(--tsa-primary);
    border-color: var(--tsa-primary);
    color: white;
    transform: translateY(-2px);
}

.btn-secondary {
    background: var(--tsa-secondary);
    border: none;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.btn-secondary:hover {
    background: var(--tsa-secondary-dark);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(129, 5, 191, 0.4);
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .activities-grid {
        grid-template-columns: 1fr;
    }
    
    .plans-grid {
        grid-template-columns: 1fr;
    }
    
    .about-accent-box {
        bottom: -10px;
        right: 10px;
        padding: 1rem 1.5rem;
    }
    
    .about-accent-box .accent-number {
        font-size: 2rem;
    }
}

@media (max-width: 768px) {
    .carousel-caption h1 {
        font-size: 1.5rem;
    }
    
    .carousel-caption .lead {
        font-size: 1rem;
    }
    
    .carousel-caption p {
        font-size: 0.9rem;
    }
    
    .carousel-caption .container > .row > div {
        padding: 1.25rem 1.5rem;
        margin: 0 1rem;
    }
    
    .stat-item h2 {
        font-size: 2rem;
    }
    
    .stat-icon {
        width: 50px;
        height: 50px;
        font-size: 1.3rem;
    }
    
    .section-badge {
        font-size: 0.75rem;
        padding: 0.3rem 0.8rem;
    }
    
    .cta-card {
        padding: 1.5rem;
        text-align: center;
    }
    
    .cta-card .d-flex {
        justify-content: center !important;
    }
    
    .event-highlight-card {
        padding: 1.5rem;
    }
    
    .newsletter-form .input-group {
        flex-direction: column;
    }
    
    .newsletter-form .form-control {
        border-radius: 50px;
        margin-bottom: 1rem;
    }
    
    .newsletter-form .btn {
        border-radius: 50px;
        width: 100%;
    }
}

/* =========================================
   ANIMATION KEYFRAMES
   ========================================= */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.fade-in-up {
    animation: fadeInUp 0.6s ease forwards;
}

/* Scroll Animation Classes */
.reveal {
    opacity: 0;
    transform: translateY(30px);
    transition: all 0.8s ease;
}

.reveal.active {
    opacity: 1;
    transform: translateY(0);
}
</style>

<script>
// Counter Animation for Statistics
document.addEventListener('DOMContentLoaded', function() {
    const counters = document.querySelectorAll('.stat-counter');
    const options = {
        threshold: 0.5
    };
    
    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const counter = entry.target;
                const target = parseInt(counter.getAttribute('data-target'));
                const duration = 2000;
                const step = target / (duration / 16);
                let current = 0;
                
                const updateCounter = () => {
                    current += step;
                    if (current < target) {
                        counter.textContent = Math.floor(current) + '+';
                        requestAnimationFrame(updateCounter);
                    } else {
                        counter.textContent = target + '+';
                    }
                };
                
                updateCounter();
                observer.unobserve(counter);
            }
        });
    }, options);
    
    counters.forEach(counter => observer.observe(counter));
    
    // Scroll Reveal Animation
    const reveals = document.querySelectorAll('.reveal');
    const revealObserver = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('active');
            }
        });
    }, { threshold: 0.1 });
    
    reveals.forEach(reveal => revealObserver.observe(reveal));
});
</script>