<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<?php
// Manual WhatsApp number - Change this to your WhatsApp number
$whatsapp_number = '233500557751'; // Format: Country code + number (no + sign, spaces, or dashes)
?>

<!-- Contact Hero Banner -->
<section class="contact-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <nav aria-label="breadcrumb" class="mb-3">
                    <ol class="breadcrumb breadcrumb-custom">
                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Contact Us</li>
                    </ol>
                </nav>
                <span class="section-badge mb-3">
                    <i class="fas fa-envelope me-2"></i>Get In Touch
                </span>
                <h1 class="display-5 fw-bold text-white mb-3">Contact Us</h1>
                <p class="lead text-white-50 mb-0">Have questions about our workshops or want to learn more? We'd love to hear from you!</p>
            </div>
            <div class="col-lg-4 text-lg-end mt-4 mt-lg-0">
                <div class="hero-contact-quick">
                    <a href="https://wa.me/<?php echo $whatsapp_number; ?>?text=Hello,%20I%20would%20like%20to%20get%20in%20touch" 
                       target="_blank" 
                       class="btn btn-whatsapp-hero">
                        <i class="fab fa-whatsapp me-2"></i>Quick Chat
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Flash Messages -->
<?php if($this->session->flashdata('message')): ?>
<div class="container mt-n3 position-relative" style="z-index: 10;">
    <div class="alert alert-<?php echo $this->session->flashdata('message_type'); ?> alert-dismissible fade show alert-custom" role="alert">
        <div class="alert-icon">
            <?php if($this->session->flashdata('message_type') == 'success'): ?>
                <i class="fas fa-check-circle"></i>
            <?php else: ?>
                <i class="fas fa-exclamation-circle"></i>
            <?php endif; ?>
        </div>
        <div class="alert-content">
            <?php echo $this->session->flashdata('message'); ?>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
</div>
<?php endif; ?>

<!-- Main Contact Section -->
<section class="py-5 contact-section">
    <div class="container">
        <div class="row">
            <!-- Contact Form -->
            <div class="col-lg-8 mb-4">
                <div class="contact-form-card">
                    <!-- Form Header -->
                    <div class="form-header">
                        <div class="header-icon">
                            <i class="fas fa-paper-plane"></i>
                        </div>
                        <h3 class="form-title">Send Us a Message</h3>
                        <p class="form-subtitle">Fill out the form below and we'll get back to you as soon as possible</p>
                    </div>
                    
                    <!-- Contact Form -->
                    <div class="form-body">
                        <?php echo form_open('contact/submit', ['class' => 'contact-form', 'id' => 'contactForm']); ?>
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Your Name <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-user"></i>
                                            <input type="text" class="form-control" name="name" 
                                                   value="<?php echo set_value('name'); ?>" 
                                                   placeholder="Enter your full name" required>
                                        </div>
                                        <?php echo form_error('name', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Email Address <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-envelope"></i>
                                            <input type="email" class="form-control" name="email" 
                                                   value="<?php echo set_value('email'); ?>" 
                                                   placeholder="your@email.com" required>
                                        </div>
                                        <?php echo form_error('email', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Phone Number</label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-phone"></i>
                                            <input type="tel" class="form-control" name="phone" 
                                                   value="<?php echo set_value('phone'); ?>" 
                                                   placeholder="+233 XX XXX XXXX">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Subject <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-tag"></i>
                                            <input type="text" class="form-control" name="subject" 
                                                   value="<?php echo set_value('subject'); ?>" 
                                                   placeholder="How can we help?" required>
                                        </div>
                                        <?php echo form_error('subject', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Inquiry Type -->
                            <div class="mb-4">
                                <label class="form-label mb-3">What's your inquiry about?</label>
                                <div class="inquiry-types">
                                    <label class="inquiry-option">
                                        <input type="radio" name="inquiry_type" value="french_workshop" checked>
                                        <span class="inquiry-card">
                                            <i class="fas fa-chalkboard-teacher"></i>
                                            <span>French Workshop</span>
                                        </span>
                                    </label>
                                    <label class="inquiry-option">
                                        <input type="radio" name="inquiry_type" value="volunteering">
                                        <span class="inquiry-card">
                                            <i class="fas fa-hands-helping"></i>
                                            <span>Volunteering</span>
                                        </span>
                                    </label>
                                    <label class="inquiry-option">
                                        <input type="radio" name="inquiry_type" value="partnership">
                                        <span class="inquiry-card">
                                            <i class="fas fa-handshake"></i>
                                            <span>Partnership</span>
                                        </span>
                                    </label>
                                    <label class="inquiry-option">
                                        <input type="radio" name="inquiry_type" value="general">
                                        <span class="inquiry-card">
                                            <i class="fas fa-question-circle"></i>
                                            <span>General</span>
                                        </span>
                                    </label>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <div class="form-group-custom">
                                    <label class="form-label">Your Message <span class="text-danger">*</span></label>
                                    <div class="input-wrapper textarea">
                                        <i class="fas fa-comment-dots"></i>
                                        <textarea class="form-control" name="message" rows="6" 
                                                  placeholder="Tell us how we can help you..." required><?php echo set_value('message'); ?></textarea>
                                    </div>
                                    <?php echo form_error('message', '<small class="text-danger">', '</small>'); ?>
                                </div>
                            </div>
                            
                            <div class="form-footer">
                                <button type="submit" class="btn btn-submit">
                                    <span class="btn-content">
                                        <i class="fas fa-paper-plane me-2"></i>
                                        <span>Send Message</span>
                                    </span>
                                    <span class="btn-loading" style="display: none;">
                                        <i class="fas fa-spinner fa-spin me-2"></i>Sending...
                                    </span>
                                </button>
                                <p class="form-note">
                                    <i class="fas fa-clock me-1"></i>
                                    We typically respond within 24-48 hours
                                </p>
                            </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <aside class="sidebar">
                    <!-- Contact Info Card -->
                    <div class="sidebar-widget contact-info-widget">
                        <h5 class="widget-title"><i class="fas fa-address-card me-2"></i>Contact Information</h5>
                        
                        <div class="contact-list">
                            <?php if (!empty($site_settings['site_email'])): ?>
                            <div class="contact-item">
                                <div class="contact-icon email">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div class="contact-content">
                                    <span class="contact-label">Email Us</span>
                                    <a href="mailto:<?php echo $site_settings['site_email']; ?>">
                                        <?php echo $site_settings['site_email']; ?>
                                    </a>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="contact-item">
                                <div class="contact-icon email">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div class="contact-content">
                                    <span class="contact-label">Email Us</span>
                                    <a href="mailto:info@theskillsatelier.com">info@theskillsatelier.com</a>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($site_settings['site_phone'])): ?>
                            <div class="contact-item">
                                <div class="contact-icon phone">
                                    <i class="fas fa-phone-alt"></i>
                                </div>
                                <div class="contact-content">
                                    <span class="contact-label">Call Us</span>
                                    <a href="tel:<?php echo $site_settings['site_phone']; ?>">
                                        <?php echo $site_settings['site_phone']; ?>
                                    </a>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="contact-item">
                                <div class="contact-icon phone">
                                    <i class="fas fa-phone-alt"></i>
                                </div>
                                <div class="contact-content">
                                    <span class="contact-label">Call Us</span>
                                    <a href="tel:+233500557751">+233 50 055 7751</a>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($whatsapp_number)): ?>
                            <div class="contact-item">
                                <div class="contact-icon whatsapp">
                                    <i class="fab fa-whatsapp"></i>
                                </div>
                                <div class="contact-content">
                                    <span class="contact-label">WhatsApp</span>
                                    <a href="https://wa.me/<?php echo $whatsapp_number; ?>" target="_blank">
                                        +<?php echo substr($whatsapp_number, 0, 3) . ' ' . substr($whatsapp_number, 3, 2) . ' ' . substr($whatsapp_number, 5, 3) . ' ' . substr($whatsapp_number, 8); ?>
                                    </a>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <div class="contact-item">
                                <div class="contact-icon location">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div class="contact-content">
                                    <span class="contact-label">Location</span>
                                    <?php if (!empty($site_settings['site_address'])): ?>
                                        <span><?php echo nl2br($site_settings['site_address']); ?></span>
                                    <?php else: ?>
                                        <span>East Legon, Accra, Ghana</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- WhatsApp Quick Chat Card -->
                    <?php if (!empty($whatsapp_number)): ?>
                    <div class="sidebar-widget whatsapp-widget">
                        <div class="whatsapp-content">
                            <div class="whatsapp-icon-large">
                                <i class="fab fa-whatsapp"></i>
                            </div>
                            <h5>Chat on WhatsApp</h5>
                            <p>Get instant responses to your questions</p>
                            <a href="https://wa.me/<?php echo $whatsapp_number; ?>?text=Hello,%20I%20would%20like%20to%20inquire%20about%20your%20services" 
                               target="_blank" 
                               class="btn btn-whatsapp-full">
                                <i class="fab fa-whatsapp me-2"></i>Start Chat
                            </a>
                        </div>
                        <div class="whatsapp-decoration">
                            <div class="bubble bubble-1"></div>
                            <div class="bubble bubble-2"></div>
                            <div class="bubble bubble-3"></div>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Office Hours Card -->
                    <div class="sidebar-widget hours-widget">
                        <div class="hours-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <h5>Office Hours</h5>
                        <div class="hours-list">
                            <div class="hours-item">
                                <span class="day">Monday - Friday</span>
                                <span class="time">9:00 AM - 5:00 PM</span>
                            </div>
                            <div class="hours-item">
                                <span class="day">Saturday</span>
                                <span class="time">10:00 AM - 2:00 PM</span>
                            </div>
                            <div class="hours-item closed">
                                <span class="day">Sunday</span>
                                <span class="time">Closed</span>
                            </div>
                        </div>
                        <p class="hours-note">
                            <i class="fas fa-info-circle me-1"></i>
                            Workshop sessions may run outside these hours
                        </p>
                    </div>
                    
                    <!-- Social Links Card -->
                    <div class="sidebar-widget social-widget">
                        <h5 class="widget-title"><i class="fas fa-share-alt me-2"></i>Follow Us</h5>
                        <p class="social-text">Stay updated with our latest activities and workshops</p>
                        <div class="social-links">
                            <a href="https://web.facebook.com/p/The-skills-Atelier-61577905511642/?_rdc=1&_rdr#" class="social-link facebook" title="Facebook">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="https://instagram.com/theskillsatelier" target="_blank" class="social-link instagram" title="Instagram">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="#" class="social-link twitter" title="Twitter">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="https://www.linkedin.com/in/the-skills-atelier-a98674365/?originalSubdomain=gh" class="social-link linkedin" title="LinkedIn">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<!-- Map Section -->
<section class="map-section">
    <div class="container-fluid px-0">
        <div class="map-wrapper">
            <div class="map-overlay">
                <div class="map-card">
                    <div class="map-card-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <h5>Find Us</h5>
                    <p>East Legon, Accra<br>Greater Accra Region, Ghana</p>
                    <a href="https://maps.google.com/?q=East+Legon+Accra+Ghana" target="_blank" class="btn btn-directions">
                        <i class="fas fa-directions me-2"></i>Get Directions
                    </a>
                </div>
            </div>
            <iframe 
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d15881.89544895477!2d-0.15687474999999998!3d5.6354179!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0xfdf9c7ebaeabe93%3A0xd78257e67498a13d!2sEast%20Legon%2C%20Accra%2C%20Ghana!5e0!3m2!1sen!2sus!4v1699999999999!5m2!1sen!2sus" 
                width="100%" 
                height="450" 
                style="border:0;" 
                allowfullscreen="" 
                loading="lazy" 
                referrerpolicy="no-referrer-when-downgrade">
            </iframe>
        </div>
    </div>
</section>

<!-- FAQ Quick Section -->
<section class="py-5 faq-section">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-badge-alt">Common Questions</span>
            <h2 class="fw-bold mt-3">Frequently Asked Questions</h2>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="faq-list">
                    <div class="faq-item">
                        <div class="faq-question" data-bs-toggle="collapse" data-bs-target="#faq1">
                            <span>What age groups do you teach?</span>
                            <i class="fas fa-chevron-down"></i>
                        </div>
                        <div class="collapse" id="faq1">
                            <div class="faq-answer">
                                Our French Workshop is currently designed for children aged 6-12 years. We're planning to launch adult programmes in 2026.
                            </div>
                        </div>
                    </div>
                    
                    <div class="faq-item">
                        <div class="faq-question" data-bs-toggle="collapse" data-bs-target="#faq2">
                            <span>Where are the workshops held?</span>
                            <i class="fas fa-chevron-down"></i>
                        </div>
                        <div class="collapse" id="faq2">
                            <div class="faq-answer">
                                Our workshops are held in East Legon, Accra. The exact venue details are shared upon registration.
                            </div>
                        </div>
                    </div>
                    
                    <div class="faq-item">
                        <div class="faq-question" data-bs-toggle="collapse" data-bs-target="#faq3">
                            <span>How can I volunteer with TSA?</span>
                            <i class="fas fa-chevron-down"></i>
                        </div>
                        <div class="collapse" id="faq3">
                            <div class="faq-answer">
                                We welcome volunteers! You can apply through our <a href="<?php echo base_url('volunteer/apply'); ?>">volunteer application page</a>. We're looking for teaching assistants, event coordinators, and more.
                            </div>
                        </div>
                    </div>
                    
                    <div class="faq-item">
                        <div class="faq-question" data-bs-toggle="collapse" data-bs-target="#faq4">
                            <span>What is your response time?</span>
                            <i class="fas fa-chevron-down"></i>
                        </div>
                        <div class="collapse" id="faq4">
                            <div class="faq-answer">
                                We typically respond to all inquiries within 24-48 hours. For urgent matters, we recommend reaching out via WhatsApp for faster response.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Floating WhatsApp Button -->
<?php if (!empty($whatsapp_number)): ?>
<a href="https://wa.me/<?php echo $whatsapp_number; ?>?text=Hello,%20I%20need%20assistance" 
   target="_blank" 
   class="whatsapp-float" 
   title="Chat on WhatsApp">
    <i class="fab fa-whatsapp"></i>
    <span class="float-tooltip">Chat with us!</span>
</a>
<?php endif; ?>

<style>
/* =========================================
   THE SKILLS ATELIER - CONTACT PAGE STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
    --whatsapp-green: #25D366;
    --whatsapp-dark: #128C7E;
}

/* =========================================
   CONTACT HERO
   ========================================= */
.contact-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 60px;
    position: relative;
    overflow: hidden;
}

.contact-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.breadcrumb-custom {
    background: transparent;
    padding: 0;
    margin: 0;
}

.breadcrumb-custom .breadcrumb-item a {
    color: rgba(255,255,255,0.7);
    text-decoration: none;
    transition: color 0.3s ease;
}

.breadcrumb-custom .breadcrumb-item a:hover {
    color: white;
}

.breadcrumb-custom .breadcrumb-item.active {
    color: white;
}

.breadcrumb-custom .breadcrumb-item + .breadcrumb-item::before {
    color: rgba(255,255,255,0.5);
}

.section-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.section-badge-alt {
    display: inline-block;
    background: var(--tsa-gradient);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-whatsapp-hero {
    background: var(--whatsapp-green);
    color: white;
    font-weight: 600;
    padding: 1rem 2rem;
    border-radius: 50px;
    border: none;
    box-shadow: 0 10px 30px rgba(37, 211, 102, 0.4);
    transition: all 0.3s ease;
}

.btn-whatsapp-hero:hover {
    background: var(--whatsapp-dark);
    color: white;
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(37, 211, 102, 0.5);
}

/* =========================================
   ALERT STYLES
   ========================================= */
.alert-custom {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.5rem;
    border-radius: 15px;
    border: none;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    max-width: 600px;
    margin: 0 auto;
}

.alert-icon {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
}

.alert-success .alert-icon { background: rgba(40, 167, 69, 0.2); color: #28a745; }
.alert-danger .alert-icon { background: rgba(220, 53, 69, 0.2); color: #dc3545; }

/* =========================================
   CONTACT SECTION
   ========================================= */
.contact-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

/* Contact Form Card */
.contact-form-card {
    background: white;
    border-radius: 25px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
    overflow: hidden;
}

.form-header {
    background: var(--tsa-gradient);
    padding: 2rem 2.5rem;
    text-align: center;
}

.header-icon {
    width: 70px;
    height: 70px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.8rem;
    color: white;
}

.form-title {
    color: white;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.form-subtitle {
    color: rgba(255,255,255,0.85);
    margin: 0;
}

.form-body {
    padding: 2rem 2.5rem;
}

/* Form Inputs */
.form-group-custom {
    margin-bottom: 0;
}

.form-label {
    font-weight: 600;
    color: #333;
    margin-bottom: 0.5rem;
    font-size: 0.95rem;
}

.input-wrapper {
    position: relative;
}

.input-wrapper i {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #adb5bd;
    font-size: 1rem;
    z-index: 1;
    transition: color 0.3s ease;
}

.input-wrapper.textarea i {
    top: 1.25rem;
    transform: none;
}

.input-wrapper .form-control {
    padding-left: 3rem;
    border: 2px solid #e9ecef;
    border-radius: 12px;
    height: auto;
    padding-top: 0.875rem;
    padding-bottom: 0.875rem;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.input-wrapper .form-control:focus {
    border-color: var(--tsa-primary);
    box-shadow: 0 0 0 4px rgba(242, 97, 36, 0.1);
}

.input-wrapper:focus-within i {
    color: var(--tsa-primary);
}

.input-wrapper textarea.form-control {
    min-height: 150px;
}

/* Inquiry Types */
.inquiry-types {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 1rem;
}

.inquiry-option {
    cursor: pointer;
}

.inquiry-option input {
    display: none;
}

.inquiry-card {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
    padding: 1.25rem 0.75rem;
    background: #f8f9fa;
    border: 2px solid #e9ecef;
    border-radius: 15px;
    text-align: center;
    transition: all 0.3s ease;
}

.inquiry-option input:checked + .inquiry-card {
    background: var(--tsa-light);
    border-color: var(--tsa-primary);
    box-shadow: 0 5px 20px rgba(242, 97, 36, 0.15);
}

.inquiry-card i {
    font-size: 1.5rem;
    color: #adb5bd;
    transition: color 0.3s ease;
}

.inquiry-option input:checked + .inquiry-card i {
    color: var(--tsa-primary);
}

.inquiry-card span {
    font-size: 0.85rem;
    font-weight: 600;
    color: #555;
}

/* Form Footer */
.form-footer {
    text-align: center;
    padding-top: 1rem;
}

.btn-submit {
    background: var(--tsa-gradient);
    border: none;
    color: white;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 1rem 3rem;
    border-radius: 50px;
    transition: all 0.3s ease;
    box-shadow: 0 10px 30px rgba(242, 97, 36, 0.3);
    display: inline-flex;
    align-items: center;
}

.btn-submit:hover {
    background: var(--tsa-gradient-reverse);
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(242, 97, 36, 0.4);
    color: white;
}

.form-note {
    margin-top: 1rem;
    color: #888;
    font-size: 0.85rem;
}

/* =========================================
   SIDEBAR
   ========================================= */
.sidebar {
    position: sticky;
    top: 100px;
}

.sidebar-widget {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.widget-title {
    font-weight: 700;
    color: #333;
    margin-bottom: 1.25rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #f0f0f0;
}

/* Contact Info Widget */
.contact-list {
    display: flex;
    flex-direction: column;
    gap: 1.25rem;
}

.contact-item {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.contact-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
}

.contact-icon.email { background: rgba(242, 97, 36, 0.1); color: var(--tsa-primary); }
.contact-icon.phone { background: rgba(129, 5, 191, 0.1); color: var(--tsa-secondary); }
.contact-icon.whatsapp { background: rgba(37, 211, 102, 0.1); color: var(--whatsapp-green); }
.contact-icon.location { background: rgba(242, 97, 36, 0.1); color: var(--tsa-primary); }

.contact-content {
    display: flex;
    flex-direction: column;
}

.contact-label {
    font-size: 0.75rem;
    color: #888;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.contact-content a,
.contact-content span {
    color: #333;
    font-weight: 500;
    font-size: 0.95rem;
    text-decoration: none;
}

.contact-content a:hover {
    color: var(--tsa-primary);
}

/* WhatsApp Widget */
.whatsapp-widget {
    background: linear-gradient(135deg, var(--whatsapp-green), var(--whatsapp-dark));
    text-align: center;
    padding: 2rem;
    position: relative;
    overflow: hidden;
}

.whatsapp-content {
    position: relative;
    z-index: 2;
}

.whatsapp-icon-large {
    width: 70px;
    height: 70px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 2rem;
    color: white;
}

.whatsapp-widget h5 {
    color: white;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.whatsapp-widget p {
    color: rgba(255,255,255,0.85);
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

.btn-whatsapp-full {
    background: white;
    color: var(--whatsapp-green);
    font-weight: 600;
    padding: 0.875rem 2rem;
    border-radius: 50px;
    border: none;
    width: 100%;
    transition: all 0.3s ease;
}

.btn-whatsapp-full:hover {
    background: rgba(255,255,255,0.9);
    color: var(--whatsapp-dark);
    transform: translateY(-2px);
}

.whatsapp-decoration {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    pointer-events: none;
}

.bubble {
    position: absolute;
    background: rgba(255,255,255,0.1);
    border-radius: 50%;
}

.bubble-1 { width: 80px; height: 80px; top: -20px; right: -20px; }
.bubble-2 { width: 50px; height: 50px; bottom: 20px; left: -10px; }
.bubble-3 { width: 30px; height: 30px; top: 50%; right: 20px; }

/* Hours Widget */
.hours-widget {
    background: var(--tsa-gradient);
    text-align: center;
    padding: 2rem;
}

.hours-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.5rem;
    color: white;
}

.hours-widget h5 {
    color: white;
    font-weight: 700;
    margin-bottom: 1.25rem;
}

.hours-list {
    margin-bottom: 1rem;
}

.hours-item {
    display: flex;
    justify-content: space-between;
    padding: 0.75rem 0;
    border-bottom: 1px solid rgba(255,255,255,0.2);
}

.hours-item:last-child {
    border-bottom: none;
}

.hours-item .day {
    color: rgba(255,255,255,0.85);
    font-weight: 500;
}

.hours-item .time {
    color: white;
    font-weight: 600;
}

.hours-item.closed .time {
    color: rgba(255,255,255,0.6);
}

.hours-note {
    color: rgba(255,255,255,0.7);
    font-size: 0.8rem;
    margin: 0;
}

/* Social Widget */
.social-text {
    color: #666;
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

.social-links {
    display: flex;
    gap: 0.75rem;
}

.social-link {
    width: 45px;
    height: 45px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
    text-decoration: none;
    transition: all 0.3s ease;
}

.social-link:hover {
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.social-link.facebook { background: #1877f2; }
.social-link.instagram { background: linear-gradient(45deg, #f09433, #e6683c, #dc2743, #cc2366, #bc1888); }
.social-link.twitter { background: #1da1f2; }
.social-link.linkedin { background: #0077b5; }

/* =========================================
   MAP SECTION
   ========================================= */
.map-section {
    background: #f8f9fa;
}

.map-wrapper {
    position: relative;
    height: 450px;
}

.map-wrapper iframe {
    width: 100%;
    height: 100%;
    filter: grayscale(20%);
}

.map-overlay {
    position: absolute;
    top: 50%;
    left: 5%;
    transform: translateY(-50%);
    z-index: 10;
}

.map-card {
    background: white;
    padding: 2rem;
    border-radius: 20px;
    box-shadow: 0 20px 50px rgba(0,0,0,0.15);
    text-align: center;
    max-width: 280px;
}

.map-card-icon {
    width: 60px;
    height: 60px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.5rem;
    color: white;
}

.map-card h5 {
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.map-card p {
    color: #666;
    font-size: 0.95rem;
    margin-bottom: 1rem;
}

.btn-directions {
    background: var(--tsa-gradient);
    color: white;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
}

.btn-directions:hover {
    background: var(--tsa-gradient-reverse);
    color: white;
    transform: translateY(-2px);
}

/* =========================================
   FAQ SECTION
   ========================================= */
.faq-section {
    background: white;
}

.faq-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.faq-item {
    background: #f8f9fa;
    border-radius: 15px;
    overflow: hidden;
    border: 2px solid transparent;
    transition: border-color 0.3s ease;
}

.faq-item:hover {
    border-color: var(--tsa-primary);
}

.faq-question {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.25rem 1.5rem;
    cursor: pointer;
    font-weight: 600;
    color: #333;
}

.faq-question i {
    color: var(--tsa-primary);
    transition: transform 0.3s ease;
}

.faq-question[aria-expanded="true"] i {
    transform: rotate(180deg);
}

.faq-answer {
    padding: 0 1.5rem 1.25rem;
    color: #666;
    line-height: 1.7;
}

.faq-answer a {
    color: var(--tsa-primary);
    font-weight: 500;
}

/* =========================================
   FLOATING WHATSAPP BUTTON
   ========================================= */
.whatsapp-float {
    position: fixed;
    width: 60px;
    height: 60px;
    bottom: 40px;
    right: 40px;
    background-color: var(--whatsapp-green);
    color: #FFF;
    border-radius: 50px;
    text-align: center;
    font-size: 30px;
    box-shadow: 0 5px 25px rgba(37, 211, 102, 0.4);
    z-index: 1000;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    text-decoration: none;
}

.whatsapp-float:hover {
    background-color: var(--whatsapp-dark);
    transform: scale(1.1);
    box-shadow: 0 8px 30px rgba(37, 211, 102, 0.5);
    color: #FFF;
}

.whatsapp-float i {
    margin-top: 3px;
}

.float-tooltip {
    position: absolute;
    right: 70px;
    background: #333;
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 8px;
    font-size: 0.85rem;
    white-space: nowrap;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.float-tooltip::after {
    content: '';
    position: absolute;
    right: -6px;
    top: 50%;
    transform: translateY(-50%);
    border-width: 6px;
    border-style: solid;
    border-color: transparent transparent transparent #333;
}

.whatsapp-float:hover .float-tooltip {
    opacity: 1;
    visibility: visible;
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .contact-hero {
        padding: 80px 0 50px;
    }
    
    .contact-hero h1 {
        font-size: 2rem;
    }
    
    .sidebar {
        position: relative;
        top: 0;
        margin-top: 2rem;
    }
    
    .inquiry-types {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .map-overlay {
        position: relative;
        top: auto;
        left: auto;
        transform: none;
        padding: 1.5rem;
    }
    
    .map-card {
        max-width: 100%;
    }
    
    .map-wrapper {
        height: auto;
    }
    
    .map-wrapper iframe {
        height: 350px;
    }
}

@media (max-width: 768px) {
    .contact-hero {
        padding: 70px 0 40px;
        text-align: center;
    }
    
    .contact-hero h1 {
        font-size: 1.75rem;
    }
    
    .form-header,
    .form-body {
        padding: 1.5rem;
    }
    
    .inquiry-types {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .inquiry-card {
        padding: 1rem 0.5rem;
    }
    
    .btn-submit {
        width: 100%;
        justify-content: center;
    }
    
    .whatsapp-float {
        width: 50px;
        height: 50px;
        bottom: 20px;
        right: 20px;
        font-size: 25px;
    }
    
    .float-tooltip {
        display: none;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Form submit loading state
    var form = document.getElementById('contactForm');
    if (form) {
        form.addEventListener('submit', function() {
            var submitBtn = form.querySelector('.btn-submit');
            var btnContent = submitBtn.querySelector('.btn-content');
            var btnLoading = submitBtn.querySelector('.btn-loading');
            
            btnContent.style.display = 'none';
            btnLoading.style.display = 'inline-flex';
            submitBtn.disabled = true;
        });
    }
});
</script>