<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Consultation Hero Banner -->
<section class="consultation-hero">
    <div class="container">
        <div class="row align-items-center justify-content-center">
            <div class="col-lg-8 text-center">
                <div class="hero-icon-wrapper">
                    <div class="hero-icon">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                    <div class="icon-ring"></div>
                </div>
                <span class="section-badge mb-3">
                    <i class="fas fa-comments me-2"></i>Free Consultation
                </span>
                <h1 class="display-5 fw-bold text-white mb-3">Book Your Consultation</h1>
                <p class="lead text-white-50 mb-0">Get personalized guidance on our workshops, programmes, and how we can help you or your child excel.</p>
            </div>
        </div>
    </div>
</section>

<!-- Flash Messages -->
<div class="container mt-n4 position-relative" style="z-index: 10;">
    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show alert-custom" role="alert">
            <div class="alert-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="alert-content">
                <strong>Success!</strong> <?php echo $this->session->flashdata('success'); ?>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show alert-custom" role="alert">
            <div class="alert-icon">
                <i class="fas fa-exclamation-circle"></i>
            </div>
            <div class="alert-content">
                <strong>Oops!</strong> <?php echo $this->session->flashdata('error'); ?>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if ($this->session->flashdata('warning')): ?>
        <div class="alert alert-warning alert-dismissible fade show alert-custom" role="alert">
            <div class="alert-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="alert-content">
                <strong>Note:</strong> <?php echo $this->session->flashdata('warning'); ?>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
</div>

<!-- Main Consultation Section -->
<section class="py-5 consultation-section">
    <div class="container">
        <div class="row">
            <!-- Consultation Form -->
            <div class="col-lg-8 mb-4">
                <div class="consultation-card">
                    <!-- Form Header -->
                    <div class="form-header">
                        <div class="header-decoration">
                            <span class="deco-dot"></span>
                            <span class="deco-dot"></span>
                            <span class="deco-dot"></span>
                        </div>
                        <div class="header-content">
                            <h3 class="form-title">Request a Consultation</h3>
                            <p class="form-subtitle">Fill in the details below and we'll get back to you promptly</p>
                        </div>
                    </div>
                    
                    <!-- Progress Steps -->
                    <div class="form-progress">
                        <div class="progress-step active" data-step="1">
                            <span class="step-number">1</span>
                            <span class="step-label">Your Info</span>
                        </div>
                        <div class="progress-line"></div>
                        <div class="progress-step" data-step="2">
                            <span class="step-number">2</span>
                            <span class="step-label">Consultation</span>
                        </div>
                        <div class="progress-line"></div>
                        <div class="progress-step" data-step="3">
                            <span class="step-number">3</span>
                            <span class="step-label">Message</span>
                        </div>
                    </div>
                    
                    <!-- Consultation Form -->
                    <div class="form-body">
                        <?php echo form_open('consultation/submit', array('id' => 'consultationForm', 'class' => 'consultation-form')); ?>
                            
                            <!-- Section 1: Personal Information -->
                            <div class="form-section" id="section-1">
                                <div class="section-header">
                                    <div class="section-icon">
                                        <i class="fas fa-user"></i>
                                    </div>
                                    <div>
                                        <h4 class="section-title">Personal Information</h4>
                                        <p class="section-subtitle">Tell us about yourself</p>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-4">
                                        <div class="form-group-custom">
                                            <label class="form-label">Full Name <span class="text-danger">*</span></label>
                                            <div class="input-wrapper">
                                                <i class="fas fa-user"></i>
                                                <input type="text" class="form-control" id="full_name" name="full_name" 
                                                       value="<?php echo set_value('full_name'); ?>" 
                                                       placeholder="Your full name" required>
                                            </div>
                                            <?php echo form_error('full_name', '<small class="text-danger">', '</small>'); ?>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6 mb-4">
                                        <div class="form-group-custom">
                                            <label class="form-label">Email Address <span class="text-danger">*</span></label>
                                            <div class="input-wrapper">
                                                <i class="fas fa-envelope"></i>
                                                <input type="email" class="form-control" id="email" name="email" 
                                                       value="<?php echo set_value('email'); ?>" 
                                                       placeholder="your@email.com" required>
                                            </div>
                                            <?php echo form_error('email', '<small class="text-danger">', '</small>'); ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-4">
                                        <div class="form-group-custom">
                                            <label class="form-label">Phone Number <span class="text-danger">*</span></label>
                                            <div class="input-wrapper">
                                                <i class="fas fa-phone"></i>
                                                <input type="tel" class="form-control" id="phone" name="phone" 
                                                       value="<?php echo set_value('phone'); ?>" 
                                                       placeholder="+233 XX XXX XXXX" required>
                                            </div>
                                            <?php echo form_error('phone', '<small class="text-danger">', '</small>'); ?>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6 mb-4">
                                        <div class="form-group-custom">
                                            <label class="form-label">Organization <span class="text-muted">(Optional)</span></label>
                                            <div class="input-wrapper">
                                                <i class="fas fa-building"></i>
                                                <input type="text" class="form-control" id="organization" name="organization" 
                                                       value="<?php echo set_value('organization'); ?>" 
                                                       placeholder="Company or School name">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Section 2: Consultation Details -->
                            <div class="form-section" id="section-2">
                                <div class="section-header">
                                    <div class="section-icon">
                                        <i class="fas fa-calendar-alt"></i>
                                    </div>
                                    <div>
                                        <h4 class="section-title">Consultation Details</h4>
                                        <p class="section-subtitle">What would you like to discuss?</p>
                                    </div>
                                </div>
                                
                                <!-- Consultation Type Visual Selector -->
                                <div class="mb-4">
                                    <label class="form-label mb-3">Select Consultation Type <span class="text-danger">*</span></label>
                                    <div class="consultation-types">
                                        <label class="type-option">
                                            <input type="radio" name="consultation_type" value="program" required 
                                                   <?php echo set_radio('consultation_type', 'program'); ?>>
                                            <span class="type-card">
                                                <span class="type-icon"><i class="fas fa-chalkboard-teacher"></i></span>
                                                <span class="type-name">Programme Info</span>
                                                <span class="type-desc">Learn about our workshops</span>
                                            </span>
                                        </label>
                                        <label class="type-option">
                                            <input type="radio" name="consultation_type" value="volunteer"
                                                   <?php echo set_radio('consultation_type', 'volunteer'); ?>>
                                            <span class="type-card">
                                                <span class="type-icon"><i class="fas fa-hands-helping"></i></span>
                                                <span class="type-name">Volunteering</span>
                                                <span class="type-desc">Join our team</span>
                                            </span>
                                        </label>
                                        <label class="type-option">
                                            <input type="radio" name="consultation_type" value="partnership"
                                                   <?php echo set_radio('consultation_type', 'partnership'); ?>>
                                            <span class="type-card">
                                                <span class="type-icon"><i class="fas fa-handshake"></i></span>
                                                <span class="type-name">Partnership</span>
                                                <span class="type-desc">Collaborate with us</span>
                                            </span>
                                        </label>
                                        <label class="type-option">
                                            <input type="radio" name="consultation_type" value="general"
                                                   <?php echo set_radio('consultation_type', 'general'); ?>>
                                            <span class="type-card">
                                                <span class="type-icon"><i class="fas fa-comments"></i></span>
                                                <span class="type-name">General</span>
                                                <span class="type-desc">Other inquiries</span>
                                            </span>
                                        </label>
                                    </div>
                                    <?php echo form_error('consultation_type', '<small class="text-danger d-block mt-2">', '</small>'); ?>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-4">
                                        <div class="form-group-custom">
                                            <label class="form-label">Preferred Date</label>
                                            <div class="input-wrapper">
                                                <i class="fas fa-calendar"></i>
                                                <input type="date" class="form-control" id="preferred_date" name="preferred_date" 
                                                       value="<?php echo set_value('preferred_date'); ?>" 
                                                       min="<?php echo date('Y-m-d'); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6 mb-4">
                                        <div class="form-group-custom">
                                            <label class="form-label">Preferred Time</label>
                                            <div class="input-wrapper">
                                                <i class="fas fa-clock"></i>
                                                <select class="form-control" id="preferred_time" name="preferred_time">
                                                    <option value="">-- Select Time --</option>
                                                    <option value="morning" <?php echo set_select('preferred_time', 'morning'); ?>>Morning (9 AM - 12 PM)</option>
                                                    <option value="afternoon" <?php echo set_select('preferred_time', 'afternoon'); ?>>Afternoon (12 PM - 3 PM)</option>
                                                    <option value="evening" <?php echo set_select('preferred_time', 'evening'); ?>>Evening (3 PM - 6 PM)</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Time Slot Visual Selector -->
                                <div class="time-slots mb-4">
                                    <label class="form-label mb-3">Or select a time slot:</label>
                                    <div class="slots-grid">
                                        <label class="slot-option">
                                            <input type="radio" name="time_slot_visual" value="morning">
                                            <span class="slot-card">
                                                <i class="fas fa-sun"></i>
                                                <span>Morning</span>
                                                <small>9 AM - 12 PM</small>
                                            </span>
                                        </label>
                                        <label class="slot-option">
                                            <input type="radio" name="time_slot_visual" value="afternoon">
                                            <span class="slot-card">
                                                <i class="fas fa-cloud-sun"></i>
                                                <span>Afternoon</span>
                                                <small>12 PM - 3 PM</small>
                                            </span>
                                        </label>
                                        <label class="slot-option">
                                            <input type="radio" name="time_slot_visual" value="evening">
                                            <span class="slot-card">
                                                <i class="fas fa-moon"></i>
                                                <span>Evening</span>
                                                <small>3 PM - 6 PM</small>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Section 3: Message -->
                            <div class="form-section" id="section-3">
                                <div class="section-header">
                                    <div class="section-icon">
                                        <i class="fas fa-comment-dots"></i>
                                    </div>
                                    <div>
                                        <h4 class="section-title">Your Message</h4>
                                        <p class="section-subtitle">Tell us more about your needs</p>
                                    </div>
                                </div>
                                
                                <div class="mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Subject <span class="text-danger">*</span></label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-tag"></i>
                                            <input type="text" class="form-control" id="subject" name="subject" 
                                                   value="<?php echo set_value('subject'); ?>" 
                                                   placeholder="Brief subject of your inquiry" required>
                                        </div>
                                        <?php echo form_error('subject', '<small class="text-danger">', '</small>'); ?>
                                    </div>
                                </div>
                                
                                <div class="mb-4">
                                    <div class="form-group-custom">
                                        <label class="form-label">Message <span class="text-danger">*</span></label>
                                        <div class="input-wrapper textarea">
                                            <i class="fas fa-pencil-alt"></i>
                                            <textarea class="form-control" id="message" name="message" rows="5" 
                                                      placeholder="Tell us how we can help you..." required><?php echo set_value('message'); ?></textarea>
                                        </div>
                                        <?php echo form_error('message', '<small class="text-danger">', '</small>'); ?>
                                        <small class="form-hint"><i class="fas fa-lightbulb me-1"></i>Be as detailed as possible so we can better assist you</small>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Submit Section -->
                            <div class="form-section submit-section">
                                <button type="submit" class="btn btn-submit">
                                    <span class="btn-content">
                                        <i class="fas fa-paper-plane me-2"></i>
                                        <span>Submit Request</span>
                                    </span>
                                    <span class="btn-loading" style="display: none;">
                                        <i class="fas fa-spinner fa-spin me-2"></i>Submitting...
                                    </span>
                                </button>
                                
                                <p class="submit-note">
                                    <i class="fas fa-clock me-1"></i>
                                    We typically respond within 24-48 hours
                                </p>
                            </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <aside class="sidebar">
                    <!-- Why Book Widget -->
                    <div class="sidebar-widget why-widget">
                        <h5 class="widget-title"><i class="fas fa-star me-2"></i>Why Book a Consultation?</h5>
                        <div class="benefit-list">
                            <div class="benefit-item">
                                <div class="benefit-icon">
                                    <i class="fas fa-check"></i>
                                </div>
                                <div class="benefit-content">
                                    <h6>Personalized Guidance</h6>
                                    <p>Get advice tailored to your specific needs</p>
                                </div>
                            </div>
                            <div class="benefit-item">
                                <div class="benefit-icon">
                                    <i class="fas fa-check"></i>
                                </div>
                                <div class="benefit-content">
                                    <h6>Expert Insights</h6>
                                    <p>Learn from experienced educators</p>
                                </div>
                            </div>
                            <div class="benefit-item">
                                <div class="benefit-icon">
                                    <i class="fas fa-check"></i>
                                </div>
                                <div class="benefit-content">
                                    <h6>No Obligation</h6>
                                    <p>Free consultation with no pressure</p>
                                </div>
                            </div>
                            <div class="benefit-item">
                                <div class="benefit-icon">
                                    <i class="fas fa-check"></i>
                                </div>
                                <div class="benefit-content">
                                    <h6>Flexible Options</h6>
                                    <p>In-person or virtual meetings</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- What to Expect Widget -->
                    <div class="sidebar-widget expect-widget">
                        <h5 class="widget-title"><i class="fas fa-clipboard-list me-2"></i>What to Expect</h5>
                        <div class="timeline">
                            <div class="timeline-item">
                                <div class="timeline-marker">1</div>
                                <div class="timeline-content">
                                    <h6>Submit Request</h6>
                                    <p>Fill out this form</p>
                                </div>
                            </div>
                            <div class="timeline-item">
                                <div class="timeline-marker">2</div>
                                <div class="timeline-content">
                                    <h6>We Review</h6>
                                    <p>Within 24-48 hours</p>
                                </div>
                            </div>
                            <div class="timeline-item">
                                <div class="timeline-marker">3</div>
                                <div class="timeline-content">
                                    <h6>Schedule Meeting</h6>
                                    <p>At your convenience</p>
                                </div>
                            </div>
                            <div class="timeline-item">
                                <div class="timeline-marker">4</div>
                                <div class="timeline-content">
                                    <h6>Get Started!</h6>
                                    <p>Begin your journey</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Quick Contact Widget -->
                    <div class="sidebar-widget quick-widget">
                        <div class="quick-content">
                            <div class="quick-icon">
                                <i class="fab fa-whatsapp"></i>
                            </div>
                            <h5>Need Immediate Help?</h5>
                            <p>Chat with us directly on WhatsApp for quick responses</p>
                            <a href="https://wa.me/233500557751?text=Hello,%20I'd%20like%20to%20book%20a%20consultation" 
                               target="_blank" 
                               class="btn btn-whatsapp">
                                <i class="fab fa-whatsapp me-2"></i>Chat Now
                            </a>
                        </div>
                    </div>
                    
                    <!-- Testimonial Widget -->
                    <div class="sidebar-widget testimonial-widget">
                        <div class="testimonial-quote">
                            <i class="fas fa-quote-left"></i>
                        </div>
                        <p class="testimonial-text">"The consultation helped me understand exactly what my child needed. The team was incredibly helpful and patient!"</p>
                        <div class="testimonial-author">
                            <div class="author-avatar">
                                <span>AP</span>
                            </div>
                            <div class="author-info">
                                <h6>Akua P.</h6>
                                <span>Parent, East Legon</span>
                            </div>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<style>
/* =========================================
   THE SKILLS ATELIER - CONSULTATION PAGE STYLES
   Primary: #f26124 (Orange)
   Secondary: #8105bf (Purple)
   ========================================= */

:root {
    --tsa-primary: #f26124;
    --tsa-primary-dark: #d94f15;
    --tsa-secondary: #8105bf;
    --tsa-secondary-dark: #6a049e;
    --tsa-light: #fff8f5;
    --tsa-cream: #f7e1b0;
    --tsa-gradient: linear-gradient(135deg, #f26124, #8105bf);
    --tsa-gradient-reverse: linear-gradient(135deg, #8105bf, #f26124);
    --whatsapp-green: #25D366;
}

/* =========================================
   CONSULTATION HERO
   ========================================= */
.consultation-hero {
    background: var(--tsa-gradient);
    padding: 100px 0 80px;
    position: relative;
    overflow: hidden;
}

.consultation-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
}

.hero-icon-wrapper {
    position: relative;
    display: inline-block;
    margin-bottom: 1.5rem;
}

.hero-icon {
    width: 100px;
    height: 100px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2.5rem;
    color: white;
    position: relative;
    z-index: 2;
    backdrop-filter: blur(10px);
}

.icon-ring {
    position: absolute;
    top: -10px;
    left: -10px;
    right: -10px;
    bottom: -10px;
    border: 3px solid rgba(255,255,255,0.2);
    border-radius: 50%;
    animation: pulse-ring 2s infinite;
}

@keyframes pulse-ring {
    0% { transform: scale(1); opacity: 1; }
    50% { transform: scale(1.1); opacity: 0.5; }
    100% { transform: scale(1); opacity: 1; }
}

.section-badge {
    display: inline-block;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
}

/* =========================================
   ALERT STYLES
   ========================================= */
.alert-custom {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.5rem;
    border-radius: 15px;
    border: none;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    max-width: 600px;
    margin: 0 auto;
}

.alert-icon {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
}

.alert-success .alert-icon { background: rgba(40, 167, 69, 0.2); color: #28a745; }
.alert-danger .alert-icon { background: rgba(220, 53, 69, 0.2); color: #dc3545; }
.alert-warning .alert-icon { background: rgba(255, 193, 7, 0.2); color: #ffc107; }

/* =========================================
   CONSULTATION SECTION
   ========================================= */
.consultation-section {
    background: linear-gradient(180deg, #fff 0%, var(--tsa-light) 100%);
}

.consultation-card {
    background: white;
    border-radius: 25px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
    overflow: hidden;
}

/* Form Header */
.form-header {
    background: var(--tsa-gradient);
    padding: 2rem 2.5rem;
    position: relative;
}

.header-decoration {
    position: absolute;
    top: 1rem;
    right: 1.5rem;
    display: flex;
    gap: 0.5rem;
}

.deco-dot {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background: rgba(255,255,255,0.3);
}

.header-content {
    text-align: center;
}

.form-title {
    color: white;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.form-subtitle {
    color: rgba(255,255,255,0.85);
    margin: 0;
}

/* Form Progress */
.form-progress {
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 1.5rem 2rem;
    background: #fafafa;
    border-bottom: 1px solid #f0f0f0;
}

.progress-step {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
}

.step-number {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #e9ecef;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #adb5bd;
    font-weight: 700;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.progress-step.active .step-number {
    background: var(--tsa-gradient);
    color: white;
    box-shadow: 0 5px 20px rgba(242, 97, 36, 0.4);
}

.step-label {
    font-size: 0.8rem;
    font-weight: 600;
    color: #adb5bd;
}

.progress-step.active .step-label {
    color: var(--tsa-primary);
}

.progress-line {
    width: 60px;
    height: 3px;
    background: #e9ecef;
    margin: 0 1rem;
    margin-bottom: 1.5rem;
    border-radius: 3px;
}

/* Form Body */
.form-body {
    padding: 2rem 2.5rem;
}

/* Form Sections */
.form-section {
    padding-bottom: 2rem;
    margin-bottom: 2rem;
    border-bottom: 1px solid #f0f0f0;
}

.form-section:last-of-type {
    border-bottom: none;
    margin-bottom: 0;
    padding-bottom: 0;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.section-icon {
    width: 50px;
    height: 50px;
    background: var(--tsa-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.section-title {
    font-weight: 700;
    margin-bottom: 0.25rem;
    color: #333;
    font-size: 1.1rem;
}

.section-subtitle {
    color: #888;
    font-size: 0.85rem;
    margin: 0;
}

/* Form Inputs */
.form-group-custom {
    margin-bottom: 0;
}

.form-label {
    font-weight: 600;
    color: #333;
    margin-bottom: 0.5rem;
    font-size: 0.95rem;
}

.input-wrapper {
    position: relative;
}

.input-wrapper i {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #adb5bd;
    font-size: 1rem;
    z-index: 1;
    transition: color 0.3s ease;
}

.input-wrapper.textarea i {
    top: 1.25rem;
    transform: none;
}

.input-wrapper .form-control {
    padding-left: 3rem;
    border: 2px solid #e9ecef;
    border-radius: 12px;
    height: auto;
    padding-top: 0.875rem;
    padding-bottom: 0.875rem;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.input-wrapper .form-control:focus {
    border-color: var(--tsa-primary);
    box-shadow: 0 0 0 4px rgba(242, 97, 36, 0.1);
}

.input-wrapper:focus-within i {
    color: var(--tsa-primary);
}

.input-wrapper textarea.form-control {
    min-height: 120px;
}

.input-wrapper select.form-control {
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='%23adb5bd' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 1rem center;
    padding-right: 2.5rem;
}

.form-hint {
    display: block;
    margin-top: 0.5rem;
    color: #888;
    font-size: 0.85rem;
}

/* Consultation Types */
.consultation-types {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 1rem;
}

.type-option {
    cursor: pointer;
}

.type-option input {
    display: none;
}

.type-card {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 1.25rem 0.75rem;
    background: #f8f9fa;
    border: 2px solid #e9ecef;
    border-radius: 15px;
    text-align: center;
    transition: all 0.3s ease;
}

.type-option input:checked + .type-card {
    background: var(--tsa-light);
    border-color: var(--tsa-primary);
    box-shadow: 0 5px 20px rgba(242, 97, 36, 0.15);
}

.type-icon {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, rgba(242, 97, 36, 0.1), rgba(129, 5, 191, 0.1));
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 0.75rem;
    font-size: 1.3rem;
    color: var(--tsa-primary);
    transition: all 0.3s ease;
}

.type-option input:checked + .type-card .type-icon {
    background: var(--tsa-gradient);
    color: white;
}

.type-name {
    font-weight: 700;
    color: #333;
    font-size: 0.9rem;
    margin-bottom: 0.25rem;
}

.type-desc {
    font-size: 0.75rem;
    color: #888;
}

/* Time Slots */
.time-slots {
    background: #f8f9fa;
    padding: 1.5rem;
    border-radius: 15px;
}

.slots-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
}

.slot-option {
    cursor: pointer;
}

.slot-option input {
    display: none;
}

.slot-card {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
    padding: 1.25rem;
    background: white;
    border: 2px solid #e9ecef;
    border-radius: 12px;
    text-align: center;
    transition: all 0.3s ease;
}

.slot-option input:checked + .slot-card {
    background: var(--tsa-primary);
    border-color: var(--tsa-primary);
    color: white;
}

.slot-card i {
    font-size: 1.5rem;
    color: var(--tsa-primary);
    transition: color 0.3s ease;
}

.slot-option input:checked + .slot-card i {
    color: white;
}

.slot-card span {
    font-weight: 600;
    font-size: 0.95rem;
}

.slot-card small {
    font-size: 0.75rem;
    color: #888;
}

.slot-option input:checked + .slot-card small {
    color: rgba(255,255,255,0.8);
}

/* Submit Section */
.submit-section {
    text-align: center;
    border-bottom: none !important;
}

.btn-submit {
    background: var(--tsa-gradient);
    border: none;
    color: white;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 1rem 3rem;
    border-radius: 50px;
    transition: all 0.3s ease;
    box-shadow: 0 10px 30px rgba(242, 97, 36, 0.3);
    display: inline-flex;
    align-items: center;
}

.btn-submit:hover {
    background: var(--tsa-gradient-reverse);
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(242, 97, 36, 0.4);
    color: white;
}

.submit-note {
    margin-top: 1rem;
    color: #888;
    font-size: 0.85rem;
}

/* =========================================
   SIDEBAR
   ========================================= */
.sidebar {
    position: sticky;
    top: 100px;
}

.sidebar-widget {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.widget-title {
    font-weight: 700;
    color: #333;
    margin-bottom: 1.25rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #f0f0f0;
}

/* Why Widget */
.benefit-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.benefit-item {
    display: flex;
    gap: 1rem;
    align-items: flex-start;
}

.benefit-icon {
    width: 35px;
    height: 35px;
    min-width: 35px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.85rem;
}

.benefit-content h6 {
    font-weight: 600;
    margin-bottom: 0.25rem;
    color: #333;
    font-size: 0.95rem;
}

.benefit-content p {
    color: #888;
    font-size: 0.85rem;
    margin: 0;
    line-height: 1.4;
}

/* Expect Widget - Timeline */
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: 12px;
    top: 20px;
    bottom: 20px;
    width: 2px;
    background: linear-gradient(to bottom, var(--tsa-primary), var(--tsa-secondary));
}

.timeline-item {
    position: relative;
    padding-bottom: 1.25rem;
}

.timeline-item:last-child {
    padding-bottom: 0;
}

.timeline-marker {
    position: absolute;
    left: -30px;
    width: 26px;
    height: 26px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.75rem;
    font-weight: 700;
    border: 3px solid white;
    box-shadow: 0 3px 10px rgba(242, 97, 36, 0.3);
}

.timeline-content h6 {
    font-weight: 600;
    margin-bottom: 0.25rem;
    color: #333;
    font-size: 0.95rem;
}

.timeline-content p {
    color: #888;
    font-size: 0.85rem;
    margin: 0;
}

/* Quick Contact Widget */
.quick-widget {
    background: linear-gradient(135deg, var(--whatsapp-green), #128C7E);
    text-align: center;
    padding: 2rem;
}

.quick-content {
    position: relative;
    z-index: 2;
}

.quick-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.75rem;
    color: white;
}

.quick-widget h5 {
    color: white;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.quick-widget p {
    color: rgba(255,255,255,0.85);
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

.btn-whatsapp {
    background: white;
    color: var(--whatsapp-green);
    font-weight: 600;
    padding: 0.875rem 2rem;
    border-radius: 50px;
    border: none;
    transition: all 0.3s ease;
    display: inline-block;
}

.btn-whatsapp:hover {
    background: rgba(255,255,255,0.9);
    color: #128C7E;
    transform: translateY(-2px);
}

/* Testimonial Widget */
.testimonial-widget {
    background: linear-gradient(135deg, var(--tsa-light), #fff);
    border: 2px solid var(--tsa-primary);
    position: relative;
    padding-top: 2.5rem;
}

.testimonial-quote {
    position: absolute;
    top: -15px;
    left: 1.5rem;
    width: 40px;
    height: 40px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1rem;
}

.testimonial-text {
    color: #555;
    font-style: italic;
    line-height: 1.7;
    margin-bottom: 1.25rem;
}

.testimonial-author {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.author-avatar {
    width: 45px;
    height: 45px;
    background: var(--tsa-gradient);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 700;
    font-size: 0.9rem;
}

.author-info h6 {
    font-weight: 600;
    margin: 0;
    color: #333;
}

.author-info span {
    font-size: 0.8rem;
    color: #888;
}

/* =========================================
   RESPONSIVE STYLES
   ========================================= */
@media (max-width: 991px) {
    .consultation-hero {
        padding: 80px 0 60px;
    }
    
    .consultation-hero h1 {
        font-size: 2rem;
    }
    
    .sidebar {
        position: relative;
        top: 0;
        margin-top: 2rem;
    }
    
    .consultation-types {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .slots-grid {
        grid-template-columns: repeat(3, 1fr);
    }
}

@media (max-width: 768px) {
    .consultation-hero {
        padding: 70px 0 50px;
    }
    
    .consultation-hero h1 {
        font-size: 1.75rem;
    }
    
    .hero-icon {
        width: 80px;
        height: 80px;
        font-size: 2rem;
    }
    
    .form-progress {
        display: none;
    }
    
    .form-header,
    .form-body {
        padding: 1.5rem;
    }
    
    .section-header {
        flex-direction: column;
        text-align: center;
    }
    
    .consultation-types {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .slots-grid {
        grid-template-columns: 1fr;
    }
    
    .btn-submit {
        width: 100%;
        justify-content: center;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Form submit loading state
    var form = document.getElementById('consultationForm');
    if (form) {
        form.addEventListener('submit', function() {
            var submitBtn = form.querySelector('.btn-submit');
            var btnContent = submitBtn.querySelector('.btn-content');
            var btnLoading = submitBtn.querySelector('.btn-loading');
            
            btnContent.style.display = 'none';
            btnLoading.style.display = 'inline-flex';
            submitBtn.disabled = true;
        });
    }
    
    // Time slot sync with dropdown
    var slotOptions = document.querySelectorAll('input[name="time_slot_visual"]');
    var timeSelect = document.getElementById('preferred_time');
    
    slotOptions.forEach(function(option) {
        option.addEventListener('change', function() {
            timeSelect.value = this.value;
        });
    });
    
    // Update visual selector when dropdown changes
    if (timeSelect) {
        timeSelect.addEventListener('change', function() {
            var value = this.value;
            slotOptions.forEach(function(option) {
                option.checked = (option.value === value);
            });
        });
    }
    
    // Update progress steps on scroll
    var sections = document.querySelectorAll('.form-section');
    var steps = document.querySelectorAll('.progress-step');
    
    function updateProgress() {
        var currentSection = 0;
        sections.forEach(function(section, index) {
            var rect = section.getBoundingClientRect();
            if (rect.top < window.innerHeight / 2) {
                currentSection = index;
            }
        });
        
        steps.forEach(function(step, index) {
            if (index <= currentSection) {
                step.classList.add('active');
            } else {
                step.classList.remove('active');
            }
        });
    }
    
    window.addEventListener('scroll', updateProgress);
    updateProgress();
});
</script>