<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Spacing Utilities */
    .mb-0 {
        margin-bottom: 0 !important;
    }

    .mb-2 {
        margin-bottom: 0.5rem !important;
    }

    .mb-3 {
        margin-bottom: 1rem !important;
    }

    .mb-4 {
        margin-bottom: 1.5rem !important;
    }

    .mt-3 {
        margin-top: 1rem !important;
    }

    .py-5 {
        padding-top: 3rem !important;
        padding-bottom: 3rem !important;
    }

    .g-3 {
        gap: 1rem;
    }

    /* Grid */
    .row {
        display: flex;
        flex-wrap: wrap;
        gap: 24px;
    }

    .col-md-2 {
        flex: 0 0 calc(16.666% - 18px);
    }

    .col-md-3 {
        flex: 0 0 calc(25% - 18px);
    }

    .col-md-10 {
        flex: 0 0 calc(83.333% - 18px);
    }

    /* Text Utilities */
    .d-flex {
        display: flex;
    }

    .justify-content-between {
        justify-content: space-between;
    }

    .justify-content-center {
        justify-content: center;
    }

    .align-items-center {
        align-items: center;
    }

    .d-inline-flex {
        display: inline-flex;
    }

    .text-muted {
        color: #6c757d !important;
    }

    .text-center {
        text-align: center;
    }

    .text-danger {
        color: var(--danger-red) !important;
    }

    h2 {
        font-size: 28px;
        font-weight: 700;
        color: #231f20;
        margin: 0;
    }

    h3 {
        font-size: 32px;
        font-weight: 700;
        color: #231f20;
        margin: 0;
    }

    h4 {
        font-size: 20px;
        font-weight: 700;
        color: #231f20;
        margin-bottom: 8px;
    }

    p {
        font-size: 14px;
        color: #6c757d;
        margin: 4px 0 0 0;
    }

    strong {
        font-weight: 700;
    }

    small {
        font-size: 12px;
    }

    i {
        margin-right: 4px;
    }

    /* Card Styling */
    .table-card {
        background: #fff;
        border-radius: 12px;
        padding: 28px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        transition: all 0.3s ease;
    }

    .table-card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }

    /* Stats Card */
    .stats-card {
        background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%);
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        border-left: 4px solid #ffc107;
        transition: all 0.3s ease;
        height: 100%;
    }

    .stats-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }

    .stats-card h3 {
        margin-bottom: 8px;
    }

    .stats-card p {
        font-size: 13px;
        font-weight: 600;
        color: #6c757d;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    /* Tabs */
    .nav-tabs {
        border-bottom: 2px solid #e9ecef;
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }

    .nav-item {
        margin: 0;
    }

    .nav-link {
        color: #6c757d;
        border: none;
        padding: 12px 16px;
        font-size: 14px;
        font-weight: 600;
        border-bottom: 3px solid transparent;
        transition: all 0.3s ease;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }

    .nav-link:hover {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
    }

    .nav-link.active {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
        background: transparent;
    }

    /* Badges */
    .badge {
        font-size: 11px;
        font-weight: 700;
        padding: 6px 10px;
        border-radius: 12px;
        display: inline-block;
        white-space: nowrap;
        margin-left: 4px;
    }

    .bg-secondary {
        background-color: #6c757d !important;
        color: #fff;
    }

    .bg-warning {
        background-color: var(--warning-yellow) !important;
        color: #231f20;
    }

    .bg-info {
        background-color: var(--info-blue) !important;
        color: #fff;
    }

    .bg-success {
        background-color: var(--success-green) !important;
        color: #fff;
    }

    .bg-danger {
        background-color: var(--danger-red) !important;
        color: #fff;
    }

    /* Table */
    .table-responsive {
        overflow-x: auto;
    }

    .table {
        width: 100%;
        margin-bottom: 0;
        border-collapse: collapse;
    }

    .table thead th {
        font-size: 13px;
        font-weight: 700;
        color: #231f20;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border: none;
        border-bottom: 2px solid #e9ecef;
        padding: 14px 12px;
        background: transparent;
        text-align: left;
    }

    .table tbody td {
        font-size: 14px;
        color: #495057;
        padding: 12px;
        border: none;
        border-bottom: 1px solid #f0f0f0;
        vertical-align: middle;
    }

    .table tbody tr:hover {
        background: #f8f9fa;
    }

    .table tbody tr:last-child td {
        border-bottom: 1px solid #e9ecef;
    }

    .table-hover tbody tr:hover {
        background-color: #f8f9fa;
    }

    /* Images */
    .rounded-circle {
        border-radius: 50%;
    }

    /* Form Controls */
    .form-control {
        display: block;
        width: 100%;
        padding: 10px 12px;
        font-size: 14px;
        color: #495057;
        background-color: #fff;
        border: 1px solid #dee2e6;
        border-radius: 6px;
        transition: all 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .form-control:focus {
        color: #495057;
        background-color: #fff;
        border-color: var(--primary-color);
        outline: 0;
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    /* Buttons */
    .btn {
        font-size: 14px;
        font-weight: 600;
        padding: 10px 16px;
        border-radius: 6px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
    }

    .btn-outline-success {
        background: transparent;
        color: var(--success-green);
        border: 1px solid var(--success-green);
    }

    .btn-outline-success:hover {
        background: var(--success-green);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-success {
        background: var(--success-green);
        color: #fff;
    }

    .btn-success:hover {
        background: #218838;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(40, 167, 69, 0.3);
    }

    .btn-outline-primary {
        background: transparent;
        color: var(--primary-color);
        border: 1px solid var(--primary-color);
    }

    .btn-outline-primary:hover {
        background: var(--primary-color);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-outline-danger {
        background: transparent;
        color: var(--danger-red);
        border: 1px solid var(--danger-red);
    }

    .btn-outline-danger:hover {
        background: var(--danger-red);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-outline-secondary {
        background: transparent;
        color: #231f20;
        border: 1px solid #dee2e6;
    }

    .btn-outline-secondary:hover {
        background: #f8f9fa;
        border-color: #231f20;
        transform: translateY(-2px);
    }

    .btn-link {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
        font-size: 12px;
        background: none;
        border: none;
        padding: 0;
    }

    .btn-link:hover {
        color: #d95520;
        text-decoration: underline;
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 12px;
    }

    .w-100 {
        width: 100%;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 60px 40px;
    }

    .empty-state i {
        font-size: 64px;
        color: #dee2e6;
        margin-bottom: 20px;
        display: block;
    }

    /* Pagination */
    .pagination {
        display: flex;
        gap: 4px;
        justify-content: center;
        margin-top: 20px;
        flex-wrap: wrap;
    }

    .pagination a,
    .pagination span {
        padding: 8px 12px;
        border-radius: 6px;
        font-size: 13px;
        font-weight: 600;
        border: 1px solid #dee2e6;
        color: #495057;
        text-decoration: none;
        transition: all 0.2s ease;
    }

    .pagination a:hover {
        background: #f8f9fa;
        border-color: var(--primary-color);
        color: var(--primary-color);
    }

    .pagination .active {
        background: var(--primary-color);
        border-color: var(--primary-color);
        color: #fff;
    }

    /* Responsive */
    @media (max-width: 992px) {
        .row {
            gap: 16px;
        }

        .col-md-3 {
            flex: 0 0 calc(50% - 8px);
        }

        .col-md-2 {
            flex: 0 0 100%;
        }

        .col-md-10 {
            flex: 0 0 100%;
        }
    }

    @media (max-width: 768px) {
        .d-flex {
            flex-direction: column;
            align-items: flex-start;
            gap: 16px;
        }

        .d-flex > div:last-child {
            width: 100%;
            display: flex;
            gap: 12px;
            flex-wrap: wrap;
        }

        .justify-content-between {
            justify-content: flex-start;
        }

        .table-card {
            padding: 18px;
        }

        .table thead th,
        .table tbody td {
            padding: 10px 8px;
            font-size: 12px;
        }

        .nav-link {
            padding: 10px 12px;
            font-size: 12px;
        }

        h2 {
            font-size: 24px;
        }

        .row {
            gap: 12px;
        }

        .col-md-3 {
            flex: 0 0 100%;
        }

        .btn {
            width: 100%;
            justify-content: center;
        }

        .btn-sm {
            width: auto;
        }

        .form-control {
            font-size: 14px;
            padding: 10px;
        }
    }

    @media (max-width: 576px) {
        .table-card {
            padding: 16px;
        }

        .table thead th {
            font-size: 11px;
        }

        .table tbody td {
            font-size: 12px;
            padding: 8px;
        }

        h2 {
            font-size: 20px;
        }

        h3 {
            font-size: 28px;
        }

        .stats-card {
            padding: 16px;
        }

        .empty-state {
            padding: 40px 20px;
        }

        .empty-state i {
            font-size: 48px;
        }

        .form-control {
            padding: 8px 10px;
            font-size: 13px;
        }
    }
</style>

<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-0">Volunteer Applications</h2>
        <p class="text-muted mb-0">Manage volunteer applications and profiles</p>
    </div>
    <div>
        <a href="<?php echo base_url('/admin/export/volunteers?status=' . ($current_status ?? '')); ?>" 
           class="btn btn-outline-success">
            <i class="fas fa-file-excel"></i> Export CSV
        </a>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="stats-card" style="border-left-color: #ffc107;">
            <h3><?php echo $statistics['pending'] ?? 0; ?></h3>
            <p>Pending Review</p>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card" style="border-left-color: #28a745;">
            <h3><?php echo $statistics['approved'] ?? 0; ?></h3>
            <p>Approved</p>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card" style="border-left-color: #007bff;">
            <h3><?php echo $statistics['active'] ?? 0; ?></h3>
            <p>Active</p>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card" style="border-left-color: #dc3545;">
            <h3><?php echo $statistics['rejected'] ?? 0; ?></h3>
            <p>Rejected</p>
        </div>
    </div>
</div>

<!-- Search Bar -->
<div class="table-card mb-3">
    <form method="get" action="<?php echo base_url('/admin/volunteers/search'); ?>" class="row g-3">
        <div class="col-md-10">
            <input type="text" 
                   class="form-control" 
                   name="keyword" 
                   placeholder="Search by name, email, phone, skills, or occupation..."
                   value="<?php echo isset($search_keyword) ? $search_keyword : ''; ?>">
        </div>
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary w-100">
                <i class="fas fa-search"></i> Search
            </button>
        </div>
    </form>
</div>

<!-- Filter Tabs -->
<div class="table-card mb-4">
    <ul class="nav nav-tabs" role="tablist">
        <li class="nav-item">
            <a class="nav-link <?php echo empty($current_status) ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/volunteers'); ?>">
                All Applications <span class="badge bg-secondary"><?php echo $statistics['total'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'pending') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/volunteers?status=pending'); ?>">
                Pending <span class="badge bg-warning"><?php echo $statistics['pending'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'approved') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/volunteers?status=approved'); ?>">
                Approved <span class="badge bg-info"><?php echo $statistics['approved'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'active') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/volunteers?status=active'); ?>">
                Active <span class="badge bg-success"><?php echo $statistics['active'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'rejected') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/volunteers?status=rejected'); ?>">
                Rejected <span class="badge bg-danger"><?php echo $statistics['rejected'] ?? 0; ?></span>
            </a>
        </li>
    </ul>
</div>

<!-- Volunteers Table -->
<div class="table-card">
    <?php if(!empty($volunteers)): ?>
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th style="width: 50px;">ID</th>
                    <th>Photo</th>
                    <th>Name</th>
                    <th>Contact</th>
                    <th>Location</th>
                    <th>Occupation</th>
                    <th>Skills</th>
                    <th>Status</th>
                    <th>Applied</th>
                    <th style="width: 150px;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($volunteers as $volunteer): ?>
                <tr>
                    <td><?php echo $volunteer->id; ?></td>
                    <td>
                        <?php if($volunteer->profile_photo): ?>
                            <img src="<?php echo base_url('uploads/volunteers/' . $volunteer->profile_photo); ?>" 
                                 class="rounded-circle" 
                                 width="40" 
                                 height="40"
                                 style="object-fit: cover;"
                                 alt="<?php echo $volunteer->full_name; ?>">
                        <?php else: ?>
                            <div class="rounded-circle bg-secondary d-inline-flex align-items-center justify-content-center" 
                                 style="width: 40px; height: 40px; color: white;">
                                <?php echo strtoupper(substr($volunteer->full_name, 0, 1)); ?>
                            </div>
                        <?php endif; ?>
                    </td>
                    <td>
                        <strong><?php echo $volunteer->full_name; ?></strong>
                    </td>
                    <td>
                        <small>
                            <i class="fas fa-envelope"></i> <?php echo $volunteer->email; ?><br>
                            <i class="fas fa-phone"></i> <?php echo $volunteer->phone; ?>
                        </small>
                    </td>
                    <td><?php echo $volunteer->city; ?></td>
                    <td><?php echo character_limiter($volunteer->occupation, 20); ?></td>
                    <td>
                        <small><?php echo character_limiter($volunteer->skills, 30); ?></small>
                    </td>
                    <td><?php echo get_status_badge($volunteer->status); ?></td>
                    <td>
                        <small><?php echo time_ago($volunteer->application_date); ?></small>
                    </td>
                    <td>
                        <a href="<?php echo base_url('/admin/volunteers/view/' . $volunteer->id); ?>" 
                           class="btn btn-sm btn-outline-primary"
                           title="View Details">
                            <i class="fas fa-eye"></i>
                        </a>
                        
                        <?php if($volunteer->status == 'pending'): ?>
                        <a href="<?php echo base_url('/admin/volunteers/approve/' . $volunteer->id); ?>" 
                           class="btn btn-sm btn-success"
                           onclick="return confirm('Approve this volunteer application?');"
                           title="Approve">
                            <i class="fas fa-check"></i>
                        </a>
                        <?php endif; ?>
                        
                        <a href="<?php echo base_url('/admin/volunteers/delete/' . $volunteer->id); ?>" 
                           class="btn btn-sm btn-outline-danger"
                           onclick="return confirm('Delete this volunteer? This action cannot be undone.');"
                           title="Delete">
                            <i class="fas fa-trash"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Pagination -->
    <?php if(!empty($pagination)): ?>
    <div class="mt-3">
        <?php echo $pagination; ?>
    </div>
    <?php endif; ?>
    
    <?php else: ?>
    <!-- Empty State -->
    <div class="text-center py-5">
        <i class="fas fa-users fa-4x text-muted mb-3"></i>
        <h4>No volunteer applications found</h4>
        <?php if(!empty($current_status)): ?>
            <p class="text-muted">No volunteers with status: <strong><?php echo ucfirst($current_status); ?></strong></p>
            <a href="<?php echo base_url('/admin/volunteers'); ?>" class="btn btn-outline-secondary">
                View All Applications
            </a>
        <?php else: ?>
            <p class="text-muted">Volunteer applications will appear here when people apply on your website</p>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</div>

<?php if(isset($search_keyword)): ?>
<div class="mt-3">
    <a href="<?php echo base_url('/admin/volunteers'); ?>" class="btn btn-link">
        <i class="fas fa-times"></i> Clear Search
    </a>
</div>
<?php endif; ?>