<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Spacing */
    .mb-2 {
        margin-bottom: 0.5rem !important;
    }

    .mb-3 {
        margin-bottom: 1rem !important;
    }

    .mb-4 {
        margin-bottom: 1.5rem !important;
    }

    .ml-2 {
        margin-left: 0.5rem !important;
    }

    .mt-3 {
        margin-top: 1rem !important;
    }

    .m-0 {
        margin: 0 !important;
    }

    .py-3 {
        padding-top: 1rem !important;
        padding-bottom: 1rem !important;
    }

    /* Grid */
    .row {
        display: flex;
        flex-wrap: wrap;
        gap: 24px;
    }

    .col-12 {
        flex: 0 0 100%;
    }

    .col-lg-6 {
        flex: 0 0 calc(50% - 12px);
    }

    /* Text Utilities */
    .text-right {
        text-align: right;
    }

    .d-flex {
        display: flex;
    }

    .justify-content-between {
        justify-content: space-between;
    }

    .align-items-center {
        align-items: center;
    }

    h6 {
        font-size: 16px;
        font-weight: 700;
        color: var(--primary-color);
        margin: 0;
    }

    /* Cards */
    .card {
        background: #fff;
        border-radius: 12px;
        border: 1px solid #e9ecef;
        overflow: hidden;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        height: 100%;
    }

    .card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }

    .card-header {
        background: #fff;
        border-bottom: 2px solid #e9ecef;
        padding: 1rem;
    }

    .card-body {
        padding: 1.5rem;
    }

    /* Tables */
    .table {
        width: 100%;
        margin-bottom: 0;
        border-collapse: collapse;
    }

    .table-bordered {
        border: 1px solid #e9ecef;
    }

    .table-bordered th,
    .table-bordered td {
        border: 1px solid #e9ecef;
        padding: 0.75rem;
    }

    .table-sm th,
    .table-sm td {
        padding: 0.5rem;
        font-size: 13px;
    }

    .table th {
        background: #f8f9fa;
        font-weight: 700;
        color: #231f20;
        text-align: left;
    }

    .table td {
        color: #495057;
    }

    .table tr:hover {
        background: #f8f9fa;
    }

    code {
        background: #f8f9fa;
        padding: 2px 6px;
        border-radius: 4px;
        color: #495057;
        font-family: 'Courier New', monospace;
        font-size: 12px;
    }

    /* Badges */
    .badge {
        font-size: 11px;
        font-weight: 700;
        padding: 6px 10px;
        border-radius: 12px;
        display: inline-block;
        white-space: nowrap;
    }

    .badge-pill {
        border-radius: 10px;
        padding: 8px 12px;
    }

    .badge-success {
        background-color: var(--success-green) !important;
        color: #fff;
    }

    .badge-warning {
        background-color: var(--warning-yellow) !important;
        color: #231f20;
    }

    .badge-danger {
        background-color: var(--danger-red) !important;
        color: #fff;
    }

    .badge-primary {
        background-color: var(--primary-color) !important;
        color: #fff;
    }

    .badge-info {
        background-color: var(--info-blue) !important;
        color: #fff;
    }

    .badge-secondary {
        background-color: #6c757d !important;
        color: #fff;
    }

    /* Buttons */
    .btn {
        font-size: 14px;
        font-weight: 600;
        padding: 10px 16px;
        border-radius: 6px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-success {
        background: var(--success-green);
        color: #fff;
    }

    .btn-success:hover {
        background: #218838;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(40, 167, 69, 0.3);
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 12px;
    }

    /* Icons */
    i {
        margin-right: 4px;
    }

    .text-center {
        text-align: center;
    }

    span {
        color: #495057;
    }

    .shadow {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    /* Responsive */
    @media (max-width: 992px) {
        .col-lg-6 {
            flex: 0 0 100%;
        }

        .row {
            gap: 16px;
        }
    }

    @media (max-width: 768px) {
        .card-header {
            padding: 0.75rem;
        }

        .card-body {
            padding: 1rem;
        }

        .table-sm th,
        .table-sm td {
            padding: 0.4rem;
            font-size: 12px;
        }

        .d-flex {
            flex-direction: column;
            gap: 8px;
        }

        .justify-content-between {
            justify-content: flex-start;
        }

        .text-right {
            text-align: left;
        }

        .btn {
            width: 100%;
            justify-content: center;
        }

        h6 {
            font-size: 14px;
        }
    }

    @media (max-width: 576px) {
        .card {
            margin-bottom: 1rem;
        }

        .card-header {
            padding: 0.6rem;
        }

        .card-body {
            padding: 0.8rem;
        }

        .table-sm th,
        .table-sm td {
            padding: 0.3rem;
            font-size: 11px;
        }

        .badge {
            font-size: 10px;
            padding: 4px 8px;
        }

        .badge-pill {
            padding: 6px 10px;
        }

        h6 {
            font-size: 13px;
        }

        code {
            font-size: 11px;
        }
    }
</style>

<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="row">
    <!-- System Information -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3">
                <h6 class="m-0">
                    <i class="fas fa-server"></i> System Information
                </h6>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-sm">
                    <tr>
                        <th width="200">PHP Version</th>
                        <td>
                            <code><?php echo $system_info['php_version']; ?></code>
                            <?php if (version_compare($system_info['php_version'], '7.2.0') >= 0): ?>
                                <span class="badge badge-success ml-2">OK</span>
                            <?php else: ?>
                                <span class="badge badge-warning ml-2">Upgrade Recommended</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th>CodeIgniter Version</th>
                        <td><code><?php echo $system_info['ci_version']; ?></code></td>
                    </tr>
                    <tr>
                        <th>Server Software</th>
                        <td><code><?php echo $system_info['server_software']; ?></code></td>
                    </tr>
                    <tr>
                        <th>Database Version</th>
                        <td><code><?php echo $system_info['database_version']; ?></code></td>
                    </tr>
                    <tr>
                        <th>Max Upload Size</th>
                        <td><code><?php echo $system_info['max_upload_size']; ?></code></td>
                    </tr>
                    <tr>
                        <th>Max POST Size</th>
                        <td><code><?php echo $system_info['max_post_size']; ?></code></td>
                    </tr>
                    <tr>
                        <th>Memory Limit</th>
                        <td><code><?php echo $system_info['memory_limit']; ?></code></td>
                    </tr>
                    <tr>
                        <th>Max Execution Time</th>
                        <td><code><?php echo $system_info['max_execution_time']; ?> seconds</code></td>
                    </tr>
                    <tr>
                        <th>Timezone</th>
                        <td><code><?php echo $system_info['timezone']; ?></code></td>
                    </tr>
                    <tr>
                        <th>Current Server Time</th>
                        <td><code><?php echo $system_info['current_time']; ?></code></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <!-- Database Statistics -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3">
                <h6 class="m-0">
                    <i class="fas fa-database"></i> Database Statistics
                </h6>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-sm">
                    <tr>
                        <th width="200">Blog Posts</th>
                        <td class="text-right">
                            <span class="badge badge-primary badge-pill">
                                <?php echo number_format($db_stats['blog_posts']); ?>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Volunteers</th>
                        <td class="text-right">
                            <span class="badge badge-success badge-pill">
                                <?php echo number_format($db_stats['volunteers']); ?>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Consultation Requests</th>
                        <td class="text-right">
                            <span class="badge badge-info badge-pill">
                                <?php echo number_format($db_stats['consultations']); ?>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Contact Messages</th>
                        <td class="text-right">
                            <span class="badge badge-warning badge-pill">
                                <?php echo number_format($db_stats['messages']); ?>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Workshops</th>
                        <td class="text-right">
                            <span class="badge badge-secondary badge-pill">
                                <?php echo number_format($db_stats['workshops']); ?>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Partners</th>
                        <td class="text-right">
                            <span class="badge badge-primary badge-pill">
                                <?php echo number_format($db_stats['partners']); ?>
                            </span>
                        </td>
                    </tr>
                </table>

                <div class="text-center mt-3">
                    <a href="<?php echo base_url('admin/settings/backup'); ?>" class="btn btn-success btn-sm">
                        <i class="fas fa-download"></i> Backup Database
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Application Paths -->
<div class="row">
    <div class="col-12 mb-4">
        <div class="card shadow">
            <div class="card-header py-3">
                <h6 class="m-0">
                    <i class="fas fa-folder"></i> Application Paths
                </h6>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-sm">
                    <tr>
                        <th width="200">Base URL</th>
                        <td><code><?php echo base_url(); ?></code></td>
                    </tr>
                    <tr>
                        <th>Application Path</th>
                        <td><code><?php echo APPPATH; ?></code></td>
                    </tr>
                    <tr>
                        <th>System Path</th>
                        <td><code><?php echo BASEPATH; ?></code></td>
                    </tr>
                    <tr>
                        <th>FCPATH (Front Controller)</th>
                        <td><code><?php echo FCPATH; ?></code></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- PHP Extensions -->
<div class="row">
    <div class="col-lg-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3">
                <h6 class="m-0">
                    <i class="fas fa-puzzle-piece"></i> Required PHP Extensions
                </h6>
            </div>
            <div class="card-body">
                <?php
                $required_extensions = array(
                    'mysqli' => 'MySQL Database',
                    'gd' => 'Image Processing (GD)',
                    'mbstring' => 'Multibyte String',
                    'curl' => 'cURL',
                    'zip' => 'ZIP Archive',
                    'json' => 'JSON'
                );

                foreach ($required_extensions as $ext => $name):
                    $loaded = extension_loaded($ext);
                ?>
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <span><?php echo $name; ?></span>
                        <?php if ($loaded): ?>
                            <span class="badge badge-success">
                                <i class="fas fa-check"></i> Loaded
                            </span>
                        <?php else: ?>
                            <span class="badge badge-danger">
                                <i class="fas fa-times"></i> Not Loaded
                            </span>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <div class="col-lg-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3">
                <h6 class="m-0">
                    <i class="fas fa-shield-alt"></i> Security Information
                </h6>
            </div>
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <span>HTTPS Enabled</span>
                    <?php if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on'): ?>
                        <span class="badge badge-success">
                            <i class="fas fa-check"></i> Yes
                        </span>
                    <?php else: ?>
                        <span class="badge badge-warning">
                            <i class="fas fa-exclamation-triangle"></i> No
                        </span>
                    <?php endif; ?>
                </div>

                <div class="d-flex justify-content-between align-items-center mb-2">
                    <span>CSRF Protection</span>
                    <?php if ($this->config->item('csrf_protection')): ?>
                        <span class="badge badge-success">
                            <i class="fas fa-check"></i> Enabled
                        </span>
                    <?php else: ?>
                        <span class="badge badge-warning">
                            <i class="fas fa-times"></i> Disabled
                        </span>
                    <?php endif; ?>
                </div>

                <div class="d-flex justify-content-between align-items-center mb-2">
                    <span>Environment</span>
                    <?php
                    $env = ENVIRONMENT;
                    $badge_class = $env === 'production' ? 'success' : 'warning';
                    ?>
                    <span class="badge badge-<?php echo $badge_class; ?>">
                        <?php echo ucfirst($env); ?>
                    </span>
                </div>

                <div class="d-flex justify-content-between align-items-center">
                    <span>Error Reporting</span>
                    <span class="badge badge-secondary">
                        <?php echo error_reporting(); ?>
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>