<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Custom Settings Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .settings-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Card Styles */
    .settings-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .settings-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
    }

    .settings-card .card-header h6 {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .settings-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 20px;
    }

    .settings-card .card-body {
        padding: 32px;
    }

    /* Section Headers */
    .section-header {
        font-size: 17px;
        font-weight: 700;
        color: var(--primary-color);
        margin-bottom: 24px;
        padding-bottom: 12px;
        border-bottom: 2px solid var(--border-color);
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .section-header i {
        font-size: 20px;
    }

    /* Form Groups */
    .form-group {
        margin-bottom: 28px;
    }

    .form-group label {
        font-size: 14px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 10px;
        display: block;
    }

    .form-group label i {
        margin-right: 6px;
    }

    /* Form Controls */
    .form-control {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 12px 16px;
        font-size: 14px;
        color: #495057;
        background: #fff;
        transition: all 0.3s ease;
    }

    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    /* Textarea */
    textarea.form-control {
        resize: vertical;
        min-height: 80px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Form Text */
    .form-text {
        display: block;
        margin-top: 8px;
        font-size: 13px;
        color: var(--muted-text);
        line-height: 1.5;
    }

    /* Divider */
    .form-divider {
        border: 0;
        border-top: 2px solid var(--border-color);
        margin: 32px 0;
    }

    /* Form Footer */
    .form-footer {
        border-top: 2px solid var(--border-color);
        padding-top: 24px;
        margin-top: 32px;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 11px 24px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        text-decoration: none;
    }

    .btn-lg {
        padding: 13px 28px;
        font-size: 15px;
    }

    .btn-success {
        background: var(--success-color);
        color: #fff;
    }

    .btn-success:hover {
        background: #17a673;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn-outline-primary {
        background: transparent;
        color: var(--primary-color);
        border: 2px solid var(--primary-color);
    }

    .btn-outline-primary:hover {
        background: var(--primary-color);
        color: #fff;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        text-decoration: none;
    }

    .btn-outline-info {
        background: transparent;
        color: var(--info-color);
        border: 2px solid var(--info-color);
    }

    .btn-outline-info:hover {
        background: var(--info-color);
        color: #fff;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(54, 185, 204, 0.3);
        text-decoration: none;
    }

    .btn-outline-success {
        background: transparent;
        color: var(--success-color);
        border: 2px solid var(--success-color);
    }

    .btn-outline-success:hover {
        background: var(--success-color);
        color: #fff;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        text-decoration: none;
    }

    .btn-outline-warning {
        background: transparent;
        color: var(--warning-color);
        border: 2px solid var(--warning-color);
    }

    .btn-outline-warning:hover {
        background: var(--warning-color);
        color: #fff;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(246, 194, 62, 0.3);
        text-decoration: none;
    }

    .btn-block {
        display: flex;
        width: 100%;
    }

    .btn i {
        font-size: 15px;
    }

    /* Sidebar Cards */
    .sidebar-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .sidebar-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 20px 24px;
    }

    .sidebar-card .card-header h6 {
        font-size: 15px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .sidebar-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 16px;
    }

    .sidebar-card .card-body {
        padding: 24px;
    }

    /* Quick Actions */
    .quick-actions .btn {
        margin-bottom: 12px;
    }

    .quick-actions .btn:last-child {
        margin-bottom: 0;
    }

    /* Info List */
    .info-list {
        font-size: 13px;
        line-height: 2;
        margin: 0;
    }

    .info-list i {
        width: 20px;
        font-size: 14px;
    }

    .info-list i.text-success {
        color: var(--success-color);
    }

    .info-list i.text-warning {
        color: var(--warning-color);
    }

    /* Social Media Icons */
    .fab.fa-facebook {
        color: #1877f2;
    }

    .fab.fa-twitter {
        color: #1da1f2;
    }

    .fab.fa-instagram {
        background: linear-gradient(45deg, #f09433 0%, #e6683c 25%, #dc2743 50%, #cc2366 75%, #bc1888 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }

    .fab.fa-linkedin {
        color: #0077b5;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .settings-container {
            padding: 16px 0;
        }

        .settings-card .card-header,
        .settings-card .card-body {
            padding: 20px;
        }

        .sidebar-card .card-header,
        .sidebar-card .card-body {
            padding: 16px 20px;
        }

        .section-header {
            font-size: 16px;
        }
    }

    @media (max-width: 768px) {
        .settings-card .card-header h6 {
            font-size: 16px;
        }

        .form-group {
            margin-bottom: 24px;
        }

        .btn-lg {
            padding: 12px 24px;
            font-size: 14px;
        }

        .section-header {
            font-size: 15px;
        }
    }
</style>

<div class="settings-container">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-8 mb-4">
                <div class="settings-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-cog"></i> General Settings
                        </h6>
                    </div>

                    <div class="card-body">
                        <?php echo form_open('admin/settings/update', array('id' => 'settingsForm')); ?>

                            <!-- Site Information -->
                            <h5 class="section-header">
                                <i class="fas fa-info-circle"></i> Site Information
                            </h5>

                            <div class="form-group">
                                <label for="site_name">Site Name</label>
                                <input type="text" 
                                       name="site_name" 
                                       id="site_name" 
                                       class="form-control" 
                                       value="<?php echo isset($settings['site_name']) ? htmlspecialchars($settings['site_name']) : ''; ?>"
                                       placeholder="Your NGO Name">
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="site_email">Site Email</label>
                                        <input type="email" 
                                               name="site_email" 
                                               id="site_email" 
                                               class="form-control" 
                                               value="<?php echo isset($settings['site_email']) ? htmlspecialchars($settings['site_email']) : ''; ?>"
                                               placeholder="info@example.com">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="site_phone">Site Phone</label>
                                        <input type="text" 
                                               name="site_phone" 
                                               id="site_phone" 
                                               class="form-control" 
                                               value="<?php echo isset($settings['site_phone']) ? htmlspecialchars($settings['site_phone']) : ''; ?>"
                                               placeholder="+233 XX XXX XXXX">
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="site_address">Site Address</label>
                                <textarea name="site_address" 
                                          id="site_address" 
                                          class="form-control" 
                                          rows="2"
                                          placeholder="Physical address"><?php echo isset($settings['site_address']) ? htmlspecialchars($settings['site_address']) : ''; ?></textarea>
                            </div>

                            <div class="form-group">
                                <label for="about_description">About Description</label>
                                <textarea name="about_description" 
                                          id="about_description" 
                                          class="form-control" 
                                          rows="4"
                                          placeholder="Brief description about your organization"><?php echo isset($settings['about_description']) ? htmlspecialchars($settings['about_description']) : ''; ?></textarea>
                                <small class="form-text">This will appear in the footer and about section</small>
                            </div>

                            <hr class="form-divider">

                            <!-- Social Media Links -->
                            <h5 class="section-header">
                                <i class="fas fa-share-alt"></i> Social Media Links
                            </h5>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="facebook_url">
                                            <i class="fab fa-facebook"></i> Facebook URL
                                        </label>
                                        <input type="url" 
                                               name="facebook_url" 
                                               id="facebook_url" 
                                               class="form-control" 
                                               value="<?php echo isset($settings['facebook_url']) ? htmlspecialchars($settings['facebook_url']) : ''; ?>"
                                               placeholder="https://facebook.com/yourpage">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="twitter_url">
                                            <i class="fab fa-twitter"></i> Twitter URL
                                        </label>
                                        <input type="url" 
                                               name="twitter_url" 
                                               id="twitter_url" 
                                               class="form-control" 
                                               value="<?php echo isset($settings['twitter_url']) ? htmlspecialchars($settings['twitter_url']) : ''; ?>"
                                               placeholder="https://twitter.com/yourhandle">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="instagram_url">
                                            <i class="fab fa-instagram"></i> Instagram URL
                                        </label>
                                        <input type="url" 
                                               name="instagram_url" 
                                               id="instagram_url" 
                                               class="form-control" 
                                               value="<?php echo isset($settings['instagram_url']) ? htmlspecialchars($settings['instagram_url']) : ''; ?>"
                                               placeholder="https://instagram.com/yourhandle">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="linkedin_url">
                                            <i class="fab fa-linkedin"></i> LinkedIn URL
                                        </label>
                                        <input type="url" 
                                               name="linkedin_url" 
                                               id="linkedin_url" 
                                               class="form-control" 
                                               value="<?php echo isset($settings['linkedin_url']) ? htmlspecialchars($settings['linkedin_url']) : ''; ?>"
                                               placeholder="https://linkedin.com/company/yourcompany">
                                    </div>
                                </div>
                            </div>

                            <hr class="form-divider">

                            <!-- Donation Information -->
                            <h5 class="section-header">
                                <i class="fas fa-hand-holding-usd"></i> Donation Information
                            </h5>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="donation_bank_name">Bank Name</label>
                                        <input type="text" 
                                               name="donation_bank_name" 
                                               id="donation_bank_name" 
                                               class="form-control" 
                                               value="<?php echo isset($settings['donation_bank_name']) ? htmlspecialchars($settings['donation_bank_name']) : ''; ?>"
                                               placeholder="e.g., Access Bank Ghana">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="donation_account_number">Account Number</label>
                                        <input type="text" 
                                               name="donation_account_number" 
                                               id="donation_account_number" 
                                               class="form-control" 
                                               value="<?php echo isset($settings['donation_account_number']) ? htmlspecialchars($settings['donation_account_number']) : ''; ?>"
                                               placeholder="XXXX-XXXX-XXXX">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="donation_account_name">Account Name</label>
                                        <input type="text" 
                                               name="donation_account_name" 
                                               id="donation_account_name" 
                                               class="form-control" 
                                               value="<?php echo isset($settings['donation_account_name']) ? htmlspecialchars($settings['donation_account_name']) : ''; ?>"
                                               placeholder="Organization Name">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="donation_mobile_money">Mobile Money Number</label>
                                        <input type="text" 
                                               name="donation_mobile_money" 
                                               id="donation_mobile_money" 
                                               class="form-control" 
                                               value="<?php echo isset($settings['donation_mobile_money']) ? htmlspecialchars($settings['donation_mobile_money']) : ''; ?>"
                                               placeholder="+233 XX XXX XXXX">
                                    </div>
                                </div>
                            </div>

                            <!-- Submit Button -->
                            <div class="form-footer">
                                <button type="submit" class="btn btn-success btn-lg">
                                    <i class="fas fa-save"></i> Save Settings
                                </button>
                            </div>

                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Quick Actions -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-bolt"></i> Quick Actions
                        </h6>
                    </div>
                    <div class="card-body quick-actions">
                        <a href="<?php echo base_url('admin/settings/email'); ?>" class="btn btn-outline-primary btn-block">
                            <i class="fas fa-envelope"></i> Email Settings
                        </a>
                        <a href="<?php echo base_url('admin/settings/system_info'); ?>" class="btn btn-outline-info btn-block">
                            <i class="fas fa-info-circle"></i> System Info
                        </a>
                        <a href="<?php echo base_url('admin/settings/backup'); ?>" class="btn btn-outline-success btn-block">
                            <i class="fas fa-database"></i> Backup Database
                        </a>
                        <a href="<?php echo base_url('admin/settings/clear_cache'); ?>" 
                           class="btn btn-outline-warning btn-block"
                           onclick="return confirm('Are you sure you want to clear cache and old logs?');">
                            <i class="fas fa-broom"></i> Clear Cache
                        </a>
                    </div>
                </div>

                <!-- Settings Info -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-info-circle"></i> Information
                        </h6>
                    </div>
                    <div class="card-body">
                        <p class="info-list mb-0">
                            <i class="fas fa-check text-success"></i> Changes take effect immediately<br>
                            <i class="fas fa-check text-success"></i> Social media links appear in footer<br>
                            <i class="fas fa-check text-success"></i> Donation info shown on donate page<br>
                            <i class="fas fa-exclamation-triangle text-warning"></i> Only Super Admins can access settings
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>