<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Custom Email Configuration Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .email-config-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Card Styles */
    .email-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .email-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
    }

    .email-card .card-header h6 {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .email-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 20px;
    }

    .email-card .card-body {
        padding: 32px;
    }

    /* Alert Styles */
    .alert {
        border-radius: 8px;
        border: 1px solid;
        padding: 16px 20px;
        margin-bottom: 24px;
        font-size: 14px;
        display: flex;
        align-items: flex-start;
        gap: 12px;
    }

    .alert i:first-child {
        font-size: 18px;
        margin-top: 2px;
        flex-shrink: 0;
    }

    .alert-info {
        background-color: #d1ecf1;
        border-color: #bee5eb;
        color: #0c5460;
    }

    .alert-warning {
        background-color: #fff3cd;
        border-color: #ffeeba;
        color: #856404;
    }

    .alert-success {
        background-color: #d4edda;
        border-color: #c3e6cb;
        color: #155724;
    }

    .alert-danger {
        background-color: #f8d7da;
        border-color: #f5c6cb;
        color: #721c24;
    }

    .alert strong {
        font-weight: 700;
    }

    .alert code {
        background: rgba(255, 255, 255, 0.5);
        padding: 2px 6px;
        border-radius: 4px;
        font-size: 13px;
    }

    .alert a {
        color: inherit;
        text-decoration: underline;
        font-weight: 600;
    }

    /* Section Headers */
    .section-header {
        font-size: 17px;
        font-weight: 700;
        color: var(--primary-color);
        margin-bottom: 20px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .section-header i {
        font-size: 20px;
    }

    /* Configuration Table */
    .config-table {
        width: 100%;
        margin-bottom: 24px;
        border-collapse: separate;
        border-spacing: 0;
        overflow: hidden;
        border-radius: 8px;
        border: 1px solid var(--border-color);
    }

    .config-table tr {
        border-bottom: 1px solid var(--border-color);
    }

    .config-table tr:last-child {
        border-bottom: none;
    }

    .config-table th,
    .config-table td {
        padding: 14px 16px;
        font-size: 14px;
        text-align: left;
    }

    .config-table th {
        background: var(--bg-light);
        color: var(--dark-text);
        font-weight: 700;
        width: 200px;
    }

    .config-table td {
        background: #fff;
    }

    .config-table code {
        background: var(--bg-light);
        padding: 4px 8px;
        border-radius: 4px;
        color: var(--danger-color);
        font-size: 13px;
        border: 1px solid var(--border-color);
    }

    /* Form Group */
    .form-group {
        margin-bottom: 24px;
    }

    .form-group label {
        font-size: 14px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 10px;
        display: block;
    }

    /* Input Groups */
    .input-group {
        position: relative;
        display: flex;
        flex-wrap: wrap;
        align-items: stretch;
        width: 100%;
    }

    .input-group > .form-control {
        position: relative;
        flex: 1 1 auto;
        width: 1%;
        min-width: 0;
        margin-bottom: 0;
        border-radius: 8px 0 0 8px;
    }

    .input-group-append {
        margin-left: -1px;
        display: flex;
    }

    .input-group-append .btn {
        border-radius: 0 8px 8px 0;
    }

    /* Form Control */
    .form-control {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 12px 16px;
        font-size: 14px;
        color: #495057;
        background: #fff;
        transition: all 0.3s ease;
    }

    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 11px 24px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        text-decoration: none;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: var(--primary-hover);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn i {
        font-size: 15px;
    }

    /* Divider */
    .form-divider {
        border: 0;
        border-top: 2px solid var(--border-color);
        margin: 32px 0;
    }

    /* Accordion */
    .accordion {
        margin-top: 20px;
    }

    .accordion .card {
        background: #fff;
        border: 1px solid var(--border-color);
        border-radius: 8px;
        margin-bottom: 12px;
        overflow: hidden;
        transition: all 0.3s ease;
    }

    .accordion .card:hover {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .accordion .card-header {
        background: var(--bg-light);
        border: none;
        padding: 0;
    }

    .accordion .card-header h6 {
        margin: 0;
    }

    .accordion .btn-link {
        width: 100%;
        text-align: left;
        padding: 16px 20px;
        color: var(--dark-text);
        text-decoration: none;
        font-weight: 600;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 10px;
        transition: all 0.3s ease;
    }

    .accordion .btn-link:hover {
        color: var(--primary-color);
        background: rgba(242, 97, 36, 0.05);
        text-decoration: none;
    }

    .accordion .btn-link i {
        font-size: 16px;
        color: var(--primary-color);
    }

    .accordion .card-body {
        padding: 20px;
        background: #fff;
    }

    .accordion .card-body p {
        margin-bottom: 12px;
        font-size: 14px;
        color: var(--muted-text);
    }

    .accordion .card-body code {
        background: var(--bg-light);
        padding: 2px 6px;
        border-radius: 4px;
        color: var(--danger-color);
        font-size: 13px;
        border: 1px solid var(--border-color);
    }

    .accordion pre {
        background: #2d2d2d;
        color: #f8f8f2;
        padding: 16px;
        border-radius: 8px;
        overflow-x: auto;
        margin: 12px 0;
    }

    .accordion pre code {
        background: transparent;
        color: #f8f8f2;
        padding: 0;
        border: none;
        font-size: 13px;
        line-height: 1.6;
    }

    /* Sidebar Cards */
    .sidebar-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .sidebar-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 20px 24px;
    }

    .sidebar-card .card-header h6 {
        font-size: 15px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .sidebar-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 16px;
    }

    .sidebar-card .card-body {
        padding: 24px;
    }

    /* Badges */
    .badge {
        padding: 6px 12px;
        font-size: 11px;
        font-weight: 600;
        border-radius: 6px;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        display: inline-block;
    }

    .badge-success {
        background: var(--success-color);
        color: #fff;
    }

    .badge-warning {
        background: var(--warning-color);
        color: #fff;
    }

    /* Resources List */
    .resources-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .resources-list li {
        margin-bottom: 16px;
    }

    .resources-list li:last-child {
        margin-bottom: 0;
    }

    .resources-list a {
        color: var(--primary-color);
        text-decoration: none;
        font-size: 13px;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 8px;
        transition: all 0.3s ease;
    }

    .resources-list a:hover {
        color: var(--primary-hover);
        transform: translateX(4px);
    }

    .resources-list a i {
        font-size: 12px;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .email-config-container {
            padding: 16px 0;
        }

        .email-card .card-header,
        .email-card .card-body {
            padding: 20px;
        }

        .sidebar-card .card-header,
        .sidebar-card .card-body {
            padding: 16px 20px;
        }

        .config-table th,
        .config-table td {
            padding: 12px;
            font-size: 13px;
        }
    }

    @media (max-width: 768px) {
        .email-card .card-header h6 {
            font-size: 16px;
        }

        .section-header {
            font-size: 16px;
        }

        .config-table {
            display: block;
            overflow-x: auto;
        }

        .config-table th {
            width: auto;
            min-width: 150px;
        }

        .alert {
            flex-direction: column;
            gap: 8px;
        }

        .input-group {
            flex-direction: column;
        }

        .input-group > .form-control {
            border-radius: 8px;
            margin-bottom: 8px;
        }

        .input-group-append {
            width: 100%;
            margin-left: 0;
        }

        .input-group-append .btn {
            width: 100%;
            border-radius: 8px;
        }
    }
</style>

<div class="email-config-container">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-8 mb-4">
                <div class="email-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-envelope"></i> Email Configuration
                        </h6>
                    </div>

                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            <div>
                                <strong>Note:</strong> Email settings are configured in <code>application/config/email.php</code>
                            </div>
                        </div>

                        <h5 class="section-header">Current Email Configuration</h5>

                        <table class="config-table">
                            <tr>
                                <th>Protocol</th>
                                <td><code><?php echo $this->config->item('protocol') ?: 'mail'; ?></code></td>
                            </tr>
                            <tr>
                                <th>SMTP Host</th>
                                <td><code><?php echo $this->config->item('smtp_host') ?: 'Not configured'; ?></code></td>
                            </tr>
                            <tr>
                                <th>SMTP Port</th>
                                <td><code><?php echo $this->config->item('smtp_port') ?: 'Not configured'; ?></code></td>
                            </tr>
                            <tr>
                                <th>SMTP User</th>
                                <td><code><?php echo $this->config->item('smtp_user') ?: 'Not configured'; ?></code></td>
                            </tr>
                            <tr>
                                <th>From Email</th>
                                <td><code><?php echo $this->config->item('smtp_from') ?: 'Not configured'; ?></code></td>
                            </tr>
                            <tr>
                                <th>From Name</th>
                                <td><code><?php echo $this->config->item('smtp_from_name') ?: 'Not configured'; ?></code></td>
                            </tr>
                        </table>

                        <hr class="form-divider">

                        <!-- Test Email -->
                        <h5 class="section-header">
                            <i class="fas fa-paper-plane"></i> Test Email Configuration
                        </h5>

                        <p style="margin-bottom: 20px; color: var(--muted-text); font-size: 14px;">
                            Send a test email to verify your email configuration is working correctly.
                        </p>

                        <div id="test-email-form">
                            <div class="form-group">
                                <label for="test_email">Test Email Address</label>
                                <div class="input-group">
                                    <input type="email" 
                                           id="test_email" 
                                           class="form-control" 
                                           placeholder="your@email.com"
                                           value="<?php echo isset($admin_email) ? $admin_email : ''; ?>">
                                    <div class="input-group-append">
                                        <button type="button" 
                                                class="btn btn-primary" 
                                                onclick="sendTestEmail()">
                                            <i class="fas fa-paper-plane"></i> Send Test Email
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="test-email-result" class="mt-3" style="display: none;"></div>

                        <hr class="form-divider">

                        <!-- Configuration Instructions -->
                        <h5 class="section-header">
                            <i class="fas fa-book"></i> Configuration Instructions
                        </h5>

                        <div class="accordion" id="emailAccordion">
                            <!-- Gmail SMTP -->
                            <div class="card">
                                <div class="card-header" id="headingGmail">
                                    <h6>
                                        <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseGmail">
                                            <i class="fab fa-google"></i> Gmail SMTP Configuration
                                        </button>
                                    </h6>
                                </div>
                                <div id="collapseGmail" class="collapse" data-parent="#emailAccordion">
                                    <div class="card-body">
                                        <p>Edit <code>application/config/email.php</code> and add:</p>
                                        <pre><code>$config['protocol'] = 'smtp';
$config['smtp_host'] = 'smtp.gmail.com';
$config['smtp_port'] = 587;
$config['smtp_user'] = 'your-email@gmail.com';
$config['smtp_pass'] = 'your-app-password';
$config['smtp_crypto'] = 'tls';
$config['mailtype'] = 'html';</code></pre>
                                        <div class="alert alert-warning">
                                            <i class="fas fa-exclamation-triangle"></i>
                                            <div>
                                                <strong>Note:</strong> Use an App Password, not your regular password. 
                                                <a href="https://support.google.com/accounts/answer/185833" target="_blank">Learn how</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- SendGrid -->
                            <div class="card">
                                <div class="card-header" id="headingSendGrid">
                                    <h6>
                                        <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseSendGrid">
                                            <i class="fas fa-paper-plane"></i> SendGrid Configuration
                                        </button>
                                    </h6>
                                </div>
                                <div id="collapseSendGrid" class="collapse" data-parent="#emailAccordion">
                                    <div class="card-body">
                                        <p>Edit <code>application/config/email.php</code> and add:</p>
                                        <pre><code>$config['protocol'] = 'smtp';
$config['smtp_host'] = 'smtp.sendgrid.net';
$config['smtp_port'] = 587;
$config['smtp_user'] = 'apikey';
$config['smtp_pass'] = 'your-sendgrid-api-key';
$config['smtp_crypto'] = 'tls';
$config['mailtype'] = 'html';</code></pre>
                                    </div>
                                </div>
                            </div>

                            <!-- PHP Mail -->
                            <div class="card">
                                <div class="card-header" id="headingPHPMail">
                                    <h6>
                                        <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapsePHPMail">
                                            <i class="fas fa-envelope"></i> PHP Mail (Default)
                                        </button>
                                    </h6>
                                </div>
                                <div id="collapsePHPMail" class="collapse" data-parent="#emailAccordion">
                                    <div class="card-body">
                                        <p>Edit <code>application/config/email.php</code> and add:</p>
                                        <pre><code>$config['protocol'] = 'mail';
$config['mailtype'] = 'html';
$config['charset'] = 'utf-8';</code></pre>
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i>
                                            <div>
                                                Uses the server's built-in mail function. May not work on all servers.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Email Status -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-check-circle"></i> Email Status
                        </h6>
                    </div>
                    <div class="card-body">
                        <p style="margin-bottom: 12px;">
                            <strong>Configuration:</strong>
                            <span class="badge badge-<?php echo $this->config->item('smtp_host') ? 'success' : 'warning'; ?>">
                                <?php echo $this->config->item('smtp_host') ? 'Configured' : 'Not Configured'; ?>
                            </span>
                        </p>
                        <p style="margin: 0; font-size: 13px; color: var(--muted-text); line-height: 1.6;">
                            Test your email configuration above to ensure emails are being sent correctly.
                        </p>
                    </div>
                </div>

                <!-- Resources -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-book"></i> Resources
                        </h6>
                    </div>
                    <div class="card-body">
                        <ul class="resources-list">
                            <li>
                                <a href="https://www.codeigniter.com/userguide3/libraries/email.html" target="_blank">
                                    <i class="fas fa-external-link-alt"></i> CodeIgniter Email Docs
                                </a>
                            </li>
                            <li>
                                <a href="https://sendgrid.com/" target="_blank">
                                    <i class="fas fa-external-link-alt"></i> SendGrid
                                </a>
                            </li>
                            <li>
                                <a href="https://mailgun.com/" target="_blank">
                                    <i class="fas fa-external-link-alt"></i> Mailgun
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
function sendTestEmail() {
    const email = document.getElementById('test_email').value;
    const resultDiv = document.getElementById('test-email-result');

    if (!email) {
        alert('Please enter an email address');
        return;
    }

    // Show loading
    resultDiv.innerHTML = '<div class="alert alert-info"><i class="fas fa-spinner fa-spin"></i><div>Sending test email...</div></div>';
    resultDiv.style.display = 'block';

    // Send AJAX request
    $.ajax({
        url: '<?php echo base_url("admin/settings/test_email"); ?>',
        method: 'POST',
        data: { test_email: email },
        success: function(response) {
            resultDiv.innerHTML = '<div class="alert alert-success"><i class="fas fa-check-circle"></i><div>' + response.message + '</div></div>';
        },
        error: function(xhr) {
            const response = JSON.parse(xhr.responseText);
            resultDiv.innerHTML = '<div class="alert alert-danger"><i class="fas fa-exclamation-circle"></i><div>' + response.message + '</div></div>';
        }
    });
}
</script>