<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Custom Change Password Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .change-password-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Card Styles */
    .password-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .password-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
    }

    .password-card .card-header h6 {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .password-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 20px;
    }

    .password-card .card-body {
        padding: 32px;
    }

    /* Form Groups */
    .form-group {
        margin-bottom: 28px;
    }

    .form-group label {
        font-size: 14px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 10px;
        display: block;
    }

    .form-group label .text-danger {
        color: var(--danger-color);
        margin-left: 4px;
    }

    /* Input Groups */
    .input-group {
        position: relative;
        display: flex;
        flex-wrap: wrap;
        align-items: stretch;
        width: 100%;
    }

    .input-group > .form-control {
        position: relative;
        flex: 1 1 auto;
        width: 1%;
        min-width: 0;
        margin-bottom: 0;
        border-radius: 8px 0 0 8px;
    }

    .input-group-append {
        margin-left: -1px;
        display: flex;
    }

    .input-group-append .btn {
        border-radius: 0 8px 8px 0;
        border: 1px solid var(--border-color);
        background: var(--bg-light);
        color: var(--muted-text);
        padding: 12px 16px;
        transition: all 0.3s ease;
    }

    .input-group-append .btn:hover {
        background: #e2e6ea;
        color: var(--dark-text);
    }

    .input-group-append .btn:focus {
        outline: none;
        box-shadow: none;
    }

    /* Form Controls */
    .form-control {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 12px 16px;
        font-size: 14px;
        color: #495057;
        background: #fff;
        transition: all 0.3s ease;
    }

    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }

    .form-control.is-invalid {
        border-color: var(--danger-color);
    }

    .form-control.is-invalid:focus {
        box-shadow: 0 0 0 3px rgba(220, 53, 69, 0.1);
    }

    /* Form Text */
    .form-text {
        display: block;
        margin-top: 8px;
        font-size: 13px;
        color: var(--muted-text);
        line-height: 1.5;
    }

    /* Invalid Feedback */
    .invalid-feedback {
        display: block;
        margin-top: 8px;
        font-size: 13px;
        color: var(--danger-color);
        font-weight: 500;
    }

    /* Password Strength Indicator */
    #password-strength {
        margin-bottom: 24px;
        padding: 16px;
        background: var(--bg-light);
        border-radius: 8px;
        border: 1px solid var(--border-color);
    }

    .progress {
        height: 8px;
        border-radius: 4px;
        background-color: #e9ecef;
        overflow: hidden;
        margin-bottom: 8px;
    }

    .progress-bar {
        transition: width 0.3s ease, background-color 0.3s ease;
        border-radius: 4px;
    }

    .progress-bar.bg-danger {
        background: linear-gradient(90deg, var(--danger-color) 0%, #e74c3c 100%);
    }

    .progress-bar.bg-warning {
        background: linear-gradient(90deg, var(--warning-color) 0%, #f39c12 100%);
    }

    .progress-bar.bg-success {
        background: linear-gradient(90deg, var(--success-color) 0%, #27ae60 100%);
    }

    #strength-text {
        display: block;
        font-size: 13px;
        font-weight: 600;
        color: var(--dark-text);
    }

    /* Form Footer */
    .form-footer {
        border-top: 2px solid var(--border-color);
        padding-top: 24px;
        margin-top: 32px;
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 11px 24px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        text-decoration: none;
    }

    .btn-lg {
        padding: 13px 28px;
        font-size: 15px;
    }

    .btn-success {
        background: var(--success-color);
        color: #fff;
    }

    .btn-success:hover {
        background: #17a673;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn-outline-secondary {
        background: transparent;
        color: #6c757d;
        border: 2px solid var(--border-color);
    }

    .btn-outline-secondary:hover {
        background: var(--bg-light);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        color: #6c757d;
        text-decoration: none;
    }

    .btn i {
        font-size: 15px;
    }

    /* Requirements Card */
    .requirements-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-top: 24px;
    }

    .requirements-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 20px 24px;
    }

    .requirements-card .card-header h6 {
        font-size: 15px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .requirements-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 16px;
    }

    .requirements-card .card-body {
        padding: 24px;
    }

    /* Requirements List */
    .requirements-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .requirements-list li {
        display: flex;
        align-items: flex-start;
        gap: 12px;
        margin-bottom: 16px;
        padding: 12px;
        background: var(--bg-light);
        border-radius: 8px;
        border-left: 3px solid var(--success-color);
        transition: all 0.3s ease;
    }

    .requirements-list li:last-child {
        margin-bottom: 0;
    }

    .requirements-list li:hover {
        background: #e2e6ea;
        transform: translateX(4px);
    }

    .requirements-list li i {
        color: var(--success-color);
        font-size: 16px;
        margin-top: 2px;
        flex-shrink: 0;
    }

    .requirements-list li span {
        font-size: 14px;
        color: var(--dark-text);
        line-height: 1.5;
        font-weight: 500;
    }

    /* Security Badge */
    .security-badge {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 8px 16px;
        background: linear-gradient(135deg, rgba(28, 200, 138, 0.1) 0%, rgba(28, 200, 138, 0.05) 100%);
        border: 1px solid rgba(28, 200, 138, 0.3);
        border-radius: 8px;
        margin-top: 16px;
        font-size: 13px;
        color: var(--success-color);
        font-weight: 600;
    }

    .security-badge i {
        font-size: 16px;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .change-password-container {
            padding: 16px 0;
        }

        .password-card .card-header,
        .password-card .card-body {
            padding: 20px;
        }

        .requirements-card .card-header,
        .requirements-card .card-body {
            padding: 16px 20px;
        }

        .form-footer {
            flex-direction: column;
        }

        .form-footer .btn {
            width: 100%;
        }
    }

    @media (max-width: 768px) {
        .password-card .card-header h6 {
            font-size: 16px;
        }

        .form-group {
            margin-bottom: 24px;
        }

        .btn-lg {
            padding: 12px 24px;
            font-size: 14px;
        }

        .requirements-list li {
            padding: 10px;
        }
    }
</style>

<div class="change-password-container">
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-lg-6 mb-4">
                <div class="password-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-key"></i> Change Password
                        </h6>
                    </div>

                    <div class="card-body">
                        <?php echo form_open('admin/profile/change_password', array('id' => 'changePasswordForm')); ?>

                            <!-- Current Password -->
                            <div class="form-group">
                                <label for="current_password">
                                    Current Password <span class="text-danger">*</span>
                                </label>
                                <div class="input-group">
                                    <input type="password" 
                                           name="current_password" 
                                           id="current_password" 
                                           class="form-control <?php echo form_error('current_password') ? 'is-invalid' : ''; ?>" 
                                           placeholder="Enter current password"
                                           required>
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" 
                                                type="button" 
                                                onclick="togglePassword('current_password')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                </div>
                                <?php if (form_error('current_password')): ?>
                                    <div class="invalid-feedback d-block"><?php echo form_error('current_password'); ?></div>
                                <?php endif; ?>
                            </div>

                            <!-- New Password -->
                            <div class="form-group">
                                <label for="new_password">
                                    New Password <span class="text-danger">*</span>
                                </label>
                                <div class="input-group">
                                    <input type="password" 
                                           name="new_password" 
                                           id="new_password" 
                                           class="form-control <?php echo form_error('new_password') ? 'is-invalid' : ''; ?>" 
                                           placeholder="Enter new password"
                                           minlength="6"
                                           required>
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" 
                                                type="button" 
                                                onclick="togglePassword('new_password')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                </div>
                                <?php if (form_error('new_password')): ?>
                                    <div class="invalid-feedback d-block"><?php echo form_error('new_password'); ?></div>
                                <?php endif; ?>
                                <small class="form-text">
                                    Minimum 6 characters
                                </small>
                            </div>

                            <!-- Confirm Password -->
                            <div class="form-group">
                                <label for="confirm_password">
                                    Confirm New Password <span class="text-danger">*</span>
                                </label>
                                <div class="input-group">
                                    <input type="password" 
                                           name="confirm_password" 
                                           id="confirm_password" 
                                           class="form-control <?php echo form_error('confirm_password') ? 'is-invalid' : ''; ?>" 
                                           placeholder="Confirm new password"
                                           minlength="6"
                                           required>
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" 
                                                type="button" 
                                                onclick="togglePassword('confirm_password')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                </div>
                                <?php if (form_error('confirm_password')): ?>
                                    <div class="invalid-feedback d-block"><?php echo form_error('confirm_password'); ?></div>
                                <?php endif; ?>
                            </div>

                            <!-- Password Strength Indicator -->
                            <div id="password-strength" style="display: none;">
                                <div class="progress">
                                    <div id="strength-bar" 
                                         class="progress-bar" 
                                         role="progressbar" 
                                         style="width: 0%"></div>
                                </div>
                                <small id="strength-text"></small>
                            </div>

                            <!-- Submit Buttons -->
                            <div class="form-footer">
                                <button type="submit" class="btn btn-success btn-lg">
                                    <i class="fas fa-save"></i> Update Password
                                </button>
                                <a href="<?php echo base_url('admin/profile'); ?>" class="btn btn-outline-secondary btn-lg">
                                    <i class="fas fa-times"></i> Cancel
                                </a>
                            </div>

                        <?php echo form_close(); ?>
                    </div>
                </div>

                <!-- Password Requirements Card -->
                <div class="requirements-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-shield-alt"></i> Password Requirements
                        </h6>
                    </div>
                    <div class="card-body">
                        <ul class="requirements-list">
                            <li>
                                <i class="fas fa-check-circle"></i>
                                <span>Minimum 6 characters long</span>
                            </li>
                            <li>
                                <i class="fas fa-check-circle"></i>
                                <span>Use a mix of letters and numbers</span>
                            </li>
                            <li>
                                <i class="fas fa-check-circle"></i>
                                <span>Include special characters for extra security</span>
                            </li>
                            <li>
                                <i class="fas fa-check-circle"></i>
                                <span>Don't reuse old passwords</span>
                            </li>
                        </ul>
                        
                        <div class="security-badge">
                            <i class="fas fa-lock"></i>
                            <span>Your password is encrypted and secure</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
// Toggle password visibility
function togglePassword(fieldId) {
    const field = document.getElementById(fieldId);
    const icon = event.currentTarget.querySelector('i');
    
    if (field.type === 'password') {
        field.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        field.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

// Password strength checker
document.getElementById('new_password').addEventListener('input', function() {
    const password = this.value;
    const strengthDiv = document.getElementById('password-strength');
    const strengthBar = document.getElementById('strength-bar');
    const strengthText = document.getElementById('strength-text');

    if (password.length === 0) {
        strengthDiv.style.display = 'none';
        return;
    }

    strengthDiv.style.display = 'block';

    let strength = 0;
    let text = '';
    let color = '';

    // Check length
    if (password.length >= 6) strength++;
    if (password.length >= 10) strength++;

    // Check for letters
    if (password.match(/[a-z]/) && password.match(/[A-Z]/)) strength++;

    // Check for numbers
    if (password.match(/[0-9]/)) strength++;

    // Check for special characters
    if (password.match(/[^a-zA-Z0-9]/)) strength++;

    // Determine strength level
    if (strength <= 1) {
        text = 'Weak';
        color = 'bg-danger';
    } else if (strength <= 3) {
        text = 'Medium';
        color = 'bg-warning';
    } else {
        text = 'Strong';
        color = 'bg-success';
    }

    const percentage = (strength / 5) * 100;
    strengthBar.style.width = percentage + '%';
    strengthBar.className = 'progress-bar ' + color;
    strengthText.textContent = 'Password strength: ' + text;
});

// Form validation
document.getElementById('changePasswordForm').addEventListener('submit', function(e) {
    const currentPassword = document.getElementById('current_password').value;
    const newPassword = document.getElementById('new_password').value;
    const confirmPassword = document.getElementById('confirm_password').value;

    if (!currentPassword) {
        e.preventDefault();
        alert('Please enter your current password.');
        return false;
    }

    if (newPassword.length < 6) {
        e.preventDefault();
        alert('New password must be at least 6 characters long.');
        return false;
    }

    if (newPassword !== confirmPassword) {
        e.preventDefault();
        alert('New password and confirmation do not match.');
        return false;
    }

    if (newPassword === currentPassword) {
        e.preventDefault();
        alert('New password must be different from current password.');
        return false;
    }

    return true;
});
</script>