<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Custom Partners Management Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --purple-color: #8105bf;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .partners-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Statistics Cards */
    .stats-row {
        margin-bottom: 32px;
    }

    .stat-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: none;
        border-left: 4px solid;
        overflow: hidden;
        transition: all 0.3s ease;
        height: 100%;
    }

    .stat-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    }

    .stat-card.stat-primary {
        border-left-color: var(--primary-color);
    }

    .stat-card.stat-success {
        border-left-color: var(--success-color);
    }

    .stat-card.stat-info {
        border-left-color: var(--info-color);
    }

    .stat-card.stat-warning {
        border-left-color: var(--warning-color);
    }

    .stat-card .card-body {
        padding: 24px;
    }

    .stat-label {
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 8px;
        color: var(--muted-text);
    }

    .stat-value {
        font-size: 32px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        line-height: 1;
    }

    .stat-icon {
        font-size: 36px;
        opacity: 0.15;
    }

    .stat-card.stat-primary .stat-icon {
        color: var(--primary-color);
    }

    .stat-card.stat-success .stat-icon {
        color: var(--success-color);
    }

    .stat-card.stat-info .stat-icon {
        color: var(--info-color);
    }

    .stat-card.stat-warning .stat-icon {
        color: var(--warning-color);
    }

    /* Main Card */
    .partners-main-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 32px;
    }

    .partners-main-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .partners-main-card .card-header h3 {
        font-size: 20px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .partners-main-card .card-header h3 i {
        color: var(--primary-color);
        font-size: 22px;
    }

    .partners-main-card .card-body {
        padding: 32px;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 10px 20px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: var(--primary-hover);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        color: #fff;
    }

    .btn-danger {
        background: var(--danger-color);
        color: #fff;
    }

    .btn-danger:hover {
        background: #c82333;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
        color: #fff;
    }

    .btn-sm {
        padding: 8px 16px;
        font-size: 13px;
    }

    .btn i {
        font-size: 14px;
    }

    .btn-block {
        display: flex;
        width: 100%;
    }

    .btn-group {
        display: flex;
        gap: 0;
    }

    .btn-group .btn {
        flex: 1;
        border-radius: 0;
    }

    .btn-group .btn:first-child {
        border-radius: 8px 0 0 8px;
    }

    .btn-group .btn:last-child {
        border-radius: 0 8px 8px 0;
    }

    /* Partner Cards */
    .partner-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        transition: all 0.3s ease;
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    .partner-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12);
    }

    /* Partner Logo Section */
    .partner-logo-section {
        background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
        height: 200px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 24px;
        border-bottom: 1px solid var(--border-color);
        position: relative;
        overflow: hidden;
    }

    .partner-logo-section::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(242, 97, 36, 0.03) 0%, transparent 70%);
        pointer-events: none;
    }

    .partner-logo-section img {
        max-width: 100%;
        max-height: 150px;
        object-fit: contain;
        position: relative;
        z-index: 1;
        transition: transform 0.3s ease;
    }

    .partner-card:hover .partner-logo-section img {
        transform: scale(1.05);
    }

    .partner-logo-placeholder {
        text-align: center;
        color: #adb5bd;
    }

    .partner-logo-placeholder i {
        font-size: 48px;
        margin-bottom: 12px;
        opacity: 0.3;
    }

    .partner-logo-placeholder p {
        margin: 0;
        font-size: 14px;
        font-weight: 500;
    }

    /* Partner Card Body */
    .partner-card .card-body {
        padding: 24px;
        flex-grow: 1;
        display: flex;
        flex-direction: column;
    }

    /* Badges */
    .badge {
        padding: 6px 12px;
        font-size: 11px;
        font-weight: 600;
        border-radius: 6px;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        display: inline-block;
    }

    .badge-success {
        background: var(--success-color);
        color: #fff;
    }

    .badge-secondary {
        background: #6c757d;
        color: #fff;
    }

    .badge-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .badge-info {
        background: var(--info-color);
        color: #fff;
    }

    .badge-warning {
        background: var(--warning-color);
        color: #fff;
    }

    .badge-purple {
        background: var(--purple-color);
        color: #fff;
    }

    /* Partner Details */
    .partner-name {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 12px;
        line-height: 1.3;
        min-height: 48px;
    }

    .partner-description {
        font-size: 13px;
        color: var(--muted-text);
        line-height: 1.6;
        margin-bottom: 12px;
        flex-grow: 1;
    }

    .partner-website {
        margin-bottom: 12px;
    }

    .partner-website a {
        color: var(--primary-color);
        text-decoration: none;
        font-size: 13px;
        font-weight: 500;
        transition: color 0.3s ease;
    }

    .partner-website a:hover {
        color: var(--primary-hover);
        text-decoration: underline;
    }

    .partner-website i {
        margin-right: 6px;
    }

    .partner-order {
        font-size: 12px;
        color: var(--muted-text);
        margin: 0;
    }

    .partner-order i {
        margin-right: 4px;
        color: var(--info-color);
    }

    /* Card Footer */
    .partner-card .card-footer {
        background: #fff;
        border-top: 1px solid var(--border-color);
        padding: 16px;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 80px 20px;
    }

    .empty-state i {
        color: #dee2e6;
        margin-bottom: 24px;
    }

    .empty-state h5 {
        font-size: 20px;
        font-weight: 700;
        color: var(--muted-text);
        margin-bottom: 12px;
    }

    .empty-state p {
        font-size: 14px;
        color: var(--muted-text);
        margin-bottom: 24px;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .partners-container {
            padding: 16px 0;
        }

        .stats-row {
            margin-bottom: 24px;
        }

        .stat-card .card-body {
            padding: 20px;
        }

        .stat-value {
            font-size: 28px;
        }

        .partners-main-card .card-header {
            padding: 20px;
            flex-direction: column;
            gap: 16px;
            align-items: flex-start;
        }

        .partners-main-card .card-body {
            padding: 20px;
        }
    }

    @media (max-width: 768px) {
        .partners-main-card .card-header h3 {
            font-size: 18px;
        }

        .stat-card {
            margin-bottom: 16px;
        }

        .partner-card {
            margin-bottom: 20px;
        }

        .partner-logo-section {
            height: 160px;
            padding: 20px;
        }

        .partner-logo-section img {
            max-height: 120px;
        }

        .partner-card .card-body {
            padding: 20px;
        }

        .partner-name {
            font-size: 16px;
            min-height: auto;
        }
    }
</style>

<div class="partners-container">
    <div class="container-fluid">
        <!-- Statistics Cards -->
        <div class="row stats-row">
            <?php
            // Calculate statistics from partners array
            $total = count($partners);
            $active = count(array_filter($partners, function($p) { return $p->status === 'active'; }));
            $inactive = count(array_filter($partners, function($p) { return $p->status === 'inactive'; }));
            
            // Count by type
            $corporate = count(array_filter($partners, function($p) { return $p->partnership_type === 'corporate'; }));
            $ngo = count(array_filter($partners, function($p) { return $p->partnership_type === 'ngo'; }));
            ?>
            
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card stat-primary">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col">
                                <div class="stat-label">Total Partners</div>
                                <div class="stat-value"><?php echo $total; ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-handshake stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card stat-success">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col">
                                <div class="stat-label">Active</div>
                                <div class="stat-value"><?php echo $active; ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-check-circle stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card stat-warning">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col">
                                <div class="stat-label">Corporate</div>
                                <div class="stat-value"><?php echo $corporate; ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-building stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card stat-info">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col">
                                <div class="stat-label">NGO Partners</div>
                                <div class="stat-value"><?php echo $ngo; ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-users stat-icon"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Card -->
        <div class="partners-main-card">
            <div class="card-header">
                <h3>
                    <i class="fas fa-handshake"></i>
                    Partners & Sponsors
                </h3>
                <div>
                    <a href="<?php echo base_url('admin/partners/add'); ?>" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Add New Partner
                    </a>
                </div>
            </div>

            <div class="card-body">
                <?php if (!empty($partners)): ?>
                    <!-- Partners Grid -->
                    <div class="row">
                        <?php foreach ($partners as $partner): ?>
                            <div class="col-lg-4 col-md-6 mb-4">
                                <div class="partner-card">
                                    <!-- Partner Logo -->
                                    <div class="partner-logo-section">
                                        <?php if (!empty($partner->logo)): ?>
                                            <img src="<?php echo base_url('uploads/partners/' . $partner->logo); ?>" 
                                                 alt="<?php echo htmlspecialchars($partner->name); ?>">
                                        <?php else: ?>
                                            <div class="partner-logo-placeholder">
                                                <i class="fas fa-building"></i>
                                                <p>No Logo</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="card-body">
                                        <!-- Status & Type Badges -->
                                        <div class="mb-3">
                                            <?php
                                            $status_badge = $partner->status === 'active' 
                                                ? '<span class="badge badge-success">Active</span>' 
                                                : '<span class="badge badge-secondary">Inactive</span>';
                                            echo $status_badge;
                                            ?>

                                            <?php
                                            $type_badges = [
                                                'corporate' => '<span class="badge badge-primary ml-1">Corporate</span>',
                                                'ngo' => '<span class="badge badge-info ml-1">NGO</span>',
                                                'government' => '<span class="badge badge-warning ml-1">Government</span>',
                                                'academic' => '<span class="badge badge-purple ml-1">Academic</span>',
                                                'individual' => '<span class="badge badge-secondary ml-1">Individual</span>'
                                            ];
                                            echo $type_badges[$partner->partnership_type] ?? '';
                                            ?>
                                        </div>

                                        <!-- Partner Name -->
                                        <h5 class="partner-name">
                                            <?php echo htmlspecialchars($partner->name); ?>
                                        </h5>

                                        <!-- Description -->
                                        <?php if (!empty($partner->description)): ?>
                                            <p class="partner-description">
                                                <?php echo htmlspecialchars(character_limiter($partner->description, 80)); ?>
                                            </p>
                                        <?php endif; ?>

                                        <!-- Website Link -->
                                        <?php if (!empty($partner->website)): ?>
                                            <p class="partner-website">
                                                <i class="fas fa-globe"></i>
                                                <a href="<?php echo htmlspecialchars($partner->website); ?>" 
                                                   target="_blank" 
                                                   rel="noopener">
                                                    Visit Website
                                                </a>
                                            </p>
                                        <?php endif; ?>

                                        <!-- Display Order -->
                                        <?php if ($partner->display_order > 0): ?>
                                            <p class="partner-order">
                                                <i class="fas fa-sort"></i>
                                                Order: <?php echo $partner->display_order; ?>
                                            </p>
                                        <?php endif; ?>
                                    </div>

                                    <!-- Card Footer with Actions -->
                                    <div class="card-footer">
                                        <div class="btn-group btn-block" role="group">
                                            <a href="<?php echo base_url('admin/partners/edit/' . $partner->id); ?>" 
                                               class="btn btn-sm btn-primary"
                                               title="Edit">
                                                <i class="fas fa-edit"></i> Edit
                                            </a>
                                            <a href="<?php echo base_url('admin/partners/delete/' . $partner->id); ?>" 
                                               class="btn btn-sm btn-danger"
                                               onclick="return confirm('Are you sure you want to delete this partner? This will also delete their logo.');"
                                               title="Delete">
                                                <i class="fas fa-trash"></i> Delete
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                <?php else: ?>
                    <!-- Empty State -->
                    <div class="empty-state">
                        <i class="fas fa-handshake fa-4x"></i>
                        <h5>No Partners Yet</h5>
                        <p>You haven't added any partners or sponsors yet.</p>
                        <a href="<?php echo base_url('admin/partners/add'); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Add Your First Partner
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>