<?php defined('BASEPATH') OR exit('No direct script access allowed'); 
$is_edit = isset($partner);
?>

<!-- Custom Partner Form Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --purple-color: #8105bf;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .partner-form-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Card Styles */
    .form-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .form-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
    }

    .form-card .card-header h6 {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .form-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 20px;
    }

    .form-card .card-body {
        padding: 32px;
    }

    /* Form Groups */
    .form-group {
        margin-bottom: 28px;
    }

    .form-group label {
        font-size: 14px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 10px;
        display: block;
    }

    .form-group label .text-danger {
        color: var(--danger-color);
        margin-left: 4px;
    }

    /* Form Controls */
    .form-control {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 12px 16px;
        font-size: 14px;
        color: #495057;
        background: #fff;
        transition: all 0.3s ease;
    }

    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    .form-control.is-invalid {
        border-color: var(--danger-color);
    }

    .form-control.is-invalid:focus {
        box-shadow: 0 0 0 3px rgba(220, 53, 69, 0.1);
    }

    /* Textarea */
    textarea.form-control {
        resize: vertical;
        min-height: 120px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Select */
    select.form-control {
        cursor: pointer;
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 12px center;
        background-size: 16px 12px;
        padding-right: 36px;
    }

    /* Input Groups */
    .input-group {
        position: relative;
        display: flex;
        flex-wrap: wrap;
        align-items: stretch;
        width: 100%;
    }

    .input-group-prepend {
        margin-right: -1px;
        display: flex;
    }

    .input-group-text {
        display: flex;
        align-items: center;
        padding: 12px 16px;
        font-size: 14px;
        font-weight: 400;
        color: #495057;
        text-align: center;
        white-space: nowrap;
        background-color: var(--bg-light);
        border: 1px solid var(--border-color);
        border-radius: 8px 0 0 8px;
    }

    .input-group > .form-control {
        position: relative;
        flex: 1 1 auto;
        width: 1%;
        min-width: 0;
        margin-bottom: 0;
        border-radius: 0 8px 8px 0;
    }

    /* Custom File Input */
    .custom-file {
        position: relative;
        display: inline-block;
        width: 100%;
        margin-bottom: 0;
    }

    .custom-file-input {
        position: relative;
        z-index: 2;
        width: 100%;
        height: calc(2.5em + 0.75rem + 2px);
        margin: 0;
        opacity: 0;
        cursor: pointer;
    }

    .custom-file-label {
        position: absolute;
        top: 0;
        right: 0;
        left: 0;
        z-index: 1;
        height: calc(2.5em + 0.75rem + 2px);
        padding: 12px 16px;
        font-weight: 400;
        line-height: 1.5;
        color: #495057;
        background-color: #fff;
        border: 2px dashed var(--border-color);
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .custom-file-label::after {
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        z-index: 3;
        display: block;
        height: calc(2.5em + 0.75rem);
        padding: 12px 16px;
        line-height: 1.5;
        color: #495057;
        content: "Browse";
        background: var(--bg-light);
        border-left: inherit;
        border-radius: 0 8px 8px 0;
    }

    .custom-file-input:hover ~ .custom-file-label {
        border-color: var(--primary-color);
        background: rgba(242, 97, 36, 0.03);
    }

    .custom-file-input:focus ~ .custom-file-label {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    /* Current Logo Section */
    .current-logo-section {
        background: var(--bg-light);
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 24px;
        margin-bottom: 16px;
        text-align: center;
    }

    .current-logo-section p strong {
        color: var(--dark-text);
        font-weight: 600;
    }

    .current-logo-section img {
        border-radius: 8px;
        border: 2px solid var(--border-color);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        background: #fff;
        padding: 12px;
    }

    /* Form Text */
    .form-text {
        display: block;
        margin-top: 8px;
        font-size: 13px;
        color: var(--muted-text);
        line-height: 1.5;
    }

    .form-text i {
        margin-right: 4px;
        color: var(--info-color);
    }

    /* Invalid Feedback */
    .invalid-feedback {
        display: block;
        margin-top: 8px;
        font-size: 13px;
        color: var(--danger-color);
        font-weight: 500;
    }

    /* Form Footer */
    .form-footer {
        border-top: 2px solid var(--border-color);
        padding-top: 24px;
        margin-top: 32px;
        display: flex;
        gap: 12px;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 11px 24px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-lg {
        padding: 13px 28px;
        font-size: 15px;
    }

    .btn-success {
        background: var(--success-color);
        color: #fff;
    }

    .btn-success:hover {
        background: #17a673;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        color: #fff;
    }

    .btn-outline-secondary {
        background: transparent;
        color: #6c757d;
        border: 2px solid var(--border-color);
    }

    .btn-outline-secondary:hover {
        background: var(--bg-light);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        color: #6c757d;
    }

    .btn i {
        font-size: 15px;
    }

    /* Sidebar Cards */
    .sidebar-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .sidebar-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 20px 24px;
    }

    .sidebar-card .card-header h6 {
        font-size: 15px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .sidebar-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 16px;
    }

    .sidebar-card .card-body {
        padding: 24px;
    }

    /* Partnership Types List */
    .partnership-types-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .partnership-types-list li {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 16px;
        padding-bottom: 16px;
        border-bottom: 1px solid var(--border-color);
    }

    .partnership-types-list li:last-child {
        margin-bottom: 0;
        padding-bottom: 0;
        border-bottom: none;
    }

    .partnership-types-list .badge {
        flex-shrink: 0;
        min-width: 80px;
        text-align: center;
    }

    .partnership-types-list .text-muted {
        font-size: 13px;
        line-height: 1.4;
    }

    /* Logo Guidelines List */
    .guidelines-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .guidelines-list li {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        margin-bottom: 12px;
        color: var(--muted-text);
        line-height: 1.5;
        font-size: 13px;
    }

    .guidelines-list li:last-child {
        margin-bottom: 0;
    }

    .guidelines-list li i {
        color: var(--success-color);
        margin-top: 2px;
        flex-shrink: 0;
    }

    /* Badges */
    .badge {
        padding: 6px 12px;
        font-size: 11px;
        font-weight: 600;
        border-radius: 6px;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        display: inline-block;
    }

    .badge-success {
        background: var(--success-color);
        color: #fff;
    }

    .badge-secondary {
        background: #6c757d;
        color: #fff;
    }

    .badge-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .badge-info {
        background: var(--info-color);
        color: #fff;
    }

    .badge-warning {
        background: var(--warning-color);
        color: #fff;
    }

    .badge-purple {
        background: var(--purple-color);
        color: #fff;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .partner-form-container {
            padding: 16px 0;
        }

        .form-card .card-header,
        .form-card .card-body {
            padding: 20px;
        }

        .sidebar-card .card-header,
        .sidebar-card .card-body {
            padding: 16px 20px;
        }

        .form-footer {
            flex-direction: column;
        }

        .form-footer .btn {
            width: 100%;
            justify-content: center;
        }
    }

    @media (max-width: 768px) {
        .form-card .card-header h6 {
            font-size: 16px;
        }

        .form-group {
            margin-bottom: 24px;
        }

        .btn-lg {
            padding: 12px 24px;
            font-size: 14px;
        }

        .partnership-types-list li {
            flex-direction: column;
            align-items: flex-start;
            gap: 8px;
        }

        .partnership-types-list .badge {
            min-width: auto;
        }
    }
</style>

<div class="partner-form-container">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-8 mb-4">
                <div class="form-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-handshake"></i> 
                            <?php echo $is_edit ? 'Edit Partner' : 'Add New Partner'; ?>
                        </h6>
                    </div>

                    <div class="card-body">
                        <?php echo form_open_multipart(current_url(), array('id' => 'partnerForm')); ?>

                            <!-- Partner Name -->
                            <div class="form-group">
                                <label for="name">
                                    Partner Name <span class="text-danger">*</span>
                                </label>
                                <input type="text" 
                                       name="name" 
                                       id="name" 
                                       class="form-control <?php echo form_error('name') ? 'is-invalid' : ''; ?>" 
                                       value="<?php echo set_value('name', $is_edit ? $partner->name : ''); ?>" 
                                       placeholder="e.g., ABC Corporation, XYZ Foundation"
                                       required
                                       maxlength="200">
                                <?php if (form_error('name')): ?>
                                    <div class="invalid-feedback"><?php echo form_error('name'); ?></div>
                                <?php endif; ?>
                            </div>

                            <!-- Partnership Type -->
                            <div class="form-group">
                                <label for="partnership_type">
                                    Partnership Type <span class="text-danger">*</span>
                                </label>
                                <select name="partnership_type" 
                                        id="partnership_type" 
                                        class="form-control <?php echo form_error('partnership_type') ? 'is-invalid' : ''; ?>" 
                                        required>
                                    <option value="">-- Select Type --</option>
                                    <option value="corporate" <?php echo set_select('partnership_type', 'corporate', $is_edit && $partner->partnership_type === 'corporate'); ?>>
                                        Corporate Partner
                                    </option>
                                    <option value="ngo" <?php echo set_select('partnership_type', 'ngo', $is_edit && $partner->partnership_type === 'ngo'); ?>>
                                        NGO Partner
                                    </option>
                                    <option value="government" <?php echo set_select('partnership_type', 'government', $is_edit && $partner->partnership_type === 'government'); ?>>
                                        Government Agency
                                    </option>
                                    <option value="academic" <?php echo set_select('partnership_type', 'academic', $is_edit && $partner->partnership_type === 'academic'); ?>>
                                        Academic Institution
                                    </option>
                                    <option value="individual" <?php echo set_select('partnership_type', 'individual', $is_edit && $partner->partnership_type === 'individual'); ?>>
                                        Individual Sponsor
                                    </option>
                                </select>
                                <?php if (form_error('partnership_type')): ?>
                                    <div class="invalid-feedback"><?php echo form_error('partnership_type'); ?></div>
                                <?php endif; ?>
                            </div>

                            <!-- Website -->
                            <div class="form-group">
                                <label for="website">
                                    Website URL
                                </label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-globe"></i>
                                        </span>
                                    </div>
                                    <input type="url" 
                                           name="website" 
                                           id="website" 
                                           class="form-control" 
                                           value="<?php echo set_value('website', $is_edit ? $partner->website : ''); ?>"
                                           placeholder="https://www.example.com">
                                </div>
                                <small class="form-text">Full URL including https://</small>
                            </div>

                            <!-- Description -->
                            <div class="form-group">
                                <label for="description">
                                    Description
                                </label>
                                <textarea name="description" 
                                          id="description" 
                                          class="form-control" 
                                          rows="4" 
                                          placeholder="Brief description of the partner organization..."><?php echo set_value('description', $is_edit ? $partner->description : ''); ?></textarea>
                                <small class="form-text">A brief description of the partnership or organization</small>
                            </div>

                            <!-- Display Order -->
                            <div class="form-group">
                                <label for="display_order">
                                    Display Order
                                </label>
                                <input type="number" 
                                       name="display_order" 
                                       id="display_order" 
                                       class="form-control" 
                                       value="<?php echo set_value('display_order', $is_edit ? $partner->display_order : '0'); ?>"
                                       min="0"
                                       placeholder="0">
                                <small class="form-text">
                                    <i class="fas fa-info-circle"></i> Lower numbers appear first. Use 0 for default order.
                                </small>
                            </div>

                            <!-- Partner Logo -->
                            <div class="form-group">
                                <label for="logo">
                                    Partner Logo
                                </label>

                                <?php if ($is_edit && !empty($partner->logo)): ?>
                                    <div class="current-logo-section">
                                        <p class="text-muted mb-3"><strong>Current Logo:</strong></p>
                                        <img src="<?php echo base_url('uploads/partners/' . $partner->logo); ?>" 
                                             alt="<?php echo htmlspecialchars($partner->name); ?>" 
                                             class="img-thumbnail" 
                                             style="max-height: 150px; max-width: 100%;">
                                        <p class="mt-3 mb-0 text-muted">
                                            <small><?php echo $partner->logo; ?></small>
                                        </p>
                                    </div>
                                <?php endif; ?>

                                <div class="custom-file">
                                    <input type="file" 
                                           name="logo" 
                                           id="logo" 
                                           class="custom-file-input" 
                                           accept="image/*">
                                    <label class="custom-file-label" for="logo">
                                        <?php echo $is_edit ? 'Choose new logo...' : 'Choose logo...'; ?>
                                    </label>
                                </div>
                                <small class="form-text">
                                    <i class="fas fa-info-circle"></i> 
                                    Recommended: PNG or JPG with transparent background. Max size: 2MB. 
                                    Optimal dimensions: 400x200px
                                </small>
                            </div>

                            <!-- Submit Buttons -->
                            <div class="form-footer">
                                <button type="submit" class="btn btn-success btn-lg">
                                    <i class="fas fa-save"></i> 
                                    <?php echo $is_edit ? 'Update Partner' : 'Add Partner'; ?>
                                </button>

                                <a href="<?php echo base_url('admin/partners'); ?>" class="btn btn-outline-secondary btn-lg">
                                    <i class="fas fa-times"></i> Cancel
                                </a>
                            </div>

                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Status -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-cog"></i> Settings
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-0">
                            <label for="status">Status</label>
                            <select name="status" id="status" class="form-control" form="partnerForm">
                                <option value="active" <?php echo set_select('status', 'active', !$is_edit || ($is_edit && $partner->status === 'active')); ?>>
                                    Active
                                </option>
                                <option value="inactive" <?php echo set_select('status', 'inactive', $is_edit && $partner->status === 'inactive'); ?>>
                                    Inactive
                                </option>
                            </select>
                            <small class="form-text">
                                Active partners will be displayed on the website
                            </small>
                        </div>
                    </div>
                </div>

                <!-- Partnership Types Info -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-info-circle"></i> Partnership Types
                        </h6>
                    </div>
                    <div class="card-body">
                        <ul class="partnership-types-list">
                            <li>
                                <span class="badge badge-primary">Corporate</span>
                                <span class="text-muted">Business partners and companies</span>
                            </li>
                            <li>
                                <span class="badge badge-info">NGO</span>
                                <span class="text-muted">Other NGO and non-profit organizations</span>
                            </li>
                            <li>
                                <span class="badge badge-warning">Government</span>
                                <span class="text-muted">Government agencies and departments</span>
                            </li>
                            <li>
                                <span class="badge badge-purple">Academic</span>
                                <span class="text-muted">Universities and educational institutions</span>
                            </li>
                            <li>
                                <span class="badge badge-secondary">Individual</span>
                                <span class="text-muted">Individual sponsors and donors</span>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Logo Guidelines -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-image"></i> Logo Guidelines
                        </h6>
                    </div>
                    <div class="card-body">
                        <ul class="guidelines-list">
                            <li>
                                <i class="fas fa-check"></i> 
                                <span>Use high-resolution images</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i> 
                                <span>PNG format with transparency preferred</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i> 
                                <span>Landscape orientation (400x200px ideal)</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i> 
                                <span>Keep file size under 2MB</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i> 
                                <span>Ensure logo is clearly visible</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
// Update file input label when file is selected
document.getElementById('logo').addEventListener('change', function() {
    const fileName = this.files[0]?.name || '<?php echo $is_edit ? "Choose new logo..." : "Choose logo..."; ?>';
    this.nextElementSibling.textContent = fileName;
    
    // Add visual feedback
    if (this.files[0]) {
        this.nextElementSibling.style.borderColor = 'var(--success-color)';
        this.nextElementSibling.style.background = 'rgba(28, 200, 138, 0.05)';
    }
});

// Form validation
document.getElementById('partnerForm').addEventListener('submit', function(e) {
    const name = document.getElementById('name').value.trim();
    const partnershipType = document.getElementById('partnership_type').value;

    if (!name) {
        e.preventDefault();
        alert('Please enter partner name.');
        return false;
    }

    if (!partnershipType) {
        e.preventDefault();
        alert('Please select partnership type.');
        return false;
    }

    return true;
});

// Validate URL format
document.getElementById('website').addEventListener('blur', function() {
    const url = this.value.trim();
    if (url && !url.match(/^https?:\/\//i)) {
        if (confirm('Website URL should start with http:// or https://. Add https:// automatically?')) {
            this.value = 'https://' + url;
        }
    }
});
</script>