<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-color: #28a745;
    }

    /* Card Styles */
    .reply-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        overflow: hidden;
        margin-bottom: 24px;
    }
    
    .reply-card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border-bottom: 2px solid #e9ecef;
        padding: 24px 28px;
    }
    
    .reply-card-title {
        font-size: 18px;
        font-weight: 700;
        color: var(--secondary-color);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .reply-card-title i {
        color: var(--primary-color);
        font-size: 20px;
    }
    
    .reply-card-body {
        padding: 32px;
    }
    
    /* Original Message Preview */
    .original-message-box {
        background: #f8f9fa;
        border: 1px solid #e9ecef;
        border-radius: 8px;
        padding: 24px;
        margin-bottom: 32px;
    }
    
    .original-message-box h6 {
        font-size: 16px;
        font-weight: 700;
        color: var(--secondary-color);
        margin-bottom: 16px;
    }
    
    .original-message-meta {
        margin-bottom: 16px;
        font-size: 14px;
    }
    
    .original-message-meta strong {
        color: var(--secondary-color);
        font-weight: 700;
    }
    
    .original-message-meta a {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
        transition: color 0.3s ease;
    }
    
    .original-message-meta a:hover {
        color: #d95520;
        text-decoration: underline;
    }
    
    .original-message-box hr {
        border: none;
        border-top: 1px solid #dee2e6;
        margin: 16px 0;
    }
    
    .original-message-content {
        background: #fff;
        border-left: 4px solid var(--primary-color);
        border-radius: 0 8px 8px 0;
        padding: 20px;
        font-size: 15px;
        line-height: 1.7;
        color: #495057;
    }
    
    /* Form Group */
    .form-group {
        margin-bottom: 24px;
    }
    
    .form-group label {
        font-size: 14px;
        font-weight: 700;
        color: var(--secondary-color);
        margin-bottom: 10px;
        display: block;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .form-group label .required {
        color: #dc3545;
        margin-left: 4px;
    }
    
    /* Textarea */
    textarea.form-control {
        border: 1px solid #e9ecef;
        border-radius: 8px;
        padding: 16px;
        font-size: 15px;
        color: #495057;
        background: #fff;
        transition: all 0.3s ease;
        width: 100%;
        min-height: 250px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        resize: vertical;
    }
    
    textarea.form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }
    
    textarea.form-control.is-invalid {
        border-color: #dc3545;
    }
    
    .invalid-feedback {
        display: block;
        margin-top: 6px;
        font-size: 13px;
        color: #dc3545;
        font-weight: 600;
    }
    
    .form-text {
        display: flex;
        align-items: center;
        gap: 6px;
        margin-top: 8px;
        font-size: 13px;
        color: #6c757d;
    }
    
    .form-text i {
        color: var(--primary-color);
    }
    
    /* Email Preview Box */
    .email-preview-box {
        background: #d1ecf1;
        border: 1px solid #bee5eb;
        border-left: 4px solid #17a2b8;
        border-radius: 8px;
        padding: 24px;
        margin-top: 16px;
        display: none;
        animation: slideDown 0.3s ease-out;
    }
    
    .email-preview-box.show {
        display: block;
    }
    
    @keyframes slideDown {
        from {
            opacity: 0;
            transform: translateY(-10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .email-preview-box h6 {
        font-size: 16px;
        font-weight: 700;
        color: #0c5460;
        margin-bottom: 16px;
    }
    
    .email-preview-content {
        background: #fff;
        border: 1px solid #bee5eb;
        border-radius: 8px;
        padding: 28px;
    }
    
    .email-preview-content p {
        margin-bottom: 12px;
        font-size: 14px;
        line-height: 1.7;
    }
    
    .email-preview-content strong {
        font-weight: 700;
        color: var(--secondary-color);
    }
    
    .email-preview-content hr {
        border: none;
        border-top: 1px solid #e9ecef;
        margin: 20px 0;
    }
    
    .email-preview-reply {
        background: #f9f9f9;
        border-left: 3px solid var(--primary-color);
        padding: 20px;
        margin: 20px 0;
        border-radius: 0 8px 8px 0;
        font-size: 15px;
        line-height: 1.7;
    }
    
    .email-preview-original {
        background: #f0f0f0;
        padding: 20px;
        margin: 20px 0;
        border-radius: 8px;
        font-size: 14px;
    }
    
    /* Action Buttons */
    .actions-section {
        margin-top: 32px;
        padding-top: 24px;
        border-top: 2px solid #e9ecef;
        display: flex;
        flex-wrap: wrap;
        gap: 12px;
    }
    
    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 12px 28px;
        font-size: 15px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }
    
    .btn-lg {
        padding: 14px 32px;
        font-size: 16px;
    }
    
    .btn-sm {
        padding: 8px 16px;
        font-size: 13px;
    }
    
    .btn-success {
        background: var(--success-color);
        color: #fff;
    }
    
    .btn-success:hover {
        background: #218838;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(40, 167, 69, 0.3);
        color: #fff;
    }
    
    .btn-outline-secondary {
        background: transparent;
        border: 2px solid #6c757d;
        color: #6c757d;
    }
    
    .btn-outline-secondary:hover {
        background: #6c757d;
        color: #fff;
        transform: translateY(-2px);
    }
    
    .btn-outline-primary {
        background: transparent;
        border: 1px solid var(--primary-color);
        color: var(--primary-color);
        justify-content: flex-start;
    }
    
    .btn-outline-primary:hover {
        background: var(--primary-color);
        color: #fff;
        transform: translateY(-1px);
    }
    
    .btn-block {
        width: 100%;
    }
    
    /* Tips Card */
    .tips-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }
    
    .tips-list li {
        display: flex;
        align-items: flex-start;
        gap: 12px;
        margin-bottom: 20px;
        padding: 12px;
        background: #f8f9fa;
        border-radius: 8px;
        transition: all 0.3s ease;
    }
    
    .tips-list li:hover {
        background: #e9ecef;
    }
    
    .tips-list li:last-child {
        margin-bottom: 0;
    }
    
    .tips-list li i {
        color: var(--success-color);
        font-size: 18px;
        flex-shrink: 0;
        margin-top: 2px;
    }
    
    .tips-list li strong {
        display: block;
        color: var(--secondary-color);
        font-weight: 700;
        margin-bottom: 4px;
    }
    
    .tips-list li span {
        font-size: 14px;
        color: #495057;
        line-height: 1.6;
    }
    
    /* Templates Card */
    .template-btn {
        margin-bottom: 12px;
    }
    
    .template-btn:last-of-type {
        margin-bottom: 0;
    }
    
    .template-info {
        display: flex;
        align-items: flex-start;
        gap: 8px;
        font-size: 13px;
        color: #6c757d;
        margin-top: 16px;
        padding-top: 16px;
        border-top: 1px solid #e9ecef;
    }
    
    .template-info i {
        color: var(--primary-color);
        margin-top: 2px;
    }
    
    /* Contact Info Card */
    .contact-info-item {
        margin-bottom: 16px;
    }
    
    .contact-info-item:last-child {
        margin-bottom: 0;
    }
    
    .contact-info-item strong {
        display: block;
        font-size: 12px;
        font-weight: 700;
        color: #6c757d;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 6px;
    }
    
    .contact-info-item span,
    .contact-info-item a {
        font-size: 15px;
        color: #495057;
        font-weight: 600;
    }
    
    .contact-info-item a {
        color: var(--primary-color);
        text-decoration: none;
        transition: color 0.3s ease;
    }
    
    .contact-info-item a:hover {
        color: #d95520;
        text-decoration: underline;
    }
    
    /* Responsive */
    @media (max-width: 768px) {
        .reply-card-header {
            padding: 20px;
        }
        
        .reply-card-body {
            padding: 24px 20px;
        }
        
        .original-message-box {
            padding: 20px;
        }
        
        textarea.form-control {
            min-height: 200px;
        }
        
        .email-preview-content {
            padding: 20px;
        }
        
        .actions-section {
            flex-direction: column;
        }
        
        .actions-section .btn {
            width: 100%;
            justify-content: center;
        }
        
        .tips-list li {
            flex-direction: column;
        }
    }
</style>

<div class="row">
    <!-- Reply Form -->
    <div class="col-lg-8 mb-4">
        <div class="reply-card">
            <div class="reply-card-header">
                <h6 class="reply-card-title">
                    <i class="fas fa-reply"></i> Reply to Message
                </h6>
            </div>

            <div class="reply-card-body">
                <?php echo form_open('', array('id' => 'replyForm')); ?>

                    <!-- Original Message Preview -->
                    <div class="original-message-box">
                        <h6>Original Message from <?php echo htmlspecialchars($message->name); ?>:</h6>
                        <div class="original-message-meta">
                            <strong>Subject:</strong> <?php echo htmlspecialchars($message->subject); ?>
                        </div>
                        <div class="original-message-meta">
                            <strong>Email:</strong> 
                            <a href="mailto:<?php echo htmlspecialchars($message->email); ?>">
                                <?php echo htmlspecialchars($message->email); ?>
                            </a>
                        </div>
                        <div class="original-message-meta">
                            <strong>Received:</strong> <?php echo date('F d, Y \a\t h:i A', strtotime($message->created_at)); ?>
                        </div>
                        <hr>
                        <div class="original-message-content">
                            <?php echo nl2br(htmlspecialchars($message->message)); ?>
                        </div>
                    </div>

                    <!-- Reply Message -->
                    <div class="form-group">
                        <label for="reply_message">
                            Your Reply
                            <span class="required">*</span>
                        </label>
                        <textarea name="reply_message" 
                                  id="reply_message" 
                                  class="form-control <?php echo form_error('reply_message') ? 'is-invalid' : ''; ?>" 
                                  rows="10" 
                                  placeholder="Type your reply message here..."
                                  required><?php echo set_value('reply_message'); ?></textarea>
                        <?php if (form_error('reply_message')): ?>
                            <div class="invalid-feedback">
                                <?php echo form_error('reply_message'); ?>
                            </div>
                        <?php endif; ?>
                        <small class="form-text">
                            <i class="fas fa-info-circle"></i> 
                            This message will be sent to <?php echo htmlspecialchars($message->email); ?>
                        </small>
                    </div>

                    <!-- Email Preview Button -->
                    <div class="form-group">
                        <button type="button" class="btn btn-sm btn-outline-secondary" onclick="toggleEmailPreview()">
                            <i class="fas fa-eye"></i> Preview Email
                        </button>
                    </div>

                    <!-- Email Preview Box -->
                    <div id="emailPreview" class="email-preview-box">
                        <h6>Email Preview:</h6>
                        <div class="email-preview-content">
                            <p><strong>To:</strong> <?php echo htmlspecialchars($message->email); ?></p>
                            <p><strong>Subject:</strong> Re: <?php echo htmlspecialchars($message->subject); ?></p>
                            <hr>
                            <h5>Response to Your Message</h5>
                            <p>Dear <?php echo htmlspecialchars($message->name); ?>,</p>
                            <p>Thank you for contacting us. Here is our response:</p>
                            <div class="email-preview-reply">
                                <span id="previewReply" style="color: #6c757d; font-style: italic;">Your reply will appear here...</span>
                            </div>
                            <p><strong>Your original message:</strong></p>
                            <div class="email-preview-original">
                                <strong>Subject:</strong> <?php echo htmlspecialchars($message->subject); ?><br>
                                <?php echo nl2br(htmlspecialchars(character_limiter($message->message, 200))); ?>
                            </div>
                            <p>If you have any further questions, please don't hesitate to contact us again.</p>
                            <p>Best regards,<br>
                            <?php echo isset($admin_data['full_name']) ? $admin_data['full_name'] : 'Admin'; ?><br>
                            <?php echo isset($site_settings['organization_name']) ? $site_settings['organization_name'] : 'Our Organization'; ?></p>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="actions-section">
                        <button type="submit" class="btn btn-success btn-lg">
                            <i class="fas fa-paper-plane"></i> Send Reply
                        </button>
                        <a href="<?php echo base_url('admin/messages/view/' . $message->id); ?>" 
                           class="btn btn-outline-secondary btn-lg">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>

                <?php echo form_close(); ?>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="col-lg-4">
        <!-- Reply Tips -->
        <div class="reply-card">
            <div class="reply-card-header">
                <h6 class="reply-card-title">
                    <i class="fas fa-lightbulb"></i> Reply Tips
                </h6>
            </div>
            <div class="reply-card-body">
                <ul class="tips-list">
                    <li>
                        <i class="fas fa-check-circle"></i>
                        <div>
                            <strong>Be Professional</strong>
                            <span>Use a friendly and professional tone.</span>
                        </div>
                    </li>
                    <li>
                        <i class="fas fa-check-circle"></i>
                        <div>
                            <strong>Be Clear</strong>
                            <span>Answer all questions directly and clearly.</span>
                        </div>
                    </li>
                    <li>
                        <i class="fas fa-check-circle"></i>
                        <div>
                            <strong>Be Helpful</strong>
                            <span>Provide additional resources if needed.</span>
                        </div>
                    </li>
                    <li>
                        <i class="fas fa-check-circle"></i>
                        <div>
                            <strong>Proofread</strong>
                            <span>Check for spelling and grammar errors.</span>
                        </div>
                    </li>
                    <li>
                        <i class="fas fa-check-circle"></i>
                        <div>
                            <strong>Follow Up</strong>
                            <span>Invite them to reach out again if needed.</span>
                        </div>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Quick Templates -->
        <div class="reply-card">
            <div class="reply-card-header">
                <h6 class="reply-card-title">
                    <i class="fas fa-file-alt"></i> Quick Templates
                </h6>
            </div>
            <div class="reply-card-body">
                <button type="button" class="btn btn-sm btn-outline-primary btn-block template-btn" 
                        onclick="insertTemplate('general')">
                    <i class="fas fa-plus"></i> General Inquiry
                </button>
                <button type="button" class="btn btn-sm btn-outline-primary btn-block template-btn" 
                        onclick="insertTemplate('volunteer')">
                    <i class="fas fa-plus"></i> Volunteer Info
                </button>
                <button type="button" class="btn btn-sm btn-outline-primary btn-block template-btn" 
                        onclick="insertTemplate('partnership')">
                    <i class="fas fa-plus"></i> Partnership
                </button>
                <button type="button" class="btn btn-sm btn-outline-primary btn-block template-btn" 
                        onclick="insertTemplate('thank_you')">
                    <i class="fas fa-plus"></i> Thank You
                </button>
                <div class="template-info">
                    <i class="fas fa-info-circle"></i>
                    <span>Click a template to insert it into your reply.</span>
                </div>
            </div>
        </div>

        <!-- Contact Info -->
        <div class="reply-card">
            <div class="reply-card-header">
                <h6 class="reply-card-title">
                    <i class="fas fa-user"></i> Contact Info
                </h6>
            </div>
            <div class="reply-card-body">
                <div class="contact-info-item">
                    <strong>Name</strong>
                    <span><?php echo htmlspecialchars($message->name); ?></span>
                </div>
                <div class="contact-info-item">
                    <strong>Email</strong>
                    <a href="mailto:<?php echo htmlspecialchars($message->email); ?>">
                        <?php echo htmlspecialchars($message->email); ?>
                    </a>
                </div>
                <?php if ($message->phone): ?>
                    <div class="contact-info-item">
                        <strong>Phone</strong>
                        <a href="tel:<?php echo htmlspecialchars($message->phone); ?>">
                            <?php echo htmlspecialchars($message->phone); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
// Update email preview as user types
document.getElementById('reply_message').addEventListener('input', function() {
    const previewReply = document.getElementById('previewReply');
    if (this.value.trim()) {
        previewReply.innerHTML = this.value.replace(/\n/g, '<br>');
        previewReply.style.color = '#495057';
        previewReply.style.fontStyle = 'normal';
    } else {
        previewReply.innerHTML = 'Your reply will appear here...';
        previewReply.style.color = '#6c757d';
        previewReply.style.fontStyle = 'italic';
    }
});

// Toggle email preview
function toggleEmailPreview() {
    const preview = document.getElementById('emailPreview');
    preview.classList.toggle('show');
}

// Insert template
function insertTemplate(type) {
    const textarea = document.getElementById('reply_message');
    let template = '';

    switch(type) {
        case 'general':
            template = "Thank you for reaching out to us.\n\nWe have received your inquiry and are pleased to assist you.\n\n[Your specific response here]\n\nIf you have any additional questions, please don't hesitate to contact us.\n\nBest regards,";
            break;

        case 'volunteer':
            template = "Thank you for your interest in volunteering with us!\n\nWe're excited about your willingness to contribute to our cause. Here's what you need to know:\n\n[Details about volunteer opportunities]\n\nPlease visit our volunteer page for more information: " + '<?php echo base_url("volunteers"); ?>' + "\n\nWe look forward to working with you!\n\nBest regards,";
            break;

        case 'partnership':
            template = "Thank you for your interest in partnering with us.\n\nWe appreciate organizations like yours that share our commitment to making a difference.\n\n[Partnership details]\n\nWe would be happy to discuss this opportunity further. Please let us know your availability for a meeting.\n\nBest regards,";
            break;

        case 'thank_you':
            template = "Thank you so much for your message.\n\nWe truly appreciate you taking the time to reach out to us. Your interest and support mean a great deal to our organization.\n\n[Additional information]\n\nPlease feel free to contact us anytime if you have further questions.\n\nWarm regards,";
            break;
    }

    textarea.value = template;
    textarea.focus();
    
    // Trigger input event to update preview
    textarea.dispatchEvent(new Event('input'));
}

// Form validation
document.getElementById('replyForm').addEventListener('submit', function(e) {
    const replyMessage = document.getElementById('reply_message').value.trim();
    
    if (replyMessage.length < 10) {
        e.preventDefault();
        alert('Please write a reply message (at least 10 characters).');
        return false;
    }

    if (!confirm('Are you sure you want to send this reply to <?php echo htmlspecialchars($message->email); ?>?')) {
        e.preventDefault();
        return false;
    }
});
</script>