<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo $page_title; ?> - <?php echo $site_settings['site_name'] ?? 'NGO Platform'; ?> Admin</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo base_url('assets/images/favicon.ico'); ?>">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom Admin CSS -->
    <style>
        :root {
            --primary-color: #f26124;
            --secondary-color: #231f20;
            --accent-color-1: #f7e1b0;
            --accent-color-2: #8105bf;
            --sidebar-width: 250px;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f4f6f9;
        }
        
        /* Sidebar Overlay - Mobile */
        .sidebar-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            display: none;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .sidebar-overlay.show {
            display: block;
            opacity: 1;
        }
        
        /* Sidebar Styles */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: var(--secondary-color);
            padding-top: 20px;
            overflow-y: auto;
            z-index: 1000;
            transition: transform 0.3s ease;
            box-shadow: 2px 0 8px rgba(0, 0, 0, 0.15);
        }

        .sidebar.hidden {
            transform: translateX(-100%);
        }
        
        .sidebar .logo {
            padding: 0 20px 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .sidebar .logo a {
            flex: 1;
        }

        .sidebar .logo img {
            height: 40px;
            width: auto;
        }

        .sidebar-close-btn {
            background: none;
            border: none;
            color: #fff;
            cursor: pointer;
            font-size: 24px;
            display: none;
            padding: 0;
            transition: all 0.3s ease;
        }

        .sidebar-close-btn:hover {
            color: var(--primary-color);
        }
        
        .sidebar .nav-link {
            color: rgba(255,255,255,0.7);
            padding: 12px 20px;
            display: flex;
            align-items: center;
            transition: all 0.3s;
            border-left: 3px solid transparent;
            text-decoration: none;
        }
        
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: #fff;
            background: rgba(242, 97, 36, 0.1);
            border-left-color: var(--primary-color);
        }
        
        .sidebar .nav-link i {
            width: 20px;
            margin-right: 10px;
        }
        
        .sidebar .badge {
            margin-left: auto;
            font-size: 10px;
        }
        
        /* Top Navbar */
        .top-navbar {
            position: fixed;
            top: 0;
            left: var(--sidebar-width);
            right: 0;
            height: 60px;
            background: #fff;
            border-bottom: 1px solid #dee2e6;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            z-index: 998;
            transition: left 0.3s ease;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .top-navbar .page-title {
            margin: 0;
            font-size: 20px;
            color: var(--secondary-color);
            font-weight: 700;
        }
        
        .top-navbar .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .top-navbar .notifications {
            position: relative;
        }
        
        .top-navbar .notifications .badge {
            position: absolute;
            top: -8px;
            right: -8px;
            font-size: 10px;
        }

        .top-navbar .btn-link {
            color: #6c757d;
            text-decoration: none;
            font-size: 18px;
            transition: all 0.3s ease;
        }

        .top-navbar .btn-link:hover {
            color: var(--primary-color);
        }

        .sidebar-toggle-btn {
            display: none;
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: #6c757d;
            margin-right: 15px;
            transition: all 0.3s ease;
        }

        .sidebar-toggle-btn:hover {
            color: var(--primary-color);
        }
        
        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            margin-top: 60px;
            padding: 20px;
            min-height: calc(100vh - 60px);
            transition: margin-left 0.3s ease;
        }
        
        /* Breadcrumb */
        .breadcrumb-section {
            background: #fff;
            padding: 15px 20px;
            margin: -20px -20px 20px;
            border-bottom: 1px solid #dee2e6;
            border-radius: 8px 8px 0 0;
        }
        
        /* Stats Cards */
        .stats-card {
            background: #fff;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            border-left: 4px solid var(--primary-color);
        }
        
        .stats-card h3 {
            font-size: 32px;
            font-weight: bold;
            margin: 10px 0;
            color: var(--secondary-color);
        }
        
        .stats-card p {
            margin: 0;
            color: #6c757d;
        }
        
        /* Table Styles */
        .table-card {
            background: #fff;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        /* Buttons */
        .btn-primary {
            background: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        .btn-primary:hover {
            background: #d95520;
            border-color: #d95520;
        }
        
        .btn-secondary {
            background: var(--secondary-color);
            border-color: var(--secondary-color);
        }

        .dropdown-menu {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border: 1px solid #e9ecef;
        }

        .dropdown-item {
            transition: all 0.2s ease;
        }

        .dropdown-item:hover {
            background: rgba(242, 97, 36, 0.1);
            color: var(--primary-color);
        }
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }
            
            .top-navbar {
                left: 0;
            }
            
            .main-content {
                margin-left: 0;
            }

            .sidebar-toggle-btn {
                display: block;
            }

            .sidebar-close-btn {
                display: block;
            }

            .sidebar .logo {
                padding: 0 15px 20px;
            }

            .sidebar .nav-link {
                padding: 12px 15px;
            }

            .page-title {
                font-size: 18px !important;
                max-width: calc(100vw - 200px);
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
            }

            .top-navbar {
                padding: 0 15px;
            }

            .user-info {
                gap: 10px !important;
            }

            .user-info .dropdown-toggle::after {
                display: none;
            }
        }

        @media (max-width: 576px) {
            :root {
                --sidebar-width: 250px;
            }

            .top-navbar .page-title {
                font-size: 16px;
            }

            .main-content {
                padding: 15px 10px;
            }

            .sidebar .nav-link {
                padding: 10px 15px;
                font-size: 14px;
            }

            .sidebar .badge {
                padding: 4px 8px !important;
                font-size: 10px;
            }
        }
    </style>
    
    <?php if(isset($custom_css)): ?>
        <?php echo $custom_css; ?>
    <?php endif; ?>
</head>
<body>
    
    <!-- Sidebar Overlay - Mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>
    
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="logo">
            <a href="<?php echo base_url(); ?>">
                <img src="<?php echo base_url('assets/images/logo2.png'); ?>" alt="Logo">
            </a>
            <button class="sidebar-close-btn" id="sidebarCloseBtn">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <nav class="nav flex-column">
            <a href="<?php echo base_url('admin/dashboard'); ?>" class="nav-link <?php echo ($current_uri == 'admin/dashboard') ? 'active' : ''; ?>">
                <i class="fas fa-tachometer-alt"></i>
                Dashboard
            </a>
            
            <a href="<?php echo base_url('admin/blog'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/blog') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-newspaper"></i>
                Blog Posts
                <span class="badge bg-secondary"><?php echo $stats['draft_posts'] ?? 0; ?></span>
            </a>
            
            <a href="<?php echo base_url('admin/volunteers'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/volunteers') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-users"></i>
                Volunteers
                <?php if(isset($stats['volunteers_pending']) && $stats['volunteers_pending'] > 0): ?>
                <span class="badge bg-warning"><?php echo $stats['volunteers_pending']; ?></span>
                <?php endif; ?>
            </a>
            
            <a href="<?php echo base_url('admin/consultations'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/consultations') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-calendar-check"></i>
                Consultations
                <?php if(isset($stats['consultations_new']) && $stats['consultations_new'] > 0): ?>
                <span class="badge bg-info"><?php echo $stats['consultations_new']; ?></span>
                <?php endif; ?>
            </a>
            
            <a href="<?php echo base_url('admin/messages'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/messages') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-envelope"></i>
                Messages
                <?php if(isset($stats['messages_unread']) && $stats['messages_unread'] > 0): ?>
                <span class="badge bg-danger"><?php echo $stats['messages_unread']; ?></span>
                <?php endif; ?>
            </a>
            
            <a href="<?php echo base_url('admin/workshops'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/workshops') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-chalkboard-teacher"></i>
                Workshops
            </a>
            
            <a href="<?php echo base_url('admin/partners'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/partners') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-handshake"></i>
                Partners
            </a>
            
            <a href="<?php echo base_url('admin/carousel'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/carousel') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-images"></i>
                Home Carousel
            </a>
			
			 <a href="<?php echo base_url('admin/media_management'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/media_management') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-film"></i>
                Media
            </a>
			
			
			 <a href="<?php echo base_url('admin/french-registrations/kids'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/french-registrations/kids') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-child"></i>
                Kids
            </a>
			<a href="<?php echo base_url('admin/french-registrations/adults'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/french-registrations/adults') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-user-tie"></i>
                Adults
            </a>
            
            <hr style="border-color: rgba(255,255,255,0.1); margin: 10px 0;">
            
            <a href="<?php echo base_url('admin/settings'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/settings') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-cog"></i>
                Settings
            </a>
            
            <a href="<?php echo base_url('admin/profile'); ?>" class="nav-link <?php echo (strpos($current_uri, 'admin/profile') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-user"></i>
                My Profile
            </a>
            
            <a href="<?php echo base_url(); ?>" class="nav-link" target="_blank">
                <i class="fas fa-external-link-alt"></i>
                View Website
            </a>
            
            <a href="<?php echo base_url('admin/logout'); ?>" class="nav-link" onclick="return confirm('Are you sure you want to logout?')">
                <i class="fas fa-sign-out-alt"></i>
                Logout
            </a>
        </nav>
    </div>
    
    <!-- Top Navbar -->
    <div class="top-navbar">
        <div style="display: flex; align-items: center; gap: 15px;">
            <button class="sidebar-toggle-btn" id="sidebarToggleBtn">
                <i class="fas fa-bars"></i>
            </button>
            <div>
                <h1 class="page-title"><?php echo $page_title; ?></h1>
                <?php if(!empty($page_subtitle)): ?>
                    <small class="text-muted"> - <?php echo $page_subtitle; ?></small>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="user-info">
            <div class="notifications">
                <a href="<?php echo base_url('admin/messages'); ?>" class="btn btn-link position-relative">
                    <i class="fas fa-bell"></i>
                    <?php if(isset($stats['messages_unread']) && $stats['messages_unread'] > 0): ?>
                    <span class="badge bg-danger rounded-pill"><?php echo $stats['messages_unread']; ?></span>
                    <?php endif; ?>
                </a>
            </div>
            
            <div class="dropdown">
                <a class="btn btn-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                    <i class="fas fa-user-circle"></i>
                    <span class="d-none d-sm-inline"><?php echo $admin_data['full_name']; ?></span>
                </a>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="<?php echo base_url('admin/profile'); ?>"><i class="fas fa-user"></i> My Profile</a></li>
                    <li><a class="dropdown-item" href="<?php echo base_url('admin/profile/change-password'); ?>"><i class="fas fa-key"></i> Change Password</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" href="<?php echo base_url('admin/logout'); ?>"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
                </ul>
            </div>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <!-- Breadcrumb -->
        <?php if(!empty($breadcrumbs)): ?>
        <div class="breadcrumb-section">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <?php foreach($breadcrumbs as $index => $crumb): ?>
                        <?php if($crumb['url']): ?>
                            <li class="breadcrumb-item"><a href="<?php echo base_url($crumb['url']); ?>"><?php echo $crumb['title']; ?></a></li>
                        <?php else: ?>
                            <li class="breadcrumb-item active"><?php echo $crumb['title']; ?></li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ol>
            </nav>
        </div>
        <?php endif; ?>
        
        <!-- Flash Messages -->
        <?php echo display_flash_message(); ?>
        
        <!-- Page Content -->
        <?php echo $content; ?>
    </div>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom Admin JS -->
    <script>
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebarOverlay');
        const sidebarToggleBtn = document.getElementById('sidebarToggleBtn');
        const sidebarCloseBtn = document.getElementById('sidebarCloseBtn');
        
        // Open sidebar
        sidebarToggleBtn.addEventListener('click', function() {
            sidebar.classList.add('show');
            sidebarOverlay.classList.add('show');
            document.body.style.overflow = 'hidden';
        });
        
        // Close sidebar
        function closeSidebar() {
            sidebar.classList.remove('show');
            sidebarOverlay.classList.remove('show');
            document.body.style.overflow = 'auto';
        }
        
        sidebarCloseBtn.addEventListener('click', closeSidebar);
        sidebarOverlay.addEventListener('click', closeSidebar);
        
        // Close sidebar when clicking on a nav link
        const navLinks = document.querySelectorAll('.sidebar .nav-link');
        navLinks.forEach(link => {
            link.addEventListener('click', function() {
                if (window.innerWidth <= 768) {
                    closeSidebar();
                }
            });
        });
        
        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                alert.style.transition = 'opacity 0.5s ease';
                alert.style.opacity = '0';
                setTimeout(() => {
                    alert.remove();
                }, 500);
            });
        }, 5000);
        
        // Confirm delete actions
        document.querySelectorAll('.btn-delete').forEach(btn => {
            btn.addEventListener('click', function(e) {
                if(!confirm('Are you sure you want to delete this item?')) {
                    e.preventDefault();
                }
            });
        });
    </script>
    
    <?php if(isset($custom_js)): ?>
        <?php echo $custom_js; ?>
    <?php endif; ?>
</body>
</html>