<!-- Custom Kid Registrations Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .kid-registrations-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Breadcrumb */
    .breadcrumb-section {
        background: #fff;
        border-radius: 8px;
        padding: 16px 24px;
        margin-bottom: 24px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    }

    .breadcrumb-section h1 {
        font-size: 24px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0 0 12px 0;
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin: 0;
        font-size: 13px;
    }

    .breadcrumb li {
        display: inline;
        color: var(--muted-text);
    }

    .breadcrumb li + li:before {
        content: "›";
        padding: 0 8px;
        color: var(--muted-text);
    }

    .breadcrumb a {
        color: var(--primary-color);
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .breadcrumb a:hover {
        color: var(--primary-hover);
    }

    .breadcrumb .active {
        color: var(--muted-text);
    }

    /* Alert Styles */
    .alert {
        border-radius: 8px;
        border: 1px solid;
        padding: 16px 20px;
        margin-bottom: 24px;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .alert-success {
        background-color: #d4edda;
        border-color: #c3e6cb;
        color: #155724;
    }

    .alert-danger {
        background-color: #f8d7da;
        border-color: #f5c6cb;
        color: #721c24;
    }

    .alert i {
        font-size: 18px;
    }

    /* Main Card */
    .registrations-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .registrations-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .registrations-card .card-header h3 {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .registrations-card .card-header h3 i {
        color: var(--primary-color);
        font-size: 20px;
    }

    .registrations-card .card-body {
        padding: 32px;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 10px 20px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }

    .btn-success {
        background: var(--success-color);
        color: #fff;
    }

    .btn-success:hover {
        background: #17a673;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn-info {
        background: var(--info-color);
        color: #fff;
    }

    .btn-info:hover {
        background: #2a9faf;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(54, 185, 204, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn-sm {
        padding: 8px 16px;
        font-size: 13px;
    }

    .btn-xs {
        padding: 6px 12px;
        font-size: 12px;
    }

    .btn i {
        font-size: 14px;
    }

    /* Table Styles */
    .table-container {
        overflow-x: auto;
        border-radius: 8px;
        border: 1px solid var(--border-color);
    }

    .table {
        width: 100%;
        margin: 0;
        border-collapse: separate;
        border-spacing: 0;
    }

    .table thead th {
        background: var(--bg-light);
        color: var(--dark-text);
        font-weight: 700;
        font-size: 13px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        padding: 16px;
        border-bottom: 2px solid var(--border-color);
        white-space: nowrap;
        text-align: left;
    }

    .table tbody td {
        padding: 16px;
        border-bottom: 1px solid var(--border-color);
        font-size: 14px;
        color: var(--dark-text);
        vertical-align: middle;
    }

    .table tbody tr:last-child td {
        border-bottom: none;
    }

    .table tbody tr {
        transition: background-color 0.2s ease;
    }

    .table tbody tr:hover {
        background-color: var(--bg-light);
    }

    /* Status Labels */
    .status-badge {
        padding: 6px 12px;
        font-size: 11px;
        font-weight: 600;
        border-radius: 6px;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        display: inline-block;
    }

    .status-badge.badge-warning {
        background: var(--warning-color);
        color: #fff;
    }

    .status-badge.badge-success {
        background: var(--success-color);
        color: #fff;
    }

    .status-badge.badge-danger {
        background: var(--danger-color);
        color: #fff;
    }

    /* Button Group */
    .btn-group {
        display: flex;
        gap: 4px;
    }

    /* DataTables Custom Styling */
    .dataTables_wrapper {
        padding: 0;
    }

    .dataTables_wrapper .dataTables_length,
    .dataTables_wrapper .dataTables_filter {
        margin-bottom: 16px;
    }

    .dataTables_wrapper .dataTables_length label,
    .dataTables_wrapper .dataTables_filter label {
        font-size: 14px;
        font-weight: 500;
        color: var(--dark-text);
    }

    .dataTables_wrapper .dataTables_length select {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 6px 32px 6px 12px;
        margin: 0 8px;
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 8px center;
        background-size: 12px 8px;
    }

    .dataTables_wrapper .dataTables_filter input {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 8px 12px;
        margin-left: 8px;
    }

    .dataTables_wrapper .dataTables_filter input:focus {
        border-color: var(--primary-color);
        outline: none;
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    .dataTables_wrapper .dataTables_info {
        font-size: 13px;
        color: var(--muted-text);
        padding-top: 16px;
    }

    .dataTables_wrapper .dataTables_paginate {
        padding-top: 16px;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 6px 12px;
        margin: 0 2px;
        border-radius: 6px;
        border: 1px solid var(--border-color);
        background: #fff;
        color: var(--dark-text) !important;
        font-size: 13px;
        transition: all 0.3s ease;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
        background: var(--primary-color);
        color: #fff !important;
        border-color: var(--primary-color);
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
        background: var(--primary-color);
        color: #fff !important;
        border-color: var(--primary-color);
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    /* Stats Box */
    .stats-box {
        background: linear-gradient(135deg, rgba(242, 97, 36, 0.05) 0%, rgba(242, 97, 36, 0.02) 100%);
        border: 1px solid rgba(242, 97, 36, 0.2);
        border-radius: 8px;
        padding: 20px;
        margin-bottom: 24px;
        display: flex;
        align-items: center;
        gap: 16px;
    }

    .stats-box i {
        font-size: 32px;
        color: var(--primary-color);
    }

    .stats-box .stats-content {
        flex: 1;
    }

    .stats-box .stats-number {
        font-size: 28px;
        font-weight: 700;
        color: var(--dark-text);
        line-height: 1;
        margin-bottom: 4px;
    }

    .stats-box .stats-label {
        font-size: 14px;
        color: var(--muted-text);
        font-weight: 500;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .kid-registrations-container {
            padding: 16px 0;
        }

        .registrations-card .card-header {
            padding: 20px;
            flex-direction: column;
            gap: 16px;
            align-items: flex-start;
        }

        .registrations-card .card-body {
            padding: 20px;
        }

        .breadcrumb-section h1 {
            font-size: 20px;
        }

        .stats-box {
            padding: 16px;
        }

        .stats-box .stats-number {
            font-size: 24px;
        }
    }

    @media (max-width: 768px) {
        .table thead th,
        .table tbody td {
            padding: 12px 8px;
            font-size: 13px;
        }

        .btn-group {
            flex-direction: column;
            gap: 4px;
        }

        .registrations-card .card-header h3 {
            font-size: 16px;
        }

        .stats-box {
            flex-direction: column;
            text-align: center;
        }
    }
</style>

<div class="kid-registrations-container">
    <div class="container-fluid">
        <!-- Breadcrumb -->
       

        <div class="row">
            <div class="col-xs-12">
                <?php if($this->session->flashdata('success')): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <?= $this->session->flashdata('success') ?>
                    </div>
                <?php endif; ?>

                <?php if($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i>
                        <?= $this->session->flashdata('error') ?>
                    </div>
                <?php endif; ?>

                <!-- Stats Box -->
                <div class="stats-box">
                    <i class="fas fa-child"></i>
                    <div class="stats-content">
                        <div class="stats-number"><?= count($registrations) ?></div>
                        <div class="stats-label">Total Kid Registrations</div>
                    </div>
                </div>

                <div class="registrations-card">
                    <div class="card-header">
                        <h3>
                            <i class="fas fa-list"></i>
                            Registered Kid Learners
                        </h3>
                        <div>
                            <a href="<?= site_url('admin/french_registrations/export_kid_registrations') ?>" class="btn btn-success btn-sm">
                                <i class="fa fa-download"></i> Export CSV
                            </a>
                        </div>
                    </div>
                    
                    <div class="card-body">
                        <div class="table-container">
                            <table id="kid-registrations" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Parent Name</th>
                                        <th>Email</th>
                                        <th>French Level</th>
                                        <th>Status</th>
                                        <th>Registered On</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($registrations as $registration): ?>
                                    <tr>
                                        <td><strong>#<?= $registration->id ?></strong></td>
                                        <td><?= htmlspecialchars($registration->first_name . ' ' . $registration->surname) ?></td>
                                        <td><?= htmlspecialchars($registration->parent_name) ?></td>
                                        <td><?= htmlspecialchars($registration->email) ?></td>
                                        <td><?= htmlspecialchars($registration->french_level) ?></td>
                                        <td>
                                            <?php 
                                            $status_class = [
                                                'Pending' => 'warning',
                                                'Approved' => 'success',
                                                'Rejected' => 'danger'
                                            ];
                                            ?>
                                            <span class="status-badge badge-<?= $status_class[$registration->status] ?>">
                                                <?= $registration->status ?>
                                            </span>
                                        </td>
                                        <td><?= date('d M Y', strtotime($registration->created_at)) ?></td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="<?= site_url('admin/french_registrations/view_kid_registration/' . $registration->id) ?>" 
                                                   class="btn btn-info btn-xs"
                                                   title="View Details">
                                                    <i class="fa fa-eye"></i> View
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#kid-registrations').DataTable({
        'paging'      : true,
        'lengthChange': true,
        'searching'   : true,
        'ordering'    : true,
        'info'        : true,
        'autoWidth'   : false,
        'pageLength'  : 25,
        'order'       : [[0, 'desc']], // Sort by ID descending (newest first)
        'language': {
            'search': 'Search registrations:',
            'lengthMenu': 'Show _MENU_ registrations',
            'info': 'Showing _START_ to _END_ of _TOTAL_ registrations',
            'infoEmpty': 'No registrations available',
            'infoFiltered': '(filtered from _MAX_ total registrations)',
            'paginate': {
                'first': 'First',
                'last': 'Last',
                'next': 'Next',
                'previous': 'Prev'
            }
        }
    });
});
</script>