<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Spacing Utilities */
    .mb-0 {
        margin-bottom: 0 !important;
    }

    .mb-2 {
        margin-bottom: 0.5rem !important;
    }

    .mb-3 {
        margin-bottom: 1rem !important;
    }

    .mb-4 {
        margin-bottom: 1.5rem !important;
    }

    .mt-3 {
        margin-top: 1rem !important;
    }

    .py-5 {
        padding-top: 3rem !important;
        padding-bottom: 3rem !important;
    }

    .me-2 {
        margin-right: 0.5rem !important;
    }

    .g-3 {
        gap: 1rem;
    }

    /* Grid */
    .row {
        display: flex;
        flex-wrap: wrap;
        gap: 24px;
    }

    .col-md-2 {
        flex: 0 0 calc(16.666% - 18px);
    }

    .col-md-3 {
        flex: 0 0 calc(25% - 18px);
    }

    .col-md-10 {
        flex: 0 0 calc(83.333% - 18px);
    }

    /* Flexbox Utilities */
    .d-flex {
        display: flex;
    }

    .justify-content-between {
        justify-content: space-between;
    }

    .align-items-center {
        align-items: center;
    }

    /* Text Utilities */
    .text-muted {
        color: #6c757d !important;
    }

    .text-center {
        text-align: center;
    }

    h2 {
        font-size: 28px;
        font-weight: 700;
        color: #231f20;
        margin: 0;
    }

    h3 {
        font-size: 32px;
        font-weight: 700;
        color: #231f20;
        margin: 0;
    }

    h4 {
        font-size: 20px;
        font-weight: 700;
        color: #231f20;
        margin-bottom: 8px;
    }

    p {
        font-size: 14px;
        color: #6c757d;
        margin: 4px 0 0 0;
    }

    strong {
        font-weight: 700;
    }

    small {
        font-size: 12px;
    }

    i {
        margin-right: 4px;
    }

    br {
        display: block;
        content: "";
        margin: 4px 0;
    }

    /* Card Styling */
    .table-card {
        background: #fff;
        border-radius: 12px;
        padding: 28px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        transition: all 0.3s ease;
    }

    .table-card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }

    /* Stats Card */
    .stats-card {
        background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%);
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        border-left: 4px solid #17a2b8;
        transition: all 0.3s ease;
        height: 100%;
    }

    .stats-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }

    .stats-card h3 {
        margin-bottom: 8px;
    }

    .stats-card p {
        font-size: 13px;
        font-weight: 600;
        color: #6c757d;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    /* Tabs */
    .nav-tabs {
        border-bottom: 2px solid #e9ecef;
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }

    .nav-item {
        margin: 0;
    }

    .nav-link {
        color: #6c757d;
        border: none;
        padding: 12px 16px;
        font-size: 14px;
        font-weight: 600;
        border-bottom: 3px solid transparent;
        transition: all 0.3s ease;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }

    .nav-link:hover {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
    }

    .nav-link.active {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
        background: transparent;
    }

    /* Badges */
    .badge {
        font-size: 11px;
        font-weight: 700;
        padding: 6px 10px;
        border-radius: 12px;
        display: inline-block;
        white-space: nowrap;
        margin-left: 4px;
    }

    .bg-secondary {
        background-color: #6c757d !important;
        color: #fff;
    }

    .bg-info {
        background-color: var(--info-blue) !important;
        color: #fff;
    }

    .bg-primary {
        background-color: var(--primary-color) !important;
        color: #fff;
    }

    .bg-warning {
        background-color: var(--warning-yellow) !important;
        color: #231f20;
    }

    .bg-success {
        background-color: var(--success-green) !important;
        color: #fff;
    }

    .bg-danger {
        background-color: var(--danger-red) !important;
        color: #fff;
    }

    /* Table */
    .table-responsive {
        overflow-x: auto;
    }

    .table {
        width: 100%;
        margin-bottom: 0;
        border-collapse: collapse;
    }

    .table thead th {
        font-size: 13px;
        font-weight: 700;
        color: #231f20;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border: none;
        border-bottom: 2px solid #e9ecef;
        padding: 14px 12px;
        background: transparent;
        text-align: left;
    }

    .table tbody td {
        font-size: 14px;
        color: #495057;
        padding: 12px;
        border: none;
        border-bottom: 1px solid #f0f0f0;
        vertical-align: middle;
    }

    .table tbody tr {
        transition: all 0.2s ease;
    }

    .table tbody tr:hover {
        background: #f8f9fa;
    }

    .table tbody tr:last-child td {
        border-bottom: 1px solid #e9ecef;
    }

    .table tbody tr.table-light {
        background: #fafbfc;
    }

    .table-hover tbody tr:hover {
        background-color: #f8f9fa;
    }

    /* Form Controls */
    .form-control {
        display: block;
        width: 100%;
        padding: 10px 12px;
        font-size: 14px;
        color: #495057;
        background-color: #fff;
        border: 1px solid #dee2e6;
        border-radius: 6px;
        transition: all 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .form-control:focus {
        color: #495057;
        background-color: #fff;
        border-color: var(--primary-color);
        outline: 0;
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    /* Buttons */
    .btn {
        font-size: 14px;
        font-weight: 600;
        padding: 10px 16px;
        border-radius: 6px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
    }

    .btn-outline-primary {
        background: transparent;
        color: var(--primary-color);
        border: 1px solid var(--primary-color);
    }

    .btn-outline-primary:hover {
        background: var(--primary-color);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-outline-success {
        background: transparent;
        color: var(--success-green);
        border: 1px solid var(--success-green);
    }

    .btn-outline-success:hover {
        background: var(--success-green);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-outline-danger {
        background: transparent;
        color: var(--danger-red);
        border: 1px solid var(--danger-red);
    }

    .btn-outline-danger:hover {
        background: var(--danger-red);
        color: #fff;
        transform: translateY(-1px);
    }

    .btn-outline-secondary {
        background: transparent;
        color: #231f20;
        border: 1px solid #dee2e6;
    }

    .btn-outline-secondary:hover {
        background: #f8f9fa;
        border-color: #231f20;
        transform: translateY(-2px);
    }

    .btn-link {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
        font-size: 12px;
        background: none;
        border: none;
        padding: 0;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-link:hover {
        color: #d95520;
        text-decoration: underline;
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 12px;
    }

    .w-100 {
        width: 100%;
    }

    .me-2 {
        margin-right: 0.5rem;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 60px 40px;
    }

    .empty-state i {
        font-size: 64px;
        color: #dee2e6;
        margin-bottom: 20px;
        display: block;
    }

    /* Pagination */
    .pagination {
        display: flex;
        gap: 4px;
        justify-content: center;
        margin-top: 20px;
        flex-wrap: wrap;
    }

    .pagination a,
    .pagination span {
        padding: 8px 12px;
        border-radius: 6px;
        font-size: 13px;
        font-weight: 600;
        border: 1px solid #dee2e6;
        color: #495057;
        text-decoration: none;
        transition: all 0.2s ease;
    }

    .pagination a:hover {
        background: #f8f9fa;
        border-color: var(--primary-color);
        color: var(--primary-color);
    }

    .pagination .active {
        background: var(--primary-color);
        border-color: var(--primary-color);
        color: #fff;
    }

    /* Responsive */
    @media (max-width: 992px) {
        .row {
            gap: 16px;
        }

        .col-md-3 {
            flex: 0 0 calc(50% - 8px);
        }

        .col-md-2 {
            flex: 0 0 100%;
        }

        .col-md-10 {
            flex: 0 0 100%;
        }
    }

    @media (max-width: 768px) {
        .d-flex {
            flex-direction: column;
            align-items: flex-start;
            gap: 16px;
        }

        .d-flex > div:last-child {
            width: 100%;
            display: flex;
            gap: 12px;
            flex-wrap: wrap;
        }

        .justify-content-between {
            justify-content: flex-start;
        }

        .table-card {
            padding: 18px;
        }

        .table thead th,
        .table tbody td {
            padding: 10px 8px;
            font-size: 12px;
        }

        .nav-link {
            padding: 10px 12px;
            font-size: 12px;
        }

        h2 {
            font-size: 24px;
        }

        .row {
            gap: 12px;
        }

        .col-md-3 {
            flex: 0 0 100%;
        }

        .btn {
            width: 100%;
            justify-content: center;
        }

        .btn-sm {
            width: auto;
        }

        .form-control {
            font-size: 14px;
            padding: 10px;
        }
    }

    @media (max-width: 576px) {
        .table-card {
            padding: 16px;
        }

        .table thead th {
            font-size: 11px;
        }

        .table tbody td {
            font-size: 12px;
            padding: 8px;
        }

        h2 {
            font-size: 20px;
        }

        h3 {
            font-size: 28px;
        }

        .stats-card {
            padding: 16px;
        }

        .empty-state {
            padding: 40px 20px;
        }

        .empty-state i {
            font-size: 48px;
        }

        .form-control {
            padding: 8px 10px;
            font-size: 13px;
        }
    }
</style>

<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-0">Consultation Requests</h2>
        <p class="text-muted mb-0">Manage consultation bookings and appointments</p>
    </div>
    <div>
        <a href="<?php echo base_url('admin/consultations/calendar'); ?>" 
           class="btn btn-outline-primary me-2">
            <i class="fas fa-calendar-alt"></i> Calendar View
        </a>
        <a href="<?php echo base_url('admin/export/consultations?status=' . ($current_status ?? '')); ?>" 
           class="btn btn-outline-success">
            <i class="fas fa-file-excel"></i> Export CSV
        </a>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="stats-card" style="border-left-color: #17a2b8;">
            <h3><?php echo $statistics['new'] ?? 0; ?></h3>
            <p>New Requests</p>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card" style="border-left-color: #ffc107;">
            <h3><?php echo $statistics['scheduled'] ?? 0; ?></h3>
            <p>Scheduled</p>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card" style="border-left-color: #28a745;">
            <h3><?php echo $statistics['completed'] ?? 0; ?></h3>
            <p>Completed</p>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card" style="border-left-color: #6c757d;">
            <h3><?php echo $statistics['upcoming'] ?? 0; ?></h3>
            <p>Upcoming</p>
        </div>
    </div>
</div>

<!-- Search Bar -->
<div class="table-card mb-3">
    <form method="get" action="<?php echo base_url('admin/consultations/search'); ?>" class="row g-3">
        <div class="col-md-10">
            <input type="text" 
                   class="form-control" 
                   name="keyword" 
                   placeholder="Search by name, email, phone, subject, or organization..."
                   value="<?php echo isset($search_keyword) ? $search_keyword : ''; ?>">
        </div>
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary w-100">
                <i class="fas fa-search"></i> Search
            </button>
        </div>
    </form>
</div>

<!-- Filter Tabs -->
<div class="table-card mb-4">
    <ul class="nav nav-tabs" role="tablist">
        <li class="nav-item">
            <a class="nav-link <?php echo empty($current_status) ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/consultations'); ?>">
                All Requests <span class="badge bg-secondary"><?php echo $statistics['total'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'new') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/consultations?status=new'); ?>">
                New <span class="badge bg-info"><?php echo $statistics['new'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'contacted') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/consultations?status=contacted'); ?>">
                Contacted <span class="badge bg-primary"><?php echo $statistics['contacted'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'scheduled') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/consultations?status=scheduled'); ?>">
                Scheduled <span class="badge bg-warning"><?php echo $statistics['scheduled'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'completed') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/consultations?status=completed'); ?>">
                Completed <span class="badge bg-success"><?php echo $statistics['completed'] ?? 0; ?></span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_status == 'cancelled') ? 'active' : ''; ?>" 
               href="<?php echo base_url('admin/consultations?status=cancelled'); ?>">
                Cancelled <span class="badge bg-danger"><?php echo $statistics['cancelled'] ?? 0; ?></span>
            </a>
        </li>
    </ul>
</div>

<!-- Consultations Table -->
<div class="table-card">
    <?php if(!empty($consultations)): ?>
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th style="width: 50px;">ID</th>
                    <th>Name</th>
                    <th>Contact</th>
                    <th>Type</th>
                    <th>Subject</th>
                    <th>Preferred Date/Time</th>
                    <th>Assigned To</th>
                    <th>Status</th>
                    <th>Submitted</th>
                    <th style="width: 120px;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($consultations as $consultation): ?>
                <tr class="<?php echo ($consultation->status == 'new') ? 'table-light' : ''; ?>">
                    <td><?php echo $consultation->id; ?></td>
                    <td>
                        <strong><?php echo $consultation->full_name; ?></strong>
                        <?php if($consultation->organization): ?>
                            <br><small class="text-muted"><?php echo character_limiter($consultation->organization, 25); ?></small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <small>
                            <i class="fas fa-envelope"></i> <?php echo character_limiter($consultation->email, 20); ?><br>
                            <i class="fas fa-phone"></i> <?php echo $consultation->phone; ?>
                        </small>
                    </td>
                    <td>
                        <span class="badge bg-secondary">
                            <?php echo ucfirst($consultation->consultation_type); ?>
                        </span>
                    </td>
                    <td>
                        <?php echo character_limiter($consultation->subject, 30); ?>
                    </td>
                    <td>
                        <?php if($consultation->preferred_date): ?>
                            <small>
                                <i class="fas fa-calendar"></i> <?php echo format_date($consultation->preferred_date); ?>
                                <?php if($consultation->preferred_time): ?>
                                    <br><i class="fas fa-clock"></i> <?php echo date('g:i A', strtotime($consultation->preferred_time)); ?>
                                <?php endif; ?>
                            </small>
                        <?php else: ?>
                            <span class="text-muted">Not specified</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($consultation->assigned_to_name): ?>
                            <span class="badge bg-primary"><?php echo $consultation->assigned_to_name; ?></span>
                        <?php else: ?>
                            <span class="text-muted">Unassigned</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo get_status_badge($consultation->status); ?></td>
                    <td>
                        <small><?php echo time_ago($consultation->created_at); ?></small>
                    </td>
                    <td>
                        <a href="<?php echo base_url('admin/consultations/view/' . $consultation->id); ?>" 
                           class="btn btn-sm btn-outline-primary"
                           title="View Details">
                            <i class="fas fa-eye"></i>
                        </a>
                        <a href="<?php echo base_url('admin/consultations/delete/' . $consultation->id); ?>" 
                           class="btn btn-sm btn-outline-danger"
                           onclick="return confirm('Delete this consultation request?');"
                           title="Delete">
                            <i class="fas fa-trash"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Pagination -->
    <?php if(!empty($pagination)): ?>
    <div class="mt-3">
        <?php echo $pagination; ?>
    </div>
    <?php endif; ?>
    
    <?php else: ?>
    <!-- Empty State -->
    <div class="text-center py-5">
        <i class="fas fa-calendar-check fa-4x text-muted mb-3"></i>
        <h4>No consultation requests found</h4>
        <?php if(!empty($current_status)): ?>
            <p class="text-muted">No consultations with status: <strong><?php echo ucfirst($current_status); ?></strong></p>
            <a href="<?php echo base_url('admin/consultations'); ?>" class="btn btn-outline-secondary">
                View All Requests
            </a>
        <?php else: ?>
            <p class="text-muted">Consultation requests will appear here when people book on your website</p>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</div>

<?php if(isset($search_keyword)): ?>
<div class="mt-3">
    <a href="<?php echo base_url('admin/consultations'); ?>" class="btn btn-link">
        <i class="fas fa-times"></i> Clear Search
    </a>
</div>
<?php endif; ?>