<?php defined('BASEPATH') OR exit('No direct script access allowed'); 
$is_edit = isset($item);
?>

<!-- Custom Carousel Form Styles -->
<style>
    :root {
        --primary-color: #f26124;
        --primary-hover: #d95520;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #dc3545;
        --dark-text: #231f20;
        --muted-text: #6c757d;
        --border-color: #e9ecef;
        --bg-light: #f8f9fa;
    }

    .carousel-form-container {
        background: #f4f6f9;
        min-height: 100vh;
        padding: 20px 0;
    }

    /* Card Styles */
    .form-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .form-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 24px 28px;
    }

    .form-card .card-header h6 {
        font-size: 18px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .form-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 20px;
    }

    .form-card .card-body {
        padding: 32px;
    }

    /* Form Groups */
    .form-group {
        margin-bottom: 28px;
    }

    .form-group label {
        font-size: 14px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 10px;
        display: block;
    }

    .form-group label .text-danger {
        color: var(--danger-color);
        margin-left: 4px;
    }

    .form-group label .text-muted {
        font-weight: 400;
        color: var(--muted-text);
        font-size: 13px;
    }

    /* Form Controls */
    .form-control {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 12px 16px;
        font-size: 14px;
        color: #495057;
        background: #fff;
        transition: all 0.3s ease;
    }

    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
        outline: none;
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    .form-control.is-invalid {
        border-color: var(--danger-color);
    }

    .form-control.is-invalid:focus {
        box-shadow: 0 0 0 3px rgba(220, 53, 69, 0.1);
    }

    /* Textarea */
    textarea.form-control {
        resize: vertical;
        min-height: 100px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Select */
    select.form-control {
        cursor: pointer;
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 12px center;
        background-size: 16px 12px;
        padding-right: 36px;
    }

    /* Input Groups */
    .input-group {
        position: relative;
        display: flex;
        flex-wrap: wrap;
        align-items: stretch;
        width: 100%;
    }

    .input-group-prepend {
        margin-right: -1px;
        display: flex;
    }

    .input-group-text {
        display: flex;
        align-items: center;
        padding: 12px 16px;
        font-size: 14px;
        font-weight: 400;
        color: #495057;
        text-align: center;
        white-space: nowrap;
        background-color: var(--bg-light);
        border: 1px solid var(--border-color);
        border-radius: 8px 0 0 8px;
    }

    .input-group > .form-control {
        position: relative;
        flex: 1 1 auto;
        width: 1%;
        min-width: 0;
        margin-bottom: 0;
        border-radius: 0 8px 8px 0;
    }

    /* Custom File Input */
    .custom-file {
        position: relative;
        display: inline-block;
        width: 100%;
        margin-bottom: 0;
    }

    .custom-file-input {
        position: relative;
        z-index: 2;
        width: 100%;
        height: calc(2.5em + 0.75rem + 2px);
        margin: 0;
        opacity: 0;
        cursor: pointer;
    }

    .custom-file-label {
        position: absolute;
        top: 0;
        right: 0;
        left: 0;
        z-index: 1;
        height: calc(2.5em + 0.75rem + 2px);
        padding: 12px 16px;
        font-weight: 400;
        line-height: 1.5;
        color: #495057;
        background-color: #fff;
        border: 2px dashed var(--border-color);
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .custom-file-label::after {
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        z-index: 3;
        display: block;
        height: calc(2.5em + 0.75rem);
        padding: 12px 16px;
        line-height: 1.5;
        color: #495057;
        content: "Browse";
        background: var(--bg-light);
        border-left: inherit;
        border-radius: 0 8px 8px 0;
    }

    .custom-file-input:hover ~ .custom-file-label {
        border-color: var(--primary-color);
        background: rgba(242, 97, 36, 0.03);
    }

    .custom-file-input:focus ~ .custom-file-label {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    /* Current Media Section */
    .current-media-section {
        background: var(--bg-light);
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 20px;
        margin-bottom: 16px;
    }

    .current-media-section p strong {
        color: var(--dark-text);
        font-weight: 600;
    }

    .current-media-section img,
    .current-media-section video {
        border-radius: 8px;
        border: 2px solid var(--border-color);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    /* Form Text */
    .form-text {
        display: block;
        margin-top: 8px;
        font-size: 13px;
        color: var(--muted-text);
        line-height: 1.5;
    }

    .form-text i {
        margin-right: 4px;
        color: var(--info-color);
    }

    /* Invalid Feedback */
    .invalid-feedback {
        display: block;
        margin-top: 8px;
        font-size: 13px;
        color: var(--danger-color);
        font-weight: 500;
    }

    /* Divider */
    .form-divider {
        border: 0;
        border-top: 2px solid var(--border-color);
        margin: 32px 0;
    }

    /* Buttons */
    .btn {
        border-radius: 8px;
        padding: 11px 24px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-lg {
        padding: 13px 28px;
        font-size: 15px;
    }

    .btn-success {
        background: var(--success-color);
        color: #fff;
    }

    .btn-success:hover {
        background: #17a673;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        color: #fff;
    }

    .btn-outline-secondary {
        background: transparent;
        color: #6c757d;
        border: 2px solid var(--border-color);
    }

    .btn-outline-secondary:hover {
        background: var(--bg-light);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        color: #6c757d;
    }

    .btn i {
        font-size: 15px;
    }

    /* Form Footer */
    .form-footer {
        border-top: 2px solid var(--border-color);
        padding-top: 24px;
        margin-top: 32px;
        display: flex;
        gap: 12px;
    }

    /* Sidebar Cards */
    .sidebar-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
        overflow: hidden;
        margin-bottom: 24px;
    }

    .sidebar-card .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #f0f0f0 100%);
        border: none;
        border-bottom: 2px solid var(--border-color);
        padding: 20px 24px;
    }

    .sidebar-card .card-header h6 {
        font-size: 15px;
        font-weight: 700;
        color: var(--dark-text);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .sidebar-card .card-header h6 i {
        color: var(--primary-color);
        font-size: 16px;
    }

    .sidebar-card .card-body {
        padding: 24px;
    }

    .sidebar-card h6 {
        font-size: 14px;
        font-weight: 700;
        color: var(--dark-text);
        margin-bottom: 12px;
    }

    .sidebar-card ul {
        padding-left: 20px;
        margin-bottom: 0;
    }

    .sidebar-card ul li {
        margin-bottom: 8px;
        color: var(--muted-text);
        line-height: 1.6;
    }

    .sidebar-card ul li:last-child {
        margin-bottom: 0;
    }

    /* Best Practices List */
    .best-practices-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .best-practices-list li {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        margin-bottom: 12px;
        color: var(--muted-text);
        line-height: 1.5;
    }

    .best-practices-list li:last-child {
        margin-bottom: 0;
    }

    .best-practices-list li i {
        color: var(--success-color);
        margin-top: 2px;
        flex-shrink: 0;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .carousel-form-container {
            padding: 16px 0;
        }

        .form-card .card-header,
        .form-card .card-body {
            padding: 20px;
        }

        .sidebar-card .card-header,
        .sidebar-card .card-body {
            padding: 16px 20px;
        }

        .form-footer {
            flex-direction: column;
        }

        .form-footer .btn {
            width: 100%;
            justify-content: center;
        }
    }

    @media (max-width: 768px) {
        .form-card .card-header h6 {
            font-size: 16px;
        }

        .form-group {
            margin-bottom: 24px;
        }

        .btn-lg {
            padding: 12px 24px;
            font-size: 14px;
        }
    }
</style>

<div class="carousel-form-container">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-8 mb-4">
                <div class="form-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-images"></i> 
                            <?php echo $is_edit ? 'Edit Carousel Slide' : 'Add New Carousel Slide'; ?>
                        </h6>
                    </div>

                    <div class="card-body">
                       <?php echo form_open_multipart(current_url(), array('id' => 'carouselForm')); ?>

                            <!-- Title -->
                            <div class="form-group">
                                <label for="title">
                                    Slide Title <span class="text-danger">*</span>
                                </label>
                                <input type="text" 
                                       name="title" 
                                       id="title" 
                                       class="form-control <?php echo form_error('title') ? 'is-invalid' : ''; ?>" 
                                       value="<?php echo set_value('title', $is_edit ? $item->title : ''); ?>" 
                                       placeholder="e.g., Welcome to Our NGO"
                                       required
                                       maxlength="255">
                                <?php if (form_error('title')): ?>
                                    <div class="invalid-feedback"><?php echo form_error('title'); ?></div>
                                <?php endif; ?>
                                <small class="form-text">Main heading text for the slide</small>
                            </div>

                            <!-- Subtitle -->
                            <div class="form-group">
                                <label for="subtitle">
                                    Subtitle <span class="text-muted">(Optional)</span>
                                </label>
                                <input type="text" 
                                       name="subtitle" 
                                       id="subtitle" 
                                       class="form-control" 
                                       value="<?php echo set_value('subtitle', $is_edit ? $item->subtitle : ''); ?>"
                                       placeholder="e.g., Making a Difference Together">
                                <small class="form-text">Secondary heading or tagline</small>
                            </div>

                            <!-- Description -->
                            <div class="form-group">
                                <label for="description">
                                    Description <span class="text-muted">(Optional)</span>
                                </label>
                                <textarea name="description" 
                                          id="description" 
                                          class="form-control" 
                                          rows="3" 
                                          placeholder="Brief description or call-to-action text..."><?php echo set_value('description', $is_edit ? $item->description : ''); ?></textarea>
                                <small class="form-text">Additional text to display on the slide</small>
                            </div>

                            <!-- Media Type -->
                            <div class="form-group">
                                <label for="media_type">
                                    Media Type <span class="text-danger">*</span>
                                </label>
                                <select name="media_type" 
                                        id="media_type" 
                                        class="form-control <?php echo form_error('media_type') ? 'is-invalid' : ''; ?>" 
                                        required>
                                    <option value="">-- Select Media Type --</option>
                                    <option value="image" <?php echo set_select('media_type', 'image', $is_edit && $item->media_type === 'image'); ?>>
                                        Image
                                    </option>
                                    <option value="video" <?php echo set_select('media_type', 'video', $is_edit && $item->media_type === 'video'); ?>>
                                        Video
                                    </option>
                                </select>
                                <?php if (form_error('media_type')): ?>
                                    <div class="invalid-feedback"><?php echo form_error('media_type'); ?></div>
                                <?php endif; ?>
                            </div>

                            <!-- Media File Upload -->
                            <div class="form-group">
                                <label for="media_file">
                                    Media File <?php echo $is_edit ? '' : '<span class="text-danger">*</span>'; ?>
                                </label>

                                <?php if ($is_edit && !empty($item->media_path)): ?>
                                    <div class="current-media-section">
                                        <p class="text-muted mb-3"><strong>Current Media:</strong></p>
                                        
                                        <?php if ($item->media_type === 'image'): ?>
                                            <img src="<?php echo base_url('uploads/carousel/' . $item->media_path); ?>" 
                                                 alt="<?php echo htmlspecialchars($item->title); ?>" 
                                                 class="img-fluid" 
                                                 style="max-height: 300px; width: 100%; object-fit: contain;">
                                        <?php elseif ($item->media_type === 'video'): ?>
                                            <video controls class="w-100" style="max-height: 300px;">
                                                <source src="<?php echo base_url('uploads/carousel/' . $item->media_path); ?>" type="video/mp4">
                                                Your browser does not support the video tag.
                                            </video>
                                        <?php endif; ?>
                                        
                                        <p class="mt-3 mb-0 text-muted">
                                            <small><strong>File:</strong> <?php echo $item->media_path; ?></small>
                                        </p>
                                    </div>
                                <?php endif; ?>

                                <div class="custom-file">
                                    <input type="file" 
                                           name="media_file" 
                                           id="media_file" 
                                           class="custom-file-input" 
                                           accept="image/*,video/*"
                                           <?php echo $is_edit ? '' : 'required'; ?>>
                                    <label class="custom-file-label" for="media_file">
                                        <?php echo $is_edit ? 'Choose new media file...' : 'Choose media file...'; ?>
                                    </label>
                                </div>
                                <small class="form-text">
                                    <i class="fas fa-info-circle"></i> 
                                    <strong>Images:</strong> JPG, PNG - Recommended size: 1920x1080px (16:9) - Max 5MB<br>
                                    <strong>Videos:</strong> MP4, WebM - Max 50MB
                                </small>
                            </div>

                            <hr class="form-divider">

                            <!-- Link URL -->
                            <div class="form-group">
                                <label for="link_url">
                                    Button Link URL <span class="text-muted">(Optional)</span>
                                </label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-link"></i>
                                        </span>
                                    </div>
                                    <input type="url" 
                                           name="link_url" 
                                           id="link_url" 
                                           class="form-control" 
                                           value="<?php echo set_value('link_url', $is_edit ? $item->link_url : ''); ?>"
                                           placeholder="https://example.com/page">
                                </div>
                                <small class="form-text">URL where the button should link to</small>
                            </div>

                            <!-- Link Text -->
                            <div class="form-group">
                                <label for="link_text">
                                    Button Text <span class="text-muted">(Optional)</span>
                                </label>
                                <input type="text" 
                                       name="link_text" 
                                       id="link_text" 
                                       class="form-control" 
                                       value="<?php echo set_value('link_text', $is_edit ? $item->link_text : ''); ?>"
                                       placeholder="e.g., Learn More, Get Involved, Donate Now">
                                <small class="form-text">Text to display on the button (defaults to "Learn More")</small>
                            </div>

                            <!-- Display Order -->
                            <div class="form-group">
                                <label for="display_order">
                                    Display Order
                                </label>
                                <input type="number" 
                                       name="display_order" 
                                       id="display_order" 
                                       class="form-control" 
                                       value="<?php echo set_value('display_order', $is_edit ? $item->display_order : '0'); ?>"
                                       min="0"
                                       placeholder="0">
                                <small class="form-text">
                                    <i class="fas fa-info-circle"></i> Lower numbers appear first (0 = default). You can also drag & drop to reorder.
                                </small>
                            </div>

                            <!-- Submit Buttons -->
                            <div class="form-footer">
                                <button type="submit" class="btn btn-success btn-lg">
                                    <i class="fas fa-save"></i> 
                                    <?php echo $is_edit ? 'Update Slide' : 'Add Slide'; ?>
                                </button>

                                <a href="<?php echo base_url('admin/carousel'); ?>" class="btn btn-outline-secondary btn-lg">
                                    <i class="fas fa-times"></i> Cancel
                                </a>
                            </div>

                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Status -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-cog"></i> Settings
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-0">
                            <label for="status">Status</label>
                            <select name="status" id="status" class="form-control" form="carouselForm">
                                <option value="active" <?php echo set_select('status', 'active', !$is_edit || ($is_edit && $item->status === 'active')); ?>>
                                    Active
                                </option>
                                <option value="inactive" <?php echo set_select('status', 'inactive', $is_edit && $item->status === 'inactive'); ?>>
                                    Inactive
                                </option>
                            </select>
                            <small class="form-text">
                                Active slides will be displayed on the homepage carousel
                            </small>
                        </div>
                    </div>
                </div>

                <!-- Media Guidelines -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-info-circle"></i> Media Guidelines
                        </h6>
                    </div>
                    <div class="card-body">
                        <h6>Images:</h6>
                        <ul class="small mb-3">
                            <li>Format: JPG or PNG</li>
                            <li>Size: 1920x1080px (16:9 ratio)</li>
                            <li>Max file size: 5MB</li>
                            <li>High quality, well-lit photos</li>
                        </ul>

                        <h6>Videos:</h6>
                        <ul class="small mb-0">
                            <li>Format: MP4 or WebM</li>
                            <li>Resolution: 1920x1080px recommended</li>
                            <li>Max file size: 50MB</li>
                            <li>Keep duration under 30 seconds</li>
                        </ul>
                    </div>
                </div>

                <!-- Tips -->
                <div class="sidebar-card">
                    <div class="card-header">
                        <h6>
                            <i class="fas fa-lightbulb"></i> Best Practices
                        </h6>
                    </div>
                    <div class="card-body">
                        <ul class="best-practices-list">
                            <li>
                                <i class="fas fa-check"></i> 
                                <span>Use high-quality, relevant images</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i> 
                                <span>Keep text concise and readable</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i> 
                                <span>Use clear calls-to-action</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i> 
                                <span>Maintain consistent styling</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i> 
                                <span>Limit to 3-5 active slides</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i> 
                                <span>Test on mobile devices</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
// Update file input label when file is selected
document.getElementById('media_file').addEventListener('change', function() {
    const fileName = this.files[0]?.name || '<?php echo $is_edit ? "Choose new media file..." : "Choose media file..."; ?>';
    this.nextElementSibling.textContent = fileName;
    
    // Add visual feedback
    if (this.files[0]) {
        this.nextElementSibling.style.borderColor = 'var(--success-color)';
        this.nextElementSibling.style.background = 'rgba(28, 200, 138, 0.05)';
    }
});

// Form validation
document.getElementById('carouselForm').addEventListener('submit', function(e) {
    const title = document.getElementById('title').value.trim();
    const mediaType = document.getElementById('media_type').value;
    const mediaFile = document.getElementById('media_file').files[0];

    if (!title) {
        e.preventDefault();
        alert('Please enter a slide title.');
        return false;
    }

    if (!mediaType) {
        e.preventDefault();
        alert('Please select media type.');
        return false;
    }

    <?php if (!$is_edit): ?>
    if (!mediaFile) {
        e.preventDefault();
        alert('Please upload a media file.');
        return false;
    }
    <?php endif; ?>

    // Check file size
    if (mediaFile) {
        const maxSize = mediaType === 'video' ? 50 * 1024 * 1024 : 5 * 1024 * 1024; // 50MB for video, 5MB for image
        if (mediaFile.size > maxSize) {
            e.preventDefault();
            alert('File size exceeds the maximum allowed (' + (maxSize / 1024 / 1024) + 'MB).');
            return false;
        }
    }

    return true;
});

// Auto-add https:// to link URL
document.getElementById('link_url').addEventListener('blur', function() {
    const url = this.value.trim();
    if (url && !url.match(/^https?:\/\//i)) {
        if (confirm('Link URL should start with http:// or https://. Add https:// automatically?')) {
            this.value = 'https://' + url;
        }
    }
});

// Show/hide link text field based on link URL
document.getElementById('link_url').addEventListener('input', function() {
    const linkTextGroup = document.getElementById('link_text').closest('.form-group');
    if (this.value.trim()) {
        linkTextGroup.style.display = 'block';
    }
});
</script>