<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Spacing Utilities */
    .mb-2 {
        margin-bottom: 0.5rem !important;
    }

    .mb-3 {
        margin-bottom: 1rem !important;
    }

    .mb-4 {
        margin-bottom: 1.5rem !important;
    }

    .mt-2 {
        margin-top: 0.5rem !important;
    }

    .mt-3 {
        margin-top: 1rem !important;
    }

    .my-4 {
        margin-top: 1.5rem !important;
        margin-bottom: 1.5rem !important;
    }

    .w-100 {
        width: 100%;
    }

    /* Text Utilities */
    h2 {
        font-size: 28px;
        font-weight: 700;
        color: #231f20;
        margin-bottom: 8px;
    }

    h5 {
        font-size: 16px;
        font-weight: 700;
        color: #231f20;
    }

    p {
        font-size: 14px;
        color: #6c757d;
        margin-bottom: 0;
    }

    .text-muted {
        color: #6c757d !important;
    }

    .text-danger {
        color: var(--danger-red) !important;
    }

    .text-center {
        text-align: center;
    }

    small {
        font-size: 12px;
    }

    strong {
        font-weight: 700;
    }

    code {
        background: #f8f9fa;
        padding: 2px 6px;
        border-radius: 4px;
        color: #495057;
        font-family: 'Courier New', monospace;
        font-size: 12px;
    }

    /* Flexbox Utilities */
    .d-flex {
        display: flex;
    }

    .justify-content-between {
        justify-content: space-between;
    }

    .row {
        display: flex;
        gap: 24px;
        flex-wrap: wrap;
    }

    .col-lg-8 {
        flex: 0 0 calc(66.666% - 12px);
    }

    .col-lg-4 {
        flex: 0 0 calc(33.333% - 12px);
    }

    /* Card Styling */
    .table-card {
        background: #fff;
        border-radius: 12px;
        padding: 28px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: 1px solid #e9ecef;
        transition: all 0.3s ease;
    }

    .table-card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
    }

    /* Form Elements */
    .form-label {
        font-size: 14px;
        font-weight: 600;
        color: #231f20;
        margin-bottom: 8px;
        display: block;
    }

    .form-control,
    .form-select {
        display: block;
        width: 100%;
        padding: 10px 12px;
        font-size: 14px;
        color: #495057;
        background-color: #fff;
        border: 1px solid #dee2e6;
        border-radius: 6px;
        transition: all 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .form-control:focus,
    .form-select:focus {
        color: #495057;
        background-color: #fff;
        border-color: var(--primary-color);
        outline: 0;
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    .form-control.is-invalid,
    .form-select.is-invalid {
        border-color: var(--danger-red);
    }

    .form-control.is-invalid:focus,
    .form-select.is-invalid:focus {
        border-color: var(--danger-red);
        box-shadow: 0 0 0 3px rgba(220, 53, 69, 0.1);
    }

    .invalid-feedback {
        display: block;
        font-size: 12px;
        color: var(--danger-red);
        margin-top: 6px;
    }

    textarea.form-control {
        resize: vertical;
        min-height: 120px;
    }

    /* Buttons */
    .btn {
        font-size: 14px;
        font-weight: 600;
        padding: 10px 16px;
        border-radius: 6px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
    }

    .btn-secondary {
        background: #6c757d;
        color: #fff;
    }

    .btn-secondary:hover {
        background: #5a6268;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(108, 117, 125, 0.3);
    }

    .btn-outline-secondary {
        background: transparent;
        color: #231f20;
        border: 1px solid #dee2e6;
    }

    .btn-outline-secondary:hover {
        background: #f8f9fa;
        border-color: #231f20;
        transform: translateY(-1px);
    }

    .btn-sm {
        padding: 8px 12px;
        font-size: 12px;
    }

    /* Horizontal Rule */
    hr {
        border: none;
        border-top: 1px solid #e9ecef;
    }

    /* Image Preview */
    .img-fluid {
        max-width: 100%;
        height: auto;
    }

    .rounded {
        border-radius: 8px;
    }

    /* Icon Styling */
    i {
        margin-right: 2px;
    }

    /* Responsive */
    @media (max-width: 992px) {
        .col-lg-8 {
            flex: 0 0 100%;
        }

        .col-lg-4 {
            flex: 0 0 100%;
        }

        .row {
            gap: 20px;
        }
    }

    @media (max-width: 768px) {
        .table-card {
            padding: 18px;
        }

        h2 {
            font-size: 24px;
        }

        h5 {
            font-size: 14px;
        }

        .form-control,
        .form-select {
            padding: 10px;
            font-size: 13px;
        }

        .d-flex {
            flex-direction: column;
            gap: 12px;
        }

        .justify-content-between {
            justify-content: flex-start;
        }

        .btn {
            width: 100%;
            justify-content: center;
        }
    }

    @media (max-width: 576px) {
        .table-card {
            padding: 16px;
        }

        h2 {
            font-size: 20px;
        }

        h5 {
            font-size: 13px;
        }

        .form-control,
        .form-select {
            padding: 8px 10px;
            font-size: 13px;
        }

        .btn {
            padding: 8px 12px;
            font-size: 12px;
        }
    }
</style>

<!-- Page Header -->
<div class="mb-4">
    <h2><?php echo isset($post) ? 'Edit Post' : 'Add New Post'; ?></h2>
    <p class="text-muted">Create engaging content for your blog</p>
</div>

<!-- Blog Post Form -->
<div class="row">
    <div class="col-lg-8">
        <div class="table-card">
           <?php echo form_open_multipart(current_url(), array('id' => 'blogForm')); ?>
            
            <!-- Title -->
            <div class="mb-3">
                <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                <input type="text" 
                       class="form-control <?php echo form_error('title') ? 'is-invalid' : ''; ?>" 
                       id="title" 
                       name="title" 
                       value="<?php echo set_value('title', isset($post) ? $post->title : ''); ?>"
                       placeholder="Enter post title..."
                       required>
                <?php if(form_error('title')): ?>
                    <div class="invalid-feedback"><?php echo form_error('title'); ?></div>
                <?php endif; ?>
            </div>
            
            <!-- Excerpt -->
            <div class="mb-3">
                <label for="excerpt" class="form-label">Excerpt</label>
                <textarea class="form-control" 
                          id="excerpt" 
                          name="excerpt" 
                          rows="3"
                          placeholder="Brief summary of the post (optional)..."><?php echo set_value('excerpt', isset($post) ? $post->excerpt : ''); ?></textarea>
                <small class="text-muted">Optional short description displayed in listings</small>
            </div>
            
            <!-- Content -->
            <div class="mb-3">
                <label for="content" class="form-label">Content <span class="text-danger">*</span></label>
                <textarea class="form-control <?php echo form_error('content') ? 'is-invalid' : ''; ?>" 
                          id="content" 
                          name="content" 
                          rows="15"
                          placeholder="Enter your post content here. You can use HTML tags for formatting."
                          required><?php echo set_value('content', isset($post) ? $post->content : ''); ?></textarea>
                <?php if(form_error('content')): ?>
                    <div class="invalid-feedback"><?php echo form_error('content'); ?></div>
                <?php endif; ?>
                <small class="text-muted">You can use HTML tags like &lt;p&gt;, &lt;strong&gt;, &lt;em&gt;, &lt;ul&gt;, &lt;li&gt;, etc.</small>
            </div>
            
            <!-- SEO Section -->
            <hr class="my-4">
            <h5 class="mb-3"><i class="fas fa-search"></i> SEO Settings</h5>
            
            <div class="mb-3">
                <label for="meta_title" class="form-label">Meta Title</label>
                <input type="text" 
                       class="form-control" 
                       id="meta_title" 
                       name="meta_title" 
                       value="<?php echo set_value('meta_title', isset($post) ? $post->meta_title : ''); ?>"
                       placeholder="Leave blank to use post title"
                       maxlength="255">
                <small class="text-muted">Recommended: 50-60 characters</small>
            </div>
            
            <div class="mb-3">
                <label for="meta_description" class="form-label">Meta Description</label>
                <textarea class="form-control" 
                          id="meta_description" 
                          name="meta_description" 
                          rows="2"
                          maxlength="300"
                          placeholder="Brief description for search engines..."><?php echo set_value('meta_description', isset($post) ? $post->meta_description : ''); ?></textarea>
                <small class="text-muted">Recommended: 150-160 characters</small>
            </div>
            
            <div class="d-flex justify-content-between">
                <a href="<?php echo base_url('admin/blog'); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Posts
                </a>
                <div class="d-flex" style="gap: 12px;">
                    <button type="submit" name="status" value="draft" class="btn btn-outline-secondary">
                        <i class="fas fa-save"></i> Save as Draft
                    </button>
                    <button type="submit" name="status" value="published" class="btn btn-primary">
                        <i class="fas fa-check"></i> Publish Post
                    </button>
                </div>
            </div>
            
            <?php echo form_close(); ?>
        </div>
    </div>
    
    <!-- Sidebar -->
    <div class="col-lg-4">
        <!-- Category -->
        <div class="table-card mb-3">
            <h5 class="mb-3"><i class="fas fa-folder"></i> Category</h5>
            <select class="form-select <?php echo form_error('category_id') ? 'is-invalid' : ''; ?>" 
                    id="category_id" 
                    name="category_id" 
                    form="blogForm"
                    required>
                <option value="">Select Category</option>
                <?php if(!empty($categories)): ?>
                    <?php foreach($categories as $category): ?>
                        <option value="<?php echo $category->id; ?>" 
                                <?php echo set_select('category_id', $category->id, (isset($post) && $post->category_id == $category->id)); ?>>
                            <?php echo $category->name; ?>
                        </option>
                    <?php endforeach; ?>
                <?php endif; ?>
            </select>
            <?php if(form_error('category_id')): ?>
                <div class="invalid-feedback"><?php echo form_error('category_id'); ?></div>
            <?php endif; ?>
            <div class="mt-2">
                <a href="<?php echo base_url('admin/blog/categories'); ?>" class="btn btn-sm btn-outline-secondary w-100">
                    <i class="fas fa-cog"></i> Manage Categories
                </a>
            </div>
        </div>
        
        <!-- Featured Image -->
        <div class="table-card mb-3">
            <h5 class="mb-3"><i class="fas fa-image"></i> Featured Image</h5>
            
            <?php if(isset($post) && $post->featured_image): ?>
            <div class="mb-3 text-center">
                <img src="<?php echo base_url('uploads/blog/' . $post->featured_image); ?>" 
                     class="img-fluid rounded" 
                     alt="Current featured image"
                     style="max-height: 200px;">
                <p class="text-muted small mt-2">Current Image</p>
            </div>
            <?php endif; ?>
            
            <input type="file" 
                   class="form-control" 
                   id="featured_image" 
                   name="featured_image" 
                   accept="image/*"
                   form="blogForm">
            <small class="text-muted">Recommended: 1200x630px, Max: 3MB</small>
            
            <div id="imagePreview" class="mt-3 text-center" style="display:none;">
                <img id="previewImg" src="" class="img-fluid rounded" style="max-height: 200px;">
            </div>
        </div>
        
        <!-- Post Info -->
        <?php if(isset($post)): ?>
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-info-circle"></i> Post Info</h5>
            <div class="mb-2">
                <small class="text-muted">Created:</small><br>
                <strong><?php echo format_datetime($post->created_at); ?></strong>
            </div>
            <?php if($post->published_at): ?>
            <div class="mb-2">
                <small class="text-muted">Published:</small><br>
                <strong><?php echo format_datetime($post->published_at); ?></strong>
            </div>
            <?php endif; ?>
            <div class="mb-2">
                <small class="text-muted">Views:</small><br>
                <strong><?php echo $post->views_count; ?></strong>
            </div>
            <div class="mb-2">
                <small class="text-muted">Slug:</small><br>
                <code><?php echo $post->slug; ?></code>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Simple JavaScript for Image Preview -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Image Preview
    const featuredImageInput = document.getElementById('featured_image');
    if (featuredImageInput) {
        featuredImageInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('previewImg').src = e.target.result;
                    document.getElementById('imagePreview').style.display = 'block';
                };
                reader.readAsDataURL(file);
            }
        });
    }
});
</script>