<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - Admin</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary-color: #f26124;
            --secondary-color: #231f20;
        }
        
        body {
            background: linear-gradient(135deg, var(--secondary-color) 0%, var(--secondary-color) 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .forgot-container {
            width: 100%;
            max-width: 450px;
            padding: 20px;
        }
        
        .forgot-card {
            background: #fff;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        
        .forgot-header {
            background: var(--primary-color);
            color: #fff;
            padding: 40px 30px;
            text-align: center;
        }
        
        .forgot-header h1 {
            font-size: 24px;
            margin: 0 0 10px;
            font-weight: bold;
        }
        
        .forgot-header p {
            margin: 0;
            opacity: 0.9;
            font-size: 14px;
        }
        
        .forgot-body {
            padding: 40px 30px;
        }
        
        .form-floating {
            margin-bottom: 20px;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(242, 97, 36, 0.25);
        }
        
        .btn-submit {
            width: 100%;
            padding: 12px;
            background: var(--primary-color);
            border: none;
            color: #fff;
            font-weight: bold;
            border-radius: 8px;
            transition: all 0.3s;
        }
        
        .btn-submit:hover {
            background: #d95520;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(242, 97, 36, 0.3);
        }
        
        .forgot-footer {
            text-align: center;
            margin-top: 20px;
        }
        
        .forgot-footer a {
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .forgot-footer a:hover {
            text-decoration: underline;
        }
        
        .alert {
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="forgot-container">
        <div class="forgot-card">
            <div class="forgot-header">
                <a class="navbar-brand" href="<?php echo base_url(); ?>">
			<img src="<?php echo base_url('assets/images/logo2.png'); ?>" alt="Logo" height="40">
		    </a>
                <h1>Forgot Password?</h1>
                <p>Enter your email to reset your password</p>
            </div>
            
            <div class="forgot-body">
                <!-- Flash Messages -->
                <?php if($this->session->flashdata('message')): ?>
                    <div class="alert alert-<?php echo $this->session->flashdata('message_type'); ?> alert-dismissible fade show" role="alert">
                        <?php echo $this->session->flashdata('message'); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <!-- Info Alert -->
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i> Enter your registered email address and we'll send you instructions to reset your password.
                </div>
                
                <!-- Forgot Password Form -->
                <?php echo form_open('admin/forgot-password'); ?>
                    
                    <div class="form-floating mb-3">
                        <input type="email" 
                               class="form-control <?php echo form_error('email') ? 'is-invalid' : ''; ?>" 
                               id="email" 
                               name="email" 
                               placeholder="name@example.com"
                               value="<?php echo set_value('email'); ?>"
                               required
                               autofocus>
                        <label for="email"><i class="fas fa-envelope"></i> Email Address</label>
                        <?php if(form_error('email')): ?>
                            <div class="invalid-feedback"><?php echo form_error('email'); ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <button type="submit" class="btn btn-submit">
                        <i class="fas fa-paper-plane"></i> Send Reset Link
                    </button>
                    
                <?php echo form_close(); ?>
                
                <div class="forgot-footer">
                    <a href="<?php echo base_url('admin/login'); ?>">
                        <i class="fas fa-arrow-left"></i> Back to Login
                    </a>
                </div>
            </div>
        </div>
        
        <div class="text-center mt-4">
            <small class="text-white-50">
                &copy; <?php echo date('Y'); ?> Atelier. All rights reserved.
            </small>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>