<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Media_category_model extends CI_Model {
    private $table = 'media_categories';

    /**
     * Get all active categories
     * @return array Active media categories
     */
    public function get_active_categories() {
        return $this->db->where('status', 'active')
                        ->order_by('name', 'ASC')
                        ->get($this->table)
                        ->result();
    }

    /**
     * Get all categories
     * @return array All media categories
     */
    public function get_all_categories() {
        return $this->db->order_by('name', 'ASC')
                        ->get($this->table)
                        ->result();
    }

    /**
     * Get a specific category by ID
     * @param int $id Category ID
     * @return object|null Category
     */
    public function get_category_by_id($id) {
        return $this->db->where('id', $id)
                        ->get($this->table)
                        ->row();
    }

    /**
     * Create a new media category
     * @param array $data Category data
     * @return int|bool Inserted ID or FALSE
     */
    public function create_category($data) {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

    /**
     * Update a media category
     * @param int $id Category ID
     * @param array $data Updated category data
     * @return bool Success status
     */
    public function update_category($id, $data) {
        return $this->db->where('id', $id)
                        ->update($this->table, $data);
    }

    /**
     * Delete a media category
     * @param int $id Category ID
     * @return bool Success status
     */
    public function delete_category($id) {
        // Check if category has associated media
        $media_count = $this->db->where('category_id', $id)
                                ->count_all_results('media');
        
        if ($media_count > 0) {
            // Prevent deletion if media exists
            return FALSE;
        }
        
        return $this->db->where('id', $id)
                        ->delete($this->table);
    }

    /**
     * Get media count for each category
     * @return array Category media counts
     */
    public function get_category_media_counts() {
        return $this->db->select('mc.id, mc.name, COUNT(m.id) as media_count')
                        ->from($this->table . ' mc')
                        ->join('media m', 'mc.id = m.category_id', 'left')
                        ->group_by('mc.id, mc.name')
                        ->order_by('media_count', 'DESC')
                        ->get()
                        ->result();
    }
}