<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Custom Email Helper Functions
 * Location: application/helpers/MY_email_helper.php
 * 
 * Load in controller: $this->load->helper('MY_email');
 */

if (!function_exists('send_email')) {
    /**
     * Send email using CodeIgniter email library
     * 
     * @param string $to Recipient email
     * @param string $subject Email subject
     * @param string $message Email message (HTML)
     * @param string $from_email Optional from email
     * @param string $from_name Optional from name
     * @return bool Success status
     */
    function send_email($to, $subject, $message, $from_email = null, $from_name = null) {
        $CI =& get_instance();
        $CI->load->library('email');
        $CI->load->model('Common_model');
        
        // Get default from email and name if not provided
        if (!$from_email) {
            $from_email = $CI->Common_model->get_setting('site_email') ?: 'noreply@ngoplatform.com';
        }
        if (!$from_name) {
            $from_name = $CI->Common_model->get_setting('site_name') ?: 'NGO Platform';
        }
        
        // Configure email
        $CI->email->from($from_email, $from_name);
        $CI->email->to($to);
        $CI->email->subject($subject);
        $CI->email->message($message);
        
        // Send email
        $result = $CI->email->send();
        
        // Log email
        $log_data = array(
            'recipient_email' => $to,
            'subject' => $subject,
            'message' => $message,
            'status' => $result ? 'sent' : 'failed',
            'error_message' => $result ? null : $CI->email->print_debugger()
        );
        $CI->Common_model->log_email($log_data);
        
        return $result;
    }
}

if (!function_exists('send_consultation_confirmation')) {
    /**
     * Send consultation request confirmation email
     * 
     * @param object $consultation Consultation data
     * @return bool Success status
     */
    function send_consultation_confirmation($consultation) {
        $CI =& get_instance();
        $CI->load->model('Common_model');
        
        $site_name = $CI->Common_model->get_setting('site_name') ?: 'NGO Platform';
        
        $subject = "Consultation Request Received - $site_name";
        
        $message = '
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: #f26124; color: white; padding: 20px; text-align: center; }
                .content { background: #f9f9f9; padding: 20px; }
                .footer { text-align: center; padding: 20px; font-size: 12px; color: #666; }
                .info-row { margin: 10px 0; }
                .label { font-weight: bold; color: #231f20; }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="header">
                    <h1>' . $site_name . '</h1>
                    <p>Consultation Request Confirmation</p>
                </div>
                <div class="content">
                    <p>Dear ' . htmlspecialchars($consultation->full_name) . ',</p>
                    
                    <p>Thank you for requesting a free 1-on-1 consultation with us. We have received your request and will get back to you within 24-48 hours.</p>
                    
                    <h3>Your Request Details:</h3>
                    <div class="info-row">
                        <span class="label">Subject:</span> ' . htmlspecialchars($consultation->subject) . '
                    </div>
                    <div class="info-row">
                        <span class="label">Type:</span> ' . ucfirst($consultation->consultation_type) . '
                    </div>
                    ' . ($consultation->preferred_date ? '<div class="info-row"><span class="label">Preferred Date:</span> ' . date('F j, Y', strtotime($consultation->preferred_date)) . '</div>' : '') . '
                    ' . ($consultation->preferred_time ? '<div class="info-row"><span class="label">Preferred Time:</span> ' . date('g:i A', strtotime($consultation->preferred_time)) . '</div>' : '') . '
                    
                    <p>If you have any urgent questions, please feel free to contact us directly.</p>
                    
                    <p>Best regards,<br>The ' . $site_name . ' Team</p>
                </div>
                <div class="footer">
                    <p>This is an automated message. Please do not reply to this email.</p>
                </div>
            </div>
        </body>
        </html>
        ';
        
        return send_email($consultation->email, $subject, $message);
    }
}

if (!function_exists('send_consultation_notification_to_admin')) {
    /**
     * Send consultation request notification to admin
     * 
     * @param object $consultation Consultation data
     * @return bool Success status
     */
    function send_consultation_notification_to_admin($consultation) {
        $CI =& get_instance();
        $CI->load->model('Common_model');
        
        $site_name = $CI->Common_model->get_setting('site_name') ?: 'NGO Platform';
        $admin_email = $CI->Common_model->get_setting('site_email') ?: 'admin@ngoplatform.com';
        
        $subject = "New Consultation Request - $site_name";
        
        $message = '
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: #231f20; color: white; padding: 20px; }
                .content { background: #fff; padding: 20px; border: 1px solid #ddd; }
                .info-row { margin: 10px 0; padding: 10px; background: #f7e1b0; }
                .label { font-weight: bold; color: #231f20; }
                .button { display: inline-block; padding: 10px 20px; background: #f26124; color: white; text-decoration: none; border-radius: 5px; margin: 20px 0; }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="header">
                    <h2>New Consultation Request</h2>
                </div>
                <div class="content">
                    <div class="info-row">
                        <span class="label">Name:</span> ' . htmlspecialchars($consultation->full_name) . '
                    </div>
                    <div class="info-row">
                        <span class="label">Email:</span> ' . htmlspecialchars($consultation->email) . '
                    </div>
                    <div class="info-row">
                        <span class="label">Phone:</span> ' . htmlspecialchars($consultation->phone) . '
                    </div>
                    ' . ($consultation->organization ? '<div class="info-row"><span class="label">Organization:</span> ' . htmlspecialchars($consultation->organization) . '</div>' : '') . '
                    <div class="info-row">
                        <span class="label">Type:</span> ' . ucfirst($consultation->consultation_type) . '
                    </div>
                    <div class="info-row">
                        <span class="label">Subject:</span> ' . htmlspecialchars($consultation->subject) . '
                    </div>
                    <div class="info-row">
                        <span class="label">Message:</span><br>' . nl2br(htmlspecialchars($consultation->message)) . '
                    </div>
                    ' . ($consultation->preferred_date ? '<div class="info-row"><span class="label">Preferred Date:</span> ' . date('F j, Y', strtotime($consultation->preferred_date)) . '</div>' : '') . '
                    ' . ($consultation->preferred_time ? '<div class="info-row"><span class="label">Preferred Time:</span> ' . date('g:i A', strtotime($consultation->preferred_time)) . '</div>' : '') . '
                    
                    <a href="' . base_url('admin/consultations/view/' . $consultation->id) . '" class="button">View in Admin Panel</a>
                </div>
            </div>
        </body>
        </html>
        ';
        
        return send_email($admin_email, $subject, $message);
    }
}

if (!function_exists('send_volunteer_confirmation')) {
    /**
     * Send volunteer application confirmation email
     * 
     * @param object $volunteer Volunteer data
     * @return bool Success status
     */
    function send_volunteer_confirmation($volunteer) {
        $CI =& get_instance();
        $CI->load->model('Common_model');
        
        $site_name = $CI->Common_model->get_setting('site_name') ?: 'NGO Platform';
        
        $subject = "Volunteer Application Received - $site_name";
        
        $message = '
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: #8105bf; color: white; padding: 20px; text-align: center; }
                .content { background: #f9f9f9; padding: 20px; }
                .footer { text-align: center; padding: 20px; font-size: 12px; color: #666; }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="header">
                    <h1>' . $site_name . '</h1>
                    <p>Volunteer Application Confirmation</p>
                </div>
                <div class="content">
                    <p>Dear ' . htmlspecialchars($volunteer->full_name) . ',</p>
                    
                    <p>Thank you for your interest in volunteering with us! We have received your application and are excited about the possibility of you joining our team.</p>
                    
                    <p>Our team will review your application and get back to you within 5-7 business days.</p>
                    
                    <p>We appreciate your willingness to contribute to our mission and make a positive impact in our community.</p>
                    
                    <p>If you have any questions, please feel free to contact us.</p>
                    
                    <p>Best regards,<br>The ' . $site_name . ' Volunteer Team</p>
                </div>
                <div class="footer">
                    <p>This is an automated message. Please do not reply to this email.</p>
                </div>
            </div>
        </body>
        </html>
        ';
        
        return send_email($volunteer->email, $subject, $message);
    }
}

if (!function_exists('send_volunteer_approval')) {
    /**
     * Send volunteer approval email
     * 
     * @param object $volunteer Volunteer data
     * @return bool Success status
     */
    function send_volunteer_approval($volunteer) {
        $CI =& get_instance();
        $CI->load->model('Common_model');
        
        $site_name = $CI->Common_model->get_setting('site_name') ?: 'NGO Platform';
        
        $subject = "Volunteer Application Approved - $site_name";
        
        $message = '
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: #28a745; color: white; padding: 20px; text-align: center; }
                .content { background: #f9f9f9; padding: 20px; }
                .footer { text-align: center; padding: 20px; font-size: 12px; color: #666; }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="header">
                    <h1>Congratulations!</h1>
                    <p>Your Volunteer Application Has Been Approved</p>
                </div>
                <div class="content">
                    <p>Dear ' . htmlspecialchars($volunteer->full_name) . ',</p>
                    
                    <p>We are delighted to inform you that your volunteer application has been approved!</p>
                    
                    <p>Welcome to the ' . $site_name . ' volunteer family. We are excited to have you on board and look forward to working together to make a positive impact.</p>
                    
                    <p>Our volunteer coordinator will contact you soon with more details about upcoming opportunities and orientation.</p>
                    
                    <p>Thank you for choosing to volunteer with us!</p>
                    
                    <p>Best regards,<br>The ' . $site_name . ' Team</p>
                </div>
                <div class="footer">
                    <p>This is an automated message. Please do not reply to this email.</p>
                </div>
            </div>
        </body>
        </html>
        ';
        
        return send_email($volunteer->email, $subject, $message);
    }
}

if (!function_exists('send_contact_confirmation')) {
    /**
     * Send contact form confirmation email
     * 
     * @param object $contact Contact message data
     * @return bool Success status
     */
    function send_contact_confirmation($contact) {
        $CI =& get_instance();
        $CI->load->model('Common_model');
        
        $site_name = $CI->Common_model->get_setting('site_name') ?: 'NGO Platform';
        
        $subject = "Message Received - $site_name";
        
        $message = '
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: #f26124; color: white; padding: 20px; text-align: center; }
                .content { background: #f9f9f9; padding: 20px; }
                .footer { text-align: center; padding: 20px; font-size: 12px; color: #666; }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="header">
                    <h1>' . $site_name . '</h1>
                    <p>Message Confirmation</p>
                </div>
                <div class="content">
                    <p>Dear ' . htmlspecialchars($contact->name) . ',</p>
                    
                    <p>Thank you for contacting us. We have received your message and will respond as soon as possible.</p>
                    
                    <p><strong>Subject:</strong> ' . htmlspecialchars($contact->subject) . '</p>
                    
                    <p>We typically respond within 24-48 hours during business days.</p>
                    
                    <p>Best regards,<br>The ' . $site_name . ' Team</p>
                </div>
                <div class="footer">
                    <p>This is an automated message. Please do not reply to this email.</p>
                </div>
            </div>
        </body>
        </html>
        ';
        
        return send_email($contact->email, $subject, $message);
    }
}