<?php
defined('BASEPATH') OR exit('No direct script access allowed');
// Manually load Admin_Controller if not autoloaded
if (!class_exists('Admin_Controller')) {
    require_once APPPATH . 'core/Admin_Controller.php';
}

/**
 * Admin Settings Controller
 * Handles site settings management
 * Location: application/controllers/admin/Settings.php
 */

class Settings extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        // Only super admins can access settings
        $this->check_role('super_admin');
    }

    /**
     * Settings page
     */
    public function index() {
        $this->set_title('Site Settings', 'Configure Your Website');
        $this->add_breadcrumb('Dashboard', 'admin/dashboard');
        $this->add_breadcrumb('Settings', null);

        // Get current settings
        $data['settings'] = $this->Common_model->get_all_settings();

        $this->render('settings/index', $data);
    }

    /**
     * Update settings
     */
    public function update() {
        if ($this->input->method() === 'post') {
            $settings_to_update = array(
                // General Settings
                'site_name' => $this->input->post('site_name', TRUE),
                'site_email' => $this->input->post('site_email', TRUE),
                'site_phone' => $this->input->post('site_phone', TRUE),
                'site_address' => $this->input->post('site_address', TRUE),
                'about_description' => $this->input->post('about_description', TRUE),
                
                // Social Media Links
                'facebook_url' => $this->input->post('facebook_url', TRUE),
                'twitter_url' => $this->input->post('twitter_url', TRUE),
                'instagram_url' => $this->input->post('instagram_url', TRUE),
                'linkedin_url' => $this->input->post('linkedin_url', TRUE),
                
                // Donation Settings
                'donation_bank_name' => $this->input->post('donation_bank_name', TRUE),
                'donation_account_number' => $this->input->post('donation_account_number', TRUE),
                'donation_account_name' => $this->input->post('donation_account_name', TRUE),
                'donation_mobile_money' => $this->input->post('donation_mobile_money', TRUE)
            );

            if ($this->Common_model->update_settings($settings_to_update)) {
                $this->log_activity('update', 'Updated site settings');
                set_flash_message('success', 'Settings updated successfully!');
            } else {
                set_flash_message('error', 'Failed to update settings. Please try again.');
            }

            redirect('admin/settings');
        }

        redirect('admin/settings');
    }

    /**
     * Email settings
     */
    /**
 * Email settings
 */
/**
 * Email settings
 */
public function email() {
    $this->set_title('Email Settings', 'Configure Email & SMTP');
    $this->add_breadcrumb('Dashboard', 'admin/dashboard');
    $this->add_breadcrumb('Settings', 'admin/settings');
    $this->add_breadcrumb('Email Settings', null);

    if ($this->input->method() === 'post') {
        // In a production app, these would be stored in database or config files
        // For now, we'll just show a success message
        set_flash_message('info', 'Email settings should be configured in application/config/email.php file.');
        redirect('admin/settings/email');
    }

    // ADD THIS LINE - Pass admin email to view
    $data['admin_email'] = isset($this->admin_data['email']) ? $this->admin_data['email'] : '';

    $this->render('settings/email', $data);  // Make sure $data is passed here
}
    /**
     * Backup database
     */
    public function backup() {
        $this->check_permission('delete'); // Only users with delete permission can backup
        
        $this->load->dbutil();
        
        // Backup configuration
        $prefs = array(
            'format' => 'zip',
            'filename' => 'ngo_platform_backup_' . date('Y-m-d_H-i-s') . '.sql'
        );

        // Backup database
        $backup = $this->dbutil->backup($prefs);

        // Force download
        $this->load->helper('download');
        force_download('ngo_platform_backup_' . date('Y-m-d_H-i-s') . '.zip', $backup);
        
        $this->log_activity('backup', 'Created database backup');
    }

    /**
     * Test email configuration
     */
    public function test_email() {
        if ($this->input->method() === 'post') {
            $test_email = $this->input->post('test_email', TRUE);
            
            if (empty($test_email) || !valid_email($test_email)) {
                $this->error_response('Please provide a valid email address');
                return;
            }

            // Send test email
            $subject = 'Test Email - NGO Platform';
            $message = '
            <h3>Test Email</h3>
            <p>This is a test email from your NGO Platform admin panel.</p>
            <p>If you receive this email, your email configuration is working correctly!</p>
            <p>Sent at: ' . date('Y-m-d H:i:s') . '</p>
            ';

            if (send_email($test_email, $subject, $message)) {
                $this->success_response('Test email sent successfully! Check your inbox.');
            } else {
                $this->error_response('Failed to send test email. Please check your email configuration.');
            }
        }
    }

    /**
     * Clear cache/logs
     */
    public function clear_cache() {
        $this->check_permission('delete');
        
        // Clear cache files
        $cache_path = APPPATH . 'cache/';
        $files = glob($cache_path . '*');
        $deleted = 0;
        
        foreach ($files as $file) {
            if (is_file($file) && $file != $cache_path . 'index.html' && $file != $cache_path . '.htaccess') {
                if (unlink($file)) {
                    $deleted++;
                }
            }
        }

        // Clear logs (keep last 7 days)
        $log_path = APPPATH . 'logs/';
        $log_files = glob($log_path . 'log-*.php');
        $seven_days_ago = strtotime('-7 days');
        
        foreach ($log_files as $file) {
            if (filemtime($file) < $seven_days_ago) {
                if (unlink($file)) {
                    $deleted++;
                }
            }
        }

        $this->log_activity('maintenance', 'Cleared cache and old logs');
        set_flash_message('success', $deleted . ' cache and log files cleared successfully!');
        redirect('admin/settings');
    }

    /**
     * System information
     */
    public function system_info() {
        $this->set_title('System Information', 'Server & Application Details');
        $this->add_breadcrumb('Dashboard', 'admin/dashboard');
        $this->add_breadcrumb('Settings', 'admin/settings');
        $this->add_breadcrumb('System Info', null);

        $data['system_info'] = array(
            'php_version' => phpversion(),
            'ci_version' => CI_VERSION,
            'server_software' => $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown',
            'database_version' => $this->db->version(),
            'max_upload_size' => ini_get('upload_max_filesize'),
            'max_post_size' => ini_get('post_max_size'),
            'memory_limit' => ini_get('memory_limit'),
            'max_execution_time' => ini_get('max_execution_time'),
            'timezone' => date_default_timezone_get(),
            'current_time' => date('Y-m-d H:i:s')
        );

        // Database statistics
        $data['db_stats'] = array(
            'blog_posts' => $this->db->count_all('blog_posts'),
            'volunteers' => $this->db->count_all('volunteers'),
            'consultations' => $this->db->count_all('consultation_requests'),
            'messages' => $this->db->count_all('contact_messages'),
            'workshops' => $this->db->count_all('workshop_programmes'),
            'partners' => $this->db->count_all('partners')
        );

        $this->render('settings/system_info', $data);
    }
}