<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Manually load Admin_Controller if not autoloaded
if (!class_exists('Admin_Controller')) {
    require_once APPPATH . 'core/Admin_Controller.php';
}

/**
 * Admin Profile Controller
 * Handles admin user profile management
 * Location: application/controllers/admin/Profile.php
 */

class Profile extends Admin_Controller {

    public function __construct() {
        parent::__construct();
    }

    /**
     * View profile
     */
    public function index() {
        $this->set_title('My Profile', 'Account Settings');
        $this->add_breadcrumb('Dashboard', 'admin/dashboard');
        $this->add_breadcrumb('My Profile', null);

        $data['admin'] = $this->Common_model->get_admin($this->admin_id);

        $this->render('profile/index', $data);
    }

    /**
     * Update profile information
     */
    public function update() {
        if ($this->input->method() === 'post') {
            $this->form_validation->set_rules('full_name', 'Full Name', 'required|max_length[150]');
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email|max_length[150]');
            $this->form_validation->set_rules('username', 'Username', 'required|max_length[100]|alpha_numeric');

            if ($this->form_validation->run() === TRUE) {
                // Check if username or email already exists (excluding current user)
                $username = $this->input->post('username', TRUE);
                $email = $this->input->post('email', TRUE);

                $this->db->where('id !=', $this->admin_id);
                $this->db->where('username', $username);
                if ($this->db->count_all_results('admin_users') > 0) {
                    set_flash_message('error', 'Username already taken.');
                    redirect('admin/profile');
                    return;
                }

                $this->db->where('id !=', $this->admin_id);
                $this->db->where('email', $email);
                if ($this->db->count_all_results('admin_users') > 0) {
                    set_flash_message('error', 'Email already taken.');
                    redirect('admin/profile');
                    return;
                }

                $data = array(
                    'full_name' => $this->input->post('full_name', TRUE),
                    'email' => $email,
                    'username' => $username
                );

                if ($this->Common_model->update_admin($this->admin_id, $data)) {
                    // Update session data
                    $admin_data = $this->session->userdata('admin_data');
                    $admin_data['full_name'] = $data['full_name'];
                    $admin_data['email'] = $data['email'];
                    $admin_data['username'] = $data['username'];
                    $this->session->set_userdata('admin_data', $admin_data);

                    $this->log_activity('update', 'Updated profile information');
                    set_flash_message('success', 'Profile updated successfully!');
                } else {
                    set_flash_message('error', 'Failed to update profile. Please try again.');
                }
            }
        }

        redirect('admin/profile');
    }

    /**
     * Change password
     */
    public function change_password() {
        $this->set_title('Change Password', 'Update Your Password');
        $this->add_breadcrumb('Dashboard', 'admin/dashboard');
        $this->add_breadcrumb('My Profile', 'admin/profile');
        $this->add_breadcrumb('Change Password', null);

        if ($this->input->method() === 'post') {
            $this->form_validation->set_rules('current_password', 'Current Password', 'required');
            $this->form_validation->set_rules('new_password', 'New Password', 'required|min_length[6]');
            $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|matches[new_password]');

            if ($this->form_validation->run() === TRUE) {
                $current_password = $this->input->post('current_password', TRUE);
                $new_password = $this->input->post('new_password', TRUE);

                // Change password using auth library
                $result = $this->auth_library->change_password($this->admin_id, $current_password, $new_password);

                if ($result['status']) {
                    $this->log_activity('security', 'Changed password');
                    set_flash_message('success', $result['message']);
                    redirect('admin/profile');
                } else {
                    set_flash_message('error', $result['message']);
                }
            }
        }

        $this->render('profile/change_password');
    }

    /**
     * Activity log
     */
    public function activity_log() {
        $this->set_title('Activity Log', 'Your Recent Activities');
        $this->add_breadcrumb('Dashboard', 'admin/dashboard');
        $this->add_breadcrumb('My Profile', 'admin/profile');
        $this->add_breadcrumb('Activity Log', null);

        // In a production app, you would have an activity_logs table
        // For now, we'll show a message
        $data['message'] = 'Activity logging is enabled. Check application logs for detailed information.';

        $this->render('profile/activity_log', $data);
    }
}