<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Manually load Frontend_Controller if not autoloaded
if (!class_exists('Frontend_Controller')) {
    require_once APPPATH . 'core/Frontend_Controller.php';
}

/**
 * Workshops Controller
 * Handles workshop programme listing and details
 * Location: application/controllers/Workshops.php
 */

class Workshops extends Frontend_Controller {

    public function __construct() {
        parent::__construct();
    }

    /**
     * Workshops listing page
     */
    public function index() {
        // Get all workshops grouped by status
        $data['upcoming_workshops'] = $this->Common_model->get_workshops('upcoming');
        $data['ongoing_workshops'] = $this->Common_model->get_workshops('ongoing');
        $data['completed_workshops'] = $this->Common_model->get_workshops('completed');

        // Set meta tags
        $this->set_meta(
            'Our Workshop Programmes',
            'Explore our comprehensive workshop programmes designed to empower and educate our community',
            'workshops, training, programmes, education, skill development, community workshops'
        );

        // Set page heading
        $this->set_heading('Our Workshop Programmes', 'Empowering Communities Through Education');

        // Breadcrumbs
        $this->add_breadcrumb('Home', base_url());
        $this->add_breadcrumb('Workshops', null);

        // Render view
        $this->render('workshops/index', $data);
    }

    /**
     * Single workshop details
     */
    public function view($slug) {
        // Get workshop by slug
        $workshop = $this->Common_model->get_workshop_by_slug($slug);

        if (!$workshop) {
            show_404();
        }

        $data['workshop'] = $workshop;

        // Get related workshops from same category or status
        $all_workshops = $this->Common_model->get_workshops($workshop->status);
        $data['related_workshops'] = array_slice(array_filter($all_workshops, function($w) use ($workshop) {
            return $w->id != $workshop->id;
        }), 0, 3);

        // Set meta tags
        $this->set_meta(
            $workshop->title,
            $workshop->description,
            'workshop, training, ' . strtolower($workshop->title)
        );

        // Set page heading
        $this->set_heading($workshop->title, $workshop->duration);

        // Breadcrumbs
        $this->add_breadcrumb('Home', base_url());
        $this->add_breadcrumb('Workshops', base_url('workshops'));
        $this->add_breadcrumb($workshop->title, null);

        // Render view
        $this->render('workshops/single', $data);
    }
}