<?php
defined('BASEPATH') OR exit('No direct script access allowed');


// Manually load Frontend_Controller if not autoloaded
if (!class_exists('Frontend_Controller')) {
    require_once APPPATH . 'core/Frontend_Controller.php';
}


/**
 * Pages Controller
 * Handles static pages (About Us, Donate, etc.)
 * Location: application/controllers/Pages.php
 */

class Pages extends Frontend_Controller {

    public function __construct() {
        parent::__construct();
        
        // Load required models
        $this->load->model('Volunteer_model');
		$this->load->model('Registration_model'); // Load registration model for learner counts
    }

    /**
     * About Us page
     */
    public function about() {
		
		 // Get learner counts from french_kid_learners and french_adult_learners tables
        $kids_count = $this->Registration_model->count_registrations('kid');
        $adults_count = $this->Registration_model->count_registrations('adult');
        $total_learners = $kids_count + $adults_count;
		
		
        // Get statistics
        $data['statistics'] = array(
            'volunteers' => $this->Volunteer_model->count_volunteers('active'),
            'workshops' => count($this->Common_model->get_workshops('completed')) + count($this->Common_model->get_workshops('ongoing')),
            'partners' => count($this->Common_model->get_partners('active')),
            'total_learners' => $total_learners // This would come from another model in real scenario
        );

        // Get some active volunteers for display
        $data['featured_volunteers'] = $this->Volunteer_model->get_active_volunteers(6);

        // Set meta tags
        $this->set_meta(
            'About Us',
            'Learn about our mission, vision, and the work we do to make a positive impact in our community',
            'about us, our mission, our vision, who we are, ngo mission'
        );

        // Set page heading
        $this->set_heading('About Us', 'Our Story, Mission & Vision');

        // Breadcrumbs
        $this->add_breadcrumb('Home', base_url());
        $this->add_breadcrumb('About Us', null);

        // Render view
        $this->render('pages/about', $data);
    }

    /**
     * Donate/Support Us page
     */
    public function donate() {
        // Get donation details from settings
        $data['donation_details'] = array(
            'bank_name' => $this->data['site_settings']['donation_bank_name'] ?? 'Bank Name',
            'account_number' => $this->data['site_settings']['donation_account_number'] ?? 'XXXX-XXXX-XXXX',
            'account_name' => $this->data['site_settings']['donation_account_name'] ?? 'NGO Platform',
            'mobile_money' => $this->data['site_settings']['donation_mobile_money'] ?? 'MTN/Vodafone: 0XX XXX XXXX'
        );

        // Impact statistics
        $data['impact_stats'] = array(
            'lives_impacted' => 1000,
            'workshops_held' => count($this->Common_model->get_workshops('completed')),
            'active_volunteers' => $this->Volunteer_model->count_volunteers('active'),
            'partners' => count($this->Common_model->get_partners('active'))
        );

        // Set meta tags
        $this->set_meta(
            'Donate & Support Us',
            'Support our mission and help us make a difference. Every contribution counts and goes directly to our community programmes.',
            'donate, donation, support us, contribute, give, charity donation'
        );

        // Set page heading
        $this->set_heading('Support Our Cause', 'Your Contribution Makes a Difference');

        // Breadcrumbs
        $this->add_breadcrumb('Home', base_url());
        $this->add_breadcrumb('Donate', null);

        // Render view
        $this->render('pages/donate', $data);
    }

    /**
     * Privacy Policy page
     */
    public function privacy() {
        // Set meta tags
        $this->set_meta('Privacy Policy', 'Read our privacy policy to understand how we collect, use, and protect your personal information.');

        // Set page heading
        $this->set_heading('Privacy Policy', 'How We Protect Your Information');

        // Breadcrumbs
        $this->add_breadcrumb('Home', base_url());
        $this->add_breadcrumb('Privacy Policy', null);

        // Render view
        $this->render('pages/privacy');
    }

    /**
     * Terms & Conditions page
     */
    public function terms() {
        // Set meta tags
        $this->set_meta('Terms & Conditions', 'Read our terms and conditions for using our website and services.');

        // Set page heading
        $this->set_heading('Terms & Conditions', 'Website Terms of Use');

        // Breadcrumbs
        $this->add_breadcrumb('Home', base_url());
        $this->add_breadcrumb('Terms & Conditions', null);

        // Render view
        $this->render('pages/terms');
    }
}