<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Manually load Frontend_Controller if not autoloaded
if (!class_exists('Frontend_Controller')) {
    require_once APPPATH . 'core/Frontend_Controller.php';
}

class Media extends Frontend_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->model(['Media_model', 'Media_category_model']);
    }

   public function index() {
    // Set meta information
    $this->set_meta(
        'Media Gallery', 
        'Explore our NGO\'s impactful moments and activities', 
        'ngo, media, gallery, community impact'
    );

    // Set page heading
    $this->set_heading('Our Media', 'Capturing Moments of Change');

    // Add breadcrumbs
    $this->add_breadcrumb('Home', base_url());
    $this->add_breadcrumb('Media Gallery', null);

    // Get filter parameters
    $category_id = $this->input->get('category') ?: NULL;
    $media_type = $this->input->get('type') ?: NULL;

    // Prepare data
    $data = [
        'categories' => $this->Media_category_model->get_all_categories(),
        'media_items' => $this->Media_model->get_media($category_id, $media_type, 'published'),
        'selected_category' => $category_id,
        'selected_type' => $media_type
    ];

    // Render view
    $this->render('media/index', $data);
}

    public function view($id) {
        // Fetch media item
        $media_item = $this->Media_model->get_media_by_id($id);

        if (empty($media_item)) {
            show_404();
        }

        // Set meta information
        $this->set_meta(
            $media_item->title, 
            $media_item->description, 
            'ngo, media, gallery'
        );

        // Set page heading
        $this->set_heading($media_item->title, $media_item->category_name);

        // Add breadcrumbs
        $this->add_breadcrumb('Home', base_url());
        $this->add_breadcrumb('Media Gallery', site_url('media'));
        $this->add_breadcrumb($media_item->title, null);

        // Prepare data
        $data = [
            'media_item' => $media_item,
            'related_media' => $this->Media_model->get_related_media($media_item->category_id, $id)
        ];

        // Render view
        $this->render('media/details', $data);
    }
}