<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Manually load Frontend_Controller if not autoloaded
if (!class_exists('Frontend_Controller')) {
    require_once APPPATH . 'core/Frontend_Controller.php';
}

/**
 * Home Controller
 * Handles the homepage with carousel, featured content
 * Location: application/controllers/Home.php
 */
class Home extends Frontend_Controller {
    
    public function __construct() {
        parent::__construct();
        
        // Load required models
        $this->load->model('Common_model');
        $this->load->model('Blog_model');
        $this->load->model('Volunteer_model');
        $this->load->model('Registration_model'); // Load registration model for learner counts
    }
    
    /**
     * Homepage
     */
    public function index() {
        // Set meta tags
        $this->set_meta(
            'Home',
            $this->data['site_settings']['about_description'] ?? 'Making a positive impact in our community',
            'ngo, charity, volunteer, community development, workshops, donation, ghana'
        );
        
        // Disable default page header for homepage
        $this->disable_page_header();
        
        // Get carousel items
        $data['carousel_items'] = $this->Common_model->get_carousel_items('active');
        
        // Get featured workshops
        $data['featured_workshops'] = $this->Common_model->get_featured_workshops(3);
        
        // Get recent blog posts
        $data['latest_posts'] = $this->Blog_model->get_recent_posts(6);
        
        // Get active partners
        $data['partners'] = $this->Common_model->get_partners('active');
        
        // Get learner counts from french_kid_learners and french_adult_learners tables
        $kids_count = $this->Registration_model->count_registrations('kid');
        $adults_count = $this->Registration_model->count_registrations('adult');
        $total_learners = $kids_count + $adults_count;
        
        // Get statistics for homepage
        $data['statistics'] = array(
            'volunteers' => $this->Volunteer_model->count_volunteers('active'),
            'workshops' => count($this->Common_model->get_workshops('upcoming')),
            'partners' => count($data['partners']),
            'blog_posts' => $this->Blog_model->count_posts('published'),
            'kids_learners' => $kids_count,
            'adult_learners' => $adults_count,
            'total_learners' => $total_learners
        );
        
        // Render view
        $this->render('home/index', $data);
    }
}