<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Manually load Frontend_Controller if not autoloaded
if (!class_exists('Frontend_Controller')) {
    require_once APPPATH . 'core/Frontend_Controller.php';
}

/**
 * Errors Controller
 * Handles custom error pages
 * Location: application/controllers/Errors.php
 */

class Errors extends Frontend_Controller {

    public function __construct() {
        parent::__construct();
    }

    /**
     * 404 Error Page
     */
    public function error_404() {
        // Set proper 404 header
        $this->output->set_status_header('404');

        // Set meta tags
        $this->set_meta('Page Not Found - 404', 'The page you are looking for could not be found.');

        // Set page heading
        $this->set_heading('404 - Page Not Found', 'Oops! The page you\'re looking for doesn\'t exist.');

        // Disable breadcrumbs
        $this->data['breadcrumbs'] = array();

        // Get some helpful links
        $data['recent_posts'] = $this->Blog_model->get_recent_posts(3);
        $data['featured_workshops'] = $this->Common_model->get_featured_workshops(3);

        // Render view
        $this->render('errors/error_404', $data);
    }

    /**
     * Generic error page
     */
    public function index() {
        $this->error_404();
    }
}