<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Media Upload Configuration
 * Defines settings for media file uploads across the NGO platform
 */
$config['media_upload'] = [
    // Upload directory
    'upload_path' => './assets/uploads/media/',
    
    // Allowed file types
    'allowed_types' => [
        'images' => 'gif|jpg|png|jpeg|webp',
        'videos' => 'mp4|avi|mov|wmv',
        'documents' => 'pdf|doc|docx|txt|csv'
    ],

    // Maximum file sizes (in kilobytes)
    'max_sizes' => [
        'images' => 5120,     // 5 MB for images
        'videos' => 20480,    // 20 MB for videos
        'documents' => 10240  // 10 MB for documents
    ],

    // Image dimension constraints
    'image_constraints' => [
        'max_width' => 3840,   // 4K width
        'max_height' => 2160,  // 4K height
        'min_width' => 300,
        'min_height' => 300
    ],

    // Filename settings
    'filename_rules' => [
        'encrypt_name' => TRUE,  // Randomize filenames
        'remove_spaces' => TRUE,
        'overwrite' => FALSE     // Prevent overwriting existing files
    ],

    // Media categorization
    'default_categories' => [
        'events' => 'NGO Events',
        'workshops' => 'Training Sessions',
        'impact' => 'Community Impact',
        'fundraising' => 'Fundraising Activities'
    ],

    // Status options
    'status_options' => [
        'draft' => 'Draft (Internal Use)',
        'published' => 'Published (Publicly Visible)',
        'archived' => 'Archived (Hidden)'
    ],

    // Media type icons
    'type_icons' => [
        'image' => 'fa-file-image-o',
        'video' => 'fa-file-video-o',
        'document' => 'fa-file-pdf-o'
    ],

    // SEO and accessibility
    'meta_rules' => [
        'require_alt_text' => TRUE,
        'max_alt_text_length' => 125
    ],

    // Security settings
    'security' => [
        'virus_scan' => TRUE,
        'duplicate_check' => TRUE
    ],

    // Resize and thumbnail generation
    'image_processing' => [
        'create_thumbnails' => TRUE,
        'thumbnail_sizes' => [
            'small' => ['width' => 150, 'height' => 150],
            'medium' => ['width' => 300, 'height' => 300],
            'large' => ['width' => 800, 'height' => 600]
        ]
    ],

    // Logging
    'logging' => [
        'log_uploads' => TRUE,
        'log_deletions' => TRUE
    ]
];

/**
 * Additional configuration for media management
 */
$config['media_management'] = [
    // Number of items per page in admin listings
    'items_per_page' => 20,

    // Default sorting
    'default_sort' => [
        'field' => 'created_at',
        'direction' => 'DESC'
    ],

    // Permissions
    'permissions' => [
        'upload' => ['admin', 'editor'],
        'edit' => ['admin', 'editor'],
        'delete' => ['admin']
    ]
];