<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| EMAIL CONFIGURATION
| -------------------------------------------------------------------------
| Configure your email settings here.
| For Gmail, you may need to enable "Less secure app access" or use App Passwords
| For production, consider using a dedicated SMTP service like SendGrid, Mailgun, etc.
|
| IMPORTANT: Update these settings with your actual email credentials
| -------------------------------------------------------------------------
*/

$config['useragent']        = 'NGO Platform';
$config['protocol']         = 'smtp';  // 'mail', 'sendmail', or 'smtp'

/*
| -------------------------------------------------------------------------
| SMTP CONFIGURATION
| -------------------------------------------------------------------------
| Configure for Gmail, or your hosting provider's SMTP
*/

// For Gmail (Development/Testing)
$config['smtp_host']        = 'smtp.gmail.com';
$config['smtp_user']        = 'your-email@gmail.com';  // CHANGE THIS
$config['smtp_pass']        = 'your-app-password';     // CHANGE THIS (use App Password, not regular password)
$config['smtp_port']        = 587;
$config['smtp_crypto']      = 'tls';  // 'tls' or 'ssl'

// For cPanel Hosting (Production)
/*
$config['smtp_host']        = 'mail.yourdomain.com';
$config['smtp_user']        = 'noreply@yourdomain.com';
$config['smtp_pass']        = 'your-email-password';
$config['smtp_port']        = 587;
$config['smtp_crypto']      = 'tls';
*/

// For SendGrid (Recommended for Production)
/*
$config['smtp_host']        = 'smtp.sendgrid.net';
$config['smtp_user']        = 'apikey';
$config['smtp_pass']        = 'your-sendgrid-api-key';
$config['smtp_port']        = 587;
$config['smtp_crypto']      = 'tls';
*/

/*
| -------------------------------------------------------------------------
| OTHER EMAIL SETTINGS
| -------------------------------------------------------------------------
*/
$config['smtp_timeout']     = 30;
$config['mailtype']         = 'html';  // 'text' or 'html'
$config['charset']          = 'utf-8';
$config['wordwrap']         = TRUE;
$config['wrapchars']        = 76;
$config['validate']         = TRUE;
$config['priority']         = 3;  // 1 = highest. 5 = lowest. 3 = normal
$config['crlf']             = "\r\n";
$config['newline']          = "\r\n";
$config['bcc_batch_mode']   = FALSE;
$config['bcc_batch_size']   = 200;

/*
| -------------------------------------------------------------------------
| DEFAULT FROM EMAIL AND NAME
| -------------------------------------------------------------------------
*/
$config['from_email']       = 'noreply@ngoplatform.com';  // CHANGE THIS
$config['from_name']        = 'NGO Platform';  // CHANGE THIS

/*
| -------------------------------------------------------------------------
| NOTES FOR CONFIGURATION
| -------------------------------------------------------------------------
|
| GMAIL SETUP:
| 1. Go to Google Account settings
| 2. Security > 2-Step Verification (enable it)
| 3. App passwords > Generate new app password
| 4. Use the generated 16-character password in smtp_pass
|
| CPANEL HOSTING:
| 1. Create an email account in cPanel (e.g., noreply@yourdomain.com)
| 2. Use the email and password in smtp_user and smtp_pass
| 3. smtp_host is usually: mail.yourdomain.com
|
| SENDGRID (Recommended):
| 1. Sign up at sendgrid.com
| 2. Create API key with "Mail Send" permissions
| 3. Use 'apikey' as smtp_user and your API key as smtp_pass
| 4. Verify your sender domain for better deliverability
|
| -------------------------------------------------------------------------
*/